/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeInsight.daemon.RainbowVisitor;
import com.intellij.codeInsight.daemon.impl.HighlightVisitor;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.impl.source.tree.ForeignLeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.OCLanguageUtils;
import com.jetbrains.cidr.lang.daemon.OCAnnotator;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCLocalSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCNamespaceQualifierOwner;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.ResolveSession;
import com.jetbrains.cidr.lang.psi.impl.OCMacroReferenceElementImpl;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCRainbowVisitor
extends RainbowVisitor {
    public boolean suitableForFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            OCRainbowVisitor.$$$reportNull$$$0(0);
        }
        return LanguageUtils.getInstance().isSupportedFile(psiFile);
    }

    public boolean analyze(@NotNull PsiFile psiFile, boolean updateWholeFile, @NotNull HighlightInfoHolder holder, @NotNull Runnable action) {
        if (psiFile == null) {
            OCRainbowVisitor.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            OCRainbowVisitor.$$$reportNull$$$0(2);
        }
        if (action == null) {
            OCRainbowVisitor.$$$reportNull$$$0(3);
        }
        OCFile ocFile = OCLanguageUtils.asOCFile(psiFile);
        return ocFile.runWithResolveSession((ResolveSession)((Object)OCAnnotator.RESOLVE_SESSION.getValue((UserDataHolder)holder.getAnnotationSession())), () -> super.analyze(psiFile, updateWholeFile, holder, action));
    }

    public void visit(@NotNull PsiElement element) {
        if (element == null) {
            OCRainbowVisitor.$$$reportNull$$$0(4);
        }
        if (element instanceof OCReferenceElement) {
            if (OCElementUtil.getElementType(element.getFirstChild()) == OCLexerTokenTypes.THIS_CPP_KEYWORD || ((OCNamespaceQualifierOwner)element).getNamespaceQualifier() != null || element.getParent() instanceof OCTypeElement || element instanceof OCMacroReferenceElementImpl) {
                return;
            }
            this.processCandidate(((OCReferenceElement)element).getName(), element);
        } else if (element instanceof OCLocalSymbolDeclarator && element instanceof PsiNameIdentifierOwner) {
            PsiNameIdentifierOwner identifierOwner = (PsiNameIdentifierOwner)element;
            OCCallable context = OCRainbowVisitor.getElementContext(element);
            if (context == null) {
                return;
            }
            PsiElement identifier = identifierOwner.getNameIdentifier();
            if ((context instanceof PsiNameIdentifierOwner || context instanceof OCFunctionDeclaration) && (context instanceof PsiNameIdentifierOwner && identifier == ((PsiNameIdentifierOwner)context).getNameIdentifier() || context instanceof OCFunctionDeclaration && identifier == ((OCFunctionDeclaration)context).getNameIdentifier())) {
                return;
            }
            this.processCandidate(identifierOwner.getName(), identifier);
        }
    }

    @Contract(value="null -> null")
    private static OCCallable getElementContext(@Nullable PsiElement element) {
        return (OCCallable)PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class);
    }

    @NotNull
    public HighlightVisitor clone() {
        return new OCRainbowVisitor();
    }

    void processCandidate(@Nullable String symbolNameToFind, @Nullable PsiElement element) {
        if (element == null || symbolNameToFind == null) {
            return;
        }
        OCResolveUtil.processLocalSymbols(symbolNameToFind, element, (Processor<OCSymbol>)((Processor)symbol -> {
            OCCallable context;
            PsiElement idLeaf;
            PsiFile file;
            OCSymbolKind symbolKind = symbol.getKind();
            TextAttributesKey tak = null;
            switch (symbolKind) {
                case LOCAL_VARIABLE: 
                case CATCH_EXCEPTION_VARIABLE: {
                    tak = OCHighlightingKeys.LOCAL_VARIABLE;
                    break;
                }
                case PARAMETER: {
                    if (symbol instanceof OCThisSelfSuperSymbol) break;
                    tak = OCHighlightingKeys.PARAMETER;
                }
            }
            if (tak != null && (file = symbol.getContainingPsiFile(element.getProject())) != null && !((idLeaf = PsiTreeUtil.firstChild((PsiElement)element)) instanceof ForeignLeafPsiElement) && (context = OCRainbowVisitor.getElementContext(file.findElementAt(symbol.getOffset()))) != null) {
                this.addInfo(this.getInfo(context, idLeaf, symbol.getName(), tak));
                return false;
            }
            return true;
        }), true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/OCRainbowVisitor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "suitableForFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "analyze";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "visit";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

