/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.documentation;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.documentation.HtmlHelper;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCmd;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenCommentGroup;
import com.jetbrains.cidr.lang.documentation.doxygen.api.DoxygenFacade;
import com.jetbrains.cidr.lang.documentation.doxygen.api.InfoItem;
import com.jetbrains.cidr.lang.documentation.doxygen.api.TagItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DoxygenRender {
    @NlsSafe
    private static final Map<String, String> TAG_TABLE = new HashMap<String, String>();
    @NlsSafe
    private static final String BREAK_WORD_STYLE_ATTR = "\nstyle=\"overflow-wrap:break-word\"";
    @Nullable
    private final DoxygenCommentGroup docComment;

    @NlsSafe
    @NotNull
    private static String extractName(@NotNull String name) {
        if (name == null) {
            DoxygenRender.$$$reportNull$$$0(0);
        }
        if (TAG_TABLE.containsKey(name)) {
            String string = TAG_TABLE.get(name);
            if (string == null) {
                DoxygenRender.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (!name.isEmpty()) {
            String string = StringUtil.toUpperCase((String)name.substring(0, 1)) + name.substring(1);
            if (string == null) {
                DoxygenRender.$$$reportNull$$$0(2);
            }
            return string;
        }
        String string = name;
        if (string == null) {
            DoxygenRender.$$$reportNull$$$0(3);
        }
        return string;
    }

    public DoxygenRender(@NotNull PsiElement element) {
        if (element == null) {
            DoxygenRender.$$$reportNull$$$0(4);
        }
        this.docComment = DoxygenFacade.getCommentGroup(element);
    }

    public boolean hasDoxygenComments() {
        return this.docComment != null && !this.docComment.isEmpty();
    }

    public void render(@NlsSafe @NotNull StringBuilder answer) {
        if (answer == null) {
            DoxygenRender.$$$reportNull$$$0(5);
        }
        this.render(answer, null);
    }

    public void render(@NlsSafe @NotNull StringBuilder answer, @Nullable Pair<@NotNull String, @NotNull String> additionalSection) {
        if (answer == null) {
            DoxygenRender.$$$reportNull$$$0(6);
        }
        if (this.docComment == null) {
            return;
        }
        HtmlHelper.HtmlDoc html = new HtmlHelper.HtmlDoc();
        @NlsSafe StringBuilder content = new StringBuilder();
        String options = this.docComment.getOptions();
        if (!options.isEmpty()) {
            content.append(HtmlHelper.code(options)).append(" ");
        }
        List<InfoItem> items = DoxygenRender.squash(this.docComment.getContent());
        Runnable finalizeContent = () -> {
            if (!content.isEmpty()) {
                html.addText("<div class='content'>");
                html.addText(HtmlHelper.paragraph(content.toString()));
                html.addText("</div>");
                content.setLength(0);
            }
        };
        for (InfoItem item : items) {
            TagItem tagItem;
            if (item instanceof CompositeInfoItem) {
                CompositeInfoItem compositeInfoItem = (CompositeInfoItem)item;
                finalizeContent.run();
                DoxygenRender.renderCompositeItem(answer, html, compositeInfoItem);
                continue;
            }
            if (item instanceof TagItem && DoxygenCmd.FORMAT_NEXT_WORD_TAGS.containsKey((tagItem = (TagItem)item).getName())) {
                DoxygenRender.processFormatTag(tagItem, content::append);
                continue;
            }
            content.append(item.getDescription());
        }
        finalizeContent.run();
        if (!html.sb.isEmpty()) {
            if (StringUtil.startsWith((CharSequence)html.sb, (CharSequence)"<br/>")) {
                html.sb.replace(0, 5, "<p>");
            }
            if (additionalSection != null) {
                HtmlHelper.renderSections(answer, (String)additionalSection.first, (String)additionalSection.second);
            }
            answer.append(html);
        }
    }

    private static void renderCompositeItem(@NotNull StringBuilder answer, @NotNull HtmlHelper.HtmlDoc html, @NotNull CompositeInfoItem composite) {
        if (answer == null) {
            DoxygenRender.$$$reportNull$$$0(7);
        }
        if (html == null) {
            DoxygenRender.$$$reportNull$$$0(8);
        }
        if (composite == null) {
            DoxygenRender.$$$reportNull$$$0(9);
        }
        String name = composite.getName();
        if (DoxygenCmd.BRIEF.toString().equals(name)) {
            @NlsSafe StringBuilder contentAnswer = new StringBuilder();
            @NlsSafe StringBuilder content = new StringBuilder();
            Runnable finalizeContent = () -> {
                if (!content.isEmpty()) {
                    contentAnswer.append(HtmlHelper.paragraph(content.toString()));
                    content.setLength(0);
                }
            };
            for (TagItem tag : composite.getTags()) {
                if (DoxygenCmd.FORMAT_NEXT_WORD_TAGS.containsKey(tag.getName())) {
                    DoxygenRender.processFormatTag(tag, content::append);
                    continue;
                }
                if (DoxygenCmd.ESCAPE_TAGS.contains(tag.getName())) {
                    content.append(tag.getDescription());
                    continue;
                }
                boolean lineStarter = content.isEmpty();
                content.append(tag.getDescription());
                if (lineStarter) continue;
                finalizeContent.run();
            }
            finalizeContent.run();
            if (!contentAnswer.isEmpty()) {
                answer.append("<div class='content'>").append((CharSequence)contentAnswer).append("</div>");
            }
        } else if (DoxygenCmd.SURROUND_TAGS.containsKey(name)) {
            for (TagItem tag : composite.getTags()) {
                String description = tag.getDescription();
                html.addText("<div class='content'>");
                html.addText(HtmlHelper.pre(HtmlHelper.code(description)));
                html.addText("</div>");
            }
        } else {
            HtmlHelper.Table table = new HtmlHelper.Table();
            Ref row = Ref.create();
            @NlsSafe StringBuilder content = new StringBuilder();
            Consumer<Boolean> finalizeContent = last -> {
                HtmlHelper.TableRow _row = (HtmlHelper.TableRow)row.get();
                if (_row != null) {
                    _row.addData(content.toString());
                    if (last.booleanValue()) {
                        table.sb.append(_row.sb.toString().replace("<td>", "<td style='padding-bottom:0'>"));
                    } else {
                        table.addRow(_row);
                    }
                    row.set(null);
                    content.setLength(0);
                }
            };
            for (TagItem tag : composite.getTags()) {
                boolean skipFinalizing;
                String tagName = tag.getName();
                boolean bl = skipFinalizing = DoxygenCmd.FORMAT_NEXT_WORD_TAGS.containsKey(tagName) || DoxygenCmd.ESCAPE_TAGS.contains(tagName);
                if (!skipFinalizing) {
                    finalizeContent.accept(false);
                }
                if (row.get() == null) {
                    row.set((Object)HtmlHelper.TableRow.withData(HtmlHelper.wrapWithTag("code\nstyle=\"overflow-wrap:break-word\"", tag.getOptions())));
                    List<String> parameters = tag.getParameters();
                    if (!parameters.isEmpty()) {
                        ((HtmlHelper.TableRow)row.get()).addData(HtmlHelper.wrapWithTag("b\nstyle=\"overflow-wrap:break-word\"", StringUtil.join(parameters, (String)", ")));
                    }
                }
                if (skipFinalizing) {
                    if (DoxygenCmd.FORMAT_NEXT_WORD_TAGS.containsKey(tagName)) {
                        DoxygenRender.processFormatTag(tag, text -> content.append((String)text));
                        continue;
                    }
                    content.append(tag.getDescription());
                    continue;
                }
                for (InfoItem item : tag.getContent()) {
                    TagItem innerTagItem;
                    String description = item.getDescription();
                    if (item instanceof TagItem && DoxygenCmd.SURROUND_TAGS.containsKey((innerTagItem = (TagItem)item).getName())) {
                        content.append(HtmlHelper.pre(HtmlHelper.code(description)));
                        continue;
                    }
                    content.append(description);
                }
            }
            finalizeContent.accept(true);
            HtmlHelper.renderSections(html.sb, DoxygenRender.extractName(name), table.toString());
        }
    }

    private static void processFormatTag(@NotNull TagItem item, @NotNull Consumer<String> addDescription) {
        if (item == null) {
            DoxygenRender.$$$reportNull$$$0(10);
        }
        if (addDescription == null) {
            DoxygenRender.$$$reportNull$$$0(11);
        }
        String nextWordWrapTag = DoxygenCmd.FORMAT_NEXT_WORD_TAGS.get(item.getName());
        assert (nextWordWrapTag != null);
        String description = StringUtil.trimLeading((String)item.getDescription());
        int spacePos = StringUtil.indexOfAny((String)description, (String)" \n\r\t");
        if (spacePos >= 0) {
            addDescription.accept(HtmlHelper.wrapWithTag(nextWordWrapTag, description.substring(0, spacePos)));
            addDescription.accept(description.substring(spacePos));
        } else {
            addDescription.accept(HtmlHelper.wrapWithTag(nextWordWrapTag, description));
        }
    }

    @NotNull
    private static List<InfoItem> squash(@NotNull List<InfoItem> items) {
        if (items == null) {
            DoxygenRender.$$$reportNull$$$0(12);
        }
        return DoxygenRender.squash(items, 0, null);
    }

    @NotNull
    private static List<InfoItem> squash(@NotNull List<InfoItem> items, int position, @Nullable CompositeInfoItem compositeItem) {
        if (items == null) {
            DoxygenRender.$$$reportNull$$$0(13);
        }
        ArrayList<InfoItem> blocks = new ArrayList<InfoItem>();
        if (position < items.size()) {
            InfoItem item = items.get(position);
            if (item instanceof TagItem) {
                TagItem tag = (TagItem)item;
                String name = tag.getName();
                if (!DoxygenCmd.PARAM.toString().equals(name) || !tag.getParameters().isEmpty()) {
                    if (compositeItem != null && (name.equals(compositeItem.getName()) || DoxygenCmd.FORMAT_NEXT_WORD_TAGS.containsKey(name) || DoxygenCmd.ESCAPE_TAGS.contains(name))) {
                        compositeItem.addItem(tag);
                    } else if (DoxygenCmd.FORMAT_NEXT_WORD_TAGS.containsKey(name) || DoxygenCmd.ESCAPE_TAGS.contains(name)) {
                        blocks.add(item);
                    } else {
                        compositeItem = new CompositeInfoItem(tag);
                        blocks.add(compositeItem);
                    }
                }
            } else {
                compositeItem = null;
                blocks.add(item);
            }
            List<InfoItem> result = DoxygenRender.squash(items, ++position, compositeItem);
            blocks.addAll(result);
        }
        ArrayList<InfoItem> arrayList = blocks;
        if (arrayList == null) {
            DoxygenRender.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    static {
        TAG_TABLE.put(DoxygenCmd.ATTENTION.toString(), "Attention");
        TAG_TABLE.put(DoxygenCmd.AUTHOR.toString(), "Author");
        TAG_TABLE.put(DoxygenCmd.AUTHORS.toString(), "Authors");
        TAG_TABLE.put(DoxygenCmd.BUG.toString(), "Bug");
        TAG_TABLE.put(DoxygenCmd.COPYRIGHT.toString(), "Copyright");
        TAG_TABLE.put(DoxygenCmd.DATE.toString(), "Date");
        TAG_TABLE.put(DoxygenCmd.DEPRECATED.toString(), "Deprecated");
        TAG_TABLE.put(DoxygenCmd.INVARIANT.toString(), "Invariant");
        TAG_TABLE.put(DoxygenCmd.PARAM.toString(), "Parameters");
        TAG_TABLE.put(DoxygenCmd.TPARAM.toString(), "Template Parameters");
        TAG_TABLE.put(DoxygenCmd.PRE.toString(), "Precondition");
        TAG_TABLE.put(DoxygenCmd.POST.toString(), "Postcondition");
        TAG_TABLE.put(DoxygenCmd.REMARK.toString(), "Remarks");
        TAG_TABLE.put(DoxygenCmd.REMARKS.toString(), "Remarks");
        TAG_TABLE.put(DoxygenCmd.SA.toString(), "See also");
        TAG_TABLE.put(DoxygenCmd.SEE.toString(), "See also");
        TAG_TABLE.put(DoxygenCmd.SINCE.toString(), "Since");
        TAG_TABLE.put(DoxygenCmd.TODO.toString(), "Todo");
        TAG_TABLE.put(DoxygenCmd.VERSION.toString(), "Version");
        TAG_TABLE.put(DoxygenCmd.WARNING.toString(), "Warning");
        TAG_TABLE.put(DoxygenCmd.RETURN.toString(), "Returns");
        TAG_TABLE.put(DoxygenCmd.RETURNS.toString(), "Returns");
        TAG_TABLE.put(DoxygenCmd.RESULT.toString(), "Returns");
        TAG_TABLE.put(DoxygenCmd.RETVAL.toString(), "Return values");
        TAG_TABLE.put(DoxygenCmd.THROW.toString(), "Exceptions");
        TAG_TABLE.put(DoxygenCmd.THROWS.toString(), "Exceptions");
        TAG_TABLE.put("exception", "Exceptions");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/documentation/DoxygenRender";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "answer";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "html";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "composite";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addDescription";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/documentation/DoxygenRender";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "extractName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "squash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "extractName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "render";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renderCompositeItem";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processFormatTag";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "squash";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 14 -> new IllegalStateException(string);
        };
    }

    private static class CompositeInfoItem
    implements InfoItem {
        private final String name;
        private final List<TagItem> tags;

        CompositeInfoItem(@NotNull TagItem item) {
            if (item == null) {
                CompositeInfoItem.$$$reportNull$$$0(0);
            }
            this.tags = new ArrayList<TagItem>();
            this.name = item.getName();
            this.tags.add(item);
        }

        public String getName() {
            return this.name;
        }

        public List<TagItem> getTags() {
            return this.tags;
        }

        public void addItem(@NotNull TagItem item) {
            if (item == null) {
                CompositeInfoItem.$$$reportNull$$$0(1);
            }
            this.tags.add(item);
        }

        @Override
        @NotNull
        public String getDescription() {
            throw new UnsupportedOperationException();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "item";
            objectArray2[1] = "com/jetbrains/cidr/lang/documentation/DoxygenRender$CompositeInfoItem";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addItem";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

