/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.editor.colors;

import com.intellij.cidr.cpp.lexer.CidrLexerSettings;
import com.intellij.cidr.cpp.lexer.OCHighlightingLexer;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.editor.colors.OCHighlightingKeys;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class OCFileHighlighter
extends SyntaxHighlighterBase {
    private static final Map<IElementType, TextAttributesKey> keys1 = new HashMap<IElementType, TextAttributesKey>();
    private final CidrLexerSettings mySettings;

    public OCFileHighlighter(CidrLexerSettings settings) {
        this.mySettings = settings;
    }

    public TextAttributesKey @NotNull [] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey[] textAttributesKeyArray = OCFileHighlighter.pack((TextAttributesKey)keys1.get(tokenType));
        if (textAttributesKeyArray == null) {
            OCFileHighlighter.$$$reportNull$$$0(0);
        }
        return textAttributesKeyArray;
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        return new OCHighlightingLexer(this.mySettings);
    }

    static {
        SyntaxHighlighterBase.fillMap(keys1, (TokenSet)OCLexerTokenTypes.KEYWORDS, (TextAttributesKey)OCHighlightingKeys.OC_KEYWORD);
        keys1.put((IElementType)OCLexerTokenTypes.THIS_CPP_KEYWORD, OCHighlightingKeys.SELFSUPERTHIS);
        OCFileHighlighter.fillMap(keys1, (TokenSet)OCLexerTokenTypes.DIRECTIVES, (TextAttributesKey)OCHighlightingKeys.OC_DIRECTIVE);
        keys1.put((IElementType)OCLexerTokenTypes.HEADER_PATH_LITERAL, OCHighlightingKeys.OC_HEADER_PATH);
        OCFileHighlighter.fillMap(keys1, (TextAttributesKey)OCHighlightingKeys.OC_OPERATION_SIGN, (IElementType[])IElementType.enumerate(type -> type instanceof OCPunctuatorElementType));
        keys1.put(StringEscapesTokenTypes.VALID_STRING_ESCAPE_TOKEN, OCHighlightingKeys.OC_VALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_CHARACTER_ESCAPE_TOKEN, OCHighlightingKeys.OC_INVALID_STRING_ESCAPE);
        keys1.put(StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN, OCHighlightingKeys.OC_INVALID_STRING_ESCAPE);
        keys1.put((IElementType)OCLexerTokenTypes.INTEGER_LITERAL, OCHighlightingKeys.OC_NUMBER);
        keys1.put((IElementType)OCLexerTokenTypes.FLOAT_LITERAL, OCHighlightingKeys.OC_NUMBER);
        keys1.put((IElementType)OCLexerTokenTypes.VERSION_LITERAL, OCHighlightingKeys.OC_NUMBER);
        keys1.put((IElementType)OCLexerTokenTypes.STRING_LITERAL, OCHighlightingKeys.OC_STRING);
        keys1.put((IElementType)OCLexerTokenTypes.AT, OCHighlightingKeys.OC_KEYWORD);
        keys1.put((IElementType)OCLexerTokenTypes.CHARACTER_LITERAL, OCHighlightingKeys.OC_STRING);
        keys1.put((IElementType)OCLexerTokenTypes.LPAR, OCHighlightingKeys.OC_PARENTHS);
        keys1.put((IElementType)OCLexerTokenTypes.RPAR, OCHighlightingKeys.OC_PARENTHS);
        keys1.put((IElementType)OCLexerTokenTypes.LBRACE, OCHighlightingKeys.OC_BRACES);
        keys1.put((IElementType)OCLexerTokenTypes.RBRACE, OCHighlightingKeys.OC_BRACES);
        keys1.put((IElementType)OCLexerTokenTypes.LBRACKET, OCHighlightingKeys.OC_BRACKETS);
        keys1.put((IElementType)OCLexerTokenTypes.RBRACKET, OCHighlightingKeys.OC_BRACKETS);
        keys1.put((IElementType)OCLexerTokenTypes.COMMA, OCHighlightingKeys.OC_COMMA);
        keys1.put((IElementType)OCLexerTokenTypes.DOT, OCHighlightingKeys.OC_DOT);
        keys1.put((IElementType)OCLexerTokenTypes.SEMICOLON, OCHighlightingKeys.OC_SEMICOLON);
        keys1.put((IElementType)OCLexerTokenTypes.BLOCK_COMMENT, OCHighlightingKeys.OC_BLOCK_COMMENT);
        keys1.put((IElementType)OCLexerTokenTypes.EOL_COMMENT, OCHighlightingKeys.OC_LINE_COMMENT);
        keys1.put(TokenType.BAD_CHARACTER, OCHighlightingKeys.OC_BAD_CHARACTER);
        keys1.put((IElementType)OCElementTypes.MACRO_REF, OCHighlightingKeys.MACRONAME);
        keys1.put((IElementType)OCElementTypes.MACRO_PARAMETER, OCHighlightingKeys.MACRO_PARAMETER);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/editor/colors/OCFileHighlighter", "getTokenHighlights"));
    }
}

