/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.cidr.lang.formatting.OCCodeBlock;
import com.jetbrains.cidr.lang.formatting.OCIndentChanger;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCSimpleBlock
implements Block,
OCIndentChanger {
    @NotNull
    protected OCCodeBlock myOwnerBlock;
    @NotNull
    private final List<Block> myBlocks;
    @NotNull
    private Indent myIndent;
    private TextRange myTextRange;
    @Nullable
    private final Wrap myWrap;
    @Nullable
    private final Alignment myAlignment;
    @NotNull
    private final ASTNode myFirst;
    @NotNull
    private final ASTNode myLast;

    public OCSimpleBlock(@Nullable Wrap wrap, @Nullable Alignment alignment, @Nullable Indent indent, @NotNull OCCodeBlock ownerBlock, @NotNull List<Block> blocks) {
        if (ownerBlock == null) {
            OCSimpleBlock.$$$reportNull$$$0(0);
        }
        if (blocks == null) {
            OCSimpleBlock.$$$reportNull$$$0(1);
        }
        assert (!blocks.isEmpty());
        this.myOwnerBlock = ownerBlock;
        this.myBlocks = blocks;
        this.myIndent = indent != null ? indent : Indent.getNoneIndent();
        this.myWrap = wrap;
        this.myAlignment = alignment;
        this.myFirst = OCSimpleBlock.extractFirstNode(this.myBlocks.get(0));
        this.myLast = OCSimpleBlock.extractLastNode(this.myBlocks.get(this.myBlocks.size() - 1));
    }

    @NotNull
    public TextRange getTextRange() {
        if (this.myTextRange == null) {
            this.myTextRange = OCSimpleBlock.getRangeFromSubBlocks(this);
        }
        TextRange textRange = this.myTextRange;
        if (textRange == null) {
            OCSimpleBlock.$$$reportNull$$$0(2);
        }
        return textRange;
    }

    @NotNull
    public List<Block> getSubBlocks() {
        List<Block> list = this.myBlocks;
        if (list == null) {
            OCSimpleBlock.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public Wrap getWrap() {
        return this.myWrap;
    }

    @NotNull
    public Indent getIndent() {
        Indent indent = this.myIndent;
        if (indent == null) {
            OCSimpleBlock.$$$reportNull$$$0(4);
        }
        return indent;
    }

    @Nullable
    public Alignment getAlignment() {
        return this.myAlignment;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        if (child2 == null) {
            OCSimpleBlock.$$$reportNull$$$0(5);
        }
        return this.myOwnerBlock.getSpacing(child1, child2);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        Block child = this.getSubBlocks().get(newChildIndex - 1);
        if (child instanceof ASTBlock && OCElementUtil.getElementType(((ASTBlock)child).getNode()) == OCLexerTokenTypes.LBRACE) {
            ChildAttributes childAttributes = this.myOwnerBlock.getChildAttributes(1);
            if (childAttributes == null) {
                OCSimpleBlock.$$$reportNull$$$0(6);
            }
            return childAttributes;
        }
        return new ChildAttributes(child.getIndent(), child.getAlignment());
    }

    public boolean isIncomplete() {
        return this.myOwnerBlock.isIncomplete();
    }

    public boolean isLeaf() {
        return false;
    }

    public String toString() {
        return OCSimpleBlock.getTextFromRange(this.myOwnerBlock.getNode(), this.getTextRange());
    }

    public ASTNode getFirstNode() {
        return this.myFirst;
    }

    public ASTNode getLastNode() {
        return this.myLast;
    }

    @Contract(value="null->null")
    public static ASTNode extractFirstNode(@Nullable Block block) {
        if (block instanceof ASTBlock) {
            return ((ASTBlock)block).getNode();
        }
        if (block instanceof OCSimpleBlock) {
            return ((OCSimpleBlock)block).getFirstNode();
        }
        return null;
    }

    @Contract(value="null->null")
    public static ASTNode extractLastNode(@Nullable Block block) {
        if (block instanceof ASTBlock) {
            return ((ASTBlock)block).getNode();
        }
        if (block instanceof OCSimpleBlock) {
            return ((OCSimpleBlock)block).getLastNode();
        }
        return null;
    }

    @NotNull
    public static TextRange getRangeFromSubBlocks(@NotNull Block block) {
        List blocks;
        if (block == null) {
            OCSimpleBlock.$$$reportNull$$$0(7);
        }
        return (blocks = block.getSubBlocks()).isEmpty() ? TextRange.EMPTY_RANGE : new TextRange(((Block)blocks.get(0)).getTextRange().getStartOffset(), ((Block)blocks.get(blocks.size() - 1)).getTextRange().getEndOffset());
    }

    @NotNull
    public static String getTextFromRange(@NotNull ASTNode ownerNode, @NotNull TextRange range) {
        if (ownerNode == null) {
            OCSimpleBlock.$$$reportNull$$$0(8);
        }
        if (range == null) {
            OCSimpleBlock.$$$reportNull$$$0(9);
        }
        for (ASTNode up = ownerNode; up != null; up = up.getTreeParent()) {
            if (up.getStartOffset() > range.getStartOffset()) continue;
            ownerNode = up;
        }
        String string = range.shiftRight(-ownerNode.getStartOffset()).substring(ownerNode.getText()) + String.valueOf(range);
        if (string == null) {
            OCSimpleBlock.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    public void putIndent(Indent indent) {
        this.myIndent = indent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerBlock";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blocks";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/formatting/OCSimpleBlock";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child2";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "block";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ownerNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/formatting/OCSimpleBlock";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubBlocks";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndent";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildAttributes";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextFromRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getSpacing";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getRangeFromSubBlocks";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTextFromRange";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6, 10 -> new IllegalStateException(string);
        };
    }
}

