/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.generate.actions.OCGenerateFromIvarsActionContext;
import com.jetbrains.cidr.lang.refactoring.changeSignature.OCParameterInfo;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import java.util.ArrayList;
import java.util.List;

public class OCGenerateMethodActionContext
extends OCGenerateFromIvarsActionContext {
    private List<OCMethodSymbol> myBaseMethods;
    private String myMethodSignature;
    private List<OCParameterInfo> myParameters;
    private boolean myDeleteExisting;
    private List<OCInstanceVariableSymbol> myNonReleasedIvars = new ArrayList<OCInstanceVariableSymbol>();

    public OCGenerateMethodActionContext(OCClassSymbol symbol, List<OCMethodSymbol> baseMethods, OCObjectType objectType, PsiElement context) {
        super(symbol, objectType, context);
        this.myBaseMethods = baseMethods;
    }

    @Override
    public boolean isValid() {
        return super.isValid() && this.myImplementationSymbol != null && !this.myBaseMethods.isEmpty() && !ContainerUtil.exists(this.myBaseMethods, symbol -> symbol == null);
    }

    public OCMethodSymbol getBaseMethod() {
        return this.myBaseMethods.get(0);
    }

    public List<OCMethodSymbol> getBaseMethods() {
        return this.myBaseMethods;
    }

    public String getMethodSignature() {
        return this.myMethodSignature;
    }

    public void setMethodSignature(String methodSignature) {
        this.myMethodSignature = methodSignature;
    }

    public List<OCParameterInfo> getParameters() {
        return this.myParameters;
    }

    public void setParameters(List<OCParameterInfo> parameters) {
        this.myParameters = parameters;
    }

    public boolean isDeleteExisting() {
        return this.myDeleteExisting;
    }

    public void setDeleteExisting(boolean deleteExisting) {
        this.myDeleteExisting = deleteExisting;
    }

    public List<OCInstanceVariableSymbol> getNonReleasedIvars() {
        return this.myNonReleasedIvars;
    }
}

