/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.generate.actions;

import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.generate.actions.OCCppActionContext;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCVisibility;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCCallableUtil;
import java.util.ArrayList;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class OCOverrideImplementCppActionContext
extends OCCppActionContext<OCStructSymbol, OCFunctionSymbol> {
    private boolean myImplementMode;

    public OCOverrideImplementCppActionContext(OCStructSymbol parent, PsiElement context, boolean implementMode) {
        super(parent, context);
        this.myImplementMode = implementMode;
    }

    @Override
    @NotNull
    public Collection<OCFunctionSymbol> getMemberCandidates() {
        ArrayList<OCFunctionSymbol> result = new ArrayList<OCFunctionSymbol>();
        OCResolveContext context = OCResolveContext.forPsi(this.getContext());
        OCStructType.processMembersInBaseTypes((OCStructSymbol)this.getParent(), null, false, false, (Condition<? super OCSymbol>)((Condition)symbol -> {
            if (!(symbol instanceof OCFunctionSymbol)) {
                return false;
            }
            OCFunctionSymbol functionSymbol = (OCFunctionSymbol)symbol;
            if (!functionSymbol.isFriendOrStatic()) {
                String newName = OCCallableUtil.getOverridingFunctionName(functionSymbol, (OCSymbolWithQualifiedName)this.getParent());
                OCTypeEqualityVisitor equalityVisitor = new OCTypeEqualityVisitor(symbol.getResolvedType(context), false, context);
                Processor processor2 = existingSymbol -> {
                    if (!(existingSymbol instanceof OCFunctionSymbol)) {
                        return false;
                    }
                    return !equalityVisitor.isFunctionSignatureEqual(existingSymbol.getResolvedType(context));
                };
                if (((OCStructSymbol)this.getParent()).processMembers(newName, (Processor<? super OCSymbol>)processor2) && (functionSymbol.getVisibility() != OCVisibility.PRIVATE || functionSymbol.isVirtual())) {
                    return true;
                }
            }
            return false;
        }), (Processor<? super OCSymbol>)((Processor)symbol -> {
            boolean isPureVirtual = ((OCFunctionSymbol)symbol).isPureVirtual();
            if ((!this.myImplementMode || isPureVirtual) && this.isValidOverride((OCFunctionSymbol)symbol)) {
                result.add((OCFunctionSymbol)symbol);
            }
            return true;
        }), context);
        ArrayList<OCFunctionSymbol> arrayList = result;
        if (arrayList == null) {
            OCOverrideImplementCppActionContext.$$$reportNull$$$0(0);
        }
        return arrayList;
    }

    private boolean isValidOverride(@NotNull OCFunctionSymbol functionSymbol) {
        OCFunctionDeclaration funDecl;
        OCType returnType;
        if (functionSymbol == null) {
            OCOverrideImplementCppActionContext.$$$reportNull$$$0(1);
        }
        if ((returnType = functionSymbol.getReturnType().getTerminalType()) instanceof OCAutoType && (funDecl = functionSymbol.locateFunctionDefinition(this.getProject())) != null && funDecl.getTrailingReturnTypeElement() == null) {
            return false;
        }
        return !functionSymbol.isFinal();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/generate/actions/OCOverrideImplementCppActionContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionSymbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getMemberCandidates";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/generate/actions/OCOverrideImplementCppActionContext";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isValidOverride";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1 -> new IllegalArgumentException(string);
        };
    }
}

