/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy;

import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.jetbrains.cidr.lang.hierarchy.OCHierarchyUtil;
import com.jetbrains.cidr.lang.hierarchy.polyglot.PolyglotHierarchyNodeDescriptor;
import org.jetbrains.annotations.Nullable;

public class OCClassHierarchyNodeDescriptor<T extends NavigatablePsiElement>
extends PolyglotHierarchyNodeDescriptor {
    private final boolean myDisplayLocation;

    public OCClassHierarchyNodeDescriptor(Project project, PolyglotHierarchyNodeDescriptor parentDescriptor, T element, boolean isBase) {
        this(project, parentDescriptor, element, isBase, true);
    }

    public OCClassHierarchyNodeDescriptor(Project project, PolyglotHierarchyNodeDescriptor parentDescriptor, T element, boolean isBase, boolean displayLocation) {
        super(project, parentDescriptor, (PsiElement)element, isBase);
        this.myDisplayLocation = displayLocation;
    }

    @Nullable
    public T getType() {
        return (T)((NavigatablePsiElement)this.getPsiElement());
    }

    public final boolean update() {
        boolean changes = super.update();
        PsiElement element = this.getPsiElement();
        if (element == null) {
            return this.invalidElement();
        }
        this.installIcon(changes);
        NavigatablePsiElement aClass = (NavigatablePsiElement)element;
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        TextAttributes classNameAttributes = null;
        if (this.myColor != null) {
            classNameAttributes = new TextAttributes(this.myColor, null, null, null, 0);
        }
        this.myHighlightedText.getEnding().addText(aClass.getName(), classNameAttributes);
        String location = OCHierarchyUtil.getLocationString(element);
        if (this.myDisplayLocation && location != null) {
            this.myHighlightedText.getEnding().addText(" (" + location + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }
}

