/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.hierarchy.call;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Query;
import com.jetbrains.cidr.lang.hierarchy.call.OCCallHierarchyNodeAggregator;
import com.jetbrains.cidr.lang.hierarchy.call.OCCallHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.polyglot.PolyglotCallHierarchyNodeDescriptor;
import com.jetbrains.cidr.lang.hierarchy.polyglot.PolyglotCallStructureProvider;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCallable;
import com.jetbrains.cidr.lang.psi.OCCppNewExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCPropertyAttribute;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.search.OCFunctionAncestorsQuery;
import com.jetbrains.cidr.lang.search.OCFunctionInheritorsSearch;
import com.jetbrains.cidr.lang.search.OCFunctionReferenceSearch;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.types.OCObjectTypeContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCCallStructureProvider
implements PolyglotCallStructureProvider<OCCallHierarchyNodeDescriptor> {
    @Override
    @Nullable
    public PsiElement isCallHierarchyAvailable(@Nullable PsiElement element) {
        return PsiTreeUtil.getParentOfType((PsiElement)element, OCCallable.class, (boolean)false);
    }

    @Override
    @Nullable
    public PsiElement getElementFromContext(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            OCCallStructureProvider.$$$reportNull$$$0(0);
        }
        return (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
    }

    private static OCCallable getImplementationOfMethod(@NotNull OCCallable method) {
        OCSymbol symbol;
        if (method == null) {
            OCCallStructureProvider.$$$reportNull$$$0(1);
        }
        if ((symbol = method.getSymbol()) != null && symbol.isPredeclaration()) {
            PsiElement implElement;
            OCSymbol impl = symbol.getDefinitionSymbol(method.getProject());
            if (impl != null) {
                symbol = impl;
            }
            if ((implElement = symbol.locateDefinition(method.getProject())) instanceof OCCallable) {
                method = (OCCallable)implElement;
            }
            if (implElement != null && implElement.getParent() instanceof OCCallable) {
                method = (OCCallable)implElement.getParent();
            }
        }
        return method;
    }

    @Override
    @NotNull
    public @NotNull Object @NotNull [] buildCallees(@NotNull OCCallHierarchyNodeDescriptor descriptor) {
        OCBlockStatement body;
        if (descriptor == null) {
            OCCallStructureProvider.$$$reportNull$$$0(2);
        }
        Project myProject = descriptor.getProject();
        if (descriptor.getPossibleResponders().size() > 1) {
            ArrayList<OCCallHierarchyNodeDescriptor> result = new ArrayList<OCCallHierarchyNodeDescriptor>();
            for (OCSymbol symbol : descriptor.getPossibleResponders()) {
                if (symbol.isPredeclaration()) {
                    OCSymbol impl = null;
                    if (myProject != null) {
                        impl = symbol.getDefinitionSymbol(myProject);
                    }
                    if (impl != null) {
                        symbol = impl;
                    }
                }
                PsiElement element = null;
                if (myProject != null) {
                    element = symbol.locateDefinition(myProject);
                }
                if (element == null) continue;
                result.add(new OCCallHierarchyNodeDescriptor(myProject, descriptor, element, false, false));
            }
            Object[] objectArray = result.toArray();
            if (objectArray == null) {
                OCCallStructureProvider.$$$reportNull$$$0(3);
            }
            return objectArray;
        }
        ChildrenCalculator calculator = new ChildrenCalculator(descriptor);
        OCCallable enclosingElement = descriptor.getEnclosingElement();
        if (enclosingElement != null && (body = (enclosingElement = OCCallStructureProvider.getImplementationOfMethod(enclosingElement)).getBody()) != null) {
            calculator.visit(body);
        }
        Object[] objectArray = calculator.getChildren();
        if (objectArray == null) {
            OCCallStructureProvider.$$$reportNull$$$0(4);
        }
        return objectArray;
    }

    private static boolean processCall(PsiReference psiReference, @NotNull Set<PsiElement> myProcessed, @NotNull SearchScope searchScope, @NotNull OCCallHierarchyNodeAggregator aggregator) {
        if (myProcessed == null) {
            OCCallStructureProvider.$$$reportNull$$$0(5);
        }
        if (searchScope == null) {
            OCCallStructureProvider.$$$reportNull$$$0(6);
        }
        if (aggregator == null) {
            OCCallStructureProvider.$$$reportNull$$$0(7);
        }
        PsiElement element = psiReference.getElement();
        String selectorName = null;
        if (element instanceof OCElement && myProcessed.add(element)) {
            OCSymbol parentSymbol;
            if (element instanceof OCSendMessageExpression) {
                OCSendMessageExpression sendMessage = (OCSendMessageExpression)element;
                selectorName = sendMessage.getMessageSelector();
            } else if (element instanceof OCPropertyAttribute) {
                boolean isSetter;
                OCProperty property = ((OCPropertyAttribute)element).getParentProperty();
                String attributeName = ((OCPropertyAttribute)element).getName();
                if (attributeName == null) {
                    return true;
                }
                OCPropertySymbol.PropertyAttribute attr = OCPropertySymbolImpl.parseAttribute(attributeName);
                boolean isGetter = attr == OCPropertySymbol.PropertyAttribute.GETTER;
                boolean bl = isSetter = attr == OCPropertySymbol.PropertyAttribute.SETTER;
                if (property == null) {
                    return true;
                }
                OCDeclaration declaration = property.getDeclaration();
                if (declaration == null) {
                    return true;
                }
                List<OCDeclarator> declarators = declaration.getDeclarators();
                if (declarators.size() != 1) {
                    return true;
                }
                ReferencesSearch.SearchParameters queryParameters = new ReferencesSearch.SearchParameters((PsiElement)declarators.get(0), searchScope, false);
                ReferencesSearch.search((ReferencesSearch.SearchParameters)queryParameters).forEach(reference -> {
                    ReadWriteAccessDetector.Access access;
                    PsiElement element1 = reference.getElement();
                    if ((element1 instanceof OCReferenceElement || element1 instanceof OCQualifiedExpression) && ((access = new OCReadWriteAccessDetector().getExpressionAccess(element1)) == ReadWriteAccessDetector.Access.Read && isGetter || access == ReadWriteAccessDetector.Access.Write && isSetter || access == ReadWriteAccessDetector.Access.ReadWrite && (isGetter || isSetter))) {
                        return OCCallStructureProvider.processCall(reference, myProcessed, searchScope, aggregator);
                    }
                    return true;
                });
                return true;
            }
            OCCallable parent = (OCCallable)PsiTreeUtil.getContextOfType((PsiElement)element, (Class[])new Class[]{OCCallable.class});
            if (parent != null && (parentSymbol = parent.getSymbol()) != null) {
                aggregator.addNodeDescriptor(parentSymbol, selectorName, element, null);
            }
        }
        return true;
    }

    @Override
    @NotNull
    public Collection<PolyglotCallHierarchyNodeDescriptor> processCallers(@NotNull List<? extends PsiReference> references, @NotNull PolyglotCallHierarchyNodeDescriptor descriptor, @NotNull SearchScope searchScope) {
        if (references == null) {
            OCCallStructureProvider.$$$reportNull$$$0(8);
        }
        if (descriptor == null) {
            OCCallStructureProvider.$$$reportNull$$$0(9);
        }
        if (searchScope == null) {
            OCCallStructureProvider.$$$reportNull$$$0(10);
        }
        OCCallHierarchyNodeAggregator aggregator = new OCCallHierarchyNodeAggregator(descriptor);
        HashSet myProcessed = new HashSet();
        references.forEach(reference -> OCCallStructureProvider.processCall(reference, myProcessed, searchScope, aggregator));
        Collection<PolyglotCallHierarchyNodeDescriptor> collection = aggregator.getChildrenCollection();
        if (collection == null) {
            OCCallStructureProvider.$$$reportNull$$$0(11);
        }
        return collection;
    }

    @Override
    @Nullable
    public Query<PsiReference> getReferencesSearchQuery(@NotNull OCCallHierarchyNodeDescriptor descriptor, @NotNull SearchScope searchScope) {
        PsiElement methodElement;
        OCCallable enclosingElement;
        OCSymbol symbol;
        if (descriptor == null) {
            OCCallStructureProvider.$$$reportNull$$$0(12);
        }
        if (searchScope == null) {
            OCCallStructureProvider.$$$reportNull$$$0(13);
        }
        OCSymbol oCSymbol = symbol = (enclosingElement = descriptor.getEnclosingElement()) != null ? enclosingElement.getSymbol() : null;
        if (symbol != null && descriptor.getProject() != null && (methodElement = symbol.locateDefinition(descriptor.getProject())) != null) {
            return ReferencesSearch.search((PsiElement)methodElement, (SearchScope)searchScope);
        }
        return null;
    }

    @Override
    @NotNull
    public OCCallHierarchyNodeDescriptor createNodeDescriptor(@NotNull Project project, @Nullable PolyglotCallHierarchyNodeDescriptor parentDescriptor, @NotNull PsiElement element, boolean isBase, boolean navigateToReference) {
        if (project == null) {
            OCCallStructureProvider.$$$reportNull$$$0(14);
        }
        if (element == null) {
            OCCallStructureProvider.$$$reportNull$$$0(15);
        }
        return new OCCallHierarchyNodeDescriptor(project, parentDescriptor, element, isBase, navigateToReference);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/hierarchy/call/OCCallStructureProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myProcessed";
                break;
            }
            case 6: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aggregator";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/hierarchy/call/OCCallStructureProvider";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCallees";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "processCallers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getElementFromContext";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getImplementationOfMethod";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildCallees";
                break;
            }
            case 3: 
            case 4: 
            case 11: {
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processCall";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processCallers";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesSearchQuery";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createNodeDescriptor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 11 -> new IllegalStateException(string);
        };
    }

    private static final class ChildrenCalculator
    extends OCCallHierarchyNodeAggregator {
        private final boolean myParentIsConstructorDestructor;

        private ChildrenCalculator(OCCallHierarchyNodeDescriptor parentDescriptor) {
            super(parentDescriptor);
            OCFunctionSymbol function;
            OCSymbol symbol;
            OCCallable parent = parentDescriptor.getEnclosingElement();
            this.myParentIsConstructorDestructor = parent != null ? ((symbol = parent.getSymbol()) instanceof OCFunctionSymbol ? (function = (OCFunctionSymbol)symbol).isCppConstructor() || function.isCppDestructor() : false) : false;
        }

        private void visit(@NotNull PsiElement element) {
            PsiElement[] children;
            if (element == null) {
                ChildrenCalculator.$$$reportNull$$$0(0);
            }
            for (PsiElement child : children = element.getChildren()) {
                String selectorName;
                PolyglotCallHierarchyNodeDescriptor desc;
                OCMethodSymbol impl;
                boolean isVirtual;
                OCSymbol known;
                this.visit(child);
                if (child instanceof OCReferenceElement) {
                    PsiElement parent = child.getParent().getParent();
                    if (!(parent instanceof OCCallExpression) && !(parent instanceof OCCppNewExpression) || !((known = ((OCReferenceElement)child).resolveToSymbol()) instanceof OCFunctionSymbol)) continue;
                    isVirtual = !this.myParentIsConstructorDestructor && ((OCReferenceElement)child).getNamespaceQualifier() == null;
                    this.processFunctionSymbol((OCFunctionSymbol)known, (OCElement)child, isVirtual);
                    continue;
                }
                if (child instanceof OCQualifiedExpression) {
                    known = ((OCQualifiedExpression)child).resolveToSymbol();
                    if (known instanceof OCMethodSymbol) {
                        this.processMethodSymbol((OCMethodSymbol)known, (OCElement)child);
                        continue;
                    }
                    if (child.getParent() instanceof OCCallExpression && known instanceof OCFunctionSymbol) {
                        isVirtual = !this.myParentIsConstructorDestructor && OCFunctionReferenceSearch.isCallViaReference(((OCQualifiedExpression)child).getQualifier());
                        this.processFunctionSymbol((OCFunctionSymbol)known, (OCElement)child, isVirtual);
                        continue;
                    }
                    if (!(known instanceof OCPropertySymbol)) continue;
                    OCPropertySymbol property = (OCPropertySymbol)known;
                    ReadWriteAccessDetector.Access access = new OCReadWriteAccessDetector().getExpressionAccess(child);
                    property.getParent().processMembers(OCMethodSymbol.class, method -> {
                        if (method.getOriginalSymbol() == property) {
                            OCResolveContext context = OCResolveContext.forPsi(element);
                            if (access == ReadWriteAccessDetector.Access.Read && method.isGetter(context) || access == ReadWriteAccessDetector.Access.Write && method.isSetter(context) || access == ReadWriteAccessDetector.Access.ReadWrite) {
                                this.processMethodSymbol((OCMethodSymbol)method, (OCElement)child);
                            }
                        }
                        return true;
                    });
                    continue;
                }
                if (!(child instanceof OCSendMessageExpression)) continue;
                OCSendMessageExpression callExpression = (OCSendMessageExpression)child;
                OCSendMessageExpression.ProbableResponders responders = callExpression.getProbableResponders();
                OCObjectTypeContext receiverContext = callExpression.getReceiverContext();
                if (receiverContext == null) continue;
                OCMethodSymbol known2 = responders.getKnownResponder();
                if (known2 != null && !known2.isDefinition() && (impl = known2.getDefinitionSymbol(element.getProject())) != null) {
                    known2 = impl;
                }
                if ((desc = this.addNodeDescriptor(known2, selectorName = callExpression.getMessageSelector(), child, null)) == null) continue;
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(selectorName, receiverContext.getType().getClassSymbol(), element.getProject(), OCMethodSymbol.class, receiverContext.getStaticMode());
                ChildrenCalculator.setSearchParameters(parameters);
                OCMemberInheritorsSearch.search(parameters).forEach(symbol -> {
                    if (receiverContext.fitsStaticness((OCMemberSymbol)symbol) && symbol.isDefinition()) {
                        desc.addPossibleInheritor((OCSymbol)symbol);
                    }
                    return true;
                });
            }
        }

        private void processMethodSymbol(@NotNull OCMethodSymbol known, @NotNull OCElement context) {
            PolyglotCallHierarchyNodeDescriptor desc;
            OCMethodSymbol impl;
            if (known == null) {
                ChildrenCalculator.$$$reportNull$$$0(1);
            }
            if (context == null) {
                ChildrenCalculator.$$$reportNull$$$0(2);
            }
            @NotNull Project myProject = context.getProject();
            if (!known.isDefinition() && (impl = known.getDefinitionSymbol(myProject)) != null) {
                known = impl;
            }
            if ((desc = this.addNodeDescriptor(known, null, context, null)) != null) {
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> parameters = OCMemberInheritorsSearch.getParameters(known, myProject);
                ChildrenCalculator.setSearchParameters(parameters);
                OCMemberInheritorsSearch.search(parameters).forEach(symbol -> {
                    if (symbol.isDefinition()) {
                        desc.addPossibleInheritor((OCSymbol)symbol);
                    }
                    return true;
                });
            }
        }

        private void processFunctionSymbol(@NotNull OCFunctionSymbol known, @NotNull OCElement context, boolean virtualCall) {
            PolyglotCallHierarchyNodeDescriptor desc;
            OCSymbol impl;
            if (known == null) {
                ChildrenCalculator.$$$reportNull$$$0(3);
            }
            if (context == null) {
                ChildrenCalculator.$$$reportNull$$$0(4);
            }
            @NotNull Project myProject = context.getProject();
            if (known.isPredeclaration() && (impl = known.getDefinitionSymbol(myProject)) instanceof OCFunctionSymbol) {
                known = (OCFunctionSymbol)impl;
            }
            if ((desc = this.addNodeDescriptor(known, null, context, null)) != null && virtualCall && OCFunctionAncestorsQuery.findFirstVirtual(known, true, myProject) != null) {
                OCFile file = context.getContainingOCFile();
                OCFunctionInheritorsSearch.SearchParameters parameters = OCFunctionInheritorsSearch.getParameters(known, file, true);
                HashSet names = new HashSet();
                parameters.setImplementationsThenPredeclarations(true);
                parameters.setIncludeSameSymbols(true);
                OCResolveContext resolveContext = OCResolveContext.forPsi(context);
                OCFunctionInheritorsSearch.search(parameters).forEach(symbol -> {
                    if (names.add(symbol.getResolvedQualifiedName(resolveContext))) {
                        desc.addPossibleInheritor((OCSymbol)symbol);
                    }
                    return true;
                });
            }
        }

        private static void setSearchParameters(@NotNull OCMemberInheritorsSearch.SearchParameters<?> parameters) {
            if (parameters == null) {
                ChildrenCalculator.$$$reportNull$$$0(5);
            }
            parameters.setIncludeSelfImplementation(true);
            parameters.setInterfacesThenImplementations(false);
            parameters.setIncludeFromID(true);
            parameters.setInheritors(true);
            parameters.setAncestors(false);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "known";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/cidr/lang/hierarchy/call/OCCallStructureProvider$ChildrenCalculator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "visit";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processMethodSymbol";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processFunctionSymbol";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setSearchParameters";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

