/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.OCTestFrameworks;
import com.jetbrains.cidr.lang.inspections.OCChecksSettings;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedObjCInspection;
import com.jetbrains.cidr.lang.inspections.OCUnusedVisitor;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.impl.OCArraySelectionExpressionImpl;
import com.jetbrains.cidr.lang.quickfixes.OCChangeGCCAttributeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCSafeDeleteIntentionAction;
import com.jetbrains.cidr.lang.search.OCElementInMacroAndNonCompiledCodeReferencesSearch;
import com.jetbrains.cidr.lang.search.OCMemberInheritorsSearch;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class OCUnusedMethodInspection
extends OCUnusedObjCInspection {
    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = OCInspectionsBundle.message((String)"inspection.unused.method.display.name", (Object[])new Object[0]);
        if (string == null) {
            OCUnusedMethodInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public OCUnusedVisitor buildVisitor() {
        return new OCUnusedVisitor((OCInspection)this){

            @Override
            public void visitMethod(OCMethod method) {
                SearchScope scope;
                OCMethodSymbol methodSymbol;
                Project project;
                OCSymbol symbol;
                block14: {
                    block13: {
                        symbol = this.getSymbol(method);
                        project = method.getProject();
                        if (!(symbol instanceof OCMethodSymbol)) break block13;
                        methodSymbol = (OCMethodSymbol)symbol;
                        if (!symbol.isUnused()) break block14;
                    }
                    return;
                }
                OCChecksSettings.UnusedChecksMode checksMode = (OCChecksSettings.UnusedChecksMode)project.getUserData(OCChecksSettings.UNUSED_CHECKS);
                if (!OCSearchScope.isInProjectSources(symbol, project) || checksMode == OCChecksSettings.UnusedChecksMode.DISABLED) {
                    return;
                }
                String selector = method.getSelector();
                OCMethodSymbol associatedSymbol = methodSymbol.getAssociatedSymbol(project);
                if (OCTestFrameworks.isTestMethodOrFunction(methodSymbol, method, project) && OCTestFrameworks.isTestClassOrStruct(methodSymbol.getParent(), method.getContainingClass(), project) || methodSymbol.getName().startsWith("keyPathsForValuesAffecting") || OCArraySelectionExpressionImpl.isArraySubscriptMethod(methodSymbol)) {
                    return;
                }
                if (associatedSymbol != null) {
                    if (!this.myOnTheFly && (methodSymbol.isDefinition() || methodSymbol.getGeneratedFromProperty() != null) || associatedSymbol.isUnused()) {
                        return;
                    }
                    OCPropertySymbol property = associatedSymbol.getGeneratedFromProperty();
                    if (property != null) {
                        this.checkSymbolUsed(method, method.getParameters().get(0).getSelectorIdentifier(), property);
                        return;
                    }
                }
                Object object = scope = this.myScope != null ? this.myScope : OCSearchScope.getProjectSourcesScope(project);
                if (scope instanceof GlobalSearchScope && PsiSearchHelper.getInstance((Project)project).isCheapEnoughToSearch(selector, (GlobalSearchScope)scope, method.getContainingFile()) == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return;
                }
                if (ReferencesSearch.search((PsiElement)method, (SearchScope)scope, (boolean)false).anyMatch(ref -> !(ref.getElement() instanceof OCMethod))) {
                    return;
                }
                CommonProcessors.FindFirstProcessor macroFinder = new CommonProcessors.FindFirstProcessor();
                ReferencesSearch.SearchParameters macroParameters = new ReferencesSearch.SearchParameters((PsiElement)method, (SearchScope)OCSearchScope.getProjectSourcesScope(project), false);
                new OCElementInMacroAndNonCompiledCodeReferencesSearch().execute(macroParameters, (Processor<? super OCElementInMacroAndNonCompiledCodeReferencesSearch.Usage>)macroFinder);
                if (macroFinder.isFound()) {
                    return;
                }
                OCMemberInheritorsSearch.SearchParameters<OCMethodSymbol> searchParameters = OCMemberInheritorsSearch.getParameters(method);
                searchParameters.setInheritors(false);
                searchParameters.setAncestors(true);
                searchParameters.setIncludeFromID(true);
                if (OCMemberInheritorsSearch.search(searchParameters).findFirst() == null) {
                    List<PsiElement> selectors = method.getSelectors();
                    if (!this.myOnTheFly && !selectors.isEmpty()) {
                        selectors = Collections.singletonList(selectors.get(0));
                    }
                    OCCompilationContext context = OCCompilationContext.create(method);
                    this.registerProblems(selectors, OCBundle.message("inspection.name.is.never.used", symbol.getNameWithKindUppercase(context)), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new OCSafeDeleteIntentionAction((PsiElement)method, symbol.getNameWithKindLowercase(context)), OCChangeGCCAttributeIntentionAction.unused(methodSymbol, method.getContainingFile()));
                }
            }
        };
    }

    public boolean runForWholeFile() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/inspections/OCUnusedMethodInspection", "getDisplayName"));
    }
}

