/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.intentions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cidr.lang.OCInspectionsBundle;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCConditionalExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCExpressionStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaIntroducer;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCSplitDeclarationAndAssignmentIntentionAction
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = OCInspectionsBundle.message((String)"intentions.split.declaration", (Object[])new Object[0]);
        if (string == null) {
            OCSplitDeclarationAndAssignmentIntentionAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            OCSplitDeclarationAndAssignmentIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile psiFile) {
        OCSymbol symbol;
        if (project == null) {
            OCSplitDeclarationAndAssignmentIntentionAction.$$$reportNull$$$0(2);
        }
        if (!OCCodeInsightUtil.isValid((PsiElement)psiFile)) {
            return false;
        }
        OCDeclarator declarator = OCSplitDeclarationAndAssignmentIntentionAction.getDeclarator(editor, psiFile);
        OCSymbol oCSymbol = symbol = declarator != null ? declarator.getSymbol() : null;
        if (declarator != null && declarator.getResolvedType() instanceof OCCppReferenceType) {
            return false;
        }
        return symbol instanceof OCDeclaratorSymbol && declarator.getInitializer() != null && !(declarator.getInitializer() instanceof OCCompoundInitializer) && !(declarator.getParent().getParent() instanceof OCLambdaIntroducer) && PsiTreeUtil.getParentOfType((PsiElement)declarator, OCBlockStatement.class) != null && !((OCDeclaratorSymbol)symbol).isConst();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile psiFile) throws IncorrectOperationException {
        if (project == null) {
            OCSplitDeclarationAndAssignmentIntentionAction.$$$reportNull$$$0(3);
        }
        PsiDocumentManager.getInstance((Project)project).commitDocument(psiFile.getViewProvider().getDocument());
        OCDeclarator declarator = OCSplitDeclarationAndAssignmentIntentionAction.getDeclarator(editor, psiFile);
        if (declarator == null) {
            return;
        }
        String name = declarator.getName();
        OCBlockStatement block = (OCBlockStatement)PsiTreeUtil.getParentOfType((PsiElement)declarator, OCBlockStatement.class);
        if (block != null) {
            OCExpressionStatement assignment = OCElementUtil.getTextWithMacros(declarator.getParent()).endsWith(";") ? (OCExpressionStatement)OCElementFactory.statementFromText(name + "=0;", declarator, false) : (OCExpressionStatement)((OCForStatement)OCElementFactory.statementFromText("for(" + name + "=0;;);", declarator, false)).getInitializer();
            OCExpression initializer = declarator.getInitializer();
            OCType initializerType = OCSplitDeclarationAndAssignmentIntentionAction.resolveInitializerType(initializer);
            OCChangeUtil.replaceHandlingMacros(((OCAssignmentExpression)assignment.getExpression()).getSourceExpression(), initializer);
            OCChangeUtil.delete(initializer);
            OCTypeElement typeElement = ((OCDeclaration)declarator.getParent()).getTypeElement();
            if (declarator.getType().getTerminalType() instanceof OCAutoType && typeElement != null && initializerType != null) {
                OCChangeUtil.replaceHandlingMacros(typeElement, OCElementFactory.typeElementFromText(initializerType.getBestNameInContext(declarator), declarator));
            }
            OCStatement declStatement = OCElementFactory.statementFromText(OCElementUtil.getTextWithMacros(declarator.getParent()) + ";", declarator);
            OCChangeUtil.addBefore(block, declStatement, declarator);
            OCChangeUtil.replaceHandlingMacros(PsiTreeUtil.getParentOfType((PsiElement)declarator, OCStatement.class), assignment);
        }
    }

    @Nullable
    private static OCType resolveInitializerType(@Nullable OCExpression initializer) {
        if (initializer == null) {
            return null;
        }
        OCType resolvedType = initializer.getResolvedType();
        if (!resolvedType.isUnknown()) {
            return resolvedType;
        }
        if (!(initializer instanceof OCConditionalExpression)) {
            return null;
        }
        OCConditionalExpression conditionalExpr = (OCConditionalExpression)initializer;
        OCExpression pos = conditionalExpr.getPositiveExpression(false);
        OCExpression neg = conditionalExpr.getNegativeExpression();
        if (pos == null || neg == null) {
            return null;
        }
        if (pos instanceof OCCastExpression) {
            return ((OCCastExpression)pos).getCastType();
        }
        if (neg instanceof OCCastExpression) {
            return ((OCCastExpression)neg).getCastType();
        }
        OCType posType = pos.getResolvedType().getTerminalType();
        OCType negType = neg.getResolvedType().getTerminalType();
        OCResolveContext context = OCResolveContext.forPsi(initializer);
        OCTypeEqualityVisitor typeEqualityVisitor = new OCTypeEqualityVisitor(posType, false, context);
        if (!posType.isUnknown() && typeEqualityVisitor.equal(negType)) {
            return posType;
        }
        return OCSplitDeclarationAndAssignmentIntentionAction.checkConversionOperators(posType, negType, context);
    }

    @Nullable
    private static OCType checkConversionOperators(@NotNull OCType posType, @NotNull OCType negType, @NotNull OCResolveContext context) {
        if (posType == null) {
            OCSplitDeclarationAndAssignmentIntentionAction.$$$reportNull$$$0(4);
        }
        if (negType == null) {
            OCSplitDeclarationAndAssignmentIntentionAction.$$$reportNull$$$0(5);
        }
        if (context == null) {
            OCSplitDeclarationAndAssignmentIntentionAction.$$$reportNull$$$0(6);
        }
        Project project = context.getProject();
        Function<OCType, OCType> keepPtrType = type -> {
            if (type instanceof OCPointerType) {
                return type;
            }
            return type.cloneWithoutCVQualifiers(project);
        };
        if (posType.isConvertibleByOperator(negType, context, false)) {
            return keepPtrType.apply(posType);
        }
        if (negType.isConvertibleByOperator(posType, context, false)) {
            return keepPtrType.apply(negType);
        }
        if (posType.isIntegerCompatible(context) && negType.isIntegerCompatible(context)) {
            return OCIntType.INT;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nullable
    private static OCDeclarator getDeclarator(Editor editor, PsiFile file) {
        OCTypeElement typeElement;
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        OCDeclarator declarator = OCElementUtil.getAdjacentParentOfType(element, OCDeclarator.class);
        if (declarator == null && (typeElement = OCElementUtil.getAdjacentParentOfType(element, OCTypeElement.class)) != null && typeElement.getParent() instanceof OCDeclaration && ((OCDeclaration)typeElement.getParent()).getDeclarators().size() == 1) {
            return ((OCDeclaration)typeElement.getParent()).getDeclarators().get(0);
        }
        return declarator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/intentions/OCSplitDeclarationAndAssignmentIntentionAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "posType";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "negType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/intentions/OCSplitDeclarationAndAssignmentIntentionAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkConversionOperators";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

