/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.interactive.cling.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.interactive.OCInteractiveBundle;
import com.jetbrains.cidr.lang.interactive.cling.OCClingInteractiveHost;
import com.jetbrains.cidr.lang.interactive.cling.OCClingSettings;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCIncludeDirective;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cidr/lang/interactive/cling/actions/OCSendIncludedHeadersToClingAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "()V", "getIncludes", "", "file", "Lcom/jetbrains/cidr/lang/psi/OCFile;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.c.core"})
public final class OCSendIncludedHeadersToClingAction
extends AnAction {
    private final String getIncludes(OCFile file) {
        List<OCIncludeDirective> list = file.findIncludeDirectives();
        Intrinsics.checkNotNullExpressionValue(list, (String)"findIncludeDirectives(...)");
        return CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"\n", null, null, (int)0, null, OCSendIncludedHeadersToClingAction::getIncludes$lambda$0, (int)30, null);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Object object = e.getData(CommonDataKeys.PSI_FILE);
        OCFile oCFile = object instanceof OCFile ? (OCFile)object : null;
        if (oCFile == null) {
            return;
        }
        OCFile file = oCFile;
        String includedHeaders = this.getIncludes(file);
        if (((CharSequence)includedHeaders).length() > 0) {
            OCClingInteractiveHost host = OCClingInteractiveHost.Companion.getInstance(project2);
            host.sendToConsole$intellij_c_core(includedHeaders);
            host.requestFocus();
        }
    }

    public void update(@NotNull AnActionEvent e) {
        OCFile file;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getData(CommonDataKeys.PSI_FILE);
        OCFile oCFile = file = object instanceof OCFile ? (OCFile)object : null;
        if (file == null || !OCClingSettings.Companion.getInstance().isClingAvailable()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        String includedHeaders = this.getIncludes(file);
        e.getPresentation().setEnabled(((CharSequence)includedHeaders).length() > 0);
        e.getPresentation().setText(OCInteractiveBundle.INSTANCE.message("action.CIDR.Interactive.SendIncludesToCling.text", new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    private static final CharSequence getIncludes$lambda$0(OCIncludeDirective it) {
        String string = it.getTextWithMacros();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTextWithMacros(...)");
        return string;
    }
}

