/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.modulemap.serialization;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.lang.modulemap.AllowedModules;
import com.jetbrains.cidr.lang.modulemap.ModuleMapLog;
import com.jetbrains.cidr.lang.modulemap.ModuleMapRoot;
import com.jetbrains.cidr.lang.modulemap.ModuleMapUtil;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapManager;
import com.jetbrains.cidr.lang.modulemap.resolve.ModuleMapPlatformType;
import com.jetbrains.cidr.lang.modulemap.serialization.DependencyInitializer;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapAssembledPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapBundledSerializationData;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapConcurrentSerializationService;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapInitialDeserializationPack;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapPlatformHolder;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapProjectSerializedData;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapReference;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationInfo;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationService;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleMapSerializationStorage;
import com.jetbrains.cidr.lang.modulemap.serialization.ModuleSeriailzationUtilKt;
import com.jetbrains.cidr.lang.modulemap.serialization.PackAssembler;
import com.jetbrains.cidr.lang.modulemap.serialization.RefToMapIndex;
import com.jetbrains.cidr.lang.modulemap.serialization.RootsWithConfigurations;
import com.jetbrains.cidr.lang.modulemap.serialization.SerializedModuleMap;
import com.jetbrains.cidr.lang.modulemap.serialization.ValidPackCollector;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMap;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapCache;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapPack;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapPackWithRoot;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSignature;
import com.jetbrains.cidr.lang.modulemap.symbols.ModuleMapSymbol;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0018\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\b\u0010\u0011\u001a\u00020\tH\u0002J\u0018\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0014\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J,\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0016\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u00162\u0006\u0010\f\u001a\u00020\rH\u0002J&\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u00162\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u001e\u001a\u00020\u000fH\u0002J\"\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0002J\u0016\u0010$\u001a\u00020\t2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0016H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapDeserializationSession;", "", "project", "Lcom/intellij/openapi/project/Project;", "serializationService", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationService;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapSerializationService;)V", "deserializeModuleMaps", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "roots", "Lcom/jetbrains/cidr/lang/modulemap/serialization/RootsWithConfigurations;", "bundledOnly", "", "deserializeForAllowedModuleRebuild", "reportDeserializationFailure", "deserializeAllModuleMaps", "deserializeBundledModuleMapsOnly", "doDeserializePacks", "deserializeRawPacks", "", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapAssembledPack;", "preparedPacks", "Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapInitialDeserializationPack;", "prepareInitialPacks", "initializeDependencies", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapPackWithRoot;", "deserializedPacks", "ignoreSetupErrors", "buildModuleToSignatureIndex", "", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSymbol;", "Lcom/jetbrains/cidr/lang/modulemap/symbols/ModuleMapSignature;", "packs", "flushValidPacksToModuleMapCache", "validPacks", "intellij.c.core"})
@SourceDebugExtension(value={"SMAP\nModuleMapDeserializationSession.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModuleMapDeserializationSession.kt\ncom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapDeserializationSession\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,174:1\n1#2:175\n*E\n"})
public final class ModuleMapDeserializationSession {
    @NotNull
    private final Project project;
    @NotNull
    private final ModuleMapSerializationService serializationService;

    public ModuleMapDeserializationSession(@NotNull Project project, @NotNull ModuleMapSerializationService serializationService) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)serializationService, (String)"serializationService");
        this.project = project;
        this.serializationService = serializationService;
    }

    public final void deserializeModuleMaps(@NotNull ProgressIndicator indicator, @NotNull RootsWithConfigurations roots, boolean bundledOnly) {
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        ModuleMapLog.INSTANCE.reportDeserializationStarted(this.project, roots);
        if (AllowedModules.Companion.isRebuildRequired()) {
            this.deserializeForAllowedModuleRebuild(indicator, roots);
            return;
        }
        if (!bundledOnly) {
            if (this.deserializeAllModuleMaps(indicator, roots)) {
                return;
            }
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new AssertionError((Object)"Deserialization failed");
            }
            ModuleMapLog.LOG.error("Module map deserialization failed");
        }
        if (this.deserializeBundledModuleMapsOnly(indicator, roots)) {
            return;
        }
        this.reportDeserializationFailure();
    }

    private final void deserializeForAllowedModuleRebuild(ProgressIndicator indicator, RootsWithConfigurations roots) {
        if (!this.deserializeBundledModuleMapsOnly(indicator, roots)) {
            this.reportDeserializationFailure();
        }
    }

    private final void reportDeserializationFailure() {
        ModuleMapLog.LOG.error("Bundled module map deserialization failed");
    }

    private final boolean deserializeAllModuleMaps(ProgressIndicator indicator, RootsWithConfigurations roots) {
        return this.doDeserializePacks(indicator, roots, false);
    }

    private final boolean deserializeBundledModuleMapsOnly(ProgressIndicator indicator, RootsWithConfigurations roots) {
        ModuleMapCache.Companion.getInstance(this.project).reset();
        ModuleMapManager.Companion.getInstance(this.project).clearCache();
        return this.doDeserializePacks(indicator, roots, true);
    }

    private final boolean doDeserializePacks(ProgressIndicator indicator, RootsWithConfigurations roots, boolean bundledOnly) {
        List<ModuleMapInitialDeserializationPack> preparedPacks = this.prepareInitialPacks(roots);
        ModuleMapLog.INSTANCE.reportDeserializationPacksCreated(this.project, preparedPacks);
        List<ModuleMapAssembledPack> packs = this.deserializeRawPacks(preparedPacks, indicator, bundledOnly);
        ModuleMapLog.INSTANCE.reportDeserializationRawPacks(this.project, packs);
        List<ModuleMapPackWithRoot> initializedPacks = this.initializeDependencies(packs, bundledOnly);
        ModuleMapLog.INSTANCE.reportDependenciesInitialized(this.project, initializedPacks);
        if (initializedPacks == null) {
            return false;
        }
        this.flushValidPacksToModuleMapCache(initializedPacks);
        ModuleMapLog.LOG.info("Loaded " + ModuleSeriailzationUtilKt.flatSize((Collection<ModuleMapPackWithRoot>)initializedPacks) + " module maps in " + initializedPacks.size() + " packs for " + roots.getSize() + " search roots");
        return true;
    }

    private final List<ModuleMapAssembledPack> deserializeRawPacks(List<ModuleMapInitialDeserializationPack> preparedPacks, ProgressIndicator indicator, boolean bundledOnly) {
        boolean shouldDeserializeNonBundledPacks = ModuleMapCache.Companion.shouldReloadCache();
        ConcurrentLinkedDeque<ModuleMapAssembledPack> concurrentDeque = new ConcurrentLinkedDeque<ModuleMapAssembledPack>();
        ModuleMapConcurrentSerializationService.Companion.getInstance().deserialize(preparedPacks, indicator, this.serializationService, (Function3<? super ModuleMapInitialDeserializationPack, ? super ModuleMapBundledSerializationData, ? super ModuleMapProjectSerializedData, Unit>)((Function3)new Function3<ModuleMapInitialDeserializationPack, ModuleMapBundledSerializationData, ModuleMapProjectSerializedData, Unit>(indicator, shouldDeserializeNonBundledPacks, concurrentDeque, bundledOnly){
            final /* synthetic */ ProgressIndicator $indicator;
            final /* synthetic */ boolean $shouldDeserializeNonBundledPacks;
            final /* synthetic */ ConcurrentLinkedDeque<ModuleMapAssembledPack> $concurrentDeque;
            final /* synthetic */ boolean $bundledOnly;
            {
                this.$indicator = $indicator;
                this.$shouldDeserializeNonBundledPacks = $shouldDeserializeNonBundledPacks;
                this.$concurrentDeque = $concurrentDeque;
                this.$bundledOnly = $bundledOnly;
                super(3, Intrinsics.Kotlin.class, "assemblePack", "deserializeRawPacks$assemblePack(Lcom/intellij/openapi/progress/ProgressIndicator;ZLjava/util/concurrent/ConcurrentLinkedDeque;ZLcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapInitialDeserializationPack;Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapBundledSerializationData;Lcom/jetbrains/cidr/lang/modulemap/serialization/ModuleMapProjectSerializedData;)V", 0);
            }

            public final void invoke(ModuleMapInitialDeserializationPack p0, ModuleMapBundledSerializationData p1, ModuleMapProjectSerializedData p2) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ModuleMapDeserializationSession.access$deserializeRawPacks$assemblePack(this.$indicator, this.$shouldDeserializeNonBundledPacks, this.$concurrentDeque, this.$bundledOnly, p0, p1, p2);
            }
        }));
        List assembledPacks = CollectionsKt.toList((Iterable)concurrentDeque);
        return assembledPacks;
    }

    private final List<ModuleMapInitialDeserializationPack> prepareInitialPacks(RootsWithConfigurations roots) {
        ModuleMapPlatformHolder platformHolder = new ModuleMapPlatformHolder();
        List preparedPacks = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)roots.getEntries()), ModuleMapDeserializationSession::prepareInitialPacks$lambda$1), arg_0 -> ModuleMapDeserializationSession.prepareInitialPacks$lambda$2(this, platformHolder, arg_0)), ModuleMapDeserializationSession::prepareInitialPacks$lambda$3));
        return preparedPacks;
    }

    private final List<ModuleMapPackWithRoot> initializeDependencies(List<ModuleMapAssembledPack> deserializedPacks, boolean ignoreSetupErrors) {
        Map<ModuleMapReference, SerializedModuleMap> refToSerializedModuleMap = new RefToMapIndex(deserializedPacks).buildRefToMapIndex();
        ModuleMapLog.INSTANCE.reportRefToSerializedModuleMap(this.project, refToSerializedModuleMap);
        List<ModuleMapAssembledPack> validPacks = new ValidPackCollector(deserializedPacks, refToSerializedModuleMap, ignoreSetupErrors).collectValidPacks();
        ModuleMapLog.INSTANCE.reportValidPacks(this.project, validPacks);
        Map<ModuleMapSymbol, ModuleMapSignature> moduleToSignature = this.buildModuleToSignatureIndex(validPacks);
        DependencyInitializer dependencyInitializer = new DependencyInitializer(validPacks, refToSerializedModuleMap, moduleToSignature, ignoreSetupErrors, this.project);
        return dependencyInitializer.setupModuleDependencies();
    }

    private final Map<ModuleMapSymbol, ModuleMapSignature> buildModuleToSignatureIndex(List<ModuleMapAssembledPack> packs) {
        Map result = new LinkedHashMap();
        for (ModuleMapAssembledPack pack : packs) {
            for (SerializedModuleMap serializedModuleMap : pack.getData().getAllMaps()) {
                ModuleMap moduleMap = serializedModuleMap.getModuleMap();
                for (ModuleMapSymbol module : ModuleMapUtil.allModules$default(moduleMap, null, 1, null)) {
                    result.put(module, moduleMap.getSignature());
                }
            }
        }
        return result;
    }

    private final void flushValidPacksToModuleMapCache(List<ModuleMapPackWithRoot> validPacks) {
        ModuleMapCache moduleMapCache = ModuleMapCache.Companion.getInstance(this.project);
        for (ModuleMapPackWithRoot pack : validPacks) {
            ModuleMapPack moduleMapPack = pack.getModuleMapPack();
            moduleMapPack.compact();
            moduleMapCache.cache(pack.getModuleMapRoot(), moduleMapPack);
        }
    }

    private static final void deserializeRawPacks$assemblePack(ProgressIndicator $indicator, boolean shouldDeserializeNonBundledPacks, ConcurrentLinkedDeque<ModuleMapAssembledPack> concurrentDeque, boolean $bundledOnly, ModuleMapInitialDeserializationPack pack, ModuleMapBundledSerializationData bundledData, ModuleMapProjectSerializedData projectData) {
        ModuleMapProjectSerializedData moduleMapProjectSerializedData;
        ModuleMapProjectSerializedData moduleMapProjectSerializedData2 = moduleMapProjectSerializedData = projectData;
        ModuleMapBundledSerializationData moduleMapBundledSerializationData = bundledData;
        ModuleMapInitialDeserializationPack moduleMapInitialDeserializationPack = pack;
        PackAssembler packAssembler = PackAssembler.INSTANCE;
        boolean bl = false;
        boolean bl2 = $bundledOnly;
        ModuleMapAssembledPack assembledPack = packAssembler.assemblePack(moduleMapInitialDeserializationPack, moduleMapBundledSerializationData, !bl2 ? moduleMapProjectSerializedData : null);
        ModuleMapLog.INSTANCE.reportAssembledPack(pack, assembledPack);
        if (assembledPack == null) {
            return;
        }
        $indicator.setText2(assembledPack.getModuleMapRoot().getRoot().getName());
        if (!shouldDeserializeNonBundledPacks && assembledPack.getData().getBundledMaps().isEmpty()) {
            return;
        }
        concurrentDeque.add(assembledPack);
    }

    private static final boolean prepareInitialPacks$lambda$1(Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return ((ModuleMapRoot)entry.getKey()).getRoot().isValid();
    }

    private static final ModuleMapInitialDeserializationPack prepareInitialPacks$lambda$2(ModuleMapDeserializationSession this$0, ModuleMapPlatformHolder $platformHolder, Map.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"<destruct>");
        ModuleMapRoot moduleMapRoot = (ModuleMapRoot)entry.getKey();
        List configurations = (List)entry.getValue();
        ModuleMapSerializationInfo info = this$0.serializationService.createSerializationInfo(moduleMapRoot);
        Set<ModuleMapPlatformType> platforms = $platformHolder.getPlatforms(configurations);
        return new ModuleMapInitialDeserializationPack(platforms, info);
    }

    private static final boolean prepareInitialPacks$lambda$3(ModuleMapInitialDeserializationPack it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it.getInfo().getStorage(), (Object)ModuleMapSerializationStorage.None.INSTANCE);
    }

    public static final /* synthetic */ void access$deserializeRawPacks$assemblePack(ProgressIndicator $indicator, boolean shouldDeserializeNonBundledPacks, ConcurrentLinkedDeque concurrentDeque, boolean $bundledOnly, ModuleMapInitialDeserializationPack pack, ModuleMapBundledSerializationData bundledData, ModuleMapProjectSerializedData projectData) {
        ModuleMapDeserializationSession.deserializeRawPacks$assemblePack($indicator, shouldDeserializeNonBundledPacks, concurrentDeque, $bundledOnly, pack, bundledData, projectData);
    }
}

