/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.preprocessor;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import com.jetbrains.cidr.lang.preprocessor.OCContextChange;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class OCContextChangeSet {
    @NotNull
    private final String myText;
    @NotNull
    private Int2ObjectMap<OCContextChange> myChangeMap;
    private int myLastOffset;
    private boolean myIsUpdated;
    private boolean myUsingOriginalMap;

    private OCContextChangeSet(@NotNull String text, @NotNull Int2ObjectMap<OCContextChange> changeMap, boolean isUpdated, int lastOffset, boolean reusingMap) {
        if (text == null) {
            OCContextChangeSet.$$$reportNull$$$0(0);
        }
        if (changeMap == null) {
            OCContextChangeSet.$$$reportNull$$$0(1);
        }
        this.myText = text;
        this.myIsUpdated = isUpdated;
        this.myChangeMap = changeMap;
        this.myLastOffset = lastOffset;
        this.myUsingOriginalMap = reusingMap;
    }

    public boolean isUpdated() {
        return this.myIsUpdated;
    }

    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            OCContextChangeSet.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    public OCContextChange getChange(int offsetAfterInclude) {
        if (offsetAfterInclude > this.myLastOffset) {
            return null;
        }
        return (OCContextChange)this.myChangeMap.get(offsetAfterInclude);
    }

    public void setChange(int offsetAfterInclude, @NotNull OCContextChange change) {
        if (change == null) {
            OCContextChangeSet.$$$reportNull$$$0(3);
        }
        if (this.myUsingOriginalMap) {
            this.myUsingOriginalMap = false;
            this.myChangeMap = new Int2ObjectOpenHashMap(this.myChangeMap);
        }
        if (offsetAfterInclude > this.myLastOffset) {
            this.myLastOffset = offsetAfterInclude;
        }
        this.myChangeMap.put(offsetAfterInclude, (Object)change);
        this.myIsUpdated = true;
    }

    @NotNull
    public static OCContextChangeSet reuse(@NotNull String newText, @Nullable OCContextChangeSet from, int validateFrom, int validateTo) {
        int diffOffset;
        if (newText == null) {
            OCContextChangeSet.$$$reportNull$$$0(4);
        }
        if (from == null) {
            return new OCContextChangeSet(newText, (Int2ObjectMap<OCContextChange>)new Int2ObjectOpenHashMap(), true, 0, false);
        }
        if (validateTo < 0) {
            validateTo = newText.length();
        }
        assert (validateFrom >= 0);
        assert (validateTo >= validateFrom && validateTo <= newText.length());
        int oldLastOffset = from.myLastOffset;
        String oldText = from.getText();
        validateTo = Math.min(oldText.length(), Math.min(validateTo, oldLastOffset + 1));
        if (validateTo == (diffOffset = (validateFrom = Math.min(validateTo, Math.min(Math.min(validateFrom, oldText.length()), newText.length()))) + StringUtil.commonPrefixLength((CharSequence)OCContextChangeSet.subSequence(oldText, validateFrom, validateTo), (CharSequence)OCContextChangeSet.subSequence(newText, validateFrom, newText.length())))) {
            return new OCContextChangeSet(newText, from.myChangeMap, false, oldLastOffset, true);
        }
        int[] loRef = new int[]{0};
        Int2ObjectOpenHashMap fromMap = new Int2ObjectOpenHashMap(from.myChangeMap);
        fromMap.int2ObjectEntrySet().removeIf(entry -> {
            boolean valid;
            boolean bl = valid = ((OCContextChange)entry.getValue()).getOffset() < diffOffset;
            if (valid && loRef[0] < entry.getIntKey()) {
                loRef[0] = entry.getIntKey();
            }
            return !valid;
        });
        int lastOffset = loRef[0];
        return new OCContextChangeSet(newText, (Int2ObjectMap<OCContextChange>)fromMap, true, lastOffset, false);
    }

    @TestOnly
    @NotNull
    public List<OCContextChange> getChanges() {
        ArrayList<OCContextChange> result = new ArrayList<OCContextChange>((Collection<OCContextChange>)this.myChangeMap.values());
        result.sort(Comparator.comparingInt(OCContextChange::getOffset));
        ArrayList<OCContextChange> arrayList = result;
        if (arrayList == null) {
            OCContextChangeSet.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static CharSequence subSequence(CharSequence seq, int start, int end) {
        return new CharSequenceSubSequence(seq, start, end);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeMap";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "change";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/preprocessor/OCContextChangeSet";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChanges";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setChange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "reuse";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 5 -> new IllegalStateException(string);
        };
    }
}

