/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.psi.impl;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.parser.OCElementTypes;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.impl.OCExpressionWithReferenceBase;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.search.usages.OCReadWriteAccessDetector;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCArraySelectionExpressionImpl
extends OCExpressionWithReferenceBase<OCOperatorReference>
implements OCArraySelectionExpression {
    public OCArraySelectionExpressionImpl(@NotNull ASTNode node) {
        if (node == null) {
            OCArraySelectionExpressionImpl.$$$reportNull$$$0(0);
        }
        super(node);
    }

    @Override
    @Nullable
    protected OCOperatorReference createReference() {
        OCExpression array = this.getArrayExpression();
        OCExpression index = this.getIndexExpression();
        PsiElement operationSign = this.getOperationSign();
        if (index != null) {
            class OCSubscriptOperatorReference
            extends OCOperatorReference
            implements MultiRangeReference {
                OCSubscriptOperatorReference(OCElement element, PsiElement signElement, OCExpression ... params) {
                    super((PsiElement)element, "[]", OCOperatorReference.OperatorPlacement.POSTFIX, signElement, params);
                }

                @NotNull
                public List<TextRange> getRanges() {
                    PsiElement right;
                    ArrayList<TextRange> result = new ArrayList<TextRange>();
                    PsiElement left = OCArraySelectionExpressionImpl.this.findChildByType((IElementType)OCLexerTokenTypes.LBRACKET);
                    if (left != null) {
                        result.add(OCElementUtil.getRangeInParent(left));
                    }
                    if ((right = OCArraySelectionExpressionImpl.this.findChildByType((IElementType)OCLexerTokenTypes.RBRACKET)) != null) {
                        result.add(OCElementUtil.getRangeInParent(right));
                    }
                    ArrayList<TextRange> arrayList = result;
                    if (arrayList == null) {
                        OCSubscriptOperatorReference.$$$reportNull$$$0(0);
                    }
                    return arrayList;
                }

                @Override
                @NotNull
                public List<OCSymbol> resolveToSymbols(@NotNull OCResolveContext context) {
                    List<OCSymbol> subscriptMethod;
                    if (context == null) {
                        OCSubscriptOperatorReference.$$$reportNull$$$0(1);
                    }
                    if ((subscriptMethod = this.resolveToSubscript(context)) != null) {
                        List<OCSymbol> list = subscriptMethod;
                        if (list == null) {
                            OCSubscriptOperatorReference.$$$reportNull$$$0(2);
                        }
                        return list;
                    }
                    List<OCSymbol> list = super.resolveToSymbols(context);
                    if (list == null) {
                        OCSubscriptOperatorReference.$$$reportNull$$$0(3);
                    }
                    return list;
                }

                @Override
                @NotNull
                public List<OCSymbol> resolveToSymbols() {
                    List<OCSymbol> subscriptMethod = this.resolveToSubscript(OCResolveContext.forPsi(OCArraySelectionExpressionImpl.this));
                    if (subscriptMethod != null) {
                        List<OCSymbol> list = subscriptMethod;
                        if (list == null) {
                            OCSubscriptOperatorReference.$$$reportNull$$$0(4);
                        }
                        return list;
                    }
                    List<OCSymbol> list = super.resolveToSymbols();
                    if (list == null) {
                        OCSubscriptOperatorReference.$$$reportNull$$$0(5);
                    }
                    return list;
                }

                @Nullable
                protected List<OCSymbol> resolveToSubscript(@NotNull OCResolveContext context) {
                    OCMethodSymbol subscriptMethod;
                    if (context == null) {
                        OCSubscriptOperatorReference.$$$reportNull$$$0(6);
                    }
                    if (OCCompilerFeaturesHelper.supportsSubscripting(OCArraySelectionExpressionImpl.this.getContainingOCFile()) && (subscriptMethod = OCArraySelectionExpressionImpl.this.getArraySubscriptMethod(context)) != null) {
                        return Collections.singletonList(subscriptMethod);
                    }
                    return null;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 2;
                        case 1, 6 -> 3;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl$1OCSubscriptOperatorReference";
                            break;
                        }
                        case 1: 
                        case 6: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "context";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "getRanges";
                            break;
                        }
                        case 1: 
                        case 6: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl$1OCSubscriptOperatorReference";
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: 
                        case 5: {
                            objectArray = objectArray2;
                            objectArray2[1] = "resolveToSymbols";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            break;
                        }
                        case 1: {
                            objectArray = objectArray;
                            objectArray[2] = "resolveToSymbols";
                            break;
                        }
                        case 6: {
                            objectArray = objectArray;
                            objectArray[2] = "resolveToSubscript";
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalStateException(string);
                        case 1, 6 -> new IllegalArgumentException(string);
                    };
                }
            }
            return new OCSubscriptOperatorReference(this, operationSign, array, index);
        }
        return null;
    }

    @Override
    @NotNull
    public OCExpression getArrayExpression() {
        IElementType tt;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null && (tt = child.getElementType()) != OCLexerTokenTypes.LBRACKET; child = child.getTreeNext()) {
            if (!OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            OCExpression oCExpression = (OCExpression)child.getPsi();
            if (oCExpression == null) {
                OCArraySelectionExpressionImpl.$$$reportNull$$$0(1);
            }
            return oCExpression;
        }
        assert (false);
        if (null == null) {
            OCArraySelectionExpressionImpl.$$$reportNull$$$0(2);
        }
        return null;
    }

    @Override
    public OCExpression getIndexExpression() {
        boolean ok = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt == OCLexerTokenTypes.LBRACKET) {
                ok = true;
                continue;
            }
            if (!ok || !OCElementTypes.EXPRESSIONS.contains(tt)) continue;
            return (OCExpression)child.getPsi();
        }
        return null;
    }

    @Nullable
    private PsiElement getOperationSign() {
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            IElementType tt = child.getElementType();
            if (tt != OCLexerTokenTypes.LBRACKET) continue;
            return child.getPsi();
        }
        return null;
    }

    @Override
    public void accept(@NotNull OCVisitor visitor) {
        if (visitor == null) {
            OCArraySelectionExpressionImpl.$$$reportNull$$$0(3);
        }
        visitor.visitArraySelectionExpression(this);
    }

    @Override
    @NotNull
    public OCType getType(@NotNull OCResolveContext context) {
        OCOperatorReference reference;
        if (context == null) {
            OCArraySelectionExpressionImpl.$$$reportNull$$$0(4);
        }
        if ((reference = (OCOperatorReference)this.getReference()) != null) {
            for (OCSymbol operator : reference.resolveToSymbols(context)) {
                if (operator instanceof OCFunctionSymbol) {
                    OCType oCType = ((OCFunctionSymbol)operator).getEffectiveType(this);
                    if (oCType == null) {
                        OCArraySelectionExpressionImpl.$$$reportNull$$$0(5);
                    }
                    return oCType;
                }
                if (!(operator instanceof OCMethodSymbol)) continue;
                OCMethodSymbol method = (OCMethodSymbol)operator;
                List<OCMethodSymbol.SelectorPartSymbol> selectors = method.getSelectors();
                OCType oCType = selectors.size() == 1 ? method.getReturnType(context.getProject()) : selectors.get(0).getParameter().getType();
                if (oCType == null) {
                    OCArraySelectionExpressionImpl.$$$reportNull$$$0(6);
                }
                return oCType;
            }
        }
        OCType oCType = OCArraySelectionExpressionImpl.getArrayIndexExprType(this.getArrayExpression().getResolvedType(context), context);
        if (oCType == null) {
            OCArraySelectionExpressionImpl.$$$reportNull$$$0(7);
        }
        return oCType;
    }

    public static OCType getArrayIndexExprType(@NotNull OCType arrayType, @NotNull OCResolveContext context) {
        if (arrayType == null) {
            OCArraySelectionExpressionImpl.$$$reportNull$$$0(8);
        }
        if (context == null) {
            OCArraySelectionExpressionImpl.$$$reportNull$$$0(9);
        }
        if (arrayType instanceof OCCppReferenceType) {
            arrayType = ((OCCppReferenceType)arrayType).getRefType();
        }
        if (arrayType instanceof OCMagicType) {
            return ((OCMagicType)arrayType).getRefType();
        }
        if (arrayType.isPointerToObject() && OCCompilerFeaturesHelper.supportsSubscripting(context.getFile())) {
            return OCIdType.pointerToID();
        }
        if (arrayType instanceof OCPointerType) {
            return ((OCPointerType)arrayType).getRefType();
        }
        return OCUnknownType.INSTANCE;
    }

    @Override
    protected List<OCExpression> getDependentExpressions() {
        return Collections.singletonList(this.getArrayExpression());
    }

    @Override
    @Nullable
    public OCMethodSymbol getArraySubscriptMethod(@NotNull OCResolveContext context) {
        if (context == null) {
            OCArraySelectionExpressionImpl.$$$reportNull$$$0(10);
        }
        OCExpression array = this.getArrayExpression();
        OCExpression index = this.getIndexExpression();
        if (index == null) {
            return null;
        }
        OCType arrayType = array.getResolvedType(context);
        OCType indexType = index.getResolvedType();
        ReadWriteAccessDetector.Access accessType = new OCReadWriteAccessDetector().getExpressionAccess(this);
        String typeName = this.getDefaultTypeName(indexType);
        String accessorName = this.getArraySubscriptAccessorName(indexType, accessType);
        if (accessorName == null || typeName == null) {
            return null;
        }
        if (arrayType.isPointerToID()) {
            arrayType = OCReferenceType.resolvedFromText(typeName, this);
        } else if (arrayType.isPointerToObject()) {
            arrayType = arrayType.getTerminalType();
        } else {
            return null;
        }
        if (arrayType instanceof OCObjectType) {
            return ((OCObjectType)arrayType).findMember(accessorName, OCMethodSymbol.class);
        }
        return null;
    }

    @Nullable
    private String getDefaultTypeName(OCType indexType) {
        if (indexType.isIntegerCompatible(OCResolveContext.forPsi(this))) {
            return "NSMutableArray";
        }
        if (indexType.isPointerToObjectCompatible()) {
            return "NSMutableDictionary";
        }
        return null;
    }

    public static boolean isArraySubscriptMethod(OCMethodSymbol symbol) {
        String name = symbol.getName();
        return "objectAtIndexedSubscript:".equals(name) || "setObject:atIndexedSubscript:".equals(name) || "objectForKeyedSubscript:".equals(name) || "setObject:forKeyedSubscript:".equals(name);
    }

    @Override
    @Nullable
    public String getArraySubscriptAccessorName(OCType indexType, ReadWriteAccessDetector.Access accessType) {
        if (indexType.isIntegerCompatible(OCResolveContext.forPsi(this))) {
            return accessType == ReadWriteAccessDetector.Access.Read ? "objectAtIndexedSubscript:" : "setObject:atIndexedSubscript:";
        }
        if (indexType.isPointerToObjectCompatible()) {
            return accessType == ReadWriteAccessDetector.Access.Read ? "objectForKeyedSubscript:" : "setObject:forKeyedSubscript:";
        }
        return null;
    }

    @Override
    @Nullable
    public String getArraySubscriptMethodSignature(OCType indexType, ReadWriteAccessDetector.Access accessType) {
        if (indexType.isIntegerCompatible(OCResolveContext.forPsi(this))) {
            return accessType == ReadWriteAccessDetector.Access.Read ? "- (id)objectAtIndexedSubscript:(NSInteger)idx" : "- (void)setObject:(id)obj atIndexedSubscript:(NSInteger)idx";
        }
        if (indexType.isPointerToObjectCompatible()) {
            return accessType == ReadWriteAccessDetector.Access.Read ? "- (id)objectForKeyedSubscript:(id)key" : "- (void)setObject:(id)obj forKeyedSubscript:(id <NSCopying>)key";
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 4: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/psi/impl/OCArraySelectionExpressionImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayExpression";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getArrayIndexExprType";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getArraySubscriptMethod";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

