/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.quickfixes;

import com.intellij.codeInsight.intention.FileModifier;
import com.intellij.codeInspection.util.IntentionFamilyName;
import com.intellij.codeInspection.util.IntentionName;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.jetbrains.cidr.lang.inspections.OCInspectionUtil;
import com.jetbrains.cidr.lang.quickfixes.OCPsiElementQuickFix;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAddElementIntentionAction
extends OCPsiElementQuickFix<PsiElement> {
    @IntentionName
    private final String myCaption;
    private final SmartPsiElementPointer<?> myNewElementPtr;
    @IntentionFamilyName
    private final String myFamilyName;

    public OCAddElementIntentionAction(@IntentionFamilyName String caption, @NotNull PsiElement parent, PsiElement newElement) {
        if (parent == null) {
            OCAddElementIntentionAction.$$$reportNull$$$0(0);
        }
        super(parent);
        this.myNewElementPtr = OCElementUtil.createPsiElementPointer(newElement);
        this.myCaption = caption;
        this.myFamilyName = caption;
    }

    @Override
    protected String getTextInternal() {
        return this.myCaption;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.myFamilyName;
        if (string == null) {
            OCAddElementIntentionAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected void invoke(PsiFile file, @NotNull PsiElement parent) {
        Object elementByPointer;
        if (parent == null) {
            OCAddElementIntentionAction.$$$reportNull$$$0(2);
        }
        if ((elementByPointer = OCElementUtil.getPsiElementByPointer(this.myNewElementPtr)) != null) {
            OCChangeUtil.addBefore(parent, elementByPointer, null);
        }
    }

    @Nullable
    public FileModifier getFileModifierForPreview(@NotNull PsiFile target) {
        if (target == null) {
            OCAddElementIntentionAction.$$$reportNull$$$0(3);
        }
        PsiElement elementCopy = OCInspectionUtil.findSameElementInCopy((SmartPsiElementPointer)this.myElementPtr, (PsiFile)target);
        PsiElement newElement = this.myNewElementPtr.getElement();
        if (elementCopy == null || newElement == null || !newElement.isValid()) {
            return null;
        }
        return new OCAddElementIntentionAction(this.myCaption, elementCopy, newElement);
    }

    @Override
    protected boolean shouldCommitAllDocuments() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/quickfixes/OCAddElementIntentionAction";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/quickfixes/OCAddElementIntentionAction";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFileModifierForPreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

