/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCGetSymbolVisitor;
import com.jetbrains.cidr.lang.psi.OCArgumentList;
import com.jetbrains.cidr.lang.psi.OCAssignmentExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCInstanceVariablesList;
import com.jetbrains.cidr.lang.psi.OCMessageArgument;
import com.jetbrains.cidr.lang.psi.OCProperty;
import com.jetbrains.cidr.lang.psi.OCQualifiedExpression;
import com.jetbrains.cidr.lang.psi.OCReferenceElement;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.psi.OCSendMessageExpression;
import com.jetbrains.cidr.lang.psi.OCSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.visitors.OCRecursiveVisitor;
import com.jetbrains.cidr.lang.refactoring.OCNamingConventionUtil;
import com.jetbrains.cidr.lang.refactoring.OCUniqueNameGenerator;
import com.jetbrains.cidr.lang.resolve.OCResolveUtil;
import com.jetbrains.cidr.lang.settings.NamingConventionRule;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedNameImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInterfaceSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCAutoType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCMagicType;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCVariadicType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCNamesValidator;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCNameSuggester {
    public static final String BOOLEAN_SHORT_NAME = "b";
    public static final String INT_SHORT_NAME = "i";
    public static final String DOUBLE_SHORT_NAME = "d";
    public static final String STRING_SHORT_NAME = "string";
    public static final String AUTO_SHORT_NAME = "item";
    public static final String POINTER_SHORT_NAME = "ptr";
    public static final String OBJECT_SHORT_NAME = "o";
    public static final String UDL_SHORT_NAME = "_op";
    public static final String VOID_SHORT_NAME = "v";
    public static final String BOOLEAN_LONG_NAME = "boolean";
    public static final String INT_LONG_NAME = "int";
    public static final String DOUBLE_LONG_NAME = "double";
    public static final String OBJECT_LONG_NAME = "object";
    public static final String FUNCTION_LONG_NAME = "function";
    public static final String VOID_LONG_NAME = "void";
    private static final Set<String> KNOWN_SMART_POINTERS = ContainerUtil.newHashSet((Object[])new String[]{"unique_ptr", "shared_ptr", "weak_ptr", "auto_ptr"});
    @NlsSafe
    private static final String STD_NAMESPACE_PREFIX = "std::";
    private static final String[] GARBAGE_SUFFIXES = new String[]{"Impl", "IMPL", "Ref", "REF", "_t"};
    private static final String[] SHORT_NAMES = new String[]{"b", "i", "d", "string", "ptr", "o", "_op", "v", "item"};
    private static final String EMPTY_PREFIX = "";

    private OCNameSuggester() {
    }

    public static Collection<String> suggestForDeclaration(OCDeclarator declarator, boolean unique, @NotNull Collection<String> predefinedNames) {
        HashSet<String> blackList;
        HashSet<String> whiteList;
        Ref symbolKindRef;
        Collection<String> candidates;
        if (predefinedNames == null) {
            OCNameSuggester.$$$reportNull$$$0(0);
        }
        if ((candidates = OCNameSuggester.doSuggestForDeclaration(declarator, (Ref<OCSymbolKind>)(symbolKindRef = new Ref()), whiteList = new HashSet<String>(predefinedNames), blackList = new HashSet<String>())).isEmpty() && declarator.getParent() instanceof OCDeclaration && ((OCDeclaration)declarator.getParent()).isTypedef() && !declarator.getType().getName().contains("CIDR_RULE_ZZZ")) {
            return Collections.singletonList(declarator.getType().getName());
        }
        OCSymbol symbol = declarator.getSymbol();
        if (symbolKindRef.isNull()) {
            symbolKindRef.set((Object)(symbol != null ? symbol.getKind() : null));
        }
        OCResolveContext context = OCResolveContext.forPsi(declarator);
        Project project = declarator.getProject();
        if (!unique) {
            return OCNamingConventionUtil.shouldIgnoreNamingConventionForSymbol(symbol) ? new HashSet<String>(candidates) : new HashSet<String>(OCNamingConventionUtil.applyNamingConvention(candidates, (OCSymbolKind)((Object)symbolKindRef.get()), symbol, context, project));
        }
        HashSet<String> uniqueNames = new HashSet<String>(candidates);
        blackList.removeAll(whiteList);
        uniqueNames.retainAll(whiteList);
        HashSet<String> toProcess = new HashSet<String>(candidates);
        toProcess.removeAll(whiteList);
        uniqueNames.addAll(OCUniqueNameGenerator.convertToUniqueNames((OCSymbolKind)((Object)symbolKindRef.get()), symbol, toProcess, declarator, blackList, context, project));
        return uniqueNames;
    }

    private static Collection<String> doSuggestForDeclaration(@NotNull OCDeclarator declarator, Ref<OCSymbolKind> symbolKindRef, Collection<String> whiteList, Collection<String> blackList) {
        OCSymbol declaratorSymbol;
        Object classSymbol;
        PsiElement ifs;
        if (declarator == null) {
            OCNameSuggester.$$$reportNull$$$0(1);
        }
        if (declarator.getParent() instanceof OCDeclaration && ((OCDeclaration)declarator.getParent()).isTypedef()) {
            return Collections.emptyList();
        }
        OCResolveContext context = OCResolveContext.forPsi(declarator);
        OCExpression initializer = declarator.getInitializer();
        if (initializer != null) {
            ArrayList<String> names = new ArrayList<String>(OCNameSuggester.doSuggestForDeclarationName(declarator, context));
            names.addAll(OCNameSuggester.doSuggestForExpression(initializer, context));
            names.addAll(OCNameSuggester.doSuggestForTemplateArguments(declarator, context));
            return names;
        }
        PsiElement declContext = declarator.getContext();
        if (declContext != null && (declContext = declContext.getContext()) instanceof OCDeclarationStatement) {
            declContext = declContext.getContext();
        }
        if (declContext instanceof OCForeachStatement) {
            OCExpression collectionExpression = ((OCForeachStatement)declContext).getCollectionExpression();
            LinkedHashSet<String> candidates = new LinkedHashSet<String>();
            for (String collectionSuggestion : OCNameSuggester.doSuggestionForContext(collectionExpression)) {
                String unplured = StringUtil.unpluralize((String)collectionSuggestion);
                candidates.add(unplured != null ? unplured : collectionSuggestion);
            }
            candidates.addAll(OCNameSuggester.doSuggestForType(declarator.getType(), EMPTY_PREFIX, context));
            ArrayList<String> names = new ArrayList<String>(OCNameSuggester.doSuggestForDeclarationName(declarator, context));
            names.addAll(candidates);
            return names;
        }
        if (declContext instanceof OCProperty) {
            ifs = declContext.getParent();
            if (ifs instanceof OCSymbolDeclarator && (classSymbol = ((OCSymbolDeclarator)ifs).getSymbol()) instanceof OCClassSymbol) {
                symbolKindRef.set((Object)OCSymbolKind.PROPERTY);
                return OCNameSuggester.suggestForProperty(declarator, (OCClassSymbol)classSymbol, whiteList, blackList, context);
            }
        } else if (declContext instanceof OCInstanceVariablesList && (ifs = declContext.getParent()) instanceof OCSymbolDeclarator && (classSymbol = ((OCSymbolDeclarator)ifs).getSymbol()) instanceof OCClassSymbol) {
            symbolKindRef.set((Object)OCSymbolKind.INSTANCE_VARIABLE);
            return OCNameSuggester.suggestForIvar(declarator, (OCClassSymbol)classSymbol, blackList, context);
        }
        if ((declaratorSymbol = declarator.getSymbol()) instanceof OCFunctionSymbol && ((OCFunctionSymbol)declaratorSymbol).isUDL()) {
            return OCNameSuggester.doSuggestForSimpleType(UDL_SHORT_NAME, UDL_SHORT_NAME, EMPTY_PREFIX);
        }
        ArrayList<String> names = new ArrayList<String>(OCNameSuggester.doSuggestForDeclarationName(declarator, context));
        names.addAll(OCNameSuggester.doSuggestForType(declarator.getType(), EMPTY_PREFIX, context));
        names.addAll(OCNameSuggester.doSuggestForTemplateArguments(declarator, context));
        return names;
    }

    @NotNull
    private static List<String> doSuggestForDeclarationName(@NotNull OCDeclarator declarator, @NotNull OCResolveContext context) {
        if (declarator == null) {
            OCNameSuggester.$$$reportNull$$$0(2);
        }
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(3);
        }
        String declaratorName = declarator.getName();
        OCSymbol symbol = declarator.getSymbol();
        if (symbol == null) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                OCNameSuggester.$$$reportNull$$$0(4);
            }
            return list;
        }
        if (!OCNamesValidator.isIdentifier(declaratorName) || declaratorName.contains("CIDR_RULE_ZZZ")) {
            List list = ContainerUtil.emptyList();
            if (list == null) {
                OCNameSuggester.$$$reportNull$$$0(5);
            }
            return list;
        }
        OCSymbolKind symbolKind = symbol.getKind();
        String suggestedName = OCNamingConventionUtil.applyNamingConvention(declaratorName, symbolKind, symbol, context, declarator.getProject());
        List<String> list = suggestedName.equals(declaratorName) ? ContainerUtil.emptyList() : List.of(suggestedName);
        if (list == null) {
            OCNameSuggester.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static Collection<String> suggestForIvar(OCDeclarator declarator, OCClassSymbol classSymbol, Collection<String> forbiddenNames, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(7);
        }
        HashSet<String> names = new HashSet<String>();
        Project project = context.getProject();
        OCInterfaceSymbol mi = classSymbol.getMainInterface(project);
        String auxCategoryName = classSymbol instanceof OCInterfaceSymbol ? classSymbol.getCategoryName() : EMPTY_PREFIX;
        OCClassSymbol mainInterface = mi == null ? classSymbol : mi;
        Processor propertyProcessor = propertySymbol -> {
            OCInstanceVariableSymbol ivar = propertySymbol.getAssociatedIvar(project);
            if (propertySymbol.getType().isCompatible(declarator.getType(), context) && (ivar == null || ivar.getGeneratedFromProperty() != null)) {
                names.add(OCNameSuggester.getNonCollidingName(propertySymbol, true, project));
            }
            return true;
        };
        Processor<OCSymbol> iVarProcessor = OCNameSuggester.namesCollectProcessor(forbiddenNames, declarator);
        mainInterface.processCategories((Processor<? super OCClassSymbol>)((Processor)ifs -> {
            if (StringUtil.compare((String)ifs.getCategoryName(), (String)auxCategoryName, (boolean)false) == 0 || ifs == mainInterface) {
                ifs.processMembers(OCPropertySymbol.class, propertyProcessor);
                ifs.processMembers(OCInstanceVariableSymbol.class, iVarProcessor);
            }
            return true;
        }), true, null, project);
        for (String name : OCNameSuggester.doSuggestForType(declarator.getType(), EMPTY_PREFIX, context)) {
            names.add(OCNameSuggester.getNonCollidingName(name, OCSymbolKind.PROPERTY, true, declarator.getProject()));
        }
        return names;
    }

    private static Collection<String> suggestForProperty(@NotNull OCDeclarator declarator, @NotNull OCClassSymbol interfaceSymbol, Collection<String> whiteList, Collection<String> forbiddenNames, @NotNull OCResolveContext context) {
        OCImplementationSymbol implementation;
        if (declarator == null) {
            OCNameSuggester.$$$reportNull$$$0(8);
        }
        if (interfaceSymbol == null) {
            OCNameSuggester.$$$reportNull$$$0(9);
        }
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(10);
        }
        HashSet<String> names = new HashSet<String>();
        Processor ivarProcessor = ivar -> {
            if (!OCResolveUtil.isDisabledSymbol(ivar, declarator.getContainingFile()) && ivar.getAssociatedProperty(context.getProject()) == null && declarator.getType().isCompatible(ivar.getType(), context)) {
                String name = OCNameSuggester.getNonCollidingName(ivar, true, context.getProject());
                names.add(name);
                whiteList.add(name);
            }
            return true;
        };
        Processor<OCSymbol> propertyProcessor = OCNameSuggester.namesCollectProcessor(forbiddenNames, declarator);
        interfaceSymbol.processCategories((Processor<? super OCClassSymbol>)((Processor)interfaceSymbol1 -> {
            String category = interfaceSymbol1.getCategoryName();
            if (category == null || category.isEmpty()) {
                interfaceSymbol1.processMembers(OCInstanceVariableSymbol.class, ivarProcessor);
                interfaceSymbol1.processMembers(OCPropertySymbol.class, propertyProcessor);
            }
            return true;
        }), true, null, context.getProject());
        String categoryName = interfaceSymbol.getCategoryName();
        if ((categoryName == null || categoryName.isEmpty()) && (implementation = interfaceSymbol.getMainImplementation(declarator.getProject())) != null) {
            implementation.processMembers(OCInstanceVariableSymbol.class, ivarProcessor);
        }
        names.addAll(OCNameSuggester.doSuggestForType(declarator.getType(), EMPTY_PREFIX, context));
        return names;
    }

    private static Processor<OCSymbol> namesCollectProcessor(Collection<String> names, @NotNull OCElement excludedElement) {
        if (excludedElement == null) {
            OCNameSuggester.$$$reportNull$$$0(11);
        }
        return symbol -> {
            PsiElement ivarDecl = symbol.locateDefinition(excludedElement.getProject());
            if (ivarDecl != null && ivarDecl.getTextOffset() != excludedElement.getTextOffset()) {
                names.add(symbol.getName());
            }
            return true;
        };
    }

    public static Collection<String> suggestForExpression(@Nullable OCSymbolKind symbolKind, @NotNull OCExpression expr) {
        if (expr == null) {
            OCNameSuggester.$$$reportNull$$$0(12);
        }
        return OCNameSuggester.suggestForExpression(symbolKind, expr, true);
    }

    public static Collection<String> suggestForExpression(@Nullable OCSymbolKind symbolKind, @NotNull OCExpression expression, boolean uniqueNames) {
        if (expression == null) {
            OCNameSuggester.$$$reportNull$$$0(13);
        }
        Project project = expression.getProject();
        OCResolveContext context = OCResolveContext.forPsi(expression);
        Collection<String> candidates = OCNameSuggester.doSuggestForExpression(expression, context);
        if (!uniqueNames) {
            return OCNamingConventionUtil.applyNamingConvention(candidates, symbolKind, project);
        }
        final ArrayList<String> forbiddenNames = new ArrayList<String>();
        expression.accept(new OCRecursiveVisitor(){

            @Override
            public void visitReferenceElement(OCReferenceElement referenceElement) {
                if (referenceElement.resolveToSymbol() != null) {
                    forbiddenNames.add(referenceElement.getName());
                }
            }
        });
        return OCUniqueNameGenerator.convertToUniqueNames(symbolKind, null, candidates, expression, forbiddenNames, context, project);
    }

    private static Collection<String> doSuggestForExpression(OCExpression expr, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(14);
        }
        LinkedHashSet<String> answer = new LinkedHashSet<String>();
        OCExpression topmost = OCParenthesesUtils.topmostParenthesized(expr);
        answer.addAll(OCNameSuggester.doSuggestForExpressionContext(topmost, topmost.getParent()));
        answer.addAll(OCNameSuggester.doSuggestForType(expr.getResolvedType().getGuessedType(), EMPTY_PREFIX, context));
        answer.addAll(OCNameSuggester.doSuggestionForContext(OCParenthesesUtils.diveIntoParentheses(expr)));
        return answer;
    }

    private static List<String> doSuggestForExpressionContext(OCExpression expr, PsiElement context) {
        List<OCDeclaratorSymbol> symbols;
        OCSymbol fun;
        int index;
        PsiElement arglistParent;
        if (context instanceof OCMessageArgument) {
            OCMethodSymbol.SelectorPartSymbol selector;
            OCDeclaratorSymbol parameter;
            List<OCMethodSymbol.SelectorPartSymbol> selectors;
            OCMethodSymbol responder;
            OCSendMessageExpression call = (OCSendMessageExpression)context.getParent();
            int index2 = call.getArguments().indexOf(context);
            if (index2 >= 0 && (responder = call.getProbableResponders().getKnownResponder()) != null && index2 < (selectors = responder.getSelectors()).size() && (parameter = (selector = selectors.get(index2)).getParameter()) != null) {
                return OCNameSuggester.doGetSuggestionsByName(parameter.getName(), EMPTY_PREFIX);
            }
        } else if (context instanceof OCArgumentList && (arglistParent = context.getParent()) instanceof OCCallExpression && (index = ((OCCallExpression)arglistParent).getArguments().indexOf(expr)) >= 0 && (fun = OCGetSymbolVisitor.getSymbol(((OCCallExpression)arglistParent).getFunctionReferenceExpression())) instanceof OCFunctionSymbol && index < (symbols = ((OCFunctionSymbol)fun).getParameterSymbols()).size()) {
            return OCNameSuggester.doGetSuggestionsByName(symbols.get(index).getName(), EMPTY_PREFIX);
        }
        return Collections.emptyList();
    }

    private static List<String> doSuggestionForContext(@Nullable OCExpression expr) {
        if (expr instanceof OCReferenceExpression && ((OCReferenceExpression)expr).getSelfSuperToken() == null) {
            return OCNameSuggester.doGetSuggestionsByName(expr.getTextWithMacros(), EMPTY_PREFIX);
        }
        if (expr instanceof OCQualifiedExpression) {
            return OCNameSuggester.doGetSuggestionsByName(((OCQualifiedExpression)expr).getName(), EMPTY_PREFIX);
        }
        if (expr instanceof OCSendMessageExpression) {
            return OCNameSuggester.doGetSuggestionsByName(((OCSendMessageExpression)expr).getMessageSelector(), EMPTY_PREFIX);
        }
        if (expr instanceof OCCallExpression) {
            return OCNameSuggester.doGetSuggestionsByName(((OCCallExpression)expr).getFunctionReferenceExpression().getTextWithMacros(), EMPTY_PREFIX);
        }
        return Collections.emptyList();
    }

    public static Collection<String> suggestForType(OCType type, @Nullable PsiElement scope, Collection<String> forbiddenNames, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(15);
        }
        return OCNameSuggester.suggestForType(null, type, scope, EMPTY_PREFIX, forbiddenNames, context);
    }

    public static Collection<String> suggestForType(OCType type, @Nullable PsiElement scope, String prefix, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(16);
        }
        return OCNameSuggester.suggestForType(null, type, scope, prefix, Collections.emptyList(), context);
    }

    public static Collection<String> suggestForType(OCSymbolKind symbolKind, OCType type, @Nullable PsiElement scope, String prefix, @NotNull Collection<String> forbiddenNames, @NotNull OCResolveContext context) {
        if (forbiddenNames == null) {
            OCNameSuggester.$$$reportNull$$$0(17);
        }
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(18);
        }
        return OCNameSuggester.suggestForType(symbolKind, null, type, scope, prefix, forbiddenNames, context);
    }

    public static Collection<String> suggestForType(OCSymbolKind symbolKind, @Nullable OCSymbol symbol, OCType type, @Nullable PsiElement scope, String prefix, @NotNull Collection<String> forbiddenNames, @NotNull OCResolveContext context) {
        if (forbiddenNames == null) {
            OCNameSuggester.$$$reportNull$$$0(19);
        }
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(20);
        }
        Collection<String> typeNames = OCNameSuggester.doSuggestForType(type, prefix, context);
        return OCUniqueNameGenerator.convertToUniqueNames(symbolKind, symbol, typeNames, scope, forbiddenNames, context, context.getProject());
    }

    public static Collection<String> suggestForExtractionContext(@NotNull OCSymbolKind symbolKind, @Nullable OCSymbol symbol, PsiElement @NotNull [] extractedElements, @NotNull OCResolveContext context, @NotNull Project project) {
        String name;
        if (symbolKind == null) {
            OCNameSuggester.$$$reportNull$$$0(21);
        }
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(22);
        }
        if (project == null) {
            OCNameSuggester.$$$reportNull$$$0(23);
        }
        if (extractedElements == null) {
            OCNameSuggester.$$$reportNull$$$0(24);
        }
        if (StringUtil.isEmpty((String)(name = OCNameSuggester.doSuggestForExtractionContext(extractedElements))) || name.equals("<unnamed>")) {
            return ContainerUtil.emptyList();
        }
        String uniqueName = OCUniqueNameGenerator.suggestUniqueName(symbolKind, symbol, context, "get" + StringUtil.capitalize((String)name), extractedElements.length > 0 ? extractedElements[0] : null, ContainerUtil.emptyList(), project);
        return Collections.singletonList(uniqueName);
    }

    @Nullable
    private static String doSuggestForExtractionContext(PsiElement @NotNull [] extractedElements) {
        OCDeclarator declarator;
        OCExpression initializer;
        if (extractedElements == null) {
            OCNameSuggester.$$$reportNull$$$0(25);
        }
        if (extractedElements.length == 0) {
            return null;
        }
        PsiElement firstElement = extractedElements[0];
        PsiElement lastElement = extractedElements[extractedElements.length - 1];
        TextRange extractionRange = new TextRange(firstElement.getTextRange().getStartOffset(), lastElement.getTextRange().getStartOffset());
        PsiElement parentElement = PsiTreeUtil.getParentOfType((PsiElement)firstElement, (Class[])new Class[]{OCDeclarator.class, OCExpression.class});
        if (parentElement == null) {
            return null;
        }
        if (parentElement instanceof OCDeclarator && (initializer = (declarator = (OCDeclarator)parentElement).getInitializer()) != null && initializer.getTextRange().contains(extractionRange)) {
            return declarator.getName();
        }
        if (!(parentElement instanceof OCExpression)) {
            return null;
        }
        OCExpression expression = OCParenthesesUtils.topmostParenthesized((OCExpression)parentElement);
        if (expression instanceof OCAssignmentExpression) {
            OCAssignmentExpression assignmentExpression = (OCAssignmentExpression)expression;
            OCExpression receiver = assignmentExpression.getReceiverExpression();
            OCExpression source = assignmentExpression.getSourceExpression();
            if (source == null || !source.getTextRange().contains(extractionRange)) {
                return null;
            }
            if (receiver instanceof OCReferenceExpression) {
                OCReferenceExpression receiverReference = (OCReferenceExpression)receiver;
                OCReferenceElement referenceElement = receiverReference.getReferenceElement();
                return referenceElement != null ? referenceElement.getName() : null;
            }
        }
        return null;
    }

    private static Collection<String> doSuggestForType(OCType type, String prefix, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(26);
        }
        if (type == null) {
            return Collections.emptyList();
        }
        if (OCIntType.isBool(type, context)) {
            return OCNameSuggester.doSuggestForSimpleType(BOOLEAN_SHORT_NAME, BOOLEAN_LONG_NAME, prefix);
        }
        if (type instanceof OCIntType) {
            return OCNameSuggester.doSuggestForSimpleType(INT_SHORT_NAME, INT_LONG_NAME, prefix);
        }
        if (type instanceof OCRealType) {
            return OCNameSuggester.doSuggestForSimpleType(DOUBLE_SHORT_NAME, DOUBLE_LONG_NAME, prefix);
        }
        if (type.isCString()) {
            return OCNameSuggester.doGetSuggestionsByName(STRING_SHORT_NAME, prefix);
        }
        if (type instanceof OCPointerType) {
            OCType ref = ((OCPointerType)type).getRefType();
            Collection<String> raw = OCNameSuggester.doSuggestForType(ref, !prefix.isEmpty() || ref instanceof OCObjectType || ref instanceof OCReferenceType ? prefix : "p", context);
            return raw.isEmpty() ? Collections.singleton(POINTER_SHORT_NAME) : raw;
        }
        if (type instanceof OCObjectType) {
            OCClassSymbol smb = ((OCObjectType)type).getClassSymbol();
            if (smb == null) {
                return OCNameSuggester.doSuggestForSimpleType(OBJECT_SHORT_NAME, OBJECT_LONG_NAME, prefix);
            }
            return OCNameSuggester.doSuggestionsByTypeName(smb.getName(), prefix);
        }
        if (type instanceof OCFunctionType) {
            if (StringUtil.isNotEmpty((String)prefix)) {
                return Collections.singleton(prefix + StringUtil.capitalize((String)FUNCTION_LONG_NAME));
            }
        } else {
            if (type instanceof OCVoidType) {
                return OCNameSuggester.doSuggestForSimpleType(VOID_SHORT_NAME, VOID_LONG_NAME, prefix);
            }
            if (type instanceof OCAutoType) {
                return OCNameSuggester.doSuggestForSimpleType(AUTO_SHORT_NAME, AUTO_SHORT_NAME, prefix);
            }
            if (type instanceof OCReferenceType) {
                return OCNameSuggester.doSuggestionsByTypeName(type.getName(), prefix);
            }
            if (type instanceof OCStructType) {
                OCStructSymbol symbol = ((OCStructType)type).getSymbol();
                return OCNameSuggester.doSuggestionsByTypeName(symbol.getName(), prefix);
            }
            if (type instanceof OCCppReferenceType) {
                return OCNameSuggester.doSuggestForType(((OCCppReferenceType)type).getRefType(), prefix, context);
            }
            if (type instanceof OCVariadicType) {
                return OCNameSuggester.doSuggestForType(((OCVariadicType)type).getUnderlyingType(), prefix, context);
            }
            if (type instanceof OCMagicType) {
                return OCNameSuggester.doSuggestionsByTypeName(type.getName(), prefix);
            }
        }
        return Collections.emptyList();
    }

    @NotNull
    private static Collection<String> doSuggestForTemplateArguments(@NotNull OCDeclarator declarator, @NotNull OCResolveContext context) {
        OCStructSymbol symbol;
        OCQualifiedName qualifiedName;
        String fullName;
        if (declarator == null) {
            OCNameSuggester.$$$reportNull$$$0(27);
        }
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(28);
        }
        ArrayList<String> names = new ArrayList<String>();
        OCType type = declarator.getResolvedType(context);
        OCType elementType = (type instanceof OCArrayType ? type.getArrayElementType() : type).getTerminalType();
        if (elementType instanceof OCStructType && (fullName = (qualifiedName = OCSymbolWithQualifiedNameImpl.getFullyQualifiedName(symbol = ((OCStructType)elementType).getSymbol())).getFullName(context)).startsWith(STD_NAMESPACE_PREFIX) && KNOWN_SMART_POINTERS.contains(symbol.getName())) {
            names.addAll(OCNameSuggester.doSuggestionsForSmartPointers(symbol, context));
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            OCNameSuggester.$$$reportNull$$$0(29);
        }
        return arrayList;
    }

    private static Collection<String> doSuggestionsForSmartPointers(@NotNull OCStructSymbol symbol, @NotNull OCResolveContext context) {
        List<OCTypeArgument> templateArguments;
        if (symbol == null) {
            OCNameSuggester.$$$reportNull$$$0(30);
        }
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(31);
        }
        if ((templateArguments = symbol.getTemplateArguments(context)).isEmpty()) {
            return ContainerUtil.emptyList();
        }
        OCTypeArgument argument = templateArguments.get(0);
        if (!(argument instanceof OCType)) {
            return ContainerUtil.emptyList();
        }
        return OCNameSuggester.doSuggestForType((OCType)argument, EMPTY_PREFIX, context);
    }

    private static Collection<String> doSuggestionsByTypeName(String typeName, String prefix) {
        int pos = typeName.indexOf(60);
        if (pos != -1) {
            typeName = typeName.substring(0, pos);
        }
        if (typeName.equals("id")) {
            return OCNameSuggester.doSuggestForSimpleType(OBJECT_SHORT_NAME, OBJECT_LONG_NAME, prefix);
        }
        if (typeName.equals("BOOL")) {
            return OCNameSuggester.doSuggestForSimpleType(BOOLEAN_SHORT_NAME, BOOLEAN_LONG_NAME, prefix);
        }
        typeName = StringUtil.trimStart((String)typeName, (String)"NS");
        return OCNameSuggester.doGetSuggestionsByName(StringUtil.trimStart((String)OCNameSuggester.stripSuffixes(typeName), (String)"const"), prefix);
    }

    private static Collection<String> doSuggestForSimpleType(String shortName, String longName, String prefix) {
        return Collections.singleton(!prefix.isEmpty() ? prefix + StringUtil.capitalize((String)longName) : shortName);
    }

    private static String stripSuffixes(String suggestion) {
        for (String suff : GARBAGE_SUFFIXES) {
            if (!StringUtil.endsWith((CharSequence)suggestion, (CharSequence)suff)) continue;
            return OCNameSuggester.stripSuffixes(suggestion.substring(0, suggestion.length() - suff.length()));
        }
        return suggestion;
    }

    private static List<String> doGetSuggestionsByName(String name, String prefix) {
        return OCNameSuggester.doGetSuggestionsByName(StringUtil.trimStart((String)name, (String)"get"), false, prefix, EMPTY_PREFIX);
    }

    private static List<String> doGetSuggestionsByName(String name, boolean uppercaseStyle, String prefix, String suffix) {
        List raw = NameUtil.getSuggestionsByName((String)name, (String)prefix, (String)suffix, (boolean)uppercaseStyle, (boolean)false, (boolean)false);
        ArrayList<String> answer = new ArrayList<String>();
        for (String suggestion : raw) {
            String s = OCNameSuggester.changeIfNotIdentifier(suggestion);
            if (!OCNamesValidator.isIdentifier(s) || OCNamesValidator.isKeyword(s)) continue;
            answer.add(s);
        }
        return answer;
    }

    @NonNls
    private static String changeIfNotIdentifier(String name) {
        if (!OCNamesValidator.isIdentifier(name = StringUtil.trimEnd((String)name, (String)":"))) {
            return StringUtil.fixVariableNameDerivedFromPropertyName((String)name);
        }
        return name;
    }

    public static String removeVariablePrefixes(String name) {
        if (name.startsWith("an")) {
            name = StringUtil.decapitalize((String)name.substring(2));
        } else if (name.startsWith("a") || name.startsWith("_")) {
            name = StringUtil.decapitalize((String)name.substring(1));
        }
        return name;
    }

    public static String removeSelectorPrefixes(String selectorPart) {
        if (selectorPart.startsWith("and")) {
            selectorPart = StringUtil.decapitalize((String)selectorPart.substring(3));
        }
        return selectorPart;
    }

    public static String suggestForParameter(Collection<String> prevParamNames, boolean isFirstSelector, String selector, OCType type, @Nullable OCMethodSymbol method, @Nullable OCExpression expression, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(32);
        }
        String paramName = isFirstSelector || selector.equals(":") ? OCNameSuggester.suggestForParameter(prevParamNames, type, expression, context) : (selector.endsWith(":") ? StringUtil.decapitalize((String)OCNameSuggester.getLastSubword(selector.substring(0, selector.length() - 1))) : "param");
        ArrayList<PsiElement> contexts = new ArrayList<PsiElement>();
        if (method != null) {
            Project project = context.getProject();
            method.processSameSymbols((Processor<OCSymbol>)((Processor)symbol -> {
                PsiElement definition = symbol.locateDefinition(project);
                if (definition != null) {
                    contexts.add(definition);
                }
                return true;
            }), project);
        }
        return OCUniqueNameGenerator.suggestUniqueName(OCSymbolKind.PARAMETER, null, paramName, contexts, prevParamNames, context, context.getProject());
    }

    public static String suggestForParameter(Collection<String> forbiddenNames, OCType type, @Nullable OCExpression expression, @NotNull OCResolveContext context) {
        if (context == null) {
            OCNameSuggester.$$$reportNull$$$0(33);
        }
        Project project = context.getProject();
        ArrayList<String> names = new ArrayList<String>(OCNameSuggester.doSuggestForType(type, EMPTY_PREFIX, context));
        names.addAll(OCNameSuggester.doSuggestionForContext(expression));
        for (String name : names) {
            if (ArrayUtil.contains((String)name, (String[])SHORT_NAMES)) continue;
            return OCUniqueNameGenerator.suggestUniqueName(OCSymbolKind.PARAMETER, null, context, name, null, forbiddenNames, project);
        }
        return OCUniqueNameGenerator.suggestUniqueName(OCSymbolKind.PARAMETER, null, context, names.isEmpty() ? "param" : (String)names.iterator().next(), null, forbiddenNames, project);
    }

    @NotNull
    public static String getLastSubword(@NotNull String word) {
        if (word == null) {
            OCNameSuggester.$$$reportNull$$$0(34);
        }
        String[] subwords = NameUtil.nameToWords((String)word);
        Object result = EMPTY_PREFIX;
        for (int i = subwords.length - 1; i >= 0; --i) {
            if (!StringUtil.isJavaIdentifier((String)(result = subwords[i] + (String)result))) continue;
            Object object = result;
            if (object == null) {
                OCNameSuggester.$$$reportNull$$$0(35);
            }
            return object;
        }
        String string = word;
        if (string == null) {
            OCNameSuggester.$$$reportNull$$$0(36);
        }
        return string;
    }

    public static String getSelectorNameWithoutParameter(String firstSelector, @Nullable String paramName) {
        if (paramName == null) {
            return firstSelector;
        }
        if (firstSelector.endsWith(StringUtil.capitalize((String)(paramName = OCNameSuggester.removeVariablePrefixes(paramName))))) {
            firstSelector = firstSelector.substring(0, firstSelector.length() - paramName.length());
        }
        return firstSelector;
    }

    public static String getNonCollidingName(OCSymbol symbol, @NotNull Project project) {
        if (project == null) {
            OCNameSuggester.$$$reportNull$$$0(37);
        }
        return OCNameSuggester.getNonCollidingName(symbol, false, project);
    }

    public static String getNonCollidingName(OCSymbol symbol, boolean allowCollision, @NotNull Project project) {
        if (project == null) {
            OCNameSuggester.$$$reportNull$$$0(38);
        }
        return OCNameSuggester.getNonCollidingName(symbol.getName(), symbol.getKind(), allowCollision, project);
    }

    public static String getNonCollidingName(String name, OCSymbolKind symbolKind, boolean allowCollision, Project project) {
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
        String prefix = settings.IVARS_PREFIX;
        String suffix = settings.IVARS_SUFFIX;
        if (symbolKind == OCSymbolKind.INSTANCE_VARIABLE) {
            String newName = OCNameSuggester.getNameWithoutPrefixAndSuffix(name, prefix, suffix);
            if (newName.equals(name) && !allowCollision) {
                return StringUtil.fixVariableNameDerivedFromPropertyName((String)name);
            }
            return newName;
        }
        if (symbolKind == OCSymbolKind.PROPERTY) {
            return OCNameSuggester.getNameWithPrefixAndSuffix(name, prefix, suffix);
        }
        if (!allowCollision) {
            return StringUtil.fixVariableNameDerivedFromPropertyName((String)name);
        }
        return name;
    }

    private static String getNameWithPrefixAndSuffix(String name, String prefix, String suffix) {
        boolean isLetterPrefix;
        boolean bl = isLetterPrefix = !prefix.isEmpty() && Character.isLetter(prefix.charAt(prefix.length() - 1));
        if (isLetterPrefix) {
            return prefix + StringUtil.capitalize((String)name) + suffix;
        }
        return prefix + name + suffix;
    }

    private static String getNameWithoutPrefixAndSuffix(String name, String prefix, String suffix) {
        String result = name;
        if (result.length() > prefix.length() && result.startsWith(prefix)) {
            result = result.substring(prefix.length());
        }
        if (result.length() > suffix.length() && result.endsWith(suffix)) {
            result = result.substring(0, result.length() - suffix.length());
        }
        return OCNamesValidator.isKeyword(result) ? StringUtil.fixVariableNameDerivedFromPropertyName((String)result) : result;
    }

    @NotNull
    public static String getClang4ImplicitIvarName(String propertyName) {
        String string = "_" + propertyName;
        if (string == null) {
            OCNameSuggester.$$$reportNull$$$0(39);
        }
        return string;
    }

    @Nullable
    public static String getClang4PropertyName(String implicitIvarName) {
        return implicitIvarName.startsWith("_") ? implicitIvarName.substring(1) : null;
    }

    public static String getCppFieldNameWithoutPrefixAndSuffix(OCDeclaratorSymbol fieldSymbol, @NotNull Project project) {
        if (project == null) {
            OCNameSuggester.$$$reportNull$$$0(40);
        }
        OCResolveContext resolveContext = OCResolveContext.forSymbol(fieldSymbol, project);
        NamingConventionRule rule = OCNamingConventionUtil.getNamingConventionRuleForSymbol(fieldSymbol.getKind(), fieldSymbol, resolveContext, project);
        return OCNameSuggester.getNameWithoutPrefixAndSuffix(fieldSymbol.getName(), rule.getCustomPrefix(), rule.getCustomSuffix());
    }

    public static String getCppGetterName(OCDeclaratorSymbol field, @NotNull Project project) {
        if (project == null) {
            OCNameSuggester.$$$reportNull$$$0(41);
        }
        return OCNameSuggester.doGetCppGetterName(field, true, project);
    }

    public static String getUniqueCppGetterName(@NotNull OCDeclaratorSymbol field, @Nullable PsiElement scopeContext, @NotNull Project project) {
        if (field == null) {
            OCNameSuggester.$$$reportNull$$$0(42);
        }
        if (project == null) {
            OCNameSuggester.$$$reportNull$$$0(43);
        }
        String baseCppGetterName = OCNameSuggester.doGetCppGetterName(field, false, project);
        List scopes = ContainerUtil.createMaybeSingletonList((Object)scopeContext);
        OCResolveContext context = OCResolveContext.forSymbol(field, project);
        return OCUniqueNameGenerator.suggestUniqueName(OCSymbolKind.FUNCTION_DECLARATION, (OCSymbol)field, baseCppGetterName, scopes, Collections.emptyList(), context, project);
    }

    private static String doGetCppGetterName(OCDeclaratorSymbol field, boolean applyNamingConvention, @NotNull Project project) {
        if (project == null) {
            OCNameSuggester.$$$reportNull$$$0(44);
        }
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
        String getterPrefix = settings.ADD_GETTER_PREFIX ? "get" : EMPTY_PREFIX;
        String name = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field, project);
        OCResolveContext resolveContext = OCResolveContext.forSymbol(field, project);
        boolean isBoolField = OCIntType.isBool(field.getResolvedType(resolveContext), resolveContext);
        if (settings.ADD_GETTER_PREFIX && isBoolField) {
            getterPrefix = "is";
            if (OCElementUtil.startsWithWord(StringUtil.decapitalize((String)name), "is")) {
                getterPrefix = EMPTY_PREFIX;
            }
        }
        String getterName = getterPrefix.isEmpty() ? name : getterPrefix + StringUtil.capitalize((String)name);
        return applyNamingConvention ? OCNamingConventionUtil.applyNamingConvention(getterName, OCSymbolKind.FUNCTION_DECLARATION, (OCSymbol)field, resolveContext, project) : getterName;
    }

    public static String getCppSetterName(OCDeclaratorSymbol field, @NotNull Project project) {
        if (project == null) {
            OCNameSuggester.$$$reportNull$$$0(45);
        }
        return OCNameSuggester.doGetCppSetterName(field, true, project);
    }

    public static String getUniqueCppSetterName(@NotNull OCDeclaratorSymbol field, @Nullable PsiElement scopeContext, @NotNull Project project) {
        if (field == null) {
            OCNameSuggester.$$$reportNull$$$0(46);
        }
        if (project == null) {
            OCNameSuggester.$$$reportNull$$$0(47);
        }
        String baseCppSetterName = OCNameSuggester.doGetCppSetterName(field, false, project);
        List scopes = ContainerUtil.createMaybeSingletonList((Object)scopeContext);
        OCResolveContext context = OCResolveContext.forSymbol(field, project);
        return OCUniqueNameGenerator.suggestUniqueName(OCSymbolKind.FUNCTION_DECLARATION, (OCSymbol)field, baseCppSetterName, scopes, Collections.emptyList(), context, project);
    }

    private static String doGetCppSetterName(OCDeclaratorSymbol field, boolean applyNamingConvention, @NotNull Project project) {
        if (project == null) {
            OCNameSuggester.$$$reportNull$$$0(48);
        }
        OCCodeStyleSettings settings = (OCCodeStyleSettings)CodeStyle.getSettings((Project)project).getCustomSettings(OCCodeStyleSettings.class);
        String setterPrefix = settings.ADD_SETTER_PREFIX ? "set" : EMPTY_PREFIX;
        String name = OCNameSuggester.getCppFieldNameWithoutPrefixAndSuffix(field, project);
        OCResolveContext resolveContext = OCResolveContext.forSymbol(field, project);
        String setterName = setterPrefix.isEmpty() ? name : setterPrefix + StringUtil.capitalize((String)name);
        return applyNamingConvention ? OCNamingConventionUtil.applyNamingConvention(setterName, OCSymbolKind.FUNCTION_DECLARATION, (OCSymbol)field, resolveContext, project) : setterName;
    }

    public static boolean isObjCGetter(String name) {
        return !name.endsWith(":");
    }

    public static boolean isObjCSetter(String name) {
        return name.indexOf(58) == name.length() - 1;
    }

    public static String getObjCSetterFromGetter(String getter) {
        return "set" + StringUtil.capitalize((String)getter) + ":";
    }

    @Nullable
    public static String getObjCGetterFromSetter(String setter) {
        if (OCElementUtil.startsWithWord(setter, "set") && setter.length() > 4 && OCNameSuggester.isObjCSetter(setter)) {
            return StringUtil.decapitalize((String)setter.substring(3, setter.length() - 1));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 29, 35, 36, 39 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predefinedNames";
                break;
            }
            case 1: 
            case 2: 
            case 8: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarator";
                break;
            }
            case 3: 
            case 7: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 18: 
            case 20: 
            case 22: 
            case 26: 
            case 28: 
            case 31: 
            case 32: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 29: 
            case 35: 
            case 36: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/refactoring/OCNameSuggester";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceSymbol";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedElement";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "forbiddenNames";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbolKind";
                break;
            }
            case 23: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 43: 
            case 44: 
            case 45: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extractedElements";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "word";
                break;
            }
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/refactoring/OCNameSuggester";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "doSuggestForDeclarationName";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "doSuggestForTemplateArguments";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastSubword";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getClang4ImplicitIvarName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "suggestForDeclaration";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doSuggestForDeclaration";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doSuggestForDeclarationName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 29: 
            case 35: 
            case 36: 
            case 39: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "suggestForIvar";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "suggestForProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "namesCollectProcessor";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "suggestForExpression";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "doSuggestForExpression";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "suggestForType";
                break;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "suggestForExtractionContext";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "doSuggestForExtractionContext";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "doSuggestForType";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "doSuggestForTemplateArguments";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "doSuggestionsForSmartPointers";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "suggestForParameter";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getLastSubword";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "getNonCollidingName";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "getCppFieldNameWithoutPrefixAndSuffix";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "getCppGetterName";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueCppGetterName";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "doGetCppGetterName";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getCppSetterName";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getUniqueCppSetterName";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "doGetCppSetterName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 29, 35, 36, 39 -> new IllegalStateException(string);
        };
    }
}

