/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.refactoring.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.psi.OCEmptyStatement;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCLoopStatement;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.refactoring.unwrap.OCUnwrapper;
import org.jetbrains.annotations.NotNull;

public class OCForUnwrapper
extends OCUnwrapper {
    public OCForUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.for", (Object[])new Object[0]));
    }

    public boolean isApplicableTo(@NotNull PsiElement e) {
        if (e == null) {
            OCForUnwrapper.$$$reportNull$$$0(0);
        }
        return e instanceof OCForStatement || e instanceof OCForeachStatement;
    }

    protected void doUnwrap(PsiElement element, OCUnwrapper.Context context) {
        boolean addNewLine = false;
        if (element instanceof OCForStatement) {
            addNewLine = OCForUnwrapper.unwrapInitializer((OCForStatement)element, context);
        }
        OCForUnwrapper.unwrapBody((OCLoopStatement)element, addNewLine, context);
        context.delete(element);
    }

    private static boolean unwrapInitializer(OCForStatement forStmt, OCUnwrapper.Context context) {
        OCStatement init = forStmt.getInitializer();
        if (init != null) {
            context.extractFromBlockOrSingleStatement(init, forStmt);
            OCStatement next = init;
            while (true) {
                if (context.isWhiteSpace(next = next.getNextSibling())) {
                    context.extractWhitespace(next, forStmt);
                    continue;
                }
                if (PsiUtilCore.getElementType((PsiElement)next) != OCLexerTokenTypes.BLOCK_COMMENT) break;
                context.extractElement(next, forStmt);
            }
            if (PsiUtilCore.getElementType((PsiElement)next) == OCLexerTokenTypes.SEMICOLON) {
                context.extractElement(next, forStmt);
            }
            return true;
        }
        return false;
    }

    private static void unwrapBody(OCLoopStatement loopStmt, boolean addNewLine, OCUnwrapper.Context context) {
        OCStatement body = loopStmt.getBody();
        if (body != null) {
            if (addNewLine && !(body instanceof OCEmptyStatement)) {
                context.addNewLineBefore(loopStmt);
            }
            context.extractFromBlockOrSingleStatement(body, loopStmt);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/refactoring/unwrap/OCForUnwrapper", "isApplicableTo"));
    }
}

