/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.psi.OCBlockExpression;
import com.jetbrains.cidr.lang.psi.OCBlockStatement;
import com.jetbrains.cidr.lang.psi.OCCaseStatement;
import com.jetbrains.cidr.lang.psi.OCCatchSection;
import com.jetbrains.cidr.lang.psi.OCCondition;
import com.jetbrains.cidr.lang.psi.OCCppNamespaceAlias;
import com.jetbrains.cidr.lang.psi.OCCppUsingStatement;
import com.jetbrains.cidr.lang.psi.OCDeclaration;
import com.jetbrains.cidr.lang.psi.OCDeclarationStatement;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCEnum;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCForeachStatement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCFunctionDefinition;
import com.jetbrains.cidr.lang.psi.OCIfStatement;
import com.jetbrains.cidr.lang.psi.OCLabeledStatement;
import com.jetbrains.cidr.lang.psi.OCLambdaExpression;
import com.jetbrains.cidr.lang.psi.OCLambdaIntroducer;
import com.jetbrains.cidr.lang.psi.OCLocalSymbolDeclarator;
import com.jetbrains.cidr.lang.psi.OCMethod;
import com.jetbrains.cidr.lang.psi.OCMethodSelectorPart;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCRequiresClause;
import com.jetbrains.cidr.lang.psi.OCStatement;
import com.jetbrains.cidr.lang.psi.OCStructLike;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingDeclarator;
import com.jetbrains.cidr.lang.psi.OCStructuredBindingList;
import com.jetbrains.cidr.lang.psi.OCSwitchStatement;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.psi.OCWhileStatement;
import com.jetbrains.cidr.lang.psi.impl.OCTemplateParameterListImpl;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;

class OCLocalDeclarationsVisitor
extends OCVisitor {
    private Processor<OCLocalSymbolDeclarator> myProcessor;
    private PsiElement myLastParent;
    private boolean myStepIntoBlocks;
    private boolean myResult = true;

    OCLocalDeclarationsVisitor(Processor<OCLocalSymbolDeclarator> processor2, PsiElement lastParent, boolean stepIntoBlocks) {
        this.myProcessor = processor2;
        this.myLastParent = lastParent;
        this.myStepIntoBlocks = stepIntoBlocks;
    }

    public boolean getResult() {
        return this.myResult;
    }

    private void processChildren(PsiElement element) {
        PsiElement lastParent = this.myLastParent;
        this.myLastParent = element;
        for (PsiElement kid = element.getFirstChild(); kid != null; kid = kid.getNextSibling()) {
            if (kid == lastParent) continue;
            kid.accept((PsiElementVisitor)this);
            if (!this.myResult) break;
        }
        this.myLastParent = lastParent;
    }

    @Override
    public void visitExpression(OCExpression expr) {
        if (this.myStepIntoBlocks) {
            this.processChildren(expr);
        }
    }

    @Override
    public void visitStatement(OCStatement stmt) {
        if (this.myStepIntoBlocks) {
            this.processChildren(stmt);
        }
    }

    @Override
    public void visitCaseStatement(OCCaseStatement stmt) {
        this.processChildren(stmt);
    }

    @Override
    public void visitBlockExpression(OCBlockExpression blockExpression) {
        OCParameterList paramList;
        if (this.myLastParent != blockExpression.getParent() && (paramList = blockExpression.getParameterList()) != null) {
            paramList.accept(this);
        }
    }

    @Override
    public void visitLambdaExpression(OCLambdaExpression lambdaExpression) {
        if (this.myLastParent != lambdaExpression.getParent()) {
            OCParameterList paramList = lambdaExpression.getParameterList();
            OCLambdaIntroducer introducer = lambdaExpression.getLambdaIntroducer();
            if (this.myLastParent != introducer) {
                introducer.accept(this);
                if (paramList != null) {
                    paramList.accept(this);
                }
            }
        }
    }

    @Override
    public void visitBlockStatement(OCBlockStatement stmt) {
        if (this.myStepIntoBlocks || this.myLastParent != stmt.getParent()) {
            this.processChildren(stmt);
        }
    }

    @Override
    public void visitCatchSection(OCCatchSection catchSection) {
        this.processChildren(catchSection);
    }

    @Override
    public void visitDeclaration(OCDeclaration declaration) {
        this.processChildren(declaration);
    }

    @Override
    public void visitDeclarationStatement(OCDeclarationStatement stmt) {
        this.processChildren(stmt);
    }

    @Override
    public void visitCondition(OCCondition declOrExpr) {
        this.processChildren(declOrExpr);
    }

    @Override
    public void visitDeclarator(OCDeclarator declarator) {
        if (!(!this.myResult || declarator.getParent() instanceof OCFunctionDefinition || declarator.getParent().getParent() instanceof OCLambdaIntroducer && this.myLastParent == declarator.getInitializer())) {
            this.myResult = this.myProcessor.process((Object)declarator);
        }
        if (this.myStepIntoBlocks || this.myLastParent != declarator.getParent()) {
            this.processChildren(declarator);
        }
    }

    @Override
    public void visitLocalSymbolDeclarator(OCLocalSymbolDeclarator declarator) {
    }

    @Override
    public void visitMethodSelectorPart(OCMethodSelectorPart part) {
        if (this.myResult) {
            this.myResult = this.myProcessor.process((Object)part);
        }
    }

    @Override
    public void visitForStatement(OCForStatement stmt) {
        if (this.myStepIntoBlocks || this.myLastParent != stmt.getParent()) {
            this.processChildren(stmt);
        }
    }

    @Override
    public void visitForeachStatement(OCForeachStatement stmt) {
        if (this.myStepIntoBlocks || this.myLastParent != stmt.getParent()) {
            this.processChildren(stmt);
        }
    }

    @Override
    public void visitIfStatement(OCIfStatement stmt) {
        if (this.myStepIntoBlocks || this.myLastParent != stmt.getParent()) {
            this.processChildren(stmt);
        }
    }

    @Override
    public void visitWhileStatement(OCWhileStatement stmt) {
        if (this.myStepIntoBlocks || this.myLastParent != stmt.getParent()) {
            this.processChildren(stmt);
        }
    }

    @Override
    public void visitSwitchStatement(OCSwitchStatement stmt) {
        if (this.myStepIntoBlocks || this.myLastParent != stmt.getParent()) {
            this.processChildren(stmt);
        }
    }

    @Override
    public void visitFunctionDeclaration(OCFunctionDeclaration declaration) {
        OCParameterList paramList;
        this.processChildren(declaration);
        if (!this.myResult) {
            return;
        }
        if (this.myLastParent != declaration.getParent() && (paramList = declaration.getParameterList()) != null) {
            paramList.accept(this);
        }
    }

    @Override
    public void visitFunctionDefinition(OCFunctionDefinition functionDefinition) {
        this.visitFunctionDeclaration(functionDefinition);
    }

    @Override
    public void visitLabeledStatement(OCLabeledStatement stmt) {
        if (this.myResult) {
            this.myResult = this.myProcessor.process((Object)stmt);
        }
        if (this.myStepIntoBlocks || this.myLastParent != stmt.getParent()) {
            this.processChildren(stmt);
        }
    }

    @Override
    public void visitMethod(OCMethod method) {
        this.processChildren(method);
    }

    @Override
    public void visitRequiresClause(OCRequiresClause requiresClause) {
        this.processChildren(requiresClause);
    }

    @Override
    public void visitParameterDeclaration(OCParameterDeclaration declaration) {
        this.processChildren(declaration);
    }

    @Override
    public void visitParameterList(OCParameterList list) {
        this.processChildren(list);
    }

    @Override
    public void visitLambdaIntroducer(OCLambdaIntroducer introducer) {
        this.processChildren(introducer);
    }

    @Override
    public void visitStructuredBindingDeclarator(OCStructuredBindingDeclarator bindingDeclarator) {
        this.processChildren(bindingDeclarator);
    }

    @Override
    public void visitStructuredBindingList(OCStructuredBindingList bindingList) {
        this.processChildren(bindingList);
    }

    @Override
    public void visitTemplateParameterList(OCTemplateParameterListImpl list) {
        this.processChildren(list);
    }

    @Override
    public void visitStructLike(OCStructLike struct) {
        if (this.myResult) {
            this.myResult = this.myProcessor.process((Object)struct);
        }
        if (struct instanceof OCEnum || this.myLastParent != struct.getParent()) {
            this.processChildren(struct);
        }
    }

    @Override
    public void visitUsingStatement(OCCppUsingStatement usingStatement) {
        if (this.myResult) {
            this.myResult = this.myProcessor.process((Object)usingStatement);
        }
    }

    @Override
    public void visitNamespaceAlias(OCCppNamespaceAlias namespaceAlias) {
        if (this.myResult) {
            this.myResult = this.myProcessor.process((Object)namespaceAlias);
        }
    }

    @Override
    public void visitTypeElement(OCTypeElement typeElement) {
        this.processChildren(typeElement);
    }
}

