/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.resolve.references;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import java.io.File;
import java.util.SortedMap;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCResourceFilesProvider {
    private static final int MAX_LANGUAGE_LENGTH = 40;
    public static final ExtensionPointName<OCResourceFilesProvider> EP_NAME = ExtensionPointName.create((String)"cidr.lang.resourceFilesProvider");

    @NotNull
    public static SortedMap<String, VirtualFile> getAccessibleResources(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(0);
        }
        if (virtualFile == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(1);
        }
        TreeMap<String, VirtualFile> result = new TreeMap<String, VirtualFile>();
        for (OCResourceFilesProvider provider2 : (OCResourceFilesProvider[])EP_NAME.getExtensions()) {
            result.putAll(provider2.getAccessibleResourceFiles(project, virtualFile));
        }
        TreeMap<String, VirtualFile> treeMap = result;
        if (treeMap == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(2);
        }
        return treeMap;
    }

    @NotNull
    public static SortedMap<String, VirtualFile> getAccessibleResources(@NotNull PsiElement element) {
        if (element == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(3);
        }
        return OCResourceFilesProvider.getAccessibleResources(element.getProject(), OCResourceFilesProvider.getFileFromElement(element));
    }

    public static boolean isAccessible(@NotNull Project project, @NotNull VirtualFile from, @NotNull VirtualFile who) {
        if (project == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(4);
        }
        if (from == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(5);
        }
        if (who == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(6);
        }
        for (OCResourceFilesProvider provider2 : (OCResourceFilesProvider[])EP_NAME.getExtensions()) {
            if (!provider2.isAccessibleInner(project, from, who)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAccessible(@NotNull PsiElement element, @NotNull VirtualFile file) {
        if (element == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(7);
        }
        if (file == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(8);
        }
        return OCResourceFilesProvider.isAccessible(element.getProject(), OCResourceFilesProvider.getFileFromElement(element), file);
    }

    @NotNull
    private static VirtualFile getFileFromElement(@NotNull PsiElement element) {
        if (element == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(9);
        }
        VirtualFile virtualFile = OCFileUtil.getVirtualFile(element.getContainingFile());
        if (virtualFile == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(10);
        }
        return virtualFile;
    }

    @NotNull
    protected abstract SortedMap<String, VirtualFile> getAccessibleResourceFiles(@NotNull Project var1, @NotNull VirtualFile var2);

    protected abstract boolean isAccessibleInner(@NotNull Project var1, @NotNull VirtualFile var2, @Nullable VirtualFile var3);

    @NlsSafe
    @NotNull
    public static String getLocalizationName(@NotNull PsiFile file) {
        if (file == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(11);
        }
        return OCResourceFilesProvider.getLocalizationName(file.getProject(), file.getVirtualFile());
    }

    @NlsSafe
    @NotNull
    public static String getLocalizationName(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(12);
        }
        if (file == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(13);
        }
        for (OCResourceFilesProvider provider2 : (OCResourceFilesProvider[])EP_NAME.getExtensions()) {
            String localizationName = provider2.getLocalizationNameInner(project, file);
            if (localizationName == null) continue;
            return OCResourceFilesProvider.shortenStringBeginning(localizationName);
        }
        String string = OCBundle.message("resource.language.unknown", new Object[0]);
        if (string == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(14);
        }
        return string;
    }

    @NotNull
    private static String shortenStringBeginning(@NotNull String localizationName) {
        if (localizationName == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(15);
        }
        String string = StringUtil.shortenTextWithEllipsis((String)localizationName, (int)40, (int)39, (boolean)true);
        if (string == null) {
            OCResourceFilesProvider.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NlsSafe
    @Nullable
    protected abstract String getLocalizationNameInner(@NotNull Project var1, @NotNull VirtualFile var2);

    @Nullable
    public static String withoutLocalization(String fileName) {
        String locationExtension = ".lproj" + File.separator;
        int extensionIndex = fileName.lastIndexOf(locationExtension);
        if (extensionIndex <= 0) {
            return null;
        }
        int separatorIndex = fileName.lastIndexOf(File.separator, extensionIndex - 1);
        if (separatorIndex == extensionIndex - 1) {
            return null;
        }
        return fileName.substring(0, separatorIndex + 1) + fileName.substring(extensionIndex + locationExtension.length());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 10, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 2: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/resolve/references/OCResourceFilesProvider";
                break;
            }
            case 3: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "who";
                break;
            }
            case 8: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localizationName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/resolve/references/OCResourceFilesProvider";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAccessibleResources";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileFromElement";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalizationName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "shortenStringBeginning";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAccessibleResources";
                break;
            }
            case 2: 
            case 10: 
            case 14: 
            case 16: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isAccessible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getFileFromElement";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getLocalizationName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "shortenStringBeginning";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 10, 14, 16 -> new IllegalStateException(string);
        };
    }
}

