/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.settings.OCOption;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ItemListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.Nls;

public class OCEnumGroupOption<T>
implements OCOption<T, JPanel> {
    private final T[] myValues;
    @Nls
    private final String[] myChoices;
    @Nls
    private final String myGroupName;
    private final Presentation myPresentation;

    public OCEnumGroupOption(@Nls String groupName, Presentation presentations, T[] values, String ... choices) {
        this.myGroupName = groupName;
        this.myPresentation = presentations;
        this.myChoices = choices;
        this.myValues = values;
    }

    @Override
    public JPanel createComponent() {
        return this.createComponent(this.myGroupName != null && !this.myGroupName.isEmpty());
    }

    public JPanel createComponent(boolean showBorder) {
        ButtonGroup group = new ButtonGroup();
        switch (this.myPresentation) {
            case Section: {
                JPanel panel = new JPanel(new FlowLayout(0, 0, 0));
                for (String choice : this.myChoices) {
                    JRadioButton radioButton = new JRadioButton(choice);
                    group.add(radioButton);
                    panel.add(radioButton);
                }
                if (showBorder) {
                    panel.setBorder(IdeBorderFactory.createTitledBorder((String)this.myGroupName));
                }
                return panel;
            }
            case Line: {
                JPanel panel = new JPanel(new FlowLayout(0, 6, 10));
                JPanel p1 = new JPanel((LayoutManager)new VerticalFlowLayout(2, 0, 0, true, false));
                JLabel label = new JLabel(this.myGroupName + ":\t");
                p1.add(Box.createVerticalStrut(2));
                p1.add(label);
                panel.add(p1);
                for (String choice : this.myChoices) {
                    JRadioButton radioButton = new JRadioButton(choice);
                    group.add(radioButton);
                    JPanel p2 = new JPanel((LayoutManager)new VerticalFlowLayout(2, 0, 0, true, false));
                    p2.add(radioButton);
                    panel.add(p2);
                }
                return panel;
            }
        }
        return null;
    }

    private static boolean processRadioButtons(JPanel component, Processor<JRadioButton> processor2) {
        for (Component child : component.getComponents()) {
            if ((!(child instanceof JPanel) || OCEnumGroupOption.processRadioButtons((JPanel)child, processor2)) && (!(child instanceof JRadioButton) || processor2.process((Object)((JRadioButton)child)))) continue;
            return false;
        }
        return true;
    }

    @Override
    public T getSelectedValue(JPanel component) {
        Ref index = Ref.create((Object)0);
        OCEnumGroupOption.processRadioButtons(component, (Processor<JRadioButton>)((Processor)button -> {
            if (button.isSelected()) {
                return false;
            }
            index.set((Object)((Integer)index.get() + 1));
            return true;
        }));
        return (Integer)index.get() < this.myValues.length ? (T)this.myValues[(Integer)index.get()] : null;
    }

    @Override
    public void selectValue(JPanel component, T value) {
        Ref index = Ref.create((Object)0);
        OCEnumGroupOption.processRadioButtons(component, (Processor<JRadioButton>)((Processor)button -> {
            if (this.myValues[(Integer)index.get()] == value) {
                button.setSelected(true);
                return false;
            }
            index.set((Object)((Integer)index.get() + 1));
            return true;
        }));
    }

    @Override
    public void addItemListener(JPanel component, ItemListener listener) {
        OCEnumGroupOption.processRadioButtons(component, (Processor<JRadioButton>)((Processor)button -> {
            button.addItemListener(listener);
            return true;
        }));
    }

    public static enum Presentation {
        Section,
        Line;

    }
}

