/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.psi.impl.OCCallExpressionImpl;
import com.jetbrains.cidr.lang.resolve.OCArgumentsList;
import com.jetbrains.cidr.lang.resolve.OCExprValueCategory;
import com.jetbrains.cidr.lang.resolve.OCResolveOverloadsUtil;
import com.jetbrains.cidr.lang.resolve.references.OCOperatorReference;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCSymbolWithQualifiedName;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCQualifiedExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.expression.OCReferenceExpressionSymbol;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCFunctionType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeParameterType;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCCallExpressionSymbol
extends OCExpressionSymbol {
    private OCExpressionSymbol myCalleeSymbol;
    private List<OCExpressionSymbol> myArguments;

    public OCCallExpressionSymbol() {
    }

    /*
     * WARNING - void declaration
     */
    public OCCallExpressionSymbol(@Nullable VirtualFile file, long offset, @NotNull OCExpressionSymbol calleeSymbol, @NotNull List<OCExpressionSymbol> list) {
        void arguments;
        if (calleeSymbol == null) {
            OCCallExpressionSymbol.$$$reportNull$$$0(0);
        }
        if (list == null) {
            OCCallExpressionSymbol.$$$reportNull$$$0(1);
        }
        super(file, offset);
        this.myCalleeSymbol = calleeSymbol;
        this.myArguments = arguments;
    }

    @Override
    public void compact() {
        super.compact();
        this.myArguments = ContainerUtil.trimToSize(this.myArguments);
    }

    public OCExpressionSymbol getCalleeSymbol() {
        return this.myCalleeSymbol;
    }

    @Override
    @NotNull
    public List<OCExpressionSymbol> getArguments() {
        List<OCExpressionSymbol> list = this.myArguments;
        if (list == null) {
            OCCallExpressionSymbol.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCCallExpressionSymbol.$$$reportNull$$$0(3);
        }
        if (first == null) {
            OCCallExpressionSymbol.$$$reportNull$$$0(4);
        }
        if (second == null) {
            OCCallExpressionSymbol.$$$reportNull$$$0(5);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCCallExpressionSymbol firstSymbol = (OCCallExpressionSymbol)first;
        OCCallExpressionSymbol secondSymbol = (OCCallExpressionSymbol)second;
        if (!c.equalObjects(firstSymbol.myCalleeSymbol, secondSymbol.myCalleeSymbol)) {
            return false;
        }
        return c.equalObjects(firstSymbol.myArguments, secondSymbol.myArguments);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            OCCallExpressionSymbol.$$$reportNull$$$0(6);
        }
        return evaluator.evalCall(this);
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        OCArgumentsList<OCExpressionSymbol> arguments;
        OCType callerType;
        if (context == null) {
            OCCallExpressionSymbol.$$$reportNull$$$0(7);
        }
        OCSymbol callerSymbol = null;
        if (this.myCalleeSymbol == null) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                OCCallExpressionSymbol.$$$reportNull$$$0(8);
            }
            return oCUnknownType;
        }
        if (this.myCalleeSymbol instanceof OCReferenceExpressionSymbol) {
            OCReferenceType type;
            OCType resolved;
            callerSymbol = ((OCReferenceExpressionSymbol)this.myCalleeSymbol).resolveToSymbol(context);
            OCResolveContext newContext = callerSymbol != null ? context.useFor(callerSymbol) : null;
            OCType oCType = callerType = callerSymbol != null ? OCTypeUtils.getSymbolType(callerSymbol, context).resolve(newContext) : null;
            if (callerType instanceof OCCppReferenceType) {
                callerType = ((OCCppReferenceType)callerType).getRefType();
            }
            if (OCTypeUtils.isUnresolvedLambdaAutoType(callerType) && (arguments = this.getArgumentList(context)) != null) {
                callerType = OCTypeUtils.resolveLambdaAutoType(callerType, context, arguments, false);
            }
            if (callerType instanceof OCPointerType) {
                callerType = ((OCPointerType)callerType).getRefType();
            }
            if (callerType instanceof OCFunctionType) {
                OCType oCType2 = OCCallExpressionImpl.getCallExprType(callerType, callerSymbol, context);
                if (oCType2 == null) {
                    OCCallExpressionSymbol.$$$reportNull$$$0(9);
                }
                return oCType2;
            }
            if (callerSymbol == null && !(resolved = (type = ((OCReferenceExpressionSymbol)this.myCalleeSymbol).asTypeReference()).resolve(context)).isUnknown()) {
                OCType oCType3 = resolved;
                if (oCType3 == null) {
                    OCCallExpressionSymbol.$$$reportNull$$$0(10);
                }
                return oCType3;
            }
        }
        OCSymbol calleeResolvedSymbol = null;
        if (this.myCalleeSymbol instanceof OCQualifiedExpressionSymbol) {
            Pair<OCSymbol, OCType> pair = ((OCQualifiedExpressionSymbol)this.myCalleeSymbol).getResolvedSymbolAndType(context);
            calleeResolvedSymbol = (OCSymbol)pair.first;
            callerType = (OCType)pair.second;
        } else {
            callerType = this.myCalleeSymbol.getResolvedType(context);
        }
        callerType = callerType.getTerminalType();
        if (callerType instanceof OCFunctionType) {
            OCSymbol dummyFunction;
            OCSymbol oCSymbol = dummyFunction = calleeResolvedSymbol instanceof OCFunctionSymbol ? calleeResolvedSymbol : new OCFunctionSymbol(null, 0L, null, OCQualifiedName.with(null), Collections.emptyList(), null, 0, 0, Collections.emptyList(), (OCFunctionType)callerType, Collections.emptyList(), OCSymbolKind.FUNCTION_DECLARATION, null);
            if (this.resolveOverloads(Collections.singletonList(dummyFunction), context) == null) {
                OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
                if (oCUnknownType == null) {
                    OCCallExpressionSymbol.$$$reportNull$$$0(11);
                }
                return oCUnknownType;
            }
        } else if (callerType instanceof OCStructType) {
            arguments = this.getArgumentList(context);
            if (arguments == null) {
                OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
                if (oCUnknownType == null) {
                    OCCallExpressionSymbol.$$$reportNull$$$0(12);
                }
                return oCUnknownType;
            }
            ArrayList<OCType> types = new ArrayList<OCType>();
            ArrayList<OCExpressionSymbol> expressions = null;
            types.add(callerType);
            types.addAll(arguments.getTypes());
            if (arguments.getExprs() != null) {
                expressions = new ArrayList<OCExpressionSymbol>();
                expressions.add(null);
                expressions.addAll(arguments.getExprs());
            }
            OCResolveContext newContext = (callerSymbol = OCOperatorReference.resolveOperator("()", OCOperatorReference.OperatorPlacement.POSTFIX, types, expressions, context)) != null ? context.useFor(callerSymbol) : null;
            callerType = callerSymbol != null ? OCTypeUtils.getSymbolType(callerSymbol, context).resolve(newContext) : null;
        }
        OCType oCType = callerType != null ? OCCallExpressionImpl.getCallExprType(callerType, callerSymbol, context) : OCUnknownType.INSTANCE;
        if (oCType == null) {
            OCCallExpressionSymbol.$$$reportNull$$$0(13);
        }
        return oCType;
    }

    @Nullable
    public OCArgumentsList<OCExpressionSymbol> getArgumentList(@NotNull OCResolveContext context) {
        if (context == null) {
            OCCallExpressionSymbol.$$$reportNull$$$0(14);
        }
        OCArgumentsList<OCExpressionSymbol> arguments = OCArgumentsList.expandVariadicExpressions(this.myArguments, context);
        for (OCType type : arguments.getTypes()) {
            if (!(type instanceof OCTypeParameterType)) continue;
            context.addTypeDependency(((OCTypeParameterType)type).getSymbol());
        }
        for (OCType type : arguments.getTypes()) {
            if (type != null) continue;
            return null;
        }
        return arguments;
    }

    @Nullable
    public OCSymbol resolveOverloads(Collection<OCSymbol> symbols, OCResolveContext context) {
        OCFunctionSymbol outerFunction;
        OCArgumentsList<OCExpressionSymbol> argumentList = this.getArgumentList(context);
        OCType leftType = null;
        OCExprValueCategory leftValueCategory = null;
        if (this.myCalleeSymbol instanceof OCQualifiedExpressionSymbol) {
            OCExpressionSymbol qualifier = ((OCQualifiedExpressionSymbol)this.myCalleeSymbol).getQualifier();
            OCSymbol qualifierSymbol = qualifier instanceof OCReferenceExpressionSymbol ? ((OCReferenceExpressionSymbol)qualifier).resolveToSymbol(context) : null;
            leftType = qualifierSymbol != null ? qualifierSymbol.getType().resolve(context) : null;
            leftValueCategory = OCExprValueCategory.classify(qualifier, context);
        }
        if ((outerFunction = context.peekOuterFunction()) != null) {
            if (leftType == null) {
                OCSymbolWithQualifiedName owner = outerFunction.getResolvedOwner(context, false);
                leftType = owner != null ? owner.getType() : null;
                leftValueCategory = null;
            }
            if (leftType != null) {
                leftType = leftType.cloneWithAddedCVQualifiers(outerFunction.getType().getCVQualifiers(), context.getProject());
            }
        }
        return argumentList != null ? OCResolveOverloadsUtil.resolveOverloads(symbols, argumentList, leftType, leftValueCategory, null, true, true, context, null) : null;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        String string = this.myCalleeSymbol.getPresentableName() + "(" + StringUtil.join(this.myArguments, OCSymbol::getPresentableName, (String)", ") + ")";
        if (string == null) {
            OCCallExpressionSymbol.$$$reportNull$$$0(15);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 8, 9, 10, 11, 12, 13, 15 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "calleeSymbol";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/expression/OCCallExpressionSymbol";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/expression/OCCallExpressionSymbol";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getArguments";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedType";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getArgumentList";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 8, 9, 10, 11, 12, 13, 15 -> new IllegalStateException(string);
        };
    }
}

