/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.expression;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cidr.lang.psi.impl.OCLiteralExpressionImpl;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.expression.OCExpressionSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.OCNamesInterner;
import com.jetbrains.cidr.lang.types.OCExpressionTypeArgument;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.util.OCExpressionEvaluator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLiteralExpressionSymbol
extends OCExpressionSymbol {
    @NotNull
    private Object myValue;
    private IElementType myTokenType;
    private Object myChildTextElements;

    public OCLiteralExpressionSymbol() {
    }

    public OCLiteralExpressionSymbol(@NotNull Object value, IElementType tokenType, @Nullable List<String> textElements) {
        if (value == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(0);
        }
        super(null, 0L);
        this.myValue = value;
        this.myTokenType = tokenType;
        this.myChildTextElements = textElements != null && textElements.size() == 1 ? OCNamesInterner.intern((String)textElements.get(0)) : textElements;
    }

    @NotNull
    public Object getValue() {
        Object object = this.myValue;
        if (object == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(1);
        }
        return object;
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(2);
        }
        if (first == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(3);
        }
        if (second == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(4);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCLiteralExpressionSymbol firstSymbol = (OCLiteralExpressionSymbol)first;
        OCLiteralExpressionSymbol secondSymbol = (OCLiteralExpressionSymbol)second;
        return c.equalObjects(firstSymbol.myValue, secondSymbol.myValue);
    }

    @Override
    @Nullable
    public <T> T evaluate(@NotNull OCExpressionEvaluator.CachingEvaluator<T> evaluator) {
        if (evaluator == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(5);
        }
        if (this.myValue instanceof Boolean) {
            return evaluator.evalBool((Boolean)this.myValue);
        }
        if (this.myValue instanceof Number) {
            return evaluator.evalInteger((Number)this.myValue);
        }
        return null;
    }

    @Override
    @NotNull
    public OCType getResolvedType(@NotNull OCResolveContext context) {
        if (context == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(6);
        }
        PsiFile file = context.getFile();
        List<String> childTextElements = this.myChildTextElements instanceof String ? Collections.singletonList((String)this.myChildTextElements) : (List<String>)this.myChildTextElements;
        OCType oCType = file != null ? OCLiteralExpressionImpl.getLiteralType(this.myTokenType, childTextElements, file) : OCUnknownType.INSTANCE;
        if (oCType == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(7);
        }
        return oCType;
    }

    @Override
    @Nullable
    public OCTypeArgument evaluateToTypeArgument(@NotNull OCResolveContext resolver) {
        if (resolver == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(8);
        }
        return new OCExpressionTypeArgument(this);
    }

    @NotNull
    public IElementType getTokenType() {
        IElementType iElementType = this.myTokenType;
        if (iElementType == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(9);
        }
        return iElementType;
    }

    @Override
    public boolean isLiteral() {
        return true;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        if (this.myChildTextElements instanceof List) {
            String string = StringUtil.join((Collection)((List)this.myChildTextElements), (String)" ");
            if (string == null) {
                OCLiteralExpressionSymbol.$$$reportNull$$$0(10);
            }
            return string;
        }
        if (this.myChildTextElements instanceof String) {
            String string = (String)this.myChildTextElements;
            if (string == null) {
                OCLiteralExpressionSymbol.$$$reportNull$$$0(11);
            }
            return string;
        }
        String string = this.myValue.toString();
        if (string == null) {
            OCLiteralExpressionSymbol.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 7, 9, 10, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/expression/OCLiteralExpressionSymbol";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "evaluator";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/expression/OCLiteralExpressionSymbol";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getValue";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getResolvedType";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getTokenType";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "evaluate";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getResolvedType";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "evaluateToTypeArgument";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 7, 9, 10, 11, 12 -> new IllegalStateException(string);
        };
    }
}

