/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.symbols.OCSymbolWithSubstitution;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.ARCAttribute;
import com.jetbrains.cidr.lang.types.OCType;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCPropertySymbol
extends OCMemberSymbol,
OCSymbolWithSubstitution {
    public static final Set<? extends PropertyAttribute> PROPERTY_ATTRIBUTES_WITH_VALUE = EnumSet.of(PropertyAttribute.GETTER, PropertyAttribute.SETTER);
    public static final Set<? extends PropertyAttribute> PROPERTY_ATTRIBUTES_FOR_OBJECT = EnumSet.of(FlagAttribute.RETAIN, PropertyAttribute.STRONG, PropertyAttribute.COPY);
    public static final Set<? extends PropertyAttribute> PROPERTY_ATTRIBUTES_AFTER_LLVM_30 = EnumSet.of(FlagAttribute.STRONG, PropertyAttribute.WEAK, PropertyAttribute.UNSAFE_UNRETAINED);

    public boolean hasAttribute(@NotNull PropertyAttribute var1);

    @Nullable
    public String getAttributeValue(@NotNull ValueAttribute var1);

    @NotNull
    default public FlagAttribute getAttributeOfGroup(@NotNull FlagAttribute defaultAttribute, @NotNull OCType type, @NotNull PsiElement context) {
        if (defaultAttribute == null) {
            OCPropertySymbol.$$$reportNull$$$0(0);
        }
        if (type == null) {
            OCPropertySymbol.$$$reportNull$$$0(1);
        }
        if (context == null) {
            OCPropertySymbol.$$$reportNull$$$0(2);
        }
        FlagAttribute flagAttribute = OCPropertySymbolImpl.getAttributeOfGroup(this, defaultAttribute, type, context);
        if (flagAttribute == null) {
            OCPropertySymbol.$$$reportNull$$$0(3);
        }
        return flagAttribute;
    }

    public boolean isOptional();

    @Override
    default public boolean isStatic() {
        return this.hasAttribute(PropertyAttribute.CLASS);
    }

    default public boolean isReadonly() {
        return this.hasAttribute(PropertyAttribute.READONLY);
    }

    default public boolean isRetained() {
        return this.hasAttribute(PropertyAttribute.RETAIN) || this.hasAttribute(PropertyAttribute.COPY);
    }

    @NotNull
    default public String getGetterName() {
        String getter = this.getAttributeValue(PropertyAttribute.GETTER);
        String string = getter != null ? getter : this.getName();
        if (string == null) {
            OCPropertySymbol.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    default public String getSetterName() {
        String setter = this.getAttributeValue(PropertyAttribute.SETTER);
        Object object = setter != null ? setter + ":" : OCNameSuggester.getObjCSetterFromGetter(this.getName());
        if (object == null) {
            OCPropertySymbol.$$$reportNull$$$0(5);
        }
        return object;
    }

    default public boolean processAccessorMethods(@NotNull Processor<? super OCMethodSymbol> processor2, boolean searchSubclasses, @NotNull Project project) {
        if (processor2 == null) {
            OCPropertySymbol.$$$reportNull$$$0(6);
        }
        if (project == null) {
            OCPropertySymbol.$$$reportNull$$$0(7);
        }
        return OCPropertySymbolImpl.processAccessorMethods(this, processor2, searchSubclasses, project);
    }

    default public boolean processSynthesizes(@NotNull Processor<? super OCSynthesizeSymbol> processor2, @NotNull Project project) {
        if (processor2 == null) {
            OCPropertySymbol.$$$reportNull$$$0(8);
        }
        if (project == null) {
            OCPropertySymbol.$$$reportNull$$$0(9);
        }
        return OCPropertySymbolImpl.processSynthesizes(this, processor2, project);
    }

    @Nullable
    default public OCInstanceVariableSymbol getAssociatedIvar(@NotNull Project project) {
        if (project == null) {
            OCPropertySymbol.$$$reportNull$$$0(10);
        }
        return OCPropertySymbolImpl.getAssociatedIvar(this, project);
    }

    default public boolean hasAllAccessorsImplemented(boolean treatSynthesizeAsAccessors, @NotNull Project project) {
        if (project == null) {
            OCPropertySymbol.$$$reportNull$$$0(11);
        }
        return OCPropertySymbolImpl.hasAllAccessorsImplemented(this, treatSynthesizeAsAccessors, project);
    }

    @Nullable
    default public OCPropertySymbol getAssociatedPropertyInPrivateCategory(@NotNull Project project) {
        if (project == null) {
            OCPropertySymbol.$$$reportNull$$$0(12);
        }
        return OCPropertySymbolImpl.getAssociatedPropertyInPrivateCategory(this, project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAttribute";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbol";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 7: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbol";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeOfGroup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getGetterName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSetterName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeOfGroup";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "processAccessorMethods";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processSynthesizes";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedIvar";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasAllAccessorsImplemented";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedPropertyInPrivateCategory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    public static final class FlagAttribute
    extends Enum<FlagAttribute>
    implements PropertyAttribute {
        public static final /* enum */ FlagAttribute NONATOMIC = new FlagAttribute(PropertyAttribute.Group.ATOMICITY);
        public static final /* enum */ FlagAttribute ATOMIC = new FlagAttribute(PropertyAttribute.Group.ATOMICITY);
        public static final /* enum */ FlagAttribute READONLY = new FlagAttribute(PropertyAttribute.Group.WRITEABILITY);
        public static final /* enum */ FlagAttribute READWRITE = new FlagAttribute(PropertyAttribute.Group.WRITEABILITY);
        public static final /* enum */ FlagAttribute ASSIGN = new FlagAttribute(PropertyAttribute.Group.ARC);
        public static final /* enum */ FlagAttribute COPY = new FlagAttribute(PropertyAttribute.Group.ARC);
        public static final /* enum */ FlagAttribute RETAIN = new FlagAttribute(PropertyAttribute.Group.ARC);
        public static final /* enum */ FlagAttribute WEAK = new FlagAttribute(PropertyAttribute.Group.ARC);
        public static final /* enum */ FlagAttribute STRONG = new FlagAttribute(PropertyAttribute.Group.ARC);
        public static final /* enum */ FlagAttribute UNSAFE_UNRETAINED = new FlagAttribute(PropertyAttribute.Group.ARC);
        public static final /* enum */ FlagAttribute NONNULL = new FlagAttribute(PropertyAttribute.Group.NULLABILITY);
        public static final /* enum */ FlagAttribute NULLABLE = new FlagAttribute(PropertyAttribute.Group.NULLABILITY);
        public static final /* enum */ FlagAttribute NULL_RESETTABLE = new FlagAttribute(PropertyAttribute.Group.NULLABILITY);
        public static final /* enum */ FlagAttribute NULL_UNSPECIFIED = new FlagAttribute(PropertyAttribute.Group.NULLABILITY);
        public static final /* enum */ FlagAttribute CLASS = new FlagAttribute(PropertyAttribute.Group.STATICNESS);
        private final PropertyAttribute.Group myGroup;
        private static final /* synthetic */ FlagAttribute[] $VALUES;

        public static FlagAttribute[] values() {
            return (FlagAttribute[])$VALUES.clone();
        }

        public static FlagAttribute valueOf(String name) {
            return Enum.valueOf(FlagAttribute.class, name);
        }

        private FlagAttribute(PropertyAttribute.Group group) {
            this.myGroup = group;
        }

        @Override
        @NotNull
        public PropertyAttribute.Group getGroup() {
            PropertyAttribute.Group group = this.myGroup;
            if (group == null) {
                FlagAttribute.$$$reportNull$$$0(0);
            }
            return group;
        }

        @Override
        @NotNull
        public String getTokenName() {
            String string = StringUtil.toLowerCase((String)this.name());
            if (string == null) {
                FlagAttribute.$$$reportNull$$$0(1);
            }
            return string;
        }

        @NotNull
        public ARCAttribute getIvarCompatibleARCAttribute() {
            ARCAttribute aRCAttribute = switch (this) {
                case ASSIGN, UNSAFE_UNRETAINED -> ARCAttribute.UNSAFE_UNRETAINED;
                case WEAK -> ARCAttribute.WEAK;
                case STRONG, COPY, RETAIN -> ARCAttribute.STRONG;
                default -> {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    yield null;
                }
            };
            if (aRCAttribute == null) {
                FlagAttribute.$$$reportNull$$$0(2);
            }
            return aRCAttribute;
        }

        public int getSemanticsGroup() {
            return switch (this) {
                case STRONG, RETAIN -> 0;
                case COPY -> 1;
                default -> 2;
            };
        }

        @Nullable
        public PropertySemantics getSemanticsAttribute() {
            return switch (this) {
                case ASSIGN, UNSAFE_UNRETAINED -> PropertySemantics.ASSIGN;
                case COPY -> PropertySemantics.COPY;
                case RETAIN -> PropertySemantics.RETAIN;
                case WEAK -> PropertySemantics.WEAK;
                case STRONG -> PropertySemantics.STRONG;
                default -> null;
            };
        }

        private static /* synthetic */ FlagAttribute[] $values() {
            return new FlagAttribute[]{NONATOMIC, ATOMIC, READONLY, READWRITE, ASSIGN, COPY, RETAIN, WEAK, STRONG, UNSAFE_UNRETAINED, NONNULL, NULLABLE, NULL_RESETTABLE, NULL_UNSPECIFIED, CLASS};
        }

        static {
            $VALUES = FlagAttribute.$values();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbol$FlagAttribute";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroup";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokenName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getIvarCompatibleARCAttribute";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    public static interface PropertyAttribute {
        public static final FlagAttribute NONATOMIC = FlagAttribute.NONATOMIC;
        public static final FlagAttribute ATOMIC = FlagAttribute.ATOMIC;
        public static final FlagAttribute READONLY = FlagAttribute.READONLY;
        public static final FlagAttribute READWRITE = FlagAttribute.READWRITE;
        public static final FlagAttribute ASSIGN = FlagAttribute.ASSIGN;
        public static final FlagAttribute COPY = FlagAttribute.COPY;
        public static final FlagAttribute RETAIN = FlagAttribute.RETAIN;
        public static final FlagAttribute WEAK = FlagAttribute.WEAK;
        public static final FlagAttribute STRONG = FlagAttribute.STRONG;
        public static final FlagAttribute UNSAFE_UNRETAINED = FlagAttribute.UNSAFE_UNRETAINED;
        public static final FlagAttribute NONNULL = FlagAttribute.NONNULL;
        public static final FlagAttribute NULLABLE = FlagAttribute.NULLABLE;
        public static final FlagAttribute NULL_RESETTABLE = FlagAttribute.NULL_RESETTABLE;
        public static final FlagAttribute NULL_UNSPECIFIED = FlagAttribute.NULL_UNSPECIFIED;
        public static final FlagAttribute CLASS = FlagAttribute.CLASS;
        public static final ValueAttribute GETTER = ValueAttribute.GETTER;
        public static final ValueAttribute SETTER = ValueAttribute.SETTER;

        @NotNull
        public Group getGroup();

        @NotNull
        public String getTokenName();

        public static enum Group {
            ATOMICITY,
            WRITEABILITY,
            ARC,
            GETTER,
            SETTER,
            NULLABILITY,
            STATICNESS;

        }
    }

    public static enum ValueAttribute implements PropertyAttribute
    {
        GETTER(PropertyAttribute.Group.GETTER),
        SETTER(PropertyAttribute.Group.SETTER);

        private final PropertyAttribute.Group myGroup;

        private ValueAttribute(PropertyAttribute.Group group) {
            if (group == null) {
                ValueAttribute.$$$reportNull$$$0(0);
            }
            this.myGroup = group;
        }

        @Override
        @NotNull
        public PropertyAttribute.Group getGroup() {
            PropertyAttribute.Group group = this.myGroup;
            if (group == null) {
                ValueAttribute.$$$reportNull$$$0(1);
            }
            return group;
        }

        @Override
        @NotNull
        public String getTokenName() {
            String string = StringUtil.toLowerCase((String)this.name());
            if (string == null) {
                ValueAttribute.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "group";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbol$ValueAttribute";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbol$ValueAttribute";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGroup";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTokenName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2 -> new IllegalStateException(string);
            };
        }
    }

    public static enum PropertySemantics {
        DEFAULT,
        STRONG,
        WEAK,
        ASSIGN,
        RETAIN,
        COPY;


        @Nullable
        public PropertyAttribute getPropertyAttribute() {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case DEFAULT -> null;
                case STRONG -> PropertyAttribute.STRONG;
                case WEAK -> PropertyAttribute.WEAK;
                case ASSIGN -> PropertyAttribute.ASSIGN;
                case RETAIN -> PropertyAttribute.RETAIN;
                case COPY -> PropertyAttribute.COPY;
            };
        }
    }
}

