/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.objc;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCIcons;
import com.jetbrains.cidr.lang.refactoring.OCNameSuggester;
import com.jetbrains.cidr.lang.search.OCSearchUtil;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbolKind;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCImplementationSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbolImpl;
import com.jetbrains.cidr.lang.symbols.objc.OCMethodSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCPropertySymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCSynthesizeSymbol;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.types.visitors.OCTypeSubstitution;
import com.jetbrains.cidr.lang.util.OCCommonProcessors;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCPropertySymbolImpl
extends OCMemberSymbolImpl
implements OCPropertySymbol {
    @NotNull
    private OCType myType;
    @Nullable
    private EnumSet<OCPropertySymbol.FlagAttribute> myFlagAttributes;
    @Nullable
    private EnumMap<OCPropertySymbol.ValueAttribute, String> myValueAttributes;
    private boolean myOptional;
    @NotNull
    private OCTypeSubstitution mySubstitution;

    public OCPropertySymbolImpl() {
        this.mySubstitution = OCTypeSubstitution.ID;
    }

    /*
     * WARNING - void declaration
     */
    public OCPropertySymbolImpl(VirtualFile file, long offset, @NotNull String name, @NotNull List<String> attributes, @NotNull OCClassSymbol parent, @NotNull OCType type, boolean isOptional, @Nullable EnumSet<OCPropertySymbol.FlagAttribute> flagAttributes, @Nullable EnumMap<OCPropertySymbol.ValueAttribute, String> enumMap) {
        void valueAttributes;
        if (name == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(0);
        }
        if (attributes == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(1);
        }
        if (parent == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(2);
        }
        if (type == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(3);
        }
        super(file, offset, name, attributes, parent);
        this.mySubstitution = OCTypeSubstitution.ID;
        this.myType = type;
        this.myOptional = isOptional;
        this.myValueAttributes = valueAttributes != null && !valueAttributes.isEmpty() ? valueAttributes : null;
        this.myFlagAttributes = flagAttributes != null && !flagAttributes.isEmpty() ? flagAttributes : null;
    }

    protected OCPropertySymbolImpl(@NotNull OCPropertySymbolImpl origin, @NotNull OCTypeSubstitution substitution) {
        if (origin == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(4);
        }
        if (substitution == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(5);
        }
        this(origin.getContainingFile(), origin.getComplexOffset(), origin.getName(), origin.getAttributes(), origin.getParent(), origin.myType, origin.myOptional, origin.myFlagAttributes, origin.myValueAttributes);
        this.mySubstitution = substitution;
    }

    @Override
    @NotNull
    public OCPropertySymbolImpl cloneWithSubstitution(@NotNull OCTypeSubstitution substitution) {
        if (substitution == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(6);
        }
        return new OCPropertySymbolImpl(this, substitution);
    }

    @Override
    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(7);
        }
        if (first == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(8);
        }
        if (second == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(9);
        }
        if (!super.deepEqualStep(c, first, second)) {
            return false;
        }
        OCPropertySymbolImpl f = (OCPropertySymbolImpl)first;
        OCPropertySymbolImpl s = (OCPropertySymbolImpl)second;
        if (!Comparing.equal(f.myFlagAttributes, s.myFlagAttributes)) {
            return false;
        }
        if (!Comparing.equal(f.myValueAttributes, s.myValueAttributes)) {
            return false;
        }
        if (!c.equalObjects(f.mySubstitution, s.mySubstitution)) {
            return false;
        }
        return c.equalObjects(f.myType, s.myType);
    }

    @Override
    public void compact() {
        super.compact();
        this.myType.compact();
    }

    public static OCPropertySymbol.PropertySemantics getDefaultSemanticsForType(OCType type, PsiElement context) {
        if ("NSString *".equals(type.getName()) || type instanceof OCBlockPointerType) {
            return OCPropertySymbol.PropertySemantics.COPY;
        }
        if (type.isPointerToObjectCompatible()) {
            return OCCompilerFeaturesHelper.isArcEnabled(context.getContainingFile()) ? OCPropertySymbol.PropertySemantics.STRONG : OCPropertySymbol.PropertySemantics.RETAIN;
        }
        return OCPropertySymbol.PropertySemantics.ASSIGN;
    }

    @Nullable
    public static OCPropertySymbol.PropertyAttribute parseAttribute(@NotNull String string) {
        if (string == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(10);
        }
        for (OCPropertySymbol.FlagAttribute flagAttribute : OCPropertySymbol.FlagAttribute.values()) {
            if (!string.equals(flagAttribute.getTokenName())) continue;
            return flagAttribute;
        }
        for (Enum enum_ : OCPropertySymbol.ValueAttribute.values()) {
            if (!string.equals(((OCPropertySymbol.ValueAttribute)enum_).getTokenName())) continue;
            return enum_;
        }
        return null;
    }

    @Override
    @NotNull
    public OCType getType() {
        OCType oCType = this.mySubstitution.substitute(this.myType);
        if (oCType == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(11);
        }
        return oCType;
    }

    @Override
    @NotNull
    public OCSymbolKind getKind() {
        OCSymbolKind oCSymbolKind = OCSymbolKind.PROPERTY;
        if (oCSymbolKind == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(12);
        }
        return oCSymbolKind;
    }

    @Override
    public boolean hasAttribute(@NotNull OCPropertySymbol.PropertyAttribute attribute) {
        if (attribute == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(13);
        }
        return this.myFlagAttributes != null && this.myFlagAttributes.contains(attribute) || this.myValueAttributes != null && this.myValueAttributes.containsKey(attribute);
    }

    @Override
    @Nullable
    public String getAttributeValue(@NotNull OCPropertySymbol.ValueAttribute attribute) {
        if (attribute == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(14);
        }
        return this.myValueAttributes != null ? this.myValueAttributes.get(attribute) : null;
    }

    @NotNull
    public static OCPropertySymbol.FlagAttribute getAttributeOfGroup(@NotNull OCPropertySymbol self, @NotNull OCPropertySymbol.FlagAttribute defaultAttribute, @NotNull OCType type, @NotNull PsiElement context) {
        if (self == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(15);
        }
        if (defaultAttribute == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(16);
        }
        if (type == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(17);
        }
        if (context == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(18);
        }
        OCPropertySymbol.PropertyAttribute.Group group = defaultAttribute.getGroup();
        for (OCPropertySymbol.FlagAttribute attr : OCPropertySymbol.FlagAttribute.values()) {
            if (attr.getGroup() != group || !self.hasAttribute(attr)) continue;
            OCPropertySymbol.FlagAttribute flagAttribute = attr;
            if (flagAttribute == null) {
                OCPropertySymbolImpl.$$$reportNull$$$0(19);
            }
            return flagAttribute;
        }
        if (group == OCPropertySymbol.PropertyAttribute.Group.ARC) {
            if (type.isPointerToObjectCompatible() && OCCompilerFeaturesHelper.isArcEnabled(context.getContainingFile())) {
                OCPropertySymbol.FlagAttribute flagAttribute = OCPropertySymbol.FlagAttribute.STRONG;
                if (flagAttribute == null) {
                    OCPropertySymbolImpl.$$$reportNull$$$0(20);
                }
                return flagAttribute;
            }
            OCPropertySymbol.FlagAttribute flagAttribute = OCPropertySymbol.FlagAttribute.ASSIGN;
            if (flagAttribute == null) {
                OCPropertySymbolImpl.$$$reportNull$$$0(21);
            }
            return flagAttribute;
        }
        OCPropertySymbol.FlagAttribute flagAttribute = defaultAttribute;
        if (flagAttribute == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(22);
        }
        return flagAttribute;
    }

    @Override
    @Nullable
    public Icon getBaseIcon() {
        return OCIcons.getPropertyIcon(this.isStatic(), this.isOptional());
    }

    @Override
    public boolean isOptional() {
        return this.myOptional;
    }

    @Override
    @NotNull
    public OCTypeSubstitution getSubstitution() {
        OCTypeSubstitution oCTypeSubstitution = this.mySubstitution;
        if (oCTypeSubstitution == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(23);
        }
        return oCTypeSubstitution;
    }

    public static boolean processAccessorMethods(@NotNull OCPropertySymbol self, @NotNull Processor<? super OCMethodSymbol> processor2, boolean searchSubclasses, @NotNull Project project) {
        if (self == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(24);
        }
        if (processor2 == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(25);
        }
        if (project == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(26);
        }
        OCCommonProcessors.OrderedProcessor<? super OCMethodSymbol> methodProcessor = new OCCommonProcessors.OrderedProcessor<OCMethodSymbol>(processor2, methodSymbol -> methodSymbol.isGetter(OCResolveContext.forSymbol(self, project)), Conditions.alwaysTrue());
        self.getParent().processMembers(null, OCMethodSymbol.class, symbol -> {
            if (symbol.getGeneratedFromProperty() == self) {
                if (searchSubclasses) {
                    return OCSearchUtil.processMembersHierarchy(symbol, symbol1 -> {
                        if (symbol1.getGeneratedFromProperty() == null) {
                            return methodProcessor.process((OCMethodSymbol)symbol1);
                        }
                        return true;
                    }, false, true, project);
                }
                OCMethodSymbol methAssociate = symbol.getAssociatedSymbol(project);
                if (methAssociate != null) {
                    return methodProcessor.process(methAssociate);
                }
                return true;
            }
            return true;
        });
        return methodProcessor.finish();
    }

    public static boolean processSynthesizes(@NotNull OCPropertySymbol self, @NotNull Processor<? super OCSynthesizeSymbol> processor2, @NotNull Project project) {
        OCImplementationSymbol implementation;
        if (self == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(27);
        }
        if (processor2 == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(28);
        }
        if (project == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(29);
        }
        if ((implementation = self.getParent().getImplementation(project)) == null) {
            return false;
        }
        return implementation.processMembers(OCSynthesizeSymbol.class, symbol -> !self.getName().equals(symbol.getName()) || processor2.process(symbol));
    }

    @Nullable
    public static OCInstanceVariableSymbol getAssociatedIvar(@NotNull OCPropertySymbol self, @NotNull Project project) {
        if (self == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(30);
        }
        if (project == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(31);
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        self.processSynthesizes((Processor<? super OCSynthesizeSymbol>)finder, project);
        if (!finder.isFound()) {
            if (OCCompilerFeaturesHelper.supportsAutosynthesis(self.getContainingPsiFile(project))) {
                String ivarName = OCNameSuggester.getClang4ImplicitIvarName(self.getName());
                CommonProcessors.FindFirstProcessor ivarFinder = new CommonProcessors.FindFirstProcessor();
                OCCommonProcessors.OrderedProcessor orderedProcessor = new OCCommonProcessors.OrderedProcessor(ivarFinder, (Condition<? super T>[])new Condition[]{symbol -> !symbol.isClang4ImplicitIvar(project), Conditions.alwaysTrue()});
                self.getParent().processMembersInAllCategories(ivarName, OCInstanceVariableSymbol.class, orderedProcessor, false, project);
                orderedProcessor.finish();
                return (OCInstanceVariableSymbol)ivarFinder.getFoundValue();
            }
            return null;
        }
        return ((OCSynthesizeSymbol)finder.getFoundValue()).getIvarSymbol(project);
    }

    public static boolean hasAllAccessorsImplemented(final @NotNull OCPropertySymbol self, final boolean treatSynthesizeAsAccessors, @NotNull Project project) {
        OCImplementationSymbol implementation;
        if (self == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(32);
        }
        if (project == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(33);
        }
        if ((implementation = self.getParent().getImplementation(project)) == null) {
            return false;
        }
        final String getter = self.getGetterName();
        final String setter = self.getSetterName();
        final OCResolveContext context = OCResolveContext.forSymbol(self, project);
        return !implementation.processMembers(null, (Processor)new Processor<OCMemberSymbol>(){
            boolean wasGetter;
            boolean wasSetter;

            public boolean process(OCMemberSymbol symbol) {
                if (treatSynthesizeAsAccessors && symbol instanceof OCSynthesizeSymbol && self.getName().equals(symbol.getName())) {
                    return false;
                }
                if (symbol instanceof OCMethodSymbol) {
                    if (getter.equals(symbol.getName()) && ((OCMethodSymbol)symbol).isGetter(context)) {
                        this.wasGetter = true;
                    }
                    if (setter.equals(symbol.getName()) && ((OCMethodSymbol)symbol).isSetter(context)) {
                        this.wasSetter = true;
                    }
                    return !this.wasGetter || !self.isReadonly() && !this.wasSetter;
                }
                return true;
            }
        });
    }

    @Nullable
    public static OCPropertySymbol getAssociatedPropertyInPrivateCategory(@NotNull OCPropertySymbol self, @NotNull Project project) {
        OCClassSymbol parent;
        if (self == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(34);
        }
        if (project == null) {
            OCPropertySymbolImpl.$$$reportNull$$$0(35);
        }
        if ("".equals((parent = self.getParent()).getCategoryName())) {
            return null;
        }
        CommonProcessors.FindFirstProcessor finder = new CommonProcessors.FindFirstProcessor();
        parent.processMembers("", self.getName(), OCPropertySymbol.class, finder, true, project);
        return (OCPropertySymbol)finder.getFoundValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 19, 20, 21, 22, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "origin";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitution";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 15: 
            case 24: 
            case 27: 
            case 30: 
            case 32: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultAttribute";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 25: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 26: 
            case 29: 
            case 31: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/symbols/objc/OCPropertySymbolImpl";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getKind";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributeOfGroup";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getSubstitution";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithSubstitution";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parseAttribute";
                break;
            }
            case 11: 
            case 12: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "hasAttribute";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeOfGroup";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processAccessorMethods";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processSynthesizes";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedIvar";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "hasAllAccessorsImplemented";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "getAssociatedPropertyInPrivateCategory";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 19, 20, 21, 22, 23 -> new IllegalStateException(string);
        };
    }
}

