/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable;

import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCRootKind;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.symtable.ContextSignature;
import com.jetbrains.cidr.lang.symbols.symtable.DumbOnlyContextSignature;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCContextSignatureBuilder
implements OCInclusionContext.SignatureBuilder {
    public static final int START_TEMP_CAPACITY = 512;
    private final Set<String> myDefined;
    private final Set<String> myNotDefined;
    private final List<String> myPendingDefined;
    private final List<String> myPendingNotDefined;
    private final Map<String, Integer> myDefinitions;
    private final List<String> myPendingDefinitions;
    private final IntList myPendingDefinitionHashes;
    @Nullable
    public final OCLanguageKind languageKind;
    @NotNull
    private final List<String> myNamespace;
    @NotNull
    private final OCRootKind myRootKind;
    private boolean myInConformMode;
    @Nullable
    private String myHeaderGuard;
    private boolean myHeaderGuardDefined;
    private boolean myIsDumbPlaceholder;
    private boolean myPendingIsDumbPlaceholder;

    public OCContextSignatureBuilder(@Nullable OCLanguageKind kind, @NotNull List<String> namespace, @NotNull OCRootKind rootKind) {
        if (namespace == null) {
            OCContextSignatureBuilder.$$$reportNull$$$0(0);
        }
        if (rootKind == null) {
            OCContextSignatureBuilder.$$$reportNull$$$0(1);
        }
        this.myDefined = new HashSet<String>();
        this.myNotDefined = new HashSet<String>();
        this.myPendingDefined = new ArrayList<String>(512);
        this.myPendingNotDefined = new ArrayList<String>(512);
        this.myDefinitions = new HashMap<String, Integer>();
        this.myPendingDefinitions = new ArrayList<String>(512);
        this.myPendingDefinitionHashes = new IntArrayList(512);
        this.languageKind = kind;
        this.myNamespace = namespace;
        this.myRootKind = rootKind;
    }

    @Override
    public void setDefined(@NotNull String name, boolean isDefined) {
        if (name == null) {
            OCContextSignatureBuilder.$$$reportNull$$$0(2);
        }
        if (this.myInConformMode) {
            if (isDefined) {
                this.myPendingDefined.add(name);
            } else {
                this.myPendingNotDefined.add(name);
            }
        } else if (isDefined) {
            this.myDefined.add(name);
        } else {
            this.myNotDefined.add(name);
        }
    }

    @Override
    public void setHeaderGuardDefined(@NotNull String guard, boolean defined) {
        if (guard == null) {
            OCContextSignatureBuilder.$$$reportNull$$$0(3);
        }
        assert (this.myHeaderGuard == null || this.myHeaderGuard.equals(guard) && this.myHeaderGuardDefined == defined);
        this.myHeaderGuard = guard;
        this.myHeaderGuardDefined = defined;
    }

    @Override
    public void setDefinition(@NotNull String name, @NotNull OCMacroSymbol result) {
        if (name == null) {
            OCContextSignatureBuilder.$$$reportNull$$$0(4);
        }
        if (result == null) {
            OCContextSignatureBuilder.$$$reportNull$$$0(5);
        }
        int substHash = result.getSubstitutionHash();
        if (this.myInConformMode) {
            this.myPendingDefinitions.add(name);
            this.myPendingDefinitionHashes.add(substHash);
        } else {
            this.myDefinitions.put(name, substHash);
        }
    }

    @Override
    public void setIsDumbPlaceholder() {
        if (this.myInConformMode) {
            this.myPendingIsDumbPlaceholder = true;
        } else {
            this.myIsDumbPlaceholder = true;
        }
    }

    @Override
    public void enterConformanceCheckMode() {
        this.resetPendingDefinitions();
        this.myInConformMode = true;
    }

    @Override
    public void exitConformanceCheckMode(boolean commit) {
        if (commit) {
            this.myDefined.addAll(this.myPendingDefined);
            this.myNotDefined.addAll(this.myPendingNotDefined);
            for (int i = 0; i < this.myPendingDefinitions.size(); ++i) {
                this.myDefinitions.put(this.myPendingDefinitions.get(i), this.myPendingDefinitionHashes.getInt(i));
            }
            this.myIsDumbPlaceholder |= this.myPendingIsDumbPlaceholder;
        }
        this.resetPendingDefinitions();
        this.myInConformMode = false;
    }

    private void resetPendingDefinitions() {
        this.myPendingDefined.clear();
        this.myPendingNotDefined.clear();
        this.myPendingDefinitions.clear();
        this.myPendingDefinitionHashes.clear();
        this.myPendingIsDumbPlaceholder = false;
    }

    @NotNull
    public ContextSignature build() {
        for (String d : this.myDefined) {
            if (this.myDefinitions.containsKey(d)) continue;
            this.myDefinitions.put(d, null);
        }
        this.myDefined.clear();
        return this.myIsDumbPlaceholder ? new DumbOnlyContextSignature(this.languageKind, this.myDefinitions, this.myNotDefined, this.myNamespace, this.myRootKind, this.myHeaderGuard, this.myHeaderGuardDefined) : new ContextSignature(this.languageKind, this.myDefinitions, this.myNotDefined, this.myNamespace, this.myRootKind, this.myHeaderGuard, this.myHeaderGuardDefined);
    }

    public void setNonDumb() {
        this.myIsDumbPlaceholder = false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootKind";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "guard";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/OCContextSignatureBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setDefined";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "setHeaderGuardDefined";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setDefinition";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

