/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.symbols.symtable.building;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.HashSetQueue;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCImportGraph;
import com.jetbrains.cidr.lang.preprocessor.OCRootKind;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTableCacheListener;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTablesCache;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCBuildingActivityProgressIndicator;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolLoadedNotifier;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuilder;
import com.jetbrains.cidr.lang.symbols.symtable.building.OCSymbolTableBuildingUtil;
import com.jetbrains.cidr.lang.symbols.symtable.building.SymbolBuildingTask;
import com.jetbrains.cidr.lang.symbols.symtable.building.SymbolTableUpdateMode;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSymbolTableUpdater {
    @NotNull
    private final Object myLock;
    @NotNull
    private final Project myProject;
    @NotNull
    private final UpdateQueue myRootQueue;
    @NotNull
    private final UpdateQueue myIncludeQueue;
    @NotNull
    private final AtomicBoolean myHugeUpdateRequested;
    @NotNull
    private final AtomicInteger myLastNotificationId;
    private final @NotNull ThreadLocal<@Nullable UpdateQueue> myParentQueue;
    @NotNull
    private final CachedValue<Boolean> myQueueUpdater;

    public FileSymbolTableUpdater(@NotNull Project project) {
        if (project == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(0);
        }
        this.myLock = new Object();
        this.myRootQueue = new UpdateQueue();
        this.myIncludeQueue = new UpdateQueue();
        this.myHugeUpdateRequested = new AtomicBoolean();
        this.myLastNotificationId = new AtomicInteger();
        this.myParentQueue = new ThreadLocal();
        this.myProject = project;
        this.myQueueUpdater = CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            OCWorkspaceModificationTrackers trackers = OCWorkspace.getInstance((Project)this.myProject).getModificationTrackers();
            return new CachedValueProvider.Result((Object)this.rebuildQueues(), new Object[]{trackers.getResolveConfigurationsTracker(), trackers.getSourceFilesTracker(), trackers.getCompilerSettingsTracker()});
        }, false);
    }

    public void ensurePendingFilesProcessed(@NotNull SymbolTableUpdateMode updateMode) {
        ProgressManager pm;
        ProgressIndicator ci;
        if (updateMode == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(1);
        }
        if ((ci = (pm = ProgressManager.getInstance()).getProgressIndicator()) == null) {
            EmptyProgressIndicator ind = new EmptyProgressIndicator();
            pm.runProcess(() -> this.update(updateMode), (ProgressIndicator)ind);
        } else {
            this.update(updateMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(@NotNull SymbolTableUpdateMode updateMode) {
        ProgressIndicator indicator;
        if (updateMode == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(2);
        }
        OCLog.LOG.assertTrue((indicator = ProgressManager.getInstance().getProgressIndicator()) != null, (Object)"no progress indicator");
        UpdateQueue parentQueue = this.myParentQueue.get();
        if (parentQueue == this.myRootQueue) {
            throw new IllegalStateException("Nested updates are not allowed for root files.");
        }
        if (parentQueue != null && updateMode == SymbolTableUpdateMode.AllFiles) {
            throw new IllegalStateException("Nested update may not process included files.");
        }
        ProgressManager.checkCanceled();
        boolean isDispatchThread = ApplicationManager.getApplication().isDispatchThread();
        int updatedCount = 0;
        while (true) {
            VirtualFile file = null;
            UpdateQueue queue = null;
            Object object = this.myLock;
            synchronized (object) {
                while (file == null) {
                    ProgressManager.checkCanceled();
                    this.myQueueUpdater.getValue();
                    if (isDispatchThread && updateMode == SymbolTableUpdateMode.AllFiles && this.tryHugeUpdate()) {
                        return;
                    }
                    if (!this.hasFilesToUpdate(updateMode)) {
                        if (updateMode == SymbolTableUpdateMode.AllFiles && updatedCount > 0) {
                            this.notifyOnUpToDate();
                        }
                        return;
                    }
                    file = this.myRootQueue.startProcessingNext();
                    queue = this.myRootQueue;
                    if (file == null && updateMode == SymbolTableUpdateMode.AllFiles) {
                        file = this.myIncludeQueue.startProcessingNext();
                        queue = this.myIncludeQueue;
                    }
                    if (file != null) continue;
                    try {
                        this.myLock.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            boolean ok = false;
            this.myParentQueue.set(queue);
            try {
                ProgressManager.checkCanceled();
                FileSymbolTableUpdater.updateTables(file, this.myProject, queue == this.myRootQueue ? OCRootKind.Root : OCRootKind.Include);
                ok = true;
                ++updatedCount;
                continue;
            }
            finally {
                this.myParentQueue.set(parentQueue);
                Object object2 = this.myLock;
                synchronized (object2) {
                    queue.finishProcessing(file, ok);
                    this.myLock.notifyAll();
                }
                continue;
            }
            break;
        }
    }

    private boolean hasFilesToUpdate(@NotNull SymbolTableUpdateMode updateMode) {
        if (updateMode == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(3);
        }
        return this.myRootQueue.hasUnprocessedFiles() || updateMode == SymbolTableUpdateMode.AllFiles && this.myIncludeQueue.hasUnprocessedFiles();
    }

    private void notifyInvalidated() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ((FileSymbolTableCacheListener)this.myProject.getMessageBus().syncPublisher(FileSymbolTableCacheListener.TOPIC)).onSymbolsInvalidated();
    }

    private void notifyOnUpToDate() {
        int notificationId = this.myLastNotificationId.incrementAndGet();
        Runnable n = () -> {
            Object object = this.myLock;
            synchronized (object) {
                if (this.myLastNotificationId.get() == notificationId && !this.myProject.isDisposed() && FileSymbolTablesCache.areSymbolsLoaded(this.myProject) && this.isUpToDate()) {
                    ((FileSymbolTableCacheListener)this.myProject.getMessageBus().syncPublisher(FileSymbolTableCacheListener.TOPIC)).onSymbolsUpToDate();
                }
            }
        };
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            n.run();
        } else {
            app.invokeLater(n);
        }
    }

    public boolean isUpToDate() {
        return this.isUpToDate(SymbolTableUpdateMode.AllFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUpToDate(@NotNull SymbolTableUpdateMode updateMode) {
        if (updateMode == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(4);
        }
        Object object = this.myLock;
        synchronized (object) {
            return !this.hasFilesToUpdate(updateMode);
        }
    }

    private boolean rebuildQueues() {
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myRootQueue.approximateSize() + this.myIncludeQueue.approximateSize());
        files.addAll(this.myRootQueue.removeAllFilesToUpdate());
        files.addAll(this.myIncludeQueue.removeAllFilesToUpdate());
        for (VirtualFile file : files) {
            this.addFileInner(file);
        }
        return true;
    }

    private static void updateTables(@NotNull VirtualFile file, @NotNull Project project, @NotNull OCRootKind rootKind) {
        if (file == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(5);
        }
        if (project == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(6);
        }
        if (rootKind == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(7);
        }
        FileSymbolTablesCache cache = FileSymbolTablesCache.getInstance(project);
        if (rootKind == OCRootKind.Include && cache.allTablesForFileCount(file) > 0) {
            return;
        }
        ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
        OCImportGraph importGraph = OCImportGraph.getInstance(project);
        for (OCResolveConfiguration config : OCResolveConfigurations.getAllBuildConfigurationsForIndexing((VirtualFile)file, (Project)project)) {
            importGraph.buildSymbolAndRootHeaderCache(config, file, rootKind, pi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileForUpdate(@NotNull VirtualFile file) {
        if (file == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(8);
        }
        Object object = this.myLock;
        synchronized (object) {
            boolean wasUpToDate = this.isUpToDate();
            this.addFileInner(file);
            if (wasUpToDate && !this.isUpToDate()) {
                this.notifyInvalidated();
            }
            this.myLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Contract(value="_, true -> !null")
    public @Nullable List<@NotNull VirtualFile> addFilesForUpdate(@NotNull @NotNull Collection<@NotNull ? extends VirtualFile> files, boolean clearCaches) {
        if (files == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(9);
        }
        Object object = this.myLock;
        synchronized (object) {
            List<VirtualFile> clearedFiles = clearCaches ? FileSymbolTablesCache.getInstance(this.myProject).removeFilesFromCache(files) : null;
            boolean wasUpToDate = this.isUpToDate();
            for (VirtualFile virtualFile : files) {
                this.addFileInner(virtualFile);
            }
            if (wasUpToDate && !this.isUpToDate()) {
                this.notifyInvalidated();
            }
            this.myLock.notifyAll();
            return clearedFiles;
        }
    }

    private void addFileInner(@NotNull VirtualFile file) {
        if (file == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(10);
        }
        if (!file.isValid()) {
            return;
        }
        switch (OCRootKind.getRootKind(file, this.myProject)) {
            case Root: {
                this.myRootQueue.add(file);
                break;
            }
            case Include: {
                this.myIncludeQueue.add(file);
            }
        }
    }

    private boolean tryHugeUpdate() {
        int fileScore = this.myRootQueue.approximateSize();
        if (fileScore < 20) {
            return false;
        }
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>(this.myRootQueue.removeAllFilesToUpdate());
        this.myHugeUpdateRequested.set(false);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (this.myHugeUpdateRequested.getAndSet(true)) {
                return;
            }
            this.buildSymbolsForFiles(files);
        }, ModalityState.nonModal());
        return true;
    }

    private void buildSymbolsForFiles(@NotNull Collection<VirtualFile> files) {
        if (files == null) {
            FileSymbolTableUpdater.$$$reportNull$$$0(11);
        }
        if (!FileSymbolTablesCache.shouldBuildTables()) {
            return;
        }
        SymbolBuildingTask.scheduleSymbolActivity("buildSymbolsForFiles", this.myProject, indicator -> {
            OCSymbolTableBuildingUtil.invokeAndWaitSafely((ProgressIndicator)indicator, () -> {
                if (this.myProject.isDisposed() || indicator.isCanceled()) {
                    return;
                }
                FileSymbolTablesCache fileSymbolTablesCache = FileSymbolTablesCache.getInstance(this.myProject);
                fileSymbolTablesCache.notifySymbolsUnloaded();
                fileSymbolTablesCache.reparseCachedPsiFiles();
            });
            indicator.checkCanceled();
            OCSymbolTableBuilder builder = new OCSymbolTableBuilder(this.myProject, (OCBuildingActivityProgressIndicator)((Object)indicator), files, OCRootKind.Root);
            builder.processBuildFiles(indicator.getFraction(), 1.0);
            OCSymbolLoadedNotifier.notifySymbolsAreLoadedAndReparseCachedFiles(this.myProject, indicator);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updateMode";
                break;
            }
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootKind";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/symbols/symtable/building/FileSymbolTableUpdater";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "ensurePendingFilesProcessed";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "hasFilesToUpdate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isUpToDate";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "updateTables";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileForUpdate";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "addFilesForUpdate";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "addFileInner";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "buildSymbolsForFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class UpdateQueue {
        private final HashSetQueue<VirtualFile> myFilesToUpdate = new HashSetQueue();
        private int myFilesInProgressCount;

        private UpdateQueue() {
        }

        public void add(VirtualFile file) {
            this.myFilesToUpdate.add((Object)file);
        }

        public VirtualFile startProcessingNext() {
            VirtualFile file = this.getFirstValid(true);
            if (file == null) {
                return null;
            }
            ++this.myFilesInProgressCount;
            return file;
        }

        public boolean hasUnprocessedFiles() {
            return this.myFilesInProgressCount > 0 || this.getFirstValid(false) != null;
        }

        @Nullable
        private VirtualFile getFirstValid(boolean remove) {
            VirtualFile first;
            while ((first = (VirtualFile)this.myFilesToUpdate.peek()) != null && !first.isValid()) {
                this.myFilesToUpdate.poll();
            }
            if (remove && first != null) {
                this.myFilesToUpdate.poll();
            }
            return first;
        }

        public void finishProcessing(VirtualFile file, boolean isProcessed) {
            --this.myFilesInProgressCount;
            if (!isProcessed) {
                this.myFilesToUpdate.add((Object)file);
            }
        }

        public Collection<VirtualFile> removeAllFilesToUpdate() {
            VirtualFile file;
            ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(this.myFilesToUpdate.size());
            while ((file = this.getFirstValid(true)) != null) {
                result.add(file);
            }
            return result;
        }

        public int approximateSize() {
            return this.myFilesToUpdate.size();
        }
    }
}

