/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.types;

import com.google.common.primitives.UnsignedBytes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.Predicate;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.symbols.DeepEqual;
import com.jetbrains.cidr.lang.symbols.OCCompilationContext;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.CVQualifiers;
import com.jetbrains.cidr.lang.types.OCArrayType;
import com.jetbrains.cidr.lang.types.OCBlockPointerType;
import com.jetbrains.cidr.lang.types.OCCppReferenceType;
import com.jetbrains.cidr.lang.types.OCIntType;
import com.jetbrains.cidr.lang.types.OCNullability;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCRealType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCTollFreeBridges;
import com.jetbrains.cidr.lang.types.OCTypeArgument;
import com.jetbrains.cidr.lang.types.OCTypeCheckResult;
import com.jetbrains.cidr.lang.types.OCTypeCheckState;
import com.jetbrains.cidr.lang.types.OCTypeOwner;
import com.jetbrains.cidr.lang.types.OCTypeUtils;
import com.jetbrains.cidr.lang.types.OCUnknownType;
import com.jetbrains.cidr.lang.types.OCVoidType;
import com.jetbrains.cidr.lang.types.visitors.OCSizeofCalculatorVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCloneVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeCompatibilityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityAfterResolvingVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeEqualityVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeResolveVisitor;
import com.jetbrains.cidr.lang.types.visitors.OCTypeVisitor;
import com.jetbrains.cidr.lang.types.visitors.names.OCDumbTypeNameVisitor;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitor;
import com.jetbrains.cidr.lang.types.visitors.names.OCTypeNameVisitorBase;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerFeaturesHelper;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCType
implements OCTypeArgument {
    @Nullable
    @NonNls
    protected String myAliasName;
    @Nullable
    private OCType myGuessedType;
    protected byte myTypeAttributes;
    private static final Pattern requiresNilAttributePattern = Pattern.compile("sentinel.*");

    public OCType() {
    }

    public OCType(boolean isConst, boolean isVolatile) {
        this.myTypeAttributes = (byte)((isConst ? Attribute.IS_CONST.flag : (byte)0) | (isVolatile ? Attribute.IS_VOLATILE.flag : (byte)0));
    }

    public OCType(boolean isConst, boolean isVolatile, @Nullable OCNullability nullability) {
        this(isConst, isVolatile);
        this.attachNullability(nullability);
    }

    public void compact() {
    }

    public void attachAliasName(@NonNls @Nullable String aliasName) {
        this.myAliasName = aliasName;
    }

    public void attachGuessedType(@Nullable OCType guessedType) {
        this.myGuessedType = guessedType;
    }

    @Contract(pure=true)
    protected static byte clearAttribute(byte mask, @NotNull Attribute attribute) {
        if (attribute == null) {
            OCType.$$$reportNull$$$0(0);
        }
        return (byte)(mask & ~attribute.flag);
    }

    @Contract(pure=true)
    protected static byte attachAttribute(byte mask, @NotNull Attribute attribute) {
        if (attribute == null) {
            OCType.$$$reportNull$$$0(1);
        }
        return (byte)(mask | attribute.flag);
    }

    @Contract(pure=true)
    protected final boolean checkAttribute(@NotNull Attribute attribute) {
        if (attribute == null) {
            OCType.$$$reportNull$$$0(2);
        }
        return (this.myTypeAttributes & attribute.flag) == attribute.flag;
    }

    public void attachNullability(@Nullable OCNullability nullability) {
        byte newAttribute = this.myTypeAttributes;
        newAttribute = OCType.clearAttribute(newAttribute, Attribute.IS_NONNULL);
        newAttribute = OCType.clearAttribute(newAttribute, Attribute.IS_NULLABLE);
        newAttribute = OCType.clearAttribute(newAttribute, Attribute.IS_NULL_UNSPECIFIED);
        newAttribute = OCType.clearAttribute(newAttribute, Attribute.IS_NULLABLE_RESULT);
        if (nullability == OCNullability.NONNULL) {
            newAttribute = OCType.attachAttribute(newAttribute, Attribute.IS_NONNULL);
        } else if (nullability == OCNullability.NULLABLE) {
            newAttribute = OCType.attachAttribute(newAttribute, Attribute.IS_NULLABLE);
        } else if (nullability == OCNullability.UNSPECIFIED) {
            newAttribute = OCType.attachAttribute(newAttribute, Attribute.IS_NULL_UNSPECIFIED);
        } else if (nullability == OCNullability.NULLABLE_RESULT) {
            newAttribute = OCType.attachAttribute(newAttribute, Attribute.IS_NULLABLE_RESULT);
        }
        this.myTypeAttributes = newAttribute;
    }

    @NotNull
    @NlsSafe
    public String getName() {
        String string = this.getShortName(0);
        if (string == null) {
            OCType.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public String getShortName(int templateDepth) {
        return new OCDumbTypeNameVisitor(templateDepth, null).getName(this);
    }

    @NotNull
    public String getName(@NotNull PsiElement context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(4);
        }
        String string = this.getName(OCResolveContext.forPsi(context));
        if (string == null) {
            OCType.$$$reportNull$$$0(5);
        }
        return string;
    }

    @NotNull
    @NlsSafe
    public String getName(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(6);
        }
        String name = this.getBestNameInContext(context, null, 0);
        String nonAliasName = this.cloneWithAliasName(null).getBestNameInContext(context, null, 0);
        String string = this.isBetterAliasName(this, nonAliasName, name, context) ? nonAliasName : name;
        if (string == null) {
            OCType.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NlsSafe
    public String getBestNameInContext(@NotNull PsiElement context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(8);
        }
        return this.getName(context);
    }

    @NlsSafe
    public String getBestNameInContext(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(9);
        }
        return this.getName(context);
    }

    @NlsSafe
    public String getBestNameInContext(@NotNull PsiElement context, @Nullable String nameHint) {
        if (context == null) {
            OCType.$$$reportNull$$$0(10);
        }
        return this.getBestNameInContext(OCResolveContext.forPsi(context), nameHint, 0);
    }

    @NlsSafe
    public String getBestNameInContext(@NotNull OCResolveContext context, @Nullable String nameHint) {
        if (context == null) {
            OCType.$$$reportNull$$$0(11);
        }
        return this.getBestNameInContext(context, nameHint, 0);
    }

    @NlsSafe
    protected String getBestNameInContext(@NotNull OCResolveContext context, @Nullable String nameHint, int templateDepth) {
        if (context == null) {
            OCType.$$$reportNull$$$0(12);
        }
        if (nameHint != null && this.equalsAfterResolving(nameHint, context)) {
            return nameHint;
        }
        return new OCTypeNameVisitor(Presentation.BEST, true, true, context, templateDepth).getName(this.resolve(context));
    }

    @NotNull
    @NlsSafe
    public String getCanonicalName(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(13);
        }
        String string = new OCTypeNameVisitor(Presentation.FULL, false, true, context, 0).getName(this);
        if (string == null) {
            OCType.$$$reportNull$$$0(14);
        }
        return string;
    }

    @Override
    @NlsSafe
    public String getNameForPresentation(Presentation presentation, @NotNull OCResolveContext context, boolean includeGlobalQualifier, int templateDepth) {
        if (context == null) {
            OCType.$$$reportNull$$$0(15);
        }
        if (presentation == Presentation.BEST) {
            return this.getBestNameInContext(context, null, templateDepth);
        }
        return new OCTypeNameVisitor(Presentation.FULL, false, includeGlobalQualifier, context, templateDepth).getName(this);
    }

    @Nullable
    @NlsSafe
    public String getAliasName() {
        return this.myAliasName;
    }

    public boolean isBetterAliasName(OCType candidateType, String candidateName, String bestAliasName, @Nullable OCResolveContext context) {
        if (candidateName != null && bestAliasName != null && candidateName.length() > bestAliasName.length() && candidateName.startsWith(bestAliasName) && candidateName.charAt(bestAliasName.length()) == '<') {
            return true;
        }
        if (context != null && candidateName != null && (bestAliasName == null || OCType.getNameComplexity(bestAliasName) > OCType.getNameComplexity(candidateName))) {
            OCType thisType = this;
            if (thisType instanceof OCCppReferenceType) {
                thisType = ((OCCppReferenceType)thisType).getRefType();
            }
            if (candidateType instanceof OCCppReferenceType) {
                candidateType = ((OCCppReferenceType)candidateType).getRefType();
            }
            return thisType.equals(candidateType, context);
        }
        return false;
    }

    protected static int getNameComplexity(String name) {
        int complexity = 0;
        for (int i = 0; i < name.length(); ++i) {
            char symbol = name.charAt(i);
            if (symbol != ':' && symbol != '<' && symbol != '>') continue;
            ++complexity;
        }
        return complexity;
    }

    @NotNull
    public OCType getGuessedType() {
        OCType oCType = this.myGuessedType != null ? this.myGuessedType : this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(16);
        }
        return oCType;
    }

    public boolean hasGuessedType() {
        return this.myGuessedType != null;
    }

    public boolean isConst() {
        return this.checkAttribute(Attribute.IS_CONST);
    }

    public boolean isVolatile() {
        return this.checkAttribute(Attribute.IS_VOLATILE);
    }

    @NotNull
    private String typeAttributesToString() {
        String string = Arrays.stream(Attribute.values()).filter(this::checkAttribute).map(Attribute::toString).collect(Collectors.joining(", "));
        if (string == null) {
            OCType.$$$reportNull$$$0(17);
        }
        return string;
    }

    @Nullable
    public OCNullability getNullability() {
        if (this.checkAttribute(Attribute.IS_NULLABLE)) {
            return OCNullability.NULLABLE;
        }
        if (this.checkAttribute(Attribute.IS_NONNULL)) {
            return OCNullability.NONNULL;
        }
        if (this.checkAttribute(Attribute.IS_NULL_UNSPECIFIED)) {
            return OCNullability.UNSPECIFIED;
        }
        if (this.checkAttribute(Attribute.IS_NULLABLE_RESULT)) {
            return OCNullability.NULLABLE_RESULT;
        }
        return null;
    }

    @NotNull
    public CVQualifiers getCVQualifiers() {
        CVQualifiers cVQualifiers = CVQualifiers.get(this.isConst(), this.isVolatile());
        if (cVQualifiers == null) {
            OCType.$$$reportNull$$$0(18);
        }
        return cVQualifiers;
    }

    @NotNull
    public OCType getGuessedUnmagicType() {
        OCType oCType = this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(19);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithCVQualifiers(@NotNull CVQualifiers modifiers, @Nullable Project project) {
        if (modifiers == null) {
            OCType.$$$reportNull$$$0(20);
        }
        if (this.getCVQualifiers() != modifiers) {
            OCType clone = this.getShallowCopy(true, modifiers.isConst(), modifiers.isVolatile());
            if (clone.myAliasName != null) {
                String aliasName = clone.myAliasName;
                aliasName = modifiers.isConst() ? OCTypeNameVisitorBase.addTypeQualifier(aliasName, clone, project, "const") : OCTypeNameVisitorBase.removeTypeQualifier(aliasName, clone, project, "const");
                aliasName = modifiers.isVolatile() ? OCTypeNameVisitorBase.addTypeQualifier(aliasName, clone, project, "volatile") : OCTypeNameVisitorBase.removeTypeQualifier(aliasName, clone, project, "volatile");
                clone.attachAliasName(aliasName);
            }
            OCType oCType = clone;
            if (oCType == null) {
                OCType.$$$reportNull$$$0(21);
            }
            return oCType;
        }
        OCType oCType = this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(22);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithoutCVQualifiers(@Nullable Project project) {
        OCType oCType = this.cloneWithCVQualifiers(CVQualifiers.EMPTY, project);
        if (oCType == null) {
            OCType.$$$reportNull$$$0(23);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithAddedCVQualifiers(@NotNull CVQualifiers modifiers, @Nullable Project project) {
        if (modifiers == null) {
            OCType.$$$reportNull$$$0(24);
        }
        OCType oCType = this.cloneWithCVQualifiers(this.getCVQualifiers().or(modifiers), project);
        if (oCType == null) {
            OCType.$$$reportNull$$$0(25);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithoutConstModifier(@Nullable Project project) {
        OCType oCType = this.cloneWithCVQualifiers(CVQualifiers.get(false, this.isVolatile()), project);
        if (oCType == null) {
            OCType.$$$reportNull$$$0(26);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithConstModifier(@Nullable Project project) {
        OCType oCType = this.cloneWithCVQualifiers(CVQualifiers.get(true, this.isVolatile()), project);
        if (oCType == null) {
            OCType.$$$reportNull$$$0(27);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithAliasName(String aliasName) {
        if (!Objects.equals(this.myAliasName, aliasName)) {
            OCType clone = this.getShallowCopy();
            clone.attachAliasName(aliasName);
            OCType oCType = clone;
            if (oCType == null) {
                OCType.$$$reportNull$$$0(28);
            }
            return oCType;
        }
        OCType oCType = this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(29);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithGuessedType(OCType guessedType) {
        if (this.myGuessedType != null || guessedType != null) {
            OCType clone = this.getShallowCopy(true, null, null);
            clone.attachGuessedType(guessedType);
            OCType oCType = clone;
            if (oCType == null) {
                OCType.$$$reportNull$$$0(30);
            }
            return oCType;
        }
        OCType oCType = this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(31);
        }
        return oCType;
    }

    @NotNull
    public OCType cloneWithNullability(@Nullable OCNullability nullability) {
        if (this.getNullability() != nullability) {
            OCType clone = this.getShallowCopy(true, null, null);
            clone.attachNullability(nullability);
            OCType oCType = clone;
            if (oCType == null) {
                OCType.$$$reportNull$$$0(32);
            }
            return oCType;
        }
        OCType oCType = this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(33);
        }
        return oCType;
    }

    protected OCType getShallowCopy() {
        return this.getShallowCopy(false, null, null);
    }

    private OCType getShallowCopy(boolean keepAliasName, Boolean forcedConst, Boolean forcedVolatile) {
        OCTypeCloneVisitor visitor = new OCTypeCloneVisitor(true, this, forcedConst, forcedVolatile);
        OCType clone = this.transformType(visitor);
        if (!keepAliasName) {
            clone.attachAliasName(null);
        }
        return clone;
    }

    @NotNull
    public OCType resolve(@NotNull PsiElement element) {
        if (element == null) {
            OCType.$$$reportNull$$$0(34);
        }
        OCType oCType = this.resolve(OCResolveContext.forPsi(element));
        if (oCType == null) {
            OCType.$$$reportNull$$$0(35);
        }
        return oCType;
    }

    @NotNull
    public OCType resolve(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(36);
        }
        OCType oCType = this.transformType(new OCTypeResolveVisitor(context));
        if (oCType == null) {
            OCType.$$$reportNull$$$0(37);
        }
        return oCType;
    }

    @NotNull
    public OCType resolve(@NotNull PsiElement context, boolean ignoringImports) {
        if (context == null) {
            OCType.$$$reportNull$$$0(38);
        }
        OCType oCType = this.transformType(new OCTypeResolveVisitor(OCResolveContext.forPsi(context), ignoringImports));
        if (oCType == null) {
            OCType.$$$reportNull$$$0(39);
        }
        return oCType;
    }

    @NotNull
    public OCType resolve(@NotNull OCResolveContext context, boolean ignoringImports) {
        if (context == null) {
            OCType.$$$reportNull$$$0(40);
        }
        OCType oCType = this.transformType(new OCTypeResolveVisitor(context, ignoringImports));
        if (oCType == null) {
            OCType.$$$reportNull$$$0(41);
        }
        return oCType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + (String)(this.myTypeAttributes != 0 ? this.typeAttributesToString() + " " : "") + this.getName() + "]";
    }

    @NotNull
    public OCType getTerminalType() {
        OCType oCType = this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(42);
        }
        return oCType;
    }

    @NotNull
    public OCType getArrayElementType() {
        OCType oCType = this;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(43);
        }
        return oCType;
    }

    public int pointersDepth() {
        return 0;
    }

    public boolean isVoid() {
        return false;
    }

    public boolean isUnknown() {
        return false;
    }

    public final boolean isUnresolved(@NotNull PsiElement context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(44);
        }
        return this.isUnresolved(OCResolveContext.forPsi(context));
    }

    public boolean isUnresolved(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(45);
        }
        return false;
    }

    public boolean isMagicInside(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(46);
        }
        return false;
    }

    public boolean isSubclassOfMagic(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(47);
        }
        return false;
    }

    public boolean isScalar() {
        return false;
    }

    public boolean isChar() {
        return false;
    }

    public boolean isScalarOrConvertibleToScalar(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(48);
        }
        if (this.isScalar()) {
            return true;
        }
        if (!this.isCppStructType(context)) {
            return false;
        }
        if (this.isIntConvertible(context) || OCIntType.BOOL_NATIVE.isConvertibleByOperator(this, context, true)) {
            return true;
        }
        if (this.isPointerConvertible(context)) {
            return true;
        }
        return this.isEnumOrEnumConvertible(context);
    }

    public boolean isInstanceable() {
        return false;
    }

    public boolean isPointerCompatible(@NotNull OCResolveContext context, boolean checkCppConvertible) {
        if (context == null) {
            OCType.$$$reportNull$$$0(49);
        }
        return !context.isCpp() && this.isIntegerCompatible(context) || checkCppConvertible && this.isCppStructType(context) && this.isPointerConvertible(context);
    }

    public boolean isPointerCompatible(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(50);
        }
        return this.isPointerCompatible(context, true);
    }

    public boolean isPointerToString() {
        return "NSString *".equals(this.getName());
    }

    public boolean isPointerToStringCompatible() {
        return this.isPointerToStringCompatible(false);
    }

    public boolean isPointerToStringCompatible(boolean includeMutable) {
        return "NSString *".equals(this.getName()) || "NSString *".equals(OCTollFreeBridges.getNSCounterpart(this.getName())) || includeMutable && ("NSMutableString *".equals(this.getName()) || "NSMutableString *".equals(OCTollFreeBridges.getNSCounterpart(this.getName())));
    }

    public boolean isObjCRootType() {
        String name = this.getName();
        return "id".equals(name) || "NSObject *".equals(name);
    }

    public boolean isEnumOrEnumConvertible(@NotNull OCResolveContext context) {
        OCType oCType;
        if (context == null) {
            OCType.$$$reportNull$$$0(51);
        }
        if (!((oCType = this) instanceof OCStructType)) {
            return false;
        }
        OCStructType that = (OCStructType)oCType;
        if (that.isEnum()) {
            return true;
        }
        Pair<OCType, OCFunctionSymbol> convertedRes = OCTypeCompatibilityVisitor.convertByOperator(that, false, true, context, (Predicate<OCType>)((Predicate)type -> OCTypeUtils.isEnumType(type)));
        return convertedRes != null;
    }

    private boolean isPointerConvertible(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(52);
        }
        return OCPointerType.to(OCVoidType.instance()).isConvertibleByOperator(this, context, false);
    }

    private boolean isIntConvertible(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(53);
        }
        return OCIntType.INT.isConvertibleByOperator(this, context, false);
    }

    public boolean isNumberCompatible(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(54);
        }
        return this.isCppStructType(context) && OCRealType.DOUBLE.isConvertibleByOperator(this, context, false);
    }

    public boolean isIntegerCompatible(@NotNull OCResolveContext context, boolean checkCppConvertible) {
        if (context == null) {
            OCType.$$$reportNull$$$0(55);
        }
        return checkCppConvertible && this.isCppStructType(context) && this.isIntConvertible(context);
    }

    public boolean isIntegerCompatible(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(56);
        }
        return this.isIntegerCompatible(context, true);
    }

    public boolean isPointerToObject() {
        return false;
    }

    public boolean isPointerToObjectCompatible() {
        return this.isPointerToObject() || this.isClassType() || this instanceof OCBlockPointerType;
    }

    public boolean isPointerToPointerToObjectCompatible() {
        return this.isPointerToObjectCompatible() || this instanceof OCPointerType && ((OCPointerType)this).getRefType().isPointerToPointerToObjectCompatible();
    }

    public boolean isPointerToID(boolean withProtocols) {
        return false;
    }

    public boolean isPointerToID() {
        return this.isPointerToID(false);
    }

    public boolean isPointerToChar() {
        return false;
    }

    public boolean isCString() {
        return false;
    }

    public boolean isPointer() {
        return false;
    }

    public boolean isPointerToVoid() {
        return false;
    }

    public boolean isClassType(boolean withProtocols) {
        if (this instanceof OCPointerType) {
            OCType refType = ((OCPointerType)this).getRefType();
            String name = refType.getName();
            return (name.equals("struct objc_class") || name.equals("objc_class")) && (!withProtocols || refType instanceof OCObjectType && !((OCObjectType)refType).getAugmentedProtocols().isEmpty());
        }
        return false;
    }

    public boolean isClassType() {
        return this.isClassType(false);
    }

    public boolean isCppStructType(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(57);
        }
        return false;
    }

    public boolean isPointerToCppStructType(@NotNull OCCompilationContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(58);
        }
        return false;
    }

    @Override
    public boolean isVariadic() {
        return false;
    }

    @NotNull
    public String getDefaultValue(@NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(59);
        }
        if (this.isPointerToObject()) {
            return "nil";
        }
        if (OCCompilerFeaturesHelper.supportsNullptr(context.getFile())) {
            return "nullptr";
        }
        return "NULL";
    }

    public final int getSizeInBytes(@Nullable PsiFile file, @Nullable OCInclusionContext context, @NotNull Project project) {
        if (project == null) {
            OCType.$$$reportNull$$$0(60);
        }
        return new OCSizeofCalculatorVisitor(file, context, project).calculate(this);
    }

    public OCType transformType(OCTypeVisitor<OCType> visitor) {
        OCType result = this.accept(visitor);
        if (result == null) {
            return null;
        }
        if (this.myAliasName != null) {
            result = result.cloneWithAliasName(this.myAliasName);
        }
        if (this.myGuessedType != null) {
            result = result.cloneWithGuessedType(this.myGuessedType);
        }
        if (this.getNullability() != null) {
            result = result.cloneWithNullability(this.getNullability());
        }
        return result;
    }

    public abstract <T> T accept(OCTypeVisitor<T> var1);

    public boolean deepEqualStep(@NotNull DeepEqual.Comparator c, @NotNull Object first, @NotNull Object second) {
        if (c == null) {
            OCType.$$$reportNull$$$0(61);
        }
        if (first == null) {
            OCType.$$$reportNull$$$0(62);
        }
        if (second == null) {
            OCType.$$$reportNull$$$0(63);
        }
        OCType f = (OCType)first;
        OCType s = (OCType)second;
        if (f.myTypeAttributes != s.myTypeAttributes) {
            return false;
        }
        if (!Objects.equals(f.myAliasName, s.myAliasName)) {
            return false;
        }
        return c.equalObjects(f.myGuessedType, s.myGuessedType);
    }

    public final boolean equals(Object o) {
        throw new UnsupportedOperationException("Use equals(Object o, @NotNull OCResolveContext context) instead");
    }

    @Override
    public boolean equals(Object o, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(64);
        }
        return this.equals(o, true, context);
    }

    public boolean equals(Object o, boolean checkCV, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(65);
        }
        return this.equals(o, checkCV, false, context);
    }

    public boolean equals(Object o, boolean checkCV, boolean checkArrayDecay, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(66);
        }
        return o instanceof OCType && new OCTypeEqualityVisitor((OCType)o, false, !checkCV, checkArrayDecay, context).equal(this);
    }

    protected int baseHashCode() {
        int result = this.myAliasName != null ? this.myAliasName.hashCode() : 0;
        result = 31 * result + (this.myGuessedType != null ? this.myGuessedType.hashCode() : 0);
        result = 31 * result + this.myTypeAttributes;
        return result;
    }

    public int hashCode() {
        OCLog.LOG.warn("An attempt to get hashCode for OCType base class!");
        return 0;
    }

    public boolean equalsAfterResolving(String typeName, @NotNull OCResolveContext context) {
        PsiElement element;
        if (context == null) {
            OCType.$$$reportNull$$$0(67);
        }
        return (element = context.getElement()) != null && this.equalsAfterResolving(OCElementUtil.getType(OCElementFactory.typeCodeFragment(typeName, element)), context, true);
    }

    public boolean equalsAfterResolving(OCType type, @NotNull OCResolveContext context, boolean magicTypeEquals) {
        if (context == null) {
            OCType.$$$reportNull$$$0(68);
        }
        OCType thisType = this;
        if (type == null) {
            return false;
        }
        if (thisType instanceof OCCppReferenceType) {
            thisType = ((OCCppReferenceType)thisType).getRefType();
        }
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        return new OCTypeEqualityAfterResolvingVisitor(type, false, magicTypeEquals, true, true, context).equal(thisType);
    }

    public boolean equalsAfterResolving(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(69);
        }
        return new OCTypeEqualityAfterResolvingVisitor(type, false, context).equal(this);
    }

    public boolean equalsWithAliasName(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(70);
        }
        String thisAliasName = this.getAliasName();
        String typeAliasName = type.getAliasName();
        if (thisAliasName == null) {
            thisAliasName = this.getCanonicalName(context);
        }
        if (typeAliasName == null) {
            typeAliasName = type.getCanonicalName(context);
        }
        return Objects.equals(thisAliasName, typeAliasName) && this.equalsAfterResolving(type, context);
    }

    @Deprecated
    @NotNull
    public OCType getLeastCommonType(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(71);
        }
        if (type == null) {
            OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
            if (oCUnknownType == null) {
                OCType.$$$reportNull$$$0(72);
            }
            return oCUnknownType;
        }
        OCType result = this.doGetLeastCommonType(type, context);
        result = result.cloneWithAddedCVQualifiers(this.getCVQualifiers().or(type.getCVQualifiers()), context.getProject());
        OCType oCType = result = OCType.updateWithCommonGuessedType(this, type, result, context);
        if (oCType == null) {
            OCType.$$$reportNull$$$0(73);
        }
        return oCType;
    }

    @NotNull
    public static OCType updateWithCommonGuessedType(OCType type1, OCType type2, OCType result, @NotNull OCResolveContext context) {
        OCType commonGuessedType;
        if (context == null) {
            OCType.$$$reportNull$$$0(74);
        }
        if (!(type1.myGuessedType == null || type2.myGuessedType == null || (commonGuessedType = type1.myGuessedType.doGetLeastCommonType(type2.myGuessedType, context)).isUnknown() || !result.isPointerToID() && commonGuessedType.isCompatible(result, context))) {
            OCType oCType = result.cloneWithGuessedType(commonGuessedType);
            if (oCType == null) {
                OCType.$$$reportNull$$$0(75);
            }
            return oCType;
        }
        OCType oCType = result;
        if (oCType == null) {
            OCType.$$$reportNull$$$0(76);
        }
        return oCType;
    }

    @NotNull
    protected OCType doGetLeastCommonType(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(77);
        }
        OCUnknownType oCUnknownType = OCUnknownType.INSTANCE;
        if (oCUnknownType == null) {
            OCType.$$$reportNull$$$0(78);
        }
        return oCUnknownType;
    }

    @NotNull
    public OCTypeCheckResult checkCompatible(OCType type, @Nullable OCTypeOwner expression, @Nullable PsiElement context, @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            OCType.$$$reportNull$$$0(79);
        }
        OCTypeCheckResult oCTypeCheckResult = this.checkCompatible(type, expression, context, true, resolveContext);
        if (oCTypeCheckResult == null) {
            OCType.$$$reportNull$$$0(80);
        }
        return oCTypeCheckResult;
    }

    @NotNull
    public OCTypeCheckResult checkCompatible(OCType type, @Nullable OCTypeOwner expression, @Nullable PsiElement context, boolean allowImplicitConversions, @NotNull OCResolveContext resolveContext) {
        if (resolveContext == null) {
            OCType.$$$reportNull$$$0(81);
        }
        OCTypeCheckResult oCTypeCheckResult = OCTypeCompatibilityVisitor.checkConvertible(this, type, expression, context, allowImplicitConversions, allowImplicitConversions, resolveContext);
        if (oCTypeCheckResult == null) {
            OCType.$$$reportNull$$$0(82);
        }
        return oCTypeCheckResult;
    }

    public boolean isConvertibleByOperator(OCType type, @NotNull OCResolveContext context, boolean isExplicitCast) {
        if (context == null) {
            OCType.$$$reportNull$$$0(83);
        }
        if (type instanceof OCCppReferenceType) {
            type = ((OCCppReferenceType)type).getRefType();
        }
        if (type instanceof OCStructType) {
            OCTypeCheckResult error = new OCTypeCheckResult(OCTypeCheckState.ERROR);
            PsiElement element = context.getElement();
            return !OCTypeCompatibilityVisitor.checkConversionOperators(this, (OCStructType)type, null, element, error, isExplicitCast, context).getState().isError(element);
        }
        return false;
    }

    public boolean isCompatible(OCType type, @NotNull OCResolveContext context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(84);
        }
        return this.checkCompatible(type, null, context.getElement(), true, context).getState() == OCTypeCheckState.OK;
    }

    public boolean isSuperType(OCType type, @NotNull PsiElement context) {
        if (context == null) {
            OCType.$$$reportNull$$$0(85);
        }
        OCResolveContext resolveContext = OCResolveContext.forPsi(context);
        OCType self = this.resolve(resolveContext);
        type = type.resolve(resolveContext);
        if (self.isPointerToObject() && type.isPointerToObject()) {
            return self.isCompatible(type, resolveContext);
        }
        if (self.isCppStructType(resolveContext) && type.isCppStructType(resolveContext)) {
            return OCTypeUtils.isSameOrDerivedFrom(type, self, resolveContext) && this.getCVQualifiers() == type.getCVQualifiers();
        }
        if (type instanceof OCArrayType && this instanceof OCPointerType) {
            OCType refType = ((OCPointerType)this).getRefType().resolve(resolveContext);
            OCType typeRefType = ((OCArrayType)type).getRefType().resolve(resolveContext);
            if (refType.isPointerToID() && typeRefType.isPointerToID()) {
                return true;
            }
        }
        return self.equalsAfterResolving(type, resolveContext);
    }

    @Nullable
    @NonNls
    public String getFormatString() {
        return null;
    }

    public static boolean isFunctionRequiringNil(OCSymbol callable) {
        for (String attribute : callable.getAttributes()) {
            Matcher matcher = requiresNilAttributePattern.matcher(attribute);
            if (!matcher.matches()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 7, 14, 16, 17, 18, 19, 21, 22, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 35, 37, 39, 41, 42, 43, 72, 73, 75, 76, 78, 80, 82 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attribute";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/types/OCType";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 36: 
            case 38: 
            case 40: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 74: 
            case 77: 
            case 83: 
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 20: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifiers";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 63: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 79: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/types/OCType";
                break;
            }
            case 3: 
            case 5: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalName";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getGuessedType";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "typeAttributesToString";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCVQualifiers";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getGuessedUnmagicType";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithCVQualifiers";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithoutCVQualifiers";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithAddedCVQualifiers";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithoutConstModifier";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithConstModifier";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithAliasName";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithGuessedType";
                break;
            }
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "cloneWithNullability";
                break;
            }
            case 35: 
            case 37: 
            case 39: 
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getTerminalType";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getArrayElementType";
                break;
            }
            case 72: 
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeastCommonType";
                break;
            }
            case 75: 
            case 76: {
                objectArray = objectArray2;
                objectArray2[1] = "updateWithCommonGuessedType";
                break;
            }
            case 78: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetLeastCommonType";
                break;
            }
            case 80: 
            case 82: {
                objectArray = objectArray2;
                objectArray2[1] = "checkCompatible";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "clearAttribute";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "attachAttribute";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "checkAttribute";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 72: 
            case 73: 
            case 75: 
            case 76: 
            case 78: 
            case 80: 
            case 82: {
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getBestNameInContext";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getCanonicalName";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getNameForPresentation";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithCVQualifiers";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithAddedCVQualifiers";
                break;
            }
            case 34: 
            case 36: 
            case 38: 
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "resolve";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "isUnresolved";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "isMagicInside";
                break;
            }
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "isSubclassOfMagic";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "isScalarOrConvertibleToScalar";
                break;
            }
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "isPointerCompatible";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "isEnumOrEnumConvertible";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "isPointerConvertible";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "isIntConvertible";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "isNumberCompatible";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "isIntegerCompatible";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "isCppStructType";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "isPointerToCppStructType";
                break;
            }
            case 59: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValue";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "getSizeInBytes";
                break;
            }
            case 61: 
            case 62: 
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "deepEqualStep";
                break;
            }
            case 64: 
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "equals";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "equalsAfterResolving";
                break;
            }
            case 70: {
                objectArray = objectArray;
                objectArray[2] = "equalsWithAliasName";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "getLeastCommonType";
                break;
            }
            case 74: {
                objectArray = objectArray;
                objectArray[2] = "updateWithCommonGuessedType";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "doGetLeastCommonType";
                break;
            }
            case 79: 
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "checkCompatible";
                break;
            }
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "isConvertibleByOperator";
                break;
            }
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "isSuperType";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 7, 14, 16, 17, 18, 19, 21, 22, 23, 25, 26, 27, 28, 29, 30, 31, 32, 33, 35, 37, 39, 41, 42, 43, 72, 73, 75, 76, 78, 80, 82 -> new IllegalStateException(string);
        };
    }

    protected static enum Attribute {
        IS_CONST,
        IS_VOLATILE,
        IS_NULLABLE,
        IS_NONNULL,
        IS_NULL_UNSPECIFIED,
        IS_NULLABLE_RESULT,
        IS_FUNCTION_LVALUE_REF,
        IS_FUNCTION_RVALUE_REF;

        final byte flag = UnsignedBytes.checkedCast((long)(1 << this.ordinal()));

        @NotNull
        public String toString() {
            String string = this.name().substring(3).replace('_', ' ').toLowerCase(Locale.ROOT);
            if (string == null) {
                Attribute.$$$reportNull$$$0(0);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/cidr/lang/types/OCType$Attribute", "toString"));
        }
    }

    public static enum Presentation {
        FULL,
        BEST;

    }
}

