/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.cidr.cpp.lexer.OCLexer;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.openapi.vfs.newvfs.AttributeInputStream;
import com.intellij.openapi.vfs.newvfs.AttributeOutputStream;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.lexer.OCLexerSettings;
import com.jetbrains.cidr.lang.parser.OCLexerTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCFileActiveConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCFileUtil;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.preprocessor.OCResolveRootAndConfigurationCache;
import com.jetbrains.cidr.lang.preprocessor.OCRootKind;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCPsiFile;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import java.io.IOException;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCLanguageKindCalculator {
    private static final Key<Pair<Long, Boolean>> LOOKS_LIKE_OBJC_KEY = new Key("LOOKS_LIKE_OBJC_KEY");
    private static final FileAttribute LOOKS_LIKE_OBJC_ATTRIBUTE = new FileAttribute("LOOKS_LIKE_OBJC_ATTRIBUTE", 1, true);
    private static final TokenSet OBJC_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{TokenSet.create((IElementType[])new IElementType[]{OCLexerTokenTypes.AT, OCLexerTokenTypes.IMPORT_DIRECTIVE}), OCLexerTokenTypes.OBJC_KEYWORDS_NO_AT, OCLexerTokenTypes.ARC_TYPE_QUALIFIERS});

    @NotNull
    public static OCLanguageKind calculateLanguageKindFast(@NotNull PsiFile file) {
        if (file == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(0);
        }
        Project project = file.getProject();
        VirtualFile virtualFile = OCFileUtil.getVirtualFile(file);
        if (OCInclusionContextUtil.isLongLived(virtualFile)) {
            return OCLanguageKindCalculator.calculateLanguageKindFast(virtualFile, project);
        }
        String name = file.getName();
        OCLanguageKind result = OCLanguageKindCalculator.tryFileExtension(project, name);
        if (result != null) {
            OCLanguageKind oCLanguageKind = result;
            if (oCLanguageKind == null) {
                OCLanguageKindCalculator.$$$reportNull$$$0(1);
            }
            return oCLanguageKind;
        }
        CLanguageKind cLanguageKind = CLanguageKind.maxLanguage();
        if (cLanguageKind == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(2);
        }
        return cLanguageKind;
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKindFast(@NotNull VirtualFile virtualFile, @NotNull Project project) {
        if (virtualFile == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(3);
        }
        if (project == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(4);
        }
        return OCLanguageKindCalculator.calculateLanguageKind(null, virtualFile, project, false);
    }

    @Nullable
    public static OCLanguageKind tryFileTypeAndExtension(@Nullable Project project, @Nullable VirtualFile file) {
        return OCLanguageKindCalculatorBase.tryFileTypeAndExtension((Project)project, (VirtualFile)file);
    }

    @Nullable
    public static OCLanguageKind calculateMinimalKindByExtension(@Nullable Project project, @NotNull String name) {
        if (name == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(5);
        }
        return OCLanguageKindCalculatorBase.calculateMinimalKindByExtension((Project)project, (String)name);
    }

    @Nullable
    private static OCLanguageKind tryFileExtension(@Nullable Project project, @NotNull String name) {
        if (name == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(6);
        }
        return OCLanguageKindCalculatorBase.tryFileExtension((Project)project, (String)name);
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@NotNull OCPsiFile file) {
        if (file == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(7);
        }
        return OCLanguageKindCalculator.calculateLanguageKind(OCFileActiveConfigurationCache.getActiveConfiguration((PsiElement)file), file, true);
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@Nullable OCResolveConfiguration configuration, @NotNull OCPsiFile file, boolean tryFromRoot) {
        if (file == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(8);
        }
        if (file instanceof OCCodeFragment) {
            PsiFile containingFile;
            PsiElement context;
            OCPsiFile curFile = file;
            while ((context = file.getContext()) != null && (containingFile = context.getContainingFile()) != null && !curFile.equals(containingFile)) {
                if (containingFile instanceof OCCodeFragment) {
                    curFile = (OCCodeFragment)containingFile;
                    continue;
                }
                OCLanguageKind kind = OCPsiFile.getKind(containingFile);
                if (kind == null) break;
                OCLanguageKind oCLanguageKind = kind;
                if (oCLanguageKind == null) {
                    OCLanguageKindCalculator.$$$reportNull$$$0(9);
                }
                return oCLanguageKind;
            }
        }
        Project project = file.getProject();
        VirtualFile virtualFile = OCFileUtil.getVirtualFile(file);
        if (!OCInclusionContextUtil.isLongLived(virtualFile)) {
            String name = file.getName();
            OCLanguageKind result = OCLanguageKindCalculator.tryFileExtension(project, name);
            if (result != null) {
                OCLanguageKind oCLanguageKind = result;
                if (oCLanguageKind == null) {
                    OCLanguageKindCalculator.$$$reportNull$$$0(10);
                }
                return oCLanguageKind;
            }
            CLanguageKind cLanguageKind = CLanguageKind.maxLanguage();
            if (cLanguageKind == null) {
                OCLanguageKindCalculator.$$$reportNull$$$0(11);
            }
            return cLanguageKind;
        }
        return OCLanguageKindCalculator.calculateLanguageKind(configuration, virtualFile, project, tryFromRoot);
    }

    @NotNull
    public static OCLanguageKind calculateLanguageKind(@Nullable OCResolveConfiguration activeConfig, @NotNull VirtualFile file, @NotNull Project project, boolean tryFromRoot) {
        OCLanguageKind result;
        if (file == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(12);
        }
        if (project == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(13);
        }
        if (activeConfig != null && (result = activeConfig.getDeclaredLanguageKind(file)) != null) {
            OCLanguageKind oCLanguageKind = result;
            if (oCLanguageKind == null) {
                OCLanguageKindCalculator.$$$reportNull$$$0(14);
            }
            return oCLanguageKind;
        }
        result = OCLanguageKindCalculator.tryFileTypeAndExtension(project, file);
        if (result != null) {
            OCLanguageKind oCLanguageKind = result;
            if (oCLanguageKind == null) {
                OCLanguageKindCalculator.$$$reportNull$$$0(15);
            }
            return oCLanguageKind;
        }
        if (tryFromRoot && OCRootKind.getRootKind(file, project) == OCRootKind.Include) {
            OCResolveRootAndConfiguration rootAndConfiguration = OCResolveRootAndConfigurationCache.getInstance(project).getResolveRootAndActiveConfiguration(file);
            VirtualFile rootFile = rootAndConfiguration.getRootFile();
            OCResolveConfiguration rootConfig = rootAndConfiguration.getConfiguration();
            if (rootFile != null && rootConfig != null && !rootFile.equals(file)) {
                result = OCLanguageKindCalculator.tryLanguageKindFromPchRoot(rootConfig, file, rootFile);
                if (result != null) {
                    OCLanguageKind oCLanguageKind = result;
                    if (oCLanguageKind == null) {
                        OCLanguageKindCalculator.$$$reportNull$$$0(16);
                    }
                    return oCLanguageKind;
                }
                return OCLanguageKindCalculator.calculateLanguageKind(rootConfig, rootFile, project, false);
            }
        }
        Set enabledLanguageKinds = activeConfig != null ? activeConfig.getEnabledLanguageKinds() : null;
        boolean isObjC = OCLanguageKindCalculator.looksLikeObjC(file);
        OCLanguageKind oCLanguageKind = OCLanguageKindCalculatorBase.findLanguageKind((Set)enabledLanguageKinds, (String)file.getName(), (boolean)isObjC);
        if (oCLanguageKind == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(17);
        }
        return oCLanguageKind;
    }

    @Nullable
    public static OCLanguageKind tryLanguageKindFromPchRoot(@NotNull OCResolveConfiguration config, @NotNull VirtualFile header, @NotNull VirtualFile pchCandidate) {
        OCImmutableInclusionContext cachedContext;
        if (config == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(18);
        }
        if (header == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(19);
        }
        if (pchCandidate == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(20);
        }
        return (cachedContext = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(config, header, pchCandidate)) != null ? cachedContext.getLanguageKind() : null;
    }

    public static boolean looksLikeObjC(@NotNull VirtualFile file) {
        if (file == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(21);
        }
        if (file.getFileType().isBinary()) {
            return false;
        }
        long currentTimestamp = file.getModificationStamp();
        Pair info = (Pair)LOOKS_LIKE_OBJC_KEY.get((UserDataHolder)file);
        if (info != null && (Long)info.first == currentTimestamp) {
            return (Boolean)info.second;
        }
        if (info == null) {
            info = OCLanguageKindCalculator.readDetectionInfo(file);
        }
        if (info == null || (Long)info.first != currentTimestamp) {
            CharSequence text = LoadTextUtil.loadText((VirtualFile)file, (int)2048);
            boolean isObjC = OCLanguageKindCalculator.calcLooksLikeObjC(text);
            info = Pair.create((Object)currentTimestamp, (Object)isObjC);
            OCLanguageKindCalculator.writeDetectionInfo(file, (Pair<Long, Boolean>)info);
        }
        file.putUserData(LOOKS_LIKE_OBJC_KEY, info);
        return (Boolean)info.second;
    }

    public static void markAsObjC(@NotNull VirtualFile file) {
        if (file == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(22);
        }
        Pair info = Pair.create((Object)file.getModificationStamp(), (Object)true);
        file.putUserData(LOOKS_LIKE_OBJC_KEY, (Object)info);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Pair<Long, Boolean> readDetectionInfo(@NotNull VirtualFile file) {
        if (file == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(23);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return null;
        }
        try (AttributeInputStream in = LOOKS_LIKE_OBJC_ATTRIBUTE.readFileAttribute(file);){
            if (in == null) return null;
            long timestamp = in.readLong();
            boolean isObjC = in.readBoolean();
            Pair pair = Pair.create((Object)timestamp, (Object)isObjC);
            return pair;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private static void writeDetectionInfo(@NotNull VirtualFile file, @NotNull Pair<Long, Boolean> info) {
        if (file == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(24);
        }
        if (info == null) {
            OCLanguageKindCalculator.$$$reportNull$$$0(25);
        }
        if (!(file instanceof VirtualFileWithId)) {
            return;
        }
        try (AttributeOutputStream out = LOOKS_LIKE_OBJC_ATTRIBUTE.writeFileAttribute(file);){
            out.writeLong((Long)info.first);
            out.writeBoolean((Boolean)info.second);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean calcLooksLikeObjC(CharSequence text) {
        OCLexer lexer = new OCLexer(OCLexerSettings.forLanguage((OCLanguageKind)CLanguageKind.OBJ_CPP).build());
        lexer.start(text);
        while (lexer.getTokenType() != null) {
            IElementType tt = lexer.getTokenType();
            if (OBJC_TOKENS.contains(tt)) {
                return true;
            }
            lexer.advance();
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 9, 10, 11, 14, 15, 16, 17 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "header";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pchCandidate";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/workspace/OCLanguageKindCalculator";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateLanguageKindFast";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateLanguageKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calculateLanguageKindFast";
                break;
            }
            case 1: 
            case 2: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "calculateMinimalKindByExtension";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "tryFileExtension";
                break;
            }
            case 7: 
            case 8: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "calculateLanguageKind";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "tryLanguageKindFromPchRoot";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "looksLikeObjC";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "markAsObjC";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "readDetectionInfo";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "writeDetectionInfo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 9, 10, 11, 14, 15, 16, 17 -> new IllegalStateException(string);
        };
    }
}

