/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing;

public class TestName {
    private final String className;
    private final String methodName;

    public TestName(String className, String methodName) {
        this.className = className;
        this.methodName = methodName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String toString() {
        return this.className + "#" + this.methodName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TestName testName = (TestName)o;
        if (this.className != null ? !this.className.equals(testName.className) : testName.className != null) {
            return false;
        }
        return !(this.methodName != null ? !this.methodName.equals(testName.methodName) : testName.methodName != null);
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + (this.methodName != null ? this.methodName.hashCode() : 0);
        return result;
    }

    public String getDisplayName() {
        return this.className.substring(this.className.lastIndexOf(46) + 1) + "#" + this.methodName;
    }
}

