/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

public class GoogleCloudTestIdentifier {
    private final String mConfiguration;
    private final String mClassName;
    private final String mTestName;

    public GoogleCloudTestIdentifier(String configuration, String className, String testName) {
        if (configuration == null || configuration.isEmpty() || className == null || className.isEmpty() || testName == null || testName.isEmpty()) {
            throw new IllegalArgumentException("configuration, className, and testName must be non-empty!");
        }
        this.mConfiguration = configuration;
        this.mClassName = className;
        this.mTestName = testName;
    }

    public String getConfiguration() {
        return this.mConfiguration;
    }

    public String getClassName() {
        return this.mClassName;
    }

    public String getTestName() {
        return this.mTestName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mConfiguration == null ? 0 : this.mConfiguration.hashCode());
        result = 31 * result + (this.mClassName == null ? 0 : this.mClassName.hashCode());
        result = 31 * result + (this.mTestName == null ? 0 : this.mTestName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GoogleCloudTestIdentifier other = (GoogleCloudTestIdentifier)obj;
        if (this.mConfiguration == null ? other.mConfiguration != null : !this.mConfiguration.equals(other.mConfiguration)) {
            return false;
        }
        if (this.mClassName == null ? other.mClassName != null : !this.mClassName.equals(other.mClassName)) {
            return false;
        }
        return !(this.mTestName == null ? other.mTestName != null : !this.mTestName.equals(other.mTestName));
    }

    public String toString() {
        return String.format("%s#%s", this.getClassName(), this.getTestName());
    }
}

