/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testing.results;

import com.google.gct.testing.results.GoogleCloudTestNodeDescriptor;
import com.google.gct.testing.results.GoogleCloudTestProxy;
import com.google.gct.testing.results.GoogleCloudTestsPresentationUtil;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.ide.ui.UISettings;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.RelativeFont;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Shape;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GoogleCloudTestTreeRenderer
extends ColoredTreeCellRenderer {
    @NonNls
    private static final String SPACE_STRING = " ";
    private final TestConsoleProperties myConsoleProperties;
    private String myDurationText;
    private Color myDurationColor;
    private int myDurationWidth;
    private int myDurationOffset;

    public GoogleCloudTestTreeRenderer(TestConsoleProperties consoleProperties) {
        this.myConsoleProperties = consoleProperties;
    }

    public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        Object userObj = node.getUserObject();
        if (userObj instanceof GoogleCloudTestNodeDescriptor) {
            GoogleCloudTestNodeDescriptor desc = (GoogleCloudTestNodeDescriptor)((Object)userObj);
            GoogleCloudTestProxy testProxy = (GoogleCloudTestProxy)desc.getElement();
            if (testProxy instanceof GoogleCloudTestProxy.GoogleCloudRootTestProxy) {
                GoogleCloudTestProxy.GoogleCloudRootTestProxy rootTestProxy = (GoogleCloudTestProxy.GoogleCloudRootTestProxy)testProxy;
                if (rootTestProxy.isLeaf()) {
                    GoogleCloudTestsPresentationUtil.formatRootNodeWithoutChildren(rootTestProxy, this);
                } else {
                    GoogleCloudTestsPresentationUtil.formatRootNodeWithChildren(rootTestProxy, this);
                }
            } else {
                GoogleCloudTestsPresentationUtil.formatTestProxy(testProxy, this);
            }
            if (TestConsoleProperties.SHOW_INLINE_STATISTICS.value((AbstractProperty.AbstractPropertyContainer)this.myConsoleProperties)) {
                this.myDurationText = testProxy.getDurationString(this.myConsoleProperties);
                if (this.myDurationText != null) {
                    FontMetrics metrics = this.getFontMetrics(RelativeFont.SMALL.derive(this.getFont()));
                    this.myDurationWidth = metrics.stringWidth(this.myDurationText);
                    this.myDurationOffset = metrics.getHeight() / 2;
                    this.myDurationColor = selected ? UIUtil.getTreeSelectionForeground((boolean)hasFocus) : SimpleTextAttributes.GRAYED_ATTRIBUTES.getFgColor();
                }
            }
            return;
        }
        String text = node.toString();
        this.append(text != null ? text : SPACE_STRING, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }

    @NotNull
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        if (this.myDurationWidth > 0) {
            preferredSize.width += this.myDurationWidth + this.myDurationOffset;
        }
        return preferredSize;
    }

    public TestConsoleProperties getConsoleProperties() {
        return this.myConsoleProperties;
    }

    protected void paintComponent(Graphics g) {
        UISettings.setupAntialiasing((Graphics)g);
        Shape clip = null;
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.isOpaque()) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, width, height);
        }
        if (this.myDurationText != null && this.myDurationWidth > 0 && (width -= this.myDurationWidth + this.myDurationOffset) > 0 && height > 0) {
            g.setColor(this.myDurationColor);
            g.setFont(RelativeFont.SMALL.derive(this.getFont()));
            g.drawString(this.myDurationText, width + this.myDurationOffset / 2, GoogleCloudTestTreeRenderer.getTextBaseLine((FontMetrics)g.getFontMetrics(), (int)height));
            clip = g.getClip();
            g.clipRect(0, 0, width, height);
        }
        super.paintComponent(g);
        if (clip != null) {
            g.setClip(clip);
        }
    }
}

