/*
 * Decompiled with CFR 0.152.
 */
package aida.io.grpc.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class InUseStateAggregator<T> {
    private final Set<T> inUseObjects = Collections.newSetFromMap(new IdentityHashMap());

    public final void updateObjectInUse(T object, boolean inUse) {
        int origSize = this.inUseObjects.size();
        if (inUse) {
            this.inUseObjects.add(object);
            if (origSize == 0) {
                this.handleInUse();
            }
        } else {
            boolean removed = this.inUseObjects.remove(object);
            if (removed && origSize == 1) {
                this.handleNotInUse();
            }
        }
    }

    public final boolean isInUse() {
        return !this.inUseObjects.isEmpty();
    }

    public final boolean anyObjectInUse(Object ... objects) {
        for (Object object : objects) {
            if (!this.inUseObjects.contains(object)) continue;
            return true;
        }
        return false;
    }

    protected abstract void handleInUse();

    protected abstract void handleNotInUse();
}

