/*
 * Decompiled with CFR 0.152.
 */
package aida.io.grpc.internal;

import aida.io.grpc.Attributes;
import aida.io.grpc.ConnectivityState;
import aida.io.grpc.ConnectivityStateInfo;
import aida.io.grpc.EquivalentAddressGroup;
import aida.io.grpc.LoadBalancer;
import aida.io.grpc.Status;
import aida.io.grpc.SynchronizationContext;
import aida.io.grpc.internal.BackoffPolicy;
import aida.io.grpc.internal.ExponentialBackoffPolicy;
import aida.io.grpc.internal.GrpcUtil;
import aida.io.grpc.internal.PickFirstLoadBalancerProvider;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

final class PickFirstLeafLoadBalancer
extends LoadBalancer {
    private static final Logger log = Logger.getLogger(PickFirstLeafLoadBalancer.class.getName());
    @VisibleForTesting
    static final int CONNECTION_DELAY_INTERVAL_MS = 250;
    private final LoadBalancer.Helper helper;
    private final Map<SocketAddress, SubchannelData> subchannels = new HashMap<SocketAddress, SubchannelData>();
    private final Index addressIndex = new Index((List<EquivalentAddressGroup>)ImmutableList.of());
    private int numTf = 0;
    private boolean firstPass = true;
    @Nullable
    private SynchronizationContext.ScheduledHandle scheduleConnectionTask = null;
    private ConnectivityState rawConnectivityState = ConnectivityState.IDLE;
    private ConnectivityState concludedState = ConnectivityState.IDLE;
    private final boolean enableHappyEyeballs = !PickFirstLeafLoadBalancer.isSerializingRetries() && PickFirstLoadBalancerProvider.isEnabledHappyEyeballs();
    private boolean notAPetiolePolicy = true;
    private final BackoffPolicy.Provider bkoffPolProvider = new ExponentialBackoffPolicy.Provider();
    private BackoffPolicy reconnectPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle reconnectTask = null;
    private final boolean serializingRetries = PickFirstLeafLoadBalancer.isSerializingRetries();

    PickFirstLeafLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
    }

    static boolean isSerializingRetries() {
        return GrpcUtil.getFlag("GRPC_SERIALIZE_RETRIES", false);
    }

    @Override
    public Status acceptResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        if (this.rawConnectivityState == ConnectivityState.SHUTDOWN) {
            return Status.FAILED_PRECONDITION.withDescription("Already shut down");
        }
        Boolean isPetiolePolicy = (Boolean)resolvedAddresses.getAttributes().get(IS_PETIOLE_POLICY);
        this.notAPetiolePolicy = isPetiolePolicy == null || isPetiolePolicy == false;
        List<EquivalentAddressGroup> servers = resolvedAddresses.getAddresses();
        if (servers.isEmpty()) {
            Status unavailableStatus = Status.UNAVAILABLE.withDescription("NameResolver returned no usable address. addrs=" + resolvedAddresses.getAddresses() + ", attrs=" + resolvedAddresses.getAttributes());
            this.handleNameResolutionError(unavailableStatus);
            return unavailableStatus;
        }
        for (EquivalentAddressGroup eag : servers) {
            if (eag != null) continue;
            Status unavailableStatus = Status.UNAVAILABLE.withDescription("NameResolver returned address list with null endpoint. addrs=" + resolvedAddresses.getAddresses() + ", attrs=" + resolvedAddresses.getAttributes());
            this.handleNameResolutionError(unavailableStatus);
            return unavailableStatus;
        }
        this.firstPass = true;
        List<EquivalentAddressGroup> cleanServers = PickFirstLeafLoadBalancer.deDupAddresses(servers);
        if (resolvedAddresses.getLoadBalancingPolicyConfig() instanceof PickFirstLeafLoadBalancerConfig) {
            PickFirstLeafLoadBalancerConfig config = (PickFirstLeafLoadBalancerConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
            if (config.shuffleAddressList != null && config.shuffleAddressList.booleanValue()) {
                Collections.shuffle(cleanServers, config.randomSeed != null ? new Random(config.randomSeed) : new Random());
            }
        }
        ImmutableList newImmutableAddressGroups = ImmutableList.builder().addAll(cleanServers).build();
        if (this.rawConnectivityState == ConnectivityState.READY) {
            SocketAddress previousAddress = this.addressIndex.getCurrentAddress();
            this.addressIndex.updateGroups((List<EquivalentAddressGroup>)newImmutableAddressGroups);
            if (this.addressIndex.seekTo(previousAddress)) {
                SubchannelData subchannelData = this.subchannels.get(previousAddress);
                subchannelData.getSubchannel().updateAddresses(this.addressIndex.getCurrentEagAsList());
                return Status.OK;
            }
        } else {
            this.addressIndex.updateGroups((List<EquivalentAddressGroup>)newImmutableAddressGroups);
        }
        HashSet<SocketAddress> oldAddrs = new HashSet<SocketAddress>(this.subchannels.keySet());
        HashSet<SocketAddress> newAddrs = new HashSet<SocketAddress>();
        for (EquivalentAddressGroup endpoint : newImmutableAddressGroups) {
            newAddrs.addAll(endpoint.getAddresses());
        }
        for (SocketAddress oldAddr : oldAddrs) {
            if (newAddrs.contains(oldAddr)) continue;
            this.subchannels.remove(oldAddr).getSubchannel().shutdown();
        }
        if (oldAddrs.size() == 0) {
            this.rawConnectivityState = ConnectivityState.CONNECTING;
            this.updateBalancingState(ConnectivityState.CONNECTING, new Picker(LoadBalancer.PickResult.withNoResult()));
        }
        if (this.rawConnectivityState == ConnectivityState.READY) {
            this.rawConnectivityState = ConnectivityState.IDLE;
            this.updateBalancingState(ConnectivityState.IDLE, new RequestConnectionPicker(this));
        } else if (this.rawConnectivityState == ConnectivityState.CONNECTING || this.rawConnectivityState == ConnectivityState.TRANSIENT_FAILURE) {
            this.cancelScheduleTask();
            this.requestConnection();
        }
        return Status.OK;
    }

    private static List<EquivalentAddressGroup> deDupAddresses(List<EquivalentAddressGroup> groups) {
        HashSet<SocketAddress> seenAddresses = new HashSet<SocketAddress>();
        ArrayList<EquivalentAddressGroup> newGroups = new ArrayList<EquivalentAddressGroup>();
        for (EquivalentAddressGroup group : groups) {
            ArrayList<SocketAddress> addrs = new ArrayList<SocketAddress>();
            for (SocketAddress addr : group.getAddresses()) {
                if (!seenAddresses.add(addr)) continue;
                addrs.add(addr);
            }
            if (addrs.isEmpty()) continue;
            newGroups.add(new EquivalentAddressGroup(addrs, group.getAttributes()));
        }
        return newGroups;
    }

    @Override
    public void handleNameResolutionError(Status error) {
        if (this.rawConnectivityState == ConnectivityState.SHUTDOWN) {
            return;
        }
        for (SubchannelData subchannelData : this.subchannels.values()) {
            subchannelData.getSubchannel().shutdown();
        }
        this.subchannels.clear();
        this.addressIndex.updateGroups((List<EquivalentAddressGroup>)ImmutableList.of());
        this.rawConnectivityState = ConnectivityState.TRANSIENT_FAILURE;
        this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new Picker(LoadBalancer.PickResult.withError(error)));
    }

    void processSubchannelState(SubchannelData subchannelData, ConnectivityStateInfo stateInfo) {
        ConnectivityState newState = stateInfo.getState();
        if (subchannelData != this.subchannels.get(this.getAddress(subchannelData.subchannel))) {
            return;
        }
        if (newState == ConnectivityState.SHUTDOWN) {
            return;
        }
        if (newState == ConnectivityState.IDLE && subchannelData.state == ConnectivityState.READY) {
            this.helper.refreshNameResolution();
        }
        subchannelData.updateState(newState);
        if (this.rawConnectivityState == ConnectivityState.TRANSIENT_FAILURE || this.concludedState == ConnectivityState.TRANSIENT_FAILURE) {
            if (newState == ConnectivityState.CONNECTING) {
                return;
            }
            if (newState == ConnectivityState.IDLE) {
                this.requestConnection();
                return;
            }
        }
        switch (newState) {
            case IDLE: {
                this.addressIndex.reset();
                this.rawConnectivityState = ConnectivityState.IDLE;
                this.updateBalancingState(ConnectivityState.IDLE, new RequestConnectionPicker(this));
                break;
            }
            case CONNECTING: {
                this.rawConnectivityState = ConnectivityState.CONNECTING;
                this.updateBalancingState(ConnectivityState.CONNECTING, new Picker(LoadBalancer.PickResult.withNoResult()));
                break;
            }
            case READY: {
                this.shutdownRemaining(subchannelData);
                this.addressIndex.seekTo(this.getAddress(subchannelData.subchannel));
                this.rawConnectivityState = ConnectivityState.READY;
                this.updateHealthCheckedState(subchannelData);
                break;
            }
            case TRANSIENT_FAILURE: {
                if (this.addressIndex.isValid() && this.subchannels.get(this.addressIndex.getCurrentAddress()) == subchannelData) {
                    if (this.addressIndex.increment()) {
                        this.cancelScheduleTask();
                        this.requestConnection();
                    } else {
                        this.scheduleBackoff();
                    }
                }
                if (!this.isPassComplete()) break;
                this.rawConnectivityState = ConnectivityState.TRANSIENT_FAILURE;
                this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new Picker(LoadBalancer.PickResult.withError(stateInfo.getStatus())));
                if (++this.numTf < this.addressIndex.size() && !this.firstPass) break;
                this.firstPass = false;
                this.numTf = 0;
                this.helper.refreshNameResolution();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported state:" + (Object)((Object)newState));
            }
        }
    }

    private void scheduleBackoff() {
        if (!this.serializingRetries) {
            return;
        }
        if (this.reconnectTask != null) {
            return;
        }
        if (this.reconnectPolicy == null) {
            this.reconnectPolicy = this.bkoffPolProvider.get();
        }
        long delayNanos = this.reconnectPolicy.nextBackoffNanos();
        class EndOfCurrentBackoff
        implements Runnable {
            EndOfCurrentBackoff() {
            }

            @Override
            public void run() {
                PickFirstLeafLoadBalancer.this.reconnectTask = null;
                PickFirstLeafLoadBalancer.this.addressIndex.reset();
                PickFirstLeafLoadBalancer.this.requestConnection();
            }
        }
        this.reconnectTask = this.helper.getSynchronizationContext().schedule(new EndOfCurrentBackoff(), delayNanos, TimeUnit.NANOSECONDS, this.helper.getScheduledExecutorService());
    }

    private void updateHealthCheckedState(SubchannelData subchannelData) {
        if (subchannelData.state != ConnectivityState.READY) {
            return;
        }
        if (this.notAPetiolePolicy || subchannelData.getHealthState() == ConnectivityState.READY) {
            this.updateBalancingState(ConnectivityState.READY, new LoadBalancer.FixedResultPicker(LoadBalancer.PickResult.withSubchannel(subchannelData.subchannel)));
        } else if (subchannelData.getHealthState() == ConnectivityState.TRANSIENT_FAILURE) {
            this.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new Picker(LoadBalancer.PickResult.withError(subchannelData.healthStateInfo.getStatus())));
        } else if (this.concludedState != ConnectivityState.TRANSIENT_FAILURE) {
            this.updateBalancingState(subchannelData.getHealthState(), new Picker(LoadBalancer.PickResult.withNoResult()));
        }
    }

    private void updateBalancingState(ConnectivityState state, LoadBalancer.SubchannelPicker picker) {
        if (state == this.concludedState && (state == ConnectivityState.IDLE || state == ConnectivityState.CONNECTING)) {
            return;
        }
        this.concludedState = state;
        this.helper.updateBalancingState(state, picker);
    }

    @Override
    public void shutdown() {
        log.log(Level.FINE, "Shutting down, currently have {} subchannels created", this.subchannels.size());
        this.rawConnectivityState = ConnectivityState.SHUTDOWN;
        this.concludedState = ConnectivityState.SHUTDOWN;
        this.cancelScheduleTask();
        if (this.reconnectTask != null) {
            this.reconnectTask.cancel();
            this.reconnectTask = null;
        }
        this.reconnectPolicy = null;
        for (SubchannelData subchannelData : this.subchannels.values()) {
            subchannelData.getSubchannel().shutdown();
        }
        this.subchannels.clear();
    }

    private void shutdownRemaining(SubchannelData activeSubchannelData) {
        if (this.reconnectTask != null) {
            this.reconnectTask.cancel();
            this.reconnectTask = null;
        }
        this.reconnectPolicy = null;
        this.cancelScheduleTask();
        for (SubchannelData subchannelData : this.subchannels.values()) {
            if (subchannelData.getSubchannel().equals(activeSubchannelData.subchannel)) continue;
            subchannelData.getSubchannel().shutdown();
        }
        this.subchannels.clear();
        activeSubchannelData.updateState(ConnectivityState.READY);
        this.subchannels.put(this.getAddress(activeSubchannelData.subchannel), activeSubchannelData);
    }

    @Override
    public void requestConnection() {
        if (!this.addressIndex.isValid() || this.rawConnectivityState == ConnectivityState.SHUTDOWN) {
            return;
        }
        SocketAddress currentAddress = this.addressIndex.getCurrentAddress();
        SubchannelData subchannelData = this.subchannels.get(currentAddress);
        if (subchannelData == null) {
            subchannelData = this.createNewSubchannel(currentAddress, this.addressIndex.getCurrentEagAttributes());
        }
        ConnectivityState subchannelState = subchannelData.getState();
        switch (subchannelState) {
            case IDLE: {
                subchannelData.subchannel.requestConnection();
                subchannelData.updateState(ConnectivityState.CONNECTING);
                this.scheduleNextConnection();
                break;
            }
            case CONNECTING: {
                this.scheduleNextConnection();
                break;
            }
            case TRANSIENT_FAILURE: {
                if (!this.serializingRetries) {
                    this.addressIndex.increment();
                    this.requestConnection();
                    break;
                }
                if (!this.addressIndex.isValid()) {
                    this.scheduleBackoff();
                    break;
                }
                subchannelData.subchannel.requestConnection();
                subchannelData.updateState(ConnectivityState.CONNECTING);
                break;
            }
        }
    }

    private void scheduleNextConnection() {
        if (!this.enableHappyEyeballs || this.scheduleConnectionTask != null && this.scheduleConnectionTask.isPending()) {
            return;
        }
        class StartNextConnection
        implements Runnable {
            StartNextConnection() {
            }

            @Override
            public void run() {
                PickFirstLeafLoadBalancer.this.scheduleConnectionTask = null;
                if (PickFirstLeafLoadBalancer.this.addressIndex.increment()) {
                    PickFirstLeafLoadBalancer.this.requestConnection();
                }
            }
        }
        this.scheduleConnectionTask = this.helper.getSynchronizationContext().schedule(new StartNextConnection(), 250L, TimeUnit.MILLISECONDS, this.helper.getScheduledExecutorService());
    }

    private void cancelScheduleTask() {
        if (this.scheduleConnectionTask != null) {
            this.scheduleConnectionTask.cancel();
            this.scheduleConnectionTask = null;
        }
    }

    private SubchannelData createNewSubchannel(SocketAddress addr, Attributes attrs) {
        HealthListener hcListener = new HealthListener();
        LoadBalancer.Subchannel subchannel = this.helper.createSubchannel(LoadBalancer.CreateSubchannelArgs.newBuilder().setAddresses(Lists.newArrayList((Object[])new EquivalentAddressGroup[]{new EquivalentAddressGroup(addr, attrs)})).addOption(HEALTH_CONSUMER_LISTENER_ARG_KEY, hcListener).addOption(LoadBalancer.DISABLE_SUBCHANNEL_RECONNECT_KEY, this.serializingRetries).build());
        if (subchannel == null) {
            log.warning("Was not able to create subchannel for " + addr);
            throw new IllegalStateException("Can't create subchannel");
        }
        SubchannelData subchannelData = new SubchannelData(subchannel, ConnectivityState.IDLE);
        hcListener.subchannelData = subchannelData;
        this.subchannels.put(addr, subchannelData);
        Attributes scAttrs = subchannel.getAttributes();
        if (this.notAPetiolePolicy || scAttrs.get(LoadBalancer.HAS_HEALTH_PRODUCER_LISTENER_KEY) == null) {
            subchannelData.healthStateInfo = ConnectivityStateInfo.forNonError(ConnectivityState.READY);
        }
        subchannel.start(stateInfo -> this.processSubchannelState(subchannelData, stateInfo));
        return subchannelData;
    }

    private boolean isPassComplete() {
        if (this.subchannels.size() < this.addressIndex.size()) {
            return false;
        }
        for (SubchannelData sc : this.subchannels.values()) {
            if (sc.isCompletedConnectivityAttempt()) continue;
            return false;
        }
        return true;
    }

    private SocketAddress getAddress(LoadBalancer.Subchannel subchannel) {
        return subchannel.getAddresses().getAddresses().get(0);
    }

    @VisibleForTesting
    ConnectivityState getConcludedConnectivityState() {
        return this.concludedState;
    }

    @VisibleForTesting
    int getGroupIndex() {
        return this.addressIndex.groupIndex;
    }

    @VisibleForTesting
    boolean isIndexValid() {
        return this.addressIndex.isValid();
    }

    public static final class PickFirstLeafLoadBalancerConfig {
        @Nullable
        public final Boolean shuffleAddressList;
        @Nullable
        final Long randomSeed;

        public PickFirstLeafLoadBalancerConfig(@Nullable Boolean shuffleAddressList) {
            this(shuffleAddressList, null);
        }

        PickFirstLeafLoadBalancerConfig(@Nullable Boolean shuffleAddressList, @Nullable Long randomSeed) {
            this.shuffleAddressList = shuffleAddressList;
            this.randomSeed = randomSeed;
        }
    }

    private static final class SubchannelData {
        private final LoadBalancer.Subchannel subchannel;
        private ConnectivityState state;
        private boolean completedConnectivityAttempt = false;
        private ConnectivityStateInfo healthStateInfo = ConnectivityStateInfo.forNonError(ConnectivityState.IDLE);

        public SubchannelData(LoadBalancer.Subchannel subchannel, ConnectivityState state) {
            this.subchannel = subchannel;
            this.state = state;
        }

        public LoadBalancer.Subchannel getSubchannel() {
            return this.subchannel;
        }

        public ConnectivityState getState() {
            return this.state;
        }

        public boolean isCompletedConnectivityAttempt() {
            return this.completedConnectivityAttempt;
        }

        private void updateState(ConnectivityState newState) {
            this.state = newState;
            if (newState == ConnectivityState.READY || newState == ConnectivityState.TRANSIENT_FAILURE) {
                this.completedConnectivityAttempt = true;
            } else if (newState == ConnectivityState.IDLE) {
                this.completedConnectivityAttempt = false;
            }
        }

        private ConnectivityState getHealthState() {
            return this.healthStateInfo.getState();
        }
    }

    @VisibleForTesting
    static final class Index {
        private List<EquivalentAddressGroup> addressGroups;
        private int size;
        private int groupIndex;
        private int addressIndex;

        public Index(List<EquivalentAddressGroup> groups) {
            this.updateGroups(groups);
        }

        public boolean isValid() {
            return this.groupIndex < this.addressGroups.size();
        }

        public boolean isAtBeginning() {
            return this.groupIndex == 0 && this.addressIndex == 0;
        }

        public boolean increment() {
            if (!this.isValid()) {
                return false;
            }
            EquivalentAddressGroup group = this.addressGroups.get(this.groupIndex);
            ++this.addressIndex;
            if (this.addressIndex >= group.getAddresses().size()) {
                ++this.groupIndex;
                this.addressIndex = 0;
                return this.groupIndex < this.addressGroups.size();
            }
            return true;
        }

        public void reset() {
            this.groupIndex = 0;
            this.addressIndex = 0;
        }

        public SocketAddress getCurrentAddress() {
            if (!this.isValid()) {
                throw new IllegalStateException("Index is past the end of the address group list");
            }
            return this.addressGroups.get(this.groupIndex).getAddresses().get(this.addressIndex);
        }

        public Attributes getCurrentEagAttributes() {
            if (!this.isValid()) {
                throw new IllegalStateException("Index is off the end of the address group list");
            }
            return this.addressGroups.get(this.groupIndex).getAttributes();
        }

        public List<EquivalentAddressGroup> getCurrentEagAsList() {
            return Collections.singletonList(new EquivalentAddressGroup(this.getCurrentAddress(), this.getCurrentEagAttributes()));
        }

        public void updateGroups(List<EquivalentAddressGroup> newGroups) {
            this.addressGroups = (List)Preconditions.checkNotNull(newGroups, (Object)"newGroups");
            this.reset();
            int size = 0;
            for (EquivalentAddressGroup eag : newGroups) {
                size += eag.getAddresses().size();
            }
            this.size = size;
        }

        public boolean seekTo(SocketAddress needle) {
            for (int i = 0; i < this.addressGroups.size(); ++i) {
                EquivalentAddressGroup group = this.addressGroups.get(i);
                int j = group.getAddresses().indexOf(needle);
                if (j == -1) continue;
                this.groupIndex = i;
                this.addressIndex = j;
                return true;
            }
            return false;
        }

        public int size() {
            return this.size;
        }
    }

    private final class RequestConnectionPicker
    extends LoadBalancer.SubchannelPicker {
        private final PickFirstLeafLoadBalancer pickFirstLeafLoadBalancer;
        private final AtomicBoolean connectionRequested = new AtomicBoolean(false);

        RequestConnectionPicker(PickFirstLeafLoadBalancer pickFirstLeafLoadBalancer2) {
            this.pickFirstLeafLoadBalancer = (PickFirstLeafLoadBalancer)Preconditions.checkNotNull((Object)pickFirstLeafLoadBalancer2, (Object)"pickFirstLeafLoadBalancer");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            if (this.connectionRequested.compareAndSet(false, true)) {
                PickFirstLeafLoadBalancer.this.helper.getSynchronizationContext().execute(this.pickFirstLeafLoadBalancer::requestConnection);
            }
            return LoadBalancer.PickResult.withNoResult();
        }
    }

    private static final class Picker
    extends LoadBalancer.SubchannelPicker {
        private final LoadBalancer.PickResult result;

        Picker(LoadBalancer.PickResult result) {
            this.result = (LoadBalancer.PickResult)Preconditions.checkNotNull((Object)result, (Object)"result");
        }

        @Override
        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            return this.result;
        }

        public String toString() {
            return MoreObjects.toStringHelper(Picker.class).add("result", (Object)this.result).toString();
        }
    }

    private final class HealthListener
    implements LoadBalancer.SubchannelStateListener {
        private SubchannelData subchannelData;

        private HealthListener() {
        }

        @Override
        public void onSubchannelState(ConnectivityStateInfo newState) {
            if (PickFirstLeafLoadBalancer.this.notAPetiolePolicy) {
                log.log(Level.WARNING, "Ignoring health status {0} for subchannel {1} as this is not under a petiole policy", new Object[]{newState, this.subchannelData.subchannel});
                return;
            }
            log.log(Level.FINE, "Received health status {0} for subchannel {1}", new Object[]{newState, this.subchannelData.subchannel});
            this.subchannelData.healthStateInfo = newState;
            if (PickFirstLeafLoadBalancer.this.addressIndex.isValid() && this.subchannelData == PickFirstLeafLoadBalancer.this.subchannels.get(PickFirstLeafLoadBalancer.this.addressIndex.getCurrentAddress())) {
                PickFirstLeafLoadBalancer.this.updateHealthCheckedState(this.subchannelData);
            }
        }
    }
}

