/*
 * Decompiled with CFR 0.152.
 */
package aida.io.grpc.netty;

import aida.io.grpc.Attributes;
import aida.io.grpc.CallOptions;
import aida.io.grpc.ChannelLogger;
import aida.io.grpc.ClientStreamTracer;
import aida.io.grpc.InternalChannelz;
import aida.io.grpc.InternalLogId;
import aida.io.grpc.Metadata;
import aida.io.grpc.MethodDescriptor;
import aida.io.grpc.Status;
import aida.io.grpc.internal.ClientStream;
import aida.io.grpc.internal.ClientTransport;
import aida.io.grpc.internal.ConnectionClientTransport;
import aida.io.grpc.internal.FailingClientStream;
import aida.io.grpc.internal.GrpcUtil;
import aida.io.grpc.internal.Http2Ping;
import aida.io.grpc.internal.KeepAliveManager;
import aida.io.grpc.internal.ManagedClientTransport;
import aida.io.grpc.internal.StatsTraceContext;
import aida.io.grpc.internal.TransportTracer;
import aida.io.grpc.netty.ClientTransportLifecycleManager;
import aida.io.grpc.netty.ForcefulCloseCommand;
import aida.io.grpc.netty.GracefulCloseCommand;
import aida.io.grpc.netty.NettyChannelBuilder;
import aida.io.grpc.netty.NettyClientHandler;
import aida.io.grpc.netty.NettyClientStream;
import aida.io.grpc.netty.ProtocolNegotiator;
import aida.io.grpc.netty.SendPingCommand;
import aida.io.grpc.netty.Utils;
import aida.io.grpc.netty.WriteBufferingAndExceptionHandler;
import aida.io.netty.bootstrap.Bootstrap;
import aida.io.netty.channel.Channel;
import aida.io.netty.channel.ChannelFactory;
import aida.io.netty.channel.ChannelFuture;
import aida.io.netty.channel.ChannelFutureListener;
import aida.io.netty.channel.ChannelHandler;
import aida.io.netty.channel.ChannelOption;
import aida.io.netty.channel.EventLoop;
import aida.io.netty.channel.EventLoopGroup;
import aida.io.netty.handler.codec.http2.StreamBufferingEncoder;
import aida.io.netty.util.AsciiString;
import aida.io.netty.util.concurrent.Future;
import aida.io.netty.util.concurrent.GenericFutureListener;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

class NettyClientTransport
implements ConnectionClientTransport {
    private final InternalLogId logId;
    private final Map<ChannelOption<?>, ?> channelOptions;
    private final SocketAddress remoteAddress;
    private final ChannelFactory<? extends Channel> channelFactory;
    private final EventLoopGroup group;
    private final ProtocolNegotiator negotiator;
    private final String authorityString;
    private final AsciiString authority;
    private final AsciiString userAgent;
    private final boolean autoFlowControl;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private final int softLimitHeaderListSize;
    private KeepAliveManager keepAliveManager;
    private final long keepAliveTimeNanos;
    private final long keepAliveTimeoutNanos;
    private final boolean keepAliveWithoutCalls;
    private final AsciiString negotiationScheme;
    private final Runnable tooManyPingsRunnable;
    private NettyClientHandler handler;
    private Channel channel;
    private Status statusExplainingWhyTheChannelIsNull;
    private ClientTransportLifecycleManager lifecycleManager;
    private final TransportTracer transportTracer;
    private final Attributes eagAttributes;
    private final NettyChannelBuilder.LocalSocketPicker localSocketPicker;
    private final ChannelLogger channelLogger;
    private final boolean useGetForSafeMethods;
    private final Ticker ticker;

    NettyClientTransport(SocketAddress address, ChannelFactory<? extends Channel> channelFactory, Map<ChannelOption<?>, ?> channelOptions, EventLoopGroup group, ProtocolNegotiator negotiator, boolean autoFlowControl, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, int softLimitHeaderListSize, long keepAliveTimeNanos, long keepAliveTimeoutNanos, boolean keepAliveWithoutCalls, String authority, @Nullable String userAgent, Runnable tooManyPingsRunnable, TransportTracer transportTracer, Attributes eagAttributes, NettyChannelBuilder.LocalSocketPicker localSocketPicker, ChannelLogger channelLogger, boolean useGetForSafeMethods, Ticker ticker) {
        this.negotiator = (ProtocolNegotiator)Preconditions.checkNotNull((Object)negotiator, (Object)"negotiator");
        this.negotiationScheme = this.negotiator.scheme();
        this.remoteAddress = (SocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.group = (EventLoopGroup)Preconditions.checkNotNull((Object)group, (Object)"group");
        this.channelFactory = channelFactory;
        this.channelOptions = (Map)Preconditions.checkNotNull(channelOptions, (Object)"channelOptions");
        this.autoFlowControl = autoFlowControl;
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.softLimitHeaderListSize = softLimitHeaderListSize;
        this.keepAliveTimeNanos = keepAliveTimeNanos;
        this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
        this.keepAliveWithoutCalls = keepAliveWithoutCalls;
        this.authorityString = authority;
        this.authority = new AsciiString(authority);
        this.userAgent = new AsciiString(GrpcUtil.getGrpcUserAgent("netty", userAgent));
        this.tooManyPingsRunnable = (Runnable)Preconditions.checkNotNull((Object)tooManyPingsRunnable, (Object)"tooManyPingsRunnable");
        this.transportTracer = (TransportTracer)Preconditions.checkNotNull((Object)transportTracer, (Object)"transportTracer");
        this.eagAttributes = (Attributes)Preconditions.checkNotNull((Object)eagAttributes, (Object)"eagAttributes");
        this.localSocketPicker = (NettyChannelBuilder.LocalSocketPicker)Preconditions.checkNotNull((Object)localSocketPicker, (Object)"localSocketPicker");
        this.logId = InternalLogId.allocate(this.getClass(), this.remoteAddress.toString());
        this.channelLogger = (ChannelLogger)Preconditions.checkNotNull((Object)channelLogger, (Object)"channelLogger");
        this.useGetForSafeMethods = useGetForSafeMethods;
        this.ticker = (Ticker)Preconditions.checkNotNull((Object)ticker, (Object)"ticker");
    }

    @Override
    public void ping(final ClientTransport.PingCallback callback, final Executor executor) {
        if (this.channel == null) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    callback.onFailure(NettyClientTransport.this.statusExplainingWhyTheChannelIsNull.asException());
                }
            });
            return;
        }
        ChannelFutureListener failureListener = new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    Status s = NettyClientTransport.this.statusFromFailedFuture(future);
                    Http2Ping.notifyFailed(callback, executor, s.asException());
                }
            }
        };
        this.handler.getWriteQueue().enqueue(new SendPingCommand(callback, executor), true).addListener(failureListener);
    }

    @Override
    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, ClientStreamTracer[] tracers) {
        Preconditions.checkNotNull(method, (Object)"method");
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        if (this.channel == null) {
            return new FailingClientStream(this.statusExplainingWhyTheChannelIsNull, tracers);
        }
        StatsTraceContext statsTraceCtx = StatsTraceContext.newClientContext(tracers, this.getAttributes(), headers);
        return new NettyClientStream(new NettyClientStream.TransportState(this.handler, this.channel.eventLoop(), this.maxMessageSize, statsTraceCtx, this.transportTracer, method.getFullMethodName(), callOptions){

            @Override
            protected Status statusFromFailedFuture(ChannelFuture f) {
                return NettyClientTransport.this.statusFromFailedFuture(f);
            }
        }, method, headers, this.channel, this.authority, this.negotiationScheme, this.userAgent, statsTraceCtx, this.transportTracer, callOptions, this.useGetForSafeMethods);
    }

    @Override
    public Runnable start(ManagedClientTransport.Listener transportListener) {
        this.lifecycleManager = new ClientTransportLifecycleManager((ManagedClientTransport.Listener)Preconditions.checkNotNull((Object)transportListener, (Object)"listener"));
        EventLoop eventLoop = this.group.next();
        if (this.keepAliveTimeNanos != Long.MAX_VALUE) {
            this.keepAliveManager = new KeepAliveManager(new KeepAliveManager.ClientKeepAlivePinger(this), eventLoop, this.keepAliveTimeNanos, this.keepAliveTimeoutNanos, this.keepAliveWithoutCalls);
        }
        this.handler = NettyClientHandler.newHandler(this.lifecycleManager, this.keepAliveManager, this.autoFlowControl, this.flowControlWindow, this.maxHeaderListSize, this.softLimitHeaderListSize, GrpcUtil.STOPWATCH_SUPPLIER, this.tooManyPingsRunnable, this.transportTracer, this.eagAttributes, this.authorityString, this.channelLogger, this.ticker);
        ChannelHandler negotiationHandler = this.negotiator.newHandler(this.handler);
        Bootstrap b = new Bootstrap();
        b.option(ChannelOption.ALLOCATOR, Utils.getByteBufAllocator(false));
        b.group(eventLoop);
        b.channelFactory(this.channelFactory);
        b.option(ChannelOption.SO_KEEPALIVE, true);
        for (Map.Entry<ChannelOption<?>, ?> entry : this.channelOptions.entrySet()) {
            b.option(entry.getKey(), entry.getValue());
        }
        WriteBufferingAndExceptionHandler bufferingHandler = new WriteBufferingAndExceptionHandler(negotiationHandler);
        b.handler(bufferingHandler);
        ChannelFuture regFuture = b.register();
        if (regFuture.isDone() && !regFuture.isSuccess()) {
            this.channel = null;
            Throwable t = regFuture.cause();
            if (t == null) {
                t = new IllegalStateException("Channel is null, but future doesn't have a cause");
            }
            this.statusExplainingWhyTheChannelIsNull = Utils.statusFromThrowable(t);
            return new Runnable(){

                @Override
                public void run() {
                    NettyClientTransport.this.lifecycleManager.notifyTerminated(NettyClientTransport.this.statusExplainingWhyTheChannelIsNull);
                }
            };
        }
        this.channel = regFuture.channel();
        try {
            ChannelOption<Integer> tcpUserTimeout;
            if (this.keepAliveTimeNanos != Long.MAX_VALUE && Class.forName("aida.io.netty.channel.epoll.AbstractEpollChannel").isInstance(this.channel) && (tcpUserTimeout = Utils.maybeGetTcpUserTimeoutOption()) != null) {
                int tcpUserTimeoutMs = (int)TimeUnit.NANOSECONDS.toMillis(this.keepAliveTimeoutNanos);
                this.channel.config().setOption(tcpUserTimeout, tcpUserTimeoutMs);
            }
        }
        catch (ClassNotFoundException tcpUserTimeout) {
            // empty catch block
        }
        this.handler.startWriteQueue(this.channel);
        this.channel.writeAndFlush(NettyClientHandler.NOOP_MESSAGE).addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    NettyClientTransport.this.lifecycleManager.notifyTerminated(Utils.statusFromThrowable(future.cause()));
                }
            }
        });
        SocketAddress localAddress = this.localSocketPicker.createSocketAddress(this.remoteAddress, this.eagAttributes);
        if (localAddress != null) {
            this.channel.connect(this.remoteAddress, localAddress);
        } else {
            this.channel.connect(this.remoteAddress);
        }
        if (this.keepAliveManager != null) {
            this.keepAliveManager.onTransportStarted();
        }
        return null;
    }

    @Override
    public void shutdown(Status reason) {
        if (this.channel == null) {
            return;
        }
        if (this.channel.isOpen()) {
            this.handler.getWriteQueue().enqueue(new GracefulCloseCommand(reason), true);
        }
    }

    @Override
    public void shutdownNow(final Status reason) {
        if (this.channel != null && this.channel.isOpen()) {
            this.handler.getWriteQueue().enqueue(new Runnable(){

                @Override
                public void run() {
                    NettyClientTransport.this.lifecycleManager.notifyShutdown(reason);
                    NettyClientTransport.this.channel.write(new ForcefulCloseCommand(reason));
                }
            }, true);
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("logId", this.logId.getId()).add("remoteAddress", (Object)this.remoteAddress).add("channel", (Object)this.channel).toString();
    }

    @Override
    public InternalLogId getLogId() {
        return this.logId;
    }

    @Override
    public Attributes getAttributes() {
        return this.handler.getAttributes();
    }

    @Override
    public ListenableFuture<InternalChannelz.SocketStats> getStats() {
        final SettableFuture result = SettableFuture.create();
        if (this.channel.eventLoop().inEventLoop()) {
            result.set((Object)this.getStatsHelper(this.channel));
            return result;
        }
        this.channel.eventLoop().submit(new Runnable(){

            @Override
            public void run() {
                result.set((Object)NettyClientTransport.this.getStatsHelper(NettyClientTransport.this.channel));
            }
        }).addListener(new GenericFutureListener<Future<Object>>(){

            @Override
            public void operationComplete(Future<Object> future) throws Exception {
                if (!future.isSuccess()) {
                    result.setException(future.cause());
                }
            }
        });
        return result;
    }

    private InternalChannelz.SocketStats getStatsHelper(Channel ch) {
        assert (ch.eventLoop().inEventLoop());
        return new InternalChannelz.SocketStats(this.transportTracer.getStats(), this.channel.localAddress(), this.channel.remoteAddress(), Utils.getSocketOptions(ch), this.handler == null ? null : this.handler.getSecurityInfo());
    }

    @VisibleForTesting
    Channel channel() {
        return this.channel;
    }

    @VisibleForTesting
    KeepAliveManager keepAliveManager() {
        return this.keepAliveManager;
    }

    private Status statusFromFailedFuture(ChannelFuture f) {
        Throwable t = f.cause();
        if (t instanceof ClosedChannelException || t instanceof StreamBufferingEncoder.Http2ChannelClosedException) {
            Status shutdownStatus = this.lifecycleManager.getShutdownStatus();
            if (shutdownStatus == null) {
                return Status.UNKNOWN.withDescription("Channel closed but for unknown reason").withCause(new ClosedChannelException().initCause(t));
            }
            return shutdownStatus;
        }
        return Utils.statusFromThrowable(t);
    }
}

