/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp;

import com.intellij.ide.caches.CachesInvalidator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.io.FileUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangdLanguageServiceProvider;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;

public final class ClangdCachesInvalidator
extends CachesInvalidator {
    public void invalidateCaches() {
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            HashSet<String> paths = new HashSet<String>();
            paths.add(ClangdLanguageServiceProvider.getModulesPath(project, ClangLanguageService.Kind.Clangd));
            paths.add(ClangdLanguageServiceProvider.getModulesPath(project, ClangLanguageService.Kind.Indexer));
            paths.add(ClangdLanguageServiceProvider.getModulesPath(project, ClangLanguageService.Kind.StatelessIndexer));
            try {
                for (String path : paths) {
                    if (!FileUtil.exists((String)path)) continue;
                    FileUtil.delete((Path)Path.of(path, new String[0]));
                }
            }
            catch (IOException ex) {
                CidrLogService.LOG.warn((Throwable)ex);
            }
        }
    }
}

