/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions;

import com.google.gson.GsonBuilder;
import com.intellij.ide.impl.OpenProjectTask;
import com.intellij.ide.impl.OpenProjectTaskBuilder;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.OSAgnosticPathUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.projectImport.ProjectOpenedCallback;
import com.intellij.util.io.Decompressor;
import com.jetbrains.cidr.lang.OCLanguageStandard;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangDaemonNotification;
import com.jetbrains.cidr.lang.daemon.clang.clangd.JSONCommand;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.ClangdPrepareProjectFromReportDialog;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.actions.CorrectingDecompressor;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.reports.ClangReportUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0003\u0014\u0015\u0016B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdPrepareProjectFromReportAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "notifyFailed", "project", "Lcom/intellij/openapi/project/Project;", "errMsg", "", "notifySuccess", "projPath", "parseCompilationInfo", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdPrepareProjectFromReportAction$ErrorOr;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdPrepareProjectFromReportAction$RawCompilationInfo;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "ErrorOr", "CompilationInfo", "RawCompilationInfo", "intellij.cidr.clangd"})
@SourceDebugExtension(value={"SMAP\nClangdPrepareProjectFromReportAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClangdPrepareProjectFromReportAction.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdPrepareProjectFromReportAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,325:1\n1869#2,2:326\n1310#3,2:328\n*S KotlinDebug\n*F\n+ 1 ClangdPrepareProjectFromReportAction.kt\ncom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdPrepareProjectFromReportAction\n*L\n225#1:326,2\n154#1:328,2\n*E\n"})
public final class ClangdPrepareProjectFromReportAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        ClangdPrepareProjectFromReportDialog diag = new ClangdPrepareProjectFromReportDialog(project2);
        diag.show();
        if (diag.isOK()) {
            Decompressor decompressor = new Decompressor.Zip(new File(diag.getReportPath())).withZipExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)decompressor, (String)"withZipExtensions(...)");
            new CorrectingDecompressor(decompressor).extract(new File(diag.getExtractPath()));
            VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByNioPath(new File(diag.getExtractPath()).toPath());
            if (virtualFile == null) {
                this.notifyFailed(project2, "Failed to find a virtual file for " + diag.getExtractPath());
                return;
            }
            VirtualFile projDir = virtualFile;
            projDir.refresh(true, true, () -> ClangdPrepareProjectFromReportAction.actionPerformed$lambda$5(projDir, this, project2, diag));
        }
    }

    private final void notifyFailed(Project project, String errMsg) {
        Object[] objectArray = new Object[]{errMsg};
        Notifications.Bus.notify((Notification)new ClangDaemonNotification(ClangdBundle.message("clangd.extract.report.failed", objectArray), NotificationType.WARNING), (Project)project);
    }

    private final void notifySuccess(Project project, String projPath) {
        String string = ClangdBundle.message("clangd.extract.report.open.project", new Object[0]);
        NotificationAction openProjectAction2 = new NotificationAction(projPath, project, string){
            final /* synthetic */ String $projPath;
            final /* synthetic */ Project $project;
            {
                this.$projPath = $projPath;
                this.$project = $project;
                super($super_call_param$1);
            }

            /*
             * WARNING - void declaration
             */
            public void actionPerformed(AnActionEvent e, Notification notification) {
                void $this$actionPerformed_u24lambda_u240;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
                notification.expire();
                String[] stringArray = new String[]{"CMakeLists.txt"};
                Path path = Paths.get(this.$projPath, stringArray);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                Project project = this.$project;
                boolean $i$f$OpenProjectTask = false;
                OpenProjectTaskBuilder this_$iv$iv = new OpenProjectTaskBuilder();
                boolean $i$f$build = false;
                OpenProjectTaskBuilder openProjectTaskBuilder = this_$iv$iv;
                Path path2 = path;
                boolean bl = false;
                $this$actionPerformed_u24lambda_u240.setProjectToClose(project);
                $this$actionPerformed_u24lambda_u240.setNewProject(true);
                boolean bl2 = this_$iv$iv.getForceOpenInNewFrame();
                boolean bl3 = this_$iv$iv.getForceReuseFrame();
                boolean bl4 = this_$iv$iv.getPreloadServices();
                Project project2 = this_$iv$iv.getProjectToClose();
                boolean bl5 = this_$iv$iv.isRefreshVfsNeeded();
                String string = this_$iv$iv.getProjectName();
                boolean bl6 = this_$iv$iv.isNewProject();
                Boolean bl7 = this_$iv$iv.getUseDefaultProjectAsTemplate();
                boolean bl8 = bl7 != null ? bl7.booleanValue() : this_$iv$iv.isNewProject();
                boolean bl9 = this_$iv$iv.getRunConfigurators();
                boolean bl10 = this_$iv$iv.isProjectCreatedWithWizard();
                boolean bl11 = this_$iv$iv.getRunConversionBeforeOpen();
                boolean bl12 = this_$iv$iv.getShowWelcomeScreen();
                Function2 function2 = this_$iv$iv.getBeforeOpen();
                Function1 function1 = this_$iv$iv.getBeforeInit();
                Function2 function22 = this_$iv$iv.getPreparedToOpen();
                ProjectOpenedCallback projectOpenedCallback = this_$iv$iv.getCallback();
                boolean bl13 = this_$iv$iv.getPreventIprLookup();
                Function1 function12 = this_$iv$iv.getProcessorChooser();
                String string2 = this_$iv$iv.getProjectWorkspaceId();
                Object object = this_$iv$iv.getImplOptions();
                int n = this_$iv$iv.getLine();
                int n2 = this_$iv$iv.getColumn();
                Project project3 = this_$iv$iv.getProject();
                ProjectUtil.openOrImport((Path)path2, (OpenProjectTask)new OpenProjectTask(bl2, bl3, project2, bl6, bl8, project3, string, bl12, projectOpenedCallback, n, n2, bl5, bl9, bl11, string2, bl10, bl4, function1, function2, function22, bl13, function12, object));
            }
        };
        Object[] objectArray = new Object[]{projPath};
        ClangDaemonNotification notification = new ClangDaemonNotification(ClangdBundle.message("clangd.extract.report.success", objectArray), NotificationType.INFORMATION);
        notification.addAction((AnAction)openProjectAction2);
        Notifications.Bus.notify((Notification)notification, (Project)project);
    }

    private final ErrorOr<RawCompilationInfo> parseCompilationInfo(VirtualFile file) {
        String text = VirtualFileUtil.readText((VirtualFile)file);
        String targetFile = null;
        String cmd = null;
        String[] stringArray = new String[]{"\n"};
        Iterable $this$forEach$iv = StringsKt.split$default((CharSequence)text, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)line, (String)"Target file: ", (boolean)false, (int)2, null)) {
                Intrinsics.checkNotNullExpressionValue((Object)line.substring(13), (String)"substring(...)");
            }
            if (!StringsKt.startsWith$default((String)line, (String)"Compilation command: ", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)line.substring(21), (String)"substring(...)");
        }
        if (targetFile == null) {
            return new ErrorOr<RawCompilationInfo>("Failed to find a target file in " + file);
        }
        if (cmd == null) {
            return new ErrorOr<RawCompilationInfo>("Failed to find a compilation command in " + file);
        }
        return new ErrorOr<RawCompilationInfo>(new RawCompilationInfo(targetFile, cmd, Intrinsics.areEqual((Object)file.getName(), (Object)"CompilationInfo.txt")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final void actionPerformed$lambda$5(VirtualFile $projDir, ClangdPrepareProjectFromReportAction this$0, Project $project, ClangdPrepareProjectFromReportDialog $diag) {
        block19: {
            v0 = $projDir.getChildren();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getChildren(...)");
            $this$firstOrNull$iv = v0;
            $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                it = (VirtualFile)element$iv;
                $i$a$-firstOrNull-ClangdPrepareProjectFromReportAction$actionPerformed$1$compInfoFile$1 = false;
                if (Intrinsics.areEqual((Object)it.getName(), (Object)"CompilationInfo.txt")) ** GOTO lbl-1000
                v1 = it.getName();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getName(...)");
                if (StringsKt.startsWith$default((String)v1, (String)"CompilationInfo_", (boolean)false, (int)2, null)) {
                    v2 = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getName(...)");
                    ** if (!StringsKt.endsWith$default((String)v2, (String)".txt", (boolean)false, (int)2, null)) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    v3 = true;
                    ** GOTO lbl19
                }
lbl-1000:
                // 2 sources

                {
                    v3 = false;
                }
lbl19:
                // 2 sources

                if (!v3) continue;
                v4 = element$iv;
                break block19;
            }
            v4 = null;
        }
        v5 = (VirtualFile)v4;
        if (v5 == null) {
            this$0.notifyFailed($project, "Failed to find any \"CompilationInfo.txt\" file(s) in the report");
            return;
        }
        compInfoFile = v5;
        it = this$0.parseCompilationInfo(compInfoFile);
        $i$a$-let-ClangdPrepareProjectFromReportAction$actionPerformed$1$rawCompInfo$1 = false;
        if (it.getError() != null) {
            this$0.notifyFailed($project, it.getError());
            return;
        }
        v6 = it.getValue();
        Intrinsics.checkNotNull((Object)v6);
        rawCompInfo = v6;
        it = rawCompInfo.resolve($projDir);
        $i$a$-let-ClangdPrepareProjectFromReportAction$actionPerformed$1$compInfo$1 = false;
        if (it.getError() != null) {
            this$0.notifyFailed($project, it.getError());
            return;
        }
        v7 = it.getValue();
        Intrinsics.checkNotNull((Object)v7);
        compInfo = v7;
        v8 = OCLanguageStandard.Companion.findLanguageStandard(compInfo.getCommandLine());
        if (v8 == null) {
            v8 = OCLanguageStandard.CPP17;
        }
        cmakeLangFlag = (langStandard = v8).isCpp() != false ? "CMAKE_CXX_STANDARD" : "CMAKE_C_STANDARD";
        var9_10 /* !! */  = new String[]{"CMakeLists.txt"};
        var9_10 /* !! */  = new FileWriter(Paths.get($projDir.getPath(), var9_10 /* !! */ ).toFile());
        var10_11 = null;
        try {
            it = (FileWriter)var9_10 /* !! */ ;
            $i$a$-use-ClangdPrepareProjectFromReportAction$actionPerformed$1$1 = false;
            it.write("cmake_minimum_required(VERSION 3.20)\nproject(" + $diag.getProjectName() + ")\n\nset(" + cmakeLangFlag + " " + langStandard.getCMakeFlag() + ")\n\nadd_executable(" + $diag.getProjectName() + "\n  " + compInfo.getTargetFile().getPath() + "\n  " + compInfo.getEntryFile().getPath() + ")\n");
            it = Unit.INSTANCE;
        }
        catch (Throwable $i$a$-use-ClangdPrepareProjectFromReportAction$actionPerformed$1$1) {
            var10_11 = $i$a$-use-ClangdPrepareProjectFromReportAction$actionPerformed$1$1;
            throw $i$a$-use-ClangdPrepareProjectFromReportAction$actionPerformed$1$1;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var9_10 /* !! */ , (Throwable)var10_11);
        }
        var9_10 /* !! */  = new String[]{"clion_compile_commands.json"};
        var9_10 /* !! */  = new FileWriter(Paths.get($projDir.getPath(), var9_10 /* !! */ ).toFile());
        var10_11 = null;
        try {
            it = (FileWriter)var9_10 /* !! */ ;
            $i$a$-use-ClangdPrepareProjectFromReportAction$actionPerformed$1$2 = false;
            gson = new GsonBuilder().setPrettyPrinting().create();
            var14_21 = new JSONCommand[]{new JSONCommand("", compInfo.escapedCommandLine(), compInfo.getTargetFile().getPath())};
            commands = CollectionsKt.mutableListOf((Object[])var14_21);
            if (!Intrinsics.areEqual((Object)compInfo.getEntryFile(), (Object)compInfo.getTargetFile())) {
                commands.add(new JSONCommand("", compInfo.escapedCommandLine(), compInfo.getEntryFile().getPath()));
            }
            gson.toJson((Object)commands, (Appendable)it);
            var11_12 = Unit.INSTANCE;
        }
        catch (Throwable var12_16) {
            var10_11 = var12_16;
            throw var12_16;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var9_10 /* !! */ , (Throwable)var10_11);
        }
        v9 = $projDir.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)v9, (String)"getPath(...)");
        this$0.notifySuccess($project, v9);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u000f\u001a\u00020\u0007J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdPrepareProjectFromReportAction$CompilationInfo;", "", "targetFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "entryFile", "commandLine", "", "", "<init>", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/util/List;)V", "getTargetFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getEntryFile", "getCommandLine", "()Ljava/util/List;", "escapedCommandLine", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.cidr.clangd"})
    private static final class CompilationInfo {
        @NotNull
        private final VirtualFile targetFile;
        @NotNull
        private final VirtualFile entryFile;
        @NotNull
        private final List<String> commandLine;

        public CompilationInfo(@NotNull VirtualFile targetFile, @NotNull VirtualFile entryFile, @NotNull List<String> commandLine) {
            Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
            Intrinsics.checkNotNullParameter((Object)entryFile, (String)"entryFile");
            Intrinsics.checkNotNullParameter(commandLine, (String)"commandLine");
            this.targetFile = targetFile;
            this.entryFile = entryFile;
            this.commandLine = commandLine;
        }

        @NotNull
        public final VirtualFile getTargetFile() {
            return this.targetFile;
        }

        @NotNull
        public final VirtualFile getEntryFile() {
            return this.entryFile;
        }

        @NotNull
        public final List<String> getCommandLine() {
            return this.commandLine;
        }

        @NotNull
        public final String escapedCommandLine() {
            return CollectionsKt.joinToString$default((Iterable)this.commandLine, (CharSequence)" ", null, null, (int)0, null, CompilationInfo::escapedCommandLine$lambda$0, (int)30, null);
        }

        @NotNull
        public final VirtualFile component1() {
            return this.targetFile;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.entryFile;
        }

        @NotNull
        public final List<String> component3() {
            return this.commandLine;
        }

        @NotNull
        public final CompilationInfo copy(@NotNull VirtualFile targetFile, @NotNull VirtualFile entryFile, @NotNull List<String> commandLine) {
            Intrinsics.checkNotNullParameter((Object)targetFile, (String)"targetFile");
            Intrinsics.checkNotNullParameter((Object)entryFile, (String)"entryFile");
            Intrinsics.checkNotNullParameter(commandLine, (String)"commandLine");
            return new CompilationInfo(targetFile, entryFile, commandLine);
        }

        public static /* synthetic */ CompilationInfo copy$default(CompilationInfo compilationInfo, VirtualFile virtualFile, VirtualFile virtualFile2, List list, int n, Object object) {
            if ((n & 1) != 0) {
                virtualFile = compilationInfo.targetFile;
            }
            if ((n & 2) != 0) {
                virtualFile2 = compilationInfo.entryFile;
            }
            if ((n & 4) != 0) {
                list = compilationInfo.commandLine;
            }
            return compilationInfo.copy(virtualFile, virtualFile2, list);
        }

        @NotNull
        public String toString() {
            return "CompilationInfo(targetFile=" + this.targetFile + ", entryFile=" + this.entryFile + ", commandLine=" + this.commandLine + ")";
        }

        public int hashCode() {
            int result = this.targetFile.hashCode();
            result = result * 31 + this.entryFile.hashCode();
            result = result * 31 + ((Object)this.commandLine).hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CompilationInfo)) {
                return false;
            }
            CompilationInfo compilationInfo = (CompilationInfo)other;
            if (!Intrinsics.areEqual((Object)this.targetFile, (Object)compilationInfo.targetFile)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.entryFile, (Object)compilationInfo.entryFile)) {
                return false;
            }
            return Intrinsics.areEqual(this.commandLine, compilationInfo.commandLine);
        }

        private static final CharSequence escapedCommandLine$lambda$0(String opt) {
            Intrinsics.checkNotNullParameter((Object)opt, (String)"opt");
            return StringsKt.indexOf$default((CharSequence)opt, (char)' ', (int)0, (boolean)false, (int)6, null) >= 0 ? (CharSequence)("\"" + opt + "\"") : (CharSequence)opt;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bR\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdPrepareProjectFromReportAction$ErrorOr;", "T", "", "value", "<init>", "(Ljava/lang/Object;)V", "error", "", "(Ljava/lang/String;)V", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getError", "()Ljava/lang/String;", "intellij.cidr.clangd"})
    private static final class ErrorOr<T> {
        @Nullable
        private final T value;
        @Nullable
        private final String error;

        @Nullable
        public final T getValue() {
            return this.value;
        }

        @Nullable
        public final String getError() {
            return this.error;
        }

        public ErrorOr(T value) {
            this.value = value;
            this.error = null;
        }

        public ErrorOr(@NotNull String error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            this.value = null;
            this.error = error;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdPrepareProjectFromReportAction$RawCompilationInfo;", "", "targetPath", "", "commandLine", "oldStyleReport", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Z)V", "getTargetPath", "()Ljava/lang/String;", "getCommandLine", "getOldStyleReport", "()Z", "resolve", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdPrepareProjectFromReportAction$ErrorOr;", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/actions/ClangdPrepareProjectFromReportAction$CompilationInfo;", "projDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "getSpecialFileName", "fileName", "targetFile", "concat", "Ljava/nio/file/Path;", "reportPath", "intellij.cidr.clangd"})
    private static final class RawCompilationInfo {
        @NotNull
        private final String targetPath;
        @NotNull
        private final String commandLine;
        private final boolean oldStyleReport;

        public RawCompilationInfo(@NotNull String targetPath, @NotNull String commandLine, boolean oldStyleReport) {
            Intrinsics.checkNotNullParameter((Object)targetPath, (String)"targetPath");
            Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
            this.targetPath = targetPath;
            this.commandLine = commandLine;
            this.oldStyleReport = oldStyleReport;
        }

        @NotNull
        public final String getTargetPath() {
            return this.targetPath;
        }

        @NotNull
        public final String getCommandLine() {
            return this.commandLine;
        }

        public final boolean getOldStyleReport() {
            return this.oldStyleReport;
        }

        @NotNull
        public final ErrorOr<CompilationInfo> resolve(@NotNull VirtualFile projDir) {
            Intrinsics.checkNotNullParameter((Object)projDir, (String)"projDir");
            Path resolvedTargetPath = this.concat(projDir, this.targetPath);
            VirtualFile virtualFile = VirtualFileManager.getInstance().refreshAndFindFileByNioPath(resolvedTargetPath);
            if (virtualFile == null) {
                return new ErrorOr<CompilationInfo>("Failed to find a virtual file for " + resolvedTargetPath);
            }
            VirtualFile targetFile = virtualFile;
            List newCommandLine = new ArrayList();
            boolean nextIsPath = false;
            for (String arg : ClangUtils.splitCommandLine(this.commandLine)) {
                ClangUtils.PathOptInfo optInfo;
                if (nextIsPath) {
                    Intrinsics.checkNotNull((Object)arg);
                    String string = this.concat(projDir, arg).toFile().getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                    newCommandLine.add(string);
                    nextIsPath = false;
                    continue;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ClangUtils.getPathOptInfo(arg), (String)"getPathOptInfo(...)");
                block0 : switch (WhenMappings.$EnumSwitchMapping$0[optInfo.type.ordinal()]) {
                    case 1: {
                        boolean bl;
                        if (OSAgnosticPathUtil.isAbsolute((String)arg)) {
                            Intrinsics.checkNotNull((Object)arg);
                            Path newPath = this.concat(projDir, arg);
                            String string = newPath.toFile().getPath();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                            bl = newCommandLine.add(string);
                            break;
                        }
                        Intrinsics.checkNotNull((Object)arg);
                        bl = newCommandLine.add(arg);
                        break;
                    }
                    case 2: {
                        Path newPath;
                        boolean bl;
                        switch (optInfo.opt) {
                            case "-imacros": {
                                String[] stringArray = new String[]{this.getSpecialFileName("clion_macros.txt", targetFile)};
                                newPath = Paths.get(projDir.getPath(), stringArray);
                                String[] stringArray2 = new String[]{"clion_clangd_inmemory_directory"};
                                Path inMemoryDirPath = Paths.get(projDir.getPath(), stringArray2);
                                FileUtilRt.createDirectory((File)inMemoryDirPath.toFile());
                                Path inMemoryFilePath = inMemoryDirPath.resolve(newPath.getFileName());
                                FileUtilRt.copy((File)newPath.toFile(), (File)inMemoryFilePath.toFile());
                                bl = newCommandLine.add(optInfo.opt + inMemoryFilePath.toFile().getPath());
                                break block0;
                            }
                            case "-fmodule-map-file=": {
                                String[] stringArray = new String[]{this.getSpecialFileName("clion_module.modulemap", targetFile)};
                                newPath = Paths.get(projDir.getPath(), stringArray);
                                bl = newCommandLine.add(optInfo.opt + newPath.toFile().getPath());
                                break block0;
                            }
                            case "-fcpp20-module-map-file=": {
                                String[] stringArray = new String[]{this.getSpecialFileName("clion_cpp20module.modulemap", targetFile)};
                                newPath = Paths.get(projDir.getPath(), stringArray);
                                bl = newCommandLine.add(optInfo.opt + newPath.toFile().getPath());
                                break block0;
                            }
                            case "-fprebuilt-module-path=": {
                                String[] stringArray = new String[]{"clangd_modules"};
                                Path cachePath = Paths.get(projDir.getPath(), stringArray);
                                FileUtilRt.createDirectory((File)cachePath.toFile());
                                bl = newCommandLine.add(optInfo.opt + cachePath.toFile().getPath());
                                break block0;
                            }
                        }
                        Intrinsics.checkNotNull((Object)arg);
                        String string = arg.substring(optInfo.opt.length());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                        newPath = this.concat(projDir, string);
                        bl = newCommandLine.add(optInfo.opt + newPath.toFile().getPath());
                        break;
                    }
                    case 3: {
                        nextIsPath = true;
                        Intrinsics.checkNotNull((Object)arg);
                        boolean bl = newCommandLine.add(arg);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            String resolvedEntryPath = (String)CollectionsKt.last((List)newCommandLine);
            VirtualFile virtualFile2 = VirtualFileManager.getInstance().refreshAndFindFileByNioPath(Paths.get(resolvedEntryPath, new String[0]));
            if (virtualFile2 == null) {
                return new ErrorOr<CompilationInfo>("Failed to find a virtual file for " + resolvedEntryPath);
            }
            VirtualFile entryFile = virtualFile2;
            return new ErrorOr<CompilationInfo>(new CompilationInfo(targetFile, entryFile, newCommandLine));
        }

        private final String getSpecialFileName(String fileName, VirtualFile targetFile) {
            if (this.oldStyleReport) {
                return fileName;
            }
            String string = FileUtilRt.getNameWithoutExtension((String)fileName);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
            String fileNameWithoutExt = string;
            String string2 = FileUtilRt.getExtension((String)fileName);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getExtension(...)");
            String fileExt = string2;
            return fileNameWithoutExt + "_" + targetFile.getName() + "." + fileExt;
        }

        private final Path concat(VirtualFile projDir, String reportPath) {
            String string;
            String string2 = ClangReportUtils.convertWindowsPath(FileUtilRt.toSystemIndependentName((String)reportPath));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"convertWindowsPath(...)");
            String converted = string2;
            if (StringsKt.startsWith$default((String)converted, (String)"/", (boolean)false, (int)2, null)) {
                String string3 = converted.substring(1);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = converted;
            }
            String relative = string;
            String[] stringArray = new String[]{relative};
            Path path = Paths.get(projDir.getPath(), stringArray);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return path;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ClangUtils.PathOptType.values().length];
                try {
                    nArray[ClangUtils.PathOptType.NotAPathOpt.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ClangUtils.PathOptType.ThisWithPath.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ClangUtils.PathOptType.NextWithPath.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

