/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.server;

import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import java.util.List;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.ServerInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB)\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ExtendedServerInfo;", "", "clangMajor", "", "clangMinor", "clangPatch", "clangVersion", "", "<init>", "(IIILjava/lang/String;)V", "toString", "Companion", "intellij.cidr.clangd"})
public final class ExtendedServerInfo {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int clangMajor;
    private final int clangMinor;
    private final int clangPatch;
    @NotNull
    private final String clangVersion;

    private ExtendedServerInfo(int clangMajor, int clangMinor, int clangPatch, String clangVersion) {
        this.clangMajor = clangMajor;
        this.clangMinor = clangMinor;
        this.clangPatch = clangPatch;
        this.clangVersion = clangVersion;
    }

    @NotNull
    public String toString() {
        return this.clangVersion;
    }

    @JvmStatic
    @NotNull
    public static final ExtendedServerInfo create(@NotNull ServerInfo serverInfo) {
        return Companion.create(serverInfo);
    }

    @JvmStatic
    @NotNull
    public static final ExtendedServerInfo createFallback() {
        return Companion.createFallback();
    }

    public /* synthetic */ ExtendedServerInfo(int clangMajor, int clangMinor, int clangPatch, String clangVersion, DefaultConstructorMarker $constructor_marker) {
        this(clangMajor, clangMinor, clangPatch, clangVersion);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0007\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ExtendedServerInfo$Companion;", "", "<init>", "()V", "create", "Lcom/jetbrains/cidr/lang/daemon/clang/clangd/lsp/server/ExtendedServerInfo;", "serverInfo", "Lorg/eclipse/lsp4j/ServerInfo;", "createFallback", "intellij.cidr.clangd"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ExtendedServerInfo create(@NotNull ServerInfo serverInfo) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)serverInfo, (String)"serverInfo");
            Matcher matcher = ClangUtils.VERSION_PATTERN.matcher(serverInfo.getVersion());
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Failed to parse version string: " + serverInfo.getVersion());
            }
            String version = matcher.group(1);
            Intrinsics.checkNotNull((Object)version);
            String[] stringArray = new String[]{"."};
            List majorMinorPatch = StringsKt.split$default((CharSequence)version, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean bl2 = bl = majorMinorPatch.size() == 3;
            if (_Assertions.ENABLED && !bl) {
                String string = "Assertion failed";
                throw new AssertionError((Object)string);
            }
            int clangMajor = Integer.parseInt((String)majorMinorPatch.get(0));
            int clangMinor = Integer.parseInt((String)majorMinorPatch.get(1));
            int clangPatch = Integer.parseInt((String)majorMinorPatch.get(2));
            String clangVersion = serverInfo.getVersion();
            Intrinsics.checkNotNull((Object)clangVersion);
            return new ExtendedServerInfo(clangMajor, clangMinor, clangPatch, clangVersion, null);
        }

        @JvmStatic
        @NotNull
        public final ExtendedServerInfo createFallback() {
            return new ExtendedServerInfo(14, 0, 0, "clangd version 14.0.0 (ssh://git@git.jetbrains.team/llvm-project.git 41b6170636aabaa99c5f78e36da3e741212c7190 based on LLVM 42b588a2000e872d63326a623982c75ab5ac28a9 revision)", null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

