/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.registry;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.lsp.ClangUrlConverter;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.AbstractClangWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangLocalWorkspace;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.ClangParseResponse;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.LocalWorkspaceFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.LocalWorkspaceFileImpl;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.PendingParseListener;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.PendingRequestsStorage;
import com.jetbrains.cidr.lang.daemon.clang.clangd.registry.WorkspaceFileListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ClangLocalWorkspaceImpl
extends AbstractClangWorkspace<LocalWorkspaceFile>
implements ClangLocalWorkspace,
WorkspaceFileListener,
PendingParseListener {
    static final Logger LOG = Logger.getInstance((String)ClangLocalWorkspaceImpl.class.getName());
    @NotNull
    private final ClangUrlConverter myConverter;
    @NotNull
    private final List<PendingParseListener> myPendingParseListeners;
    @NotNull
    private final AtomicLong myGlobalVersionCounter;

    public ClangLocalWorkspaceImpl(@NotNull ClangUrlConverter converter) {
        if (converter == null) {
            ClangLocalWorkspaceImpl.$$$reportNull$$$0(0);
        }
        this.myPendingParseListeners = new ArrayList<PendingParseListener>();
        this.myGlobalVersionCounter = new AtomicLong(0L);
        this.myConverter = converter;
    }

    @Override
    public void completePendingParses() {
        List<String> urls = this.getRegisteredUrls();
        for (String url : urls) {
            this.modify(url, (WF wf) -> {
                PendingRequestsStorage storage = wf.getOrDefault(LocalWorkspaceFileImpl.REQUESTS_STORAGE);
                storage.forEachPending(cf -> {
                    if (cf.getOpState() != ClangParseResponse.OpState.None) {
                        ClangParseResponse.completeAnswers(cf);
                    }
                    return true;
                });
            });
        }
    }

    @Override
    public int getMaxSizeOfPendingParsesQueue() {
        int maxSize = 0;
        for (String url : this.getRegisteredUrls()) {
            int fileQueueSize = this.apply(url, (WF wf) -> wf.getMaxSizeOfPendingParsesQueue());
            if (fileQueueSize <= maxSize) continue;
            maxSize = fileQueueSize;
        }
        return maxSize;
    }

    @Override
    public int getSizeOfPendingParses(@NotNull String url) {
        if (url == null) {
            ClangLocalWorkspaceImpl.$$$reportNull$$$0(1);
        }
        return this.apply(url, (WF wf) -> wf.getOrDefault(LocalWorkspaceFileImpl.REQUESTS_STORAGE).sizeOfPending());
    }

    @Override
    @NonNls
    @NotNull
    public String printStats(@NonNls @NotNull String linePrefix) {
        if (linePrefix == null) {
            ClangLocalWorkspaceImpl.$$$reportNull$$$0(2);
        }
        StringBuilder sb = new StringBuilder();
        List<String> urls = this.getRegisteredUrls();
        sb.append(linePrefix).append("Registered files number = ").append(urls.size()).append("\n");
        for (String url : urls) {
            int fileMemUsage = this.apply(url, (WF wf) -> {
                AtomicInteger memUsage = new AtomicInteger(0);
                ClangParseResponse lastResponse = wf.getLastParseResponse();
                if (lastResponse != null) {
                    memUsage.addAndGet(ClangParseResponse.getMemoryUsage(lastResponse));
                }
                wf.forEachPendingParse(pp -> {
                    if (pp != lastResponse) {
                        memUsage.addAndGet(ClangParseResponse.getMemoryUsage(pp));
                    }
                    return true;
                });
                return memUsage.get();
            });
            if (fileMemUsage <= 0) continue;
            sb.append(linePrefix).append(" - ").append(url).append(" -> ").append(ClangUtils.renderHumanReadableSize(fileMemUsage)).append("\n");
        }
        sb.append(linePrefix).append("Max size of pending requests queue = ").append(this.getMaxSizeOfPendingParsesQueue()).append("\n");
        sb.append(super.printStats(linePrefix + "Local "));
        String string = sb.toString();
        if (string == null) {
            ClangLocalWorkspaceImpl.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Override
    public void addPendingParseListener(@NotNull PendingParseListener listener) {
        if (listener == null) {
            ClangLocalWorkspaceImpl.$$$reportNull$$$0(4);
        }
        this.myPendingParseListeners.add(listener);
    }

    @Override
    public void onOverflow(@NotNull ClangParseResponse oldest) {
        if (oldest == null) {
            ClangLocalWorkspaceImpl.$$$reportNull$$$0(5);
        }
        for (PendingParseListener listener : this.myPendingParseListeners) {
            listener.onOverflow(oldest);
        }
    }

    @Override
    @NotNull
    protected LocalWorkspaceFile createWorkspaceFile(@NotNull String url) {
        if (url == null) {
            ClangLocalWorkspaceImpl.$$$reportNull$$$0(6);
        }
        return new LocalWorkspaceFileImpl(url, this.myGlobalVersionCounter, this.myConverter, this, this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "converter";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linePrefix";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangLocalWorkspaceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/clangd/registry/ClangLocalWorkspaceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "printStats";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getSizeOfPendingParses";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "printStats";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addPendingParseListener";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onOverflow";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createWorkspaceFile";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3 -> new IllegalStateException(string);
        };
    }
}

