/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.clangd.settings;

import com.intellij.DynamicBundle;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.codeInspection.ProjectInspectionProfileManager;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.TextAccessor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.ClangUtils;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettings;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangdSettingsListener;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import com.jetbrains.cidr.lang.settings.CPPLanguageConfigurable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangdConfigurable
extends CPPLanguageConfigurable {
    private JBCheckBox myShowErrorsFromClangdJBCheckBox;
    private JBCheckBox myUseClangTidyViaJBCheckBox;
    private JPanel myRootPanel;
    private JPanel myClangFlagsEditor;
    private JPanel myClangErrorsAndWarningsPanel;
    private JPanel myClangTidyPanel;
    private JPanel myClangNavigationPanel;
    private JPanel myClangParameterInfoPanel;
    private JBCheckBox myUseParameterInfoViaClangdCheckBox;
    private JPanel myClangdCompletionPanel;
    private JBCheckBox myUseNavigationViaClangdCheckBox;
    private JBCheckBox myClangdCompletionType;
    private JBCheckBox myClangdLookupNamespacesByDefault;
    private JBLabel myEnabledCLionInspectionsHint;
    private JPanel myClangdOptionsPanel;
    private JTextPane mySeeTheListOfTextPane;
    private JBLabel myClangdVersionLabel;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ClangdSettings mySettings;
    public static final String ID = "language.cpp.clangd";
    private ProgressIndicator myProgressIndicator;
    @NlsSafe
    private static final String TOOL_NAME = "clangd";

    public ClangdConfigurable(@NotNull Project project) {
        if (project == null) {
            ClangdConfigurable.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
        this.mySettings = ClangdSettings.getInstance(project);
    }

    @Nullable
    public JComponent createComponent() {
        this.initializeUI();
        return this.myRootPanel;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @Nullable
    public String getHelpTopic() {
        return "settings.clangd";
    }

    public boolean isModified() {
        return this.myShowErrorsFromClangdJBCheckBox.isSelected() != this.mySettings.isClangdShowErrors() || this.myUseClangTidyViaJBCheckBox.isSelected() != this.mySettings.isClangTidyViaClangd() || this.myUseNavigationViaClangdCheckBox.isSelected() != this.mySettings.isNavigationViaClangd() || this.myUseParameterInfoViaClangdCheckBox.isSelected() != this.mySettings.isParameterInfoViaClangd() || this.myClangdCompletionType.isSelected() != (this.mySettings.getCompletionType() == ClangdSettings.CompletionType.Clangd) || this.myClangdLookupNamespacesByDefault.isSelected() != this.mySettings.isCompleteInNamespacesByDefault() || !Objects.equals(this.mySettings.getClangFlags(), ((TextAccessor)this.myClangFlagsEditor).getText());
    }

    public void apply() throws ConfigurationException {
        this.saveSettings();
        ClangdSettings.rehighlight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        ClangdSettings clangdSettings = this.mySettings;
        synchronized (clangdSettings) {
            this.myShowErrorsFromClangdJBCheckBox.setSelected(this.mySettings.isClangdShowErrors());
            this.myUseClangTidyViaJBCheckBox.setSelected(this.mySettings.isClangTidyViaClangd());
            this.myUseNavigationViaClangdCheckBox.setSelected(this.mySettings.isNavigationViaClangd());
            this.myUseParameterInfoViaClangdCheckBox.setSelected(this.mySettings.isParameterInfoViaClangd());
            this.myClangdCompletionType.setSelected(this.mySettings.getCompletionType() == ClangdSettings.CompletionType.Clangd);
            this.myClangdLookupNamespacesByDefault.setSelected(this.mySettings.isCompleteInNamespacesByDefault());
            ((TextAccessor)this.myClangFlagsEditor).setText(this.mySettings.getClangFlags());
        }
    }

    @Nls
    public String getDisplayName() {
        return ClangdBundle.message("configurable.ClangdConfigurable.display.name", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveSettings() {
        ClangdSettings clangdSettings = this.mySettings;
        synchronized (clangdSettings) {
            this.mySettings.setClangdShowErrors(this.myShowErrorsFromClangdJBCheckBox.isSelected());
            this.mySettings.setClangTidyViaClangd(this.myUseClangTidyViaJBCheckBox.isSelected());
            this.mySettings.setNavigationViaClangd(this.myUseNavigationViaClangdCheckBox.isSelected());
            this.mySettings.setParameterInfoViaClangd(this.myUseParameterInfoViaClangdCheckBox.isSelected());
            this.mySettings.setCompletionType(this.myClangdCompletionType.isSelected() ? ClangdSettings.CompletionType.Clangd : ClangdSettings.CompletionType.Builtin);
            this.mySettings.setCompleteInNamespacesByDefault(this.myClangdLookupNamespacesByDefault.isSelected());
            this.mySettings.setClangFlags(((TextAccessor)this.myClangFlagsEditor).getText());
        }
    }

    private void initializeUI() {
        this.myClangErrorsAndWarningsPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ClangdBundle.message("language.cpp.clangd.errors.border.title", new Object[0]), (boolean)false));
        this.myClangTidyPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ClangdBundle.message("language.cpp.clangd.clang.tidy.inspections.border.title", new Object[0]), (boolean)false));
        this.myClangNavigationPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ClangdBundle.message("language.cpp.clangd.navigation.border.title", new Object[0]), (boolean)false));
        this.myClangParameterInfoPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ClangdBundle.message("language.cpp.clangd.parameter.info.border.title", new Object[0]), (boolean)false));
        this.myClangdCompletionPanel.setBorder((Border)IdeBorderFactory.createTitledBorder((String)ClangdBundle.message("language.cpp.clangd.completion.border.title", new Object[0]), (boolean)false));
        this.myClangErrorsAndWarningsPanel.setVisible(ClangdBridge.getClangErrorsAndWarnings());
        this.myClangNavigationPanel.setVisible(ClangdBridge.getNavigation());
        this.myClangParameterInfoPanel.setVisible(ClangdBridge.getParameterInfo());
        this.myClangdCompletionPanel.setVisible(ClangdBridge.getCompletion());
        ((TextAccessor)this.myClangFlagsEditor).setText(this.mySettings.getClangFlags());
        this.myShowErrorsFromClangdJBCheckBox.setSelected(this.mySettings.isClangdShowErrors());
        this.mySeeTheListOfTextPane.setBackground(this.myShowErrorsFromClangdJBCheckBox.getBackground());
        Messages.configureMessagePaneUi((JTextPane)this.mySeeTheListOfTextPane, (String)("<html><body bgcolor=" + ColorUtil.toHtmlColor((Color)this.myShowErrorsFromClangdJBCheckBox.getBackground()) + ClangdBundle.message("clangd.configurable.link.to.diagnostics", new Object[0]) + "</body></html>"), null);
        this.mySeeTheListOfTextPane.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                BrowserUtil.browse((String)e.getDescription());
            }
        });
        this.myUseClangTidyViaJBCheckBox.setSelected(this.mySettings.isClangTidyViaClangd());
        this.myUseNavigationViaClangdCheckBox.setSelected(this.mySettings.isNavigationViaClangd());
        this.myUseParameterInfoViaClangdCheckBox.setSelected(this.mySettings.isParameterInfoViaClangd());
        this.myClangdCompletionType.setSelected(this.mySettings.getCompletionType() == ClangdSettings.CompletionType.Clangd);
        this.myClangdLookupNamespacesByDefault.setSelected(this.mySettings.isCompleteInNamespacesByDefault());
        this.myClangdLookupNamespacesByDefault.setEnabled(this.myClangdCompletionType.isSelected());
        this.myClangdCompletionType.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ClangdConfigurable.this.myClangdLookupNamespacesByDefault.setEnabled(ClangdConfigurable.this.myClangdCompletionType.isSelected());
            }
        });
        final Runnable onShowErrorsStateChanged = () -> UIUtil.setEnabled((Component)this.myClangFlagsEditor, (boolean)this.myShowErrorsFromClangdJBCheckBox.isSelected(), (boolean)true);
        this.myShowErrorsFromClangdJBCheckBox.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                onShowErrorsStateChanged.run();
                ClangdSettings.rehighlight();
            }
        });
        Runnable onClangdEnableStateChanged = () -> {
            boolean enableOptions = this.mySettings.isClangdEnabled();
            ((ClangdSettingsListener)this.myProject.getMessageBus().syncPublisher(ClangdSettingsListener.TOPIC_UI)).onClangdOnChanged(enableOptions);
            UIUtil.setEnabled((Component)this.myClangdOptionsPanel, (boolean)enableOptions, (boolean)true);
            if (enableOptions) {
                onShowErrorsStateChanged.run();
            }
        };
        onClangdEnableStateChanged.run();
        this.myClangdVersionLabel.setCopyable(true);
        this.myClangdVersionLabel.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        this.myClangdVersionLabel.setText(ClangdBundle.message("configurable.clangTool.version.checking", TOOL_NAME));
        this.myProgressIndicator = new AbstractProgressIndicatorBase();
        ClangUtils.getClangToolVersionAsync(TOOL_NAME, ClangUtils.getBuiltinClangToolPath(TOOL_NAME).getPath()).thenAccept(output -> SwingUtilities.invokeLater(() -> {
            this.myProgressIndicator.checkCanceled();
            Matcher matcher = StringUtil.isNotEmpty((String)output) ? ClangUtils.VERSION_PATTERN.matcher((CharSequence)output) : null;
            this.myClangdVersionLabel.setText(ClangdConfigurable.getPrettyVersionAndRevisionText(matcher));
        }));
    }

    @NlsContexts.Label
    private static String getPrettyVersionAndRevisionText(@Nullable Matcher matcher) {
        String llvmRevision;
        String clionRevision;
        if (matcher == null || !matcher.matches()) {
            return ClangdBundle.message("configurable.clangTool.version.unable.check", TOOL_NAME);
        }
        Application application = ApplicationManager.getApplication();
        HtmlBuilder html = new HtmlBuilder();
        html.append(ClangdBundle.message("configurable.clangTool.version", TOOL_NAME, matcher.group(1))).br();
        if ((application.isInternal() || application.isEAP()) && (clionRevision = matcher.group(3)) != null) {
            html.append(ClangdBundle.message("configurable.clangTool.revision.internal", clionRevision)).br();
        }
        if ((llvmRevision = matcher.group(4)) != null) {
            html.append(ClangdBundle.message("configurable.clangTool.revision", llvmRevision));
        }
        return html.wrapWithHtmlBody().toString();
    }

    private void createUIComponents() {
        this.myClangFlagsEditor = new RawCommandLineEditor(text -> StringUtil.split((String)text, (String)","), checks -> StringUtil.join((Collection)checks, (String)","));
        this.myEnabledCLionInspectionsHint = this.createCLionInspectionsHint();
    }

    public void disposeUIResources() {
        if (this.myProgressIndicator != null && this.myProgressIndicator.isRunning()) {
            this.myProgressIndicator.cancel();
            this.myProgressIndicator = null;
        }
    }

    private JBLabel createCLionInspectionsHint() {
        String currentProfile = ((InspectionManagerBase)InspectionManager.getInstance((Project)this.myProject)).getCurrentProfile();
        ProjectInspectionProfileManager profileManager = ProjectInspectionProfileManager.getInstance((Project)this.myProject);
        InspectionProfileImpl profile = profileManager.getProfile(currentProfile);
        List<String> inspections = profile.getAllEnabledInspectionTools(this.myProject).stream().map(t -> t.getTool()).filter(t -> t.getTool() instanceof OCInspectionBase.CLionClangTidyBasedMarker).map(i -> i.getDisplayName()).sorted().toList();
        String inspectionsToEnable = StringUtil.join(inspections, (String)"<br/>");
        return ContextHelpLabel.create((String)ClangdBundle.message("language.cpp.clangd.will.enable.clion.inspections", inspectionsToEnable));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBLabel jBLabel;
        JBCheckBox jBCheckBox;
        JPanel jPanel;
        JBCheckBox jBCheckBox2;
        JBCheckBox jBCheckBox3;
        JPanel jPanel2;
        JBCheckBox jBCheckBox4;
        JPanel jPanel3;
        JBCheckBox jBCheckBox5;
        JPanel jPanel4;
        JTextPane jTextPane;
        JBCheckBox jBCheckBox6;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        this.createUIComponents();
        this.myRootPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myClangdOptionsPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(8, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel6, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null, 2));
        this.myClangErrorsAndWarningsPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel5.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel8.add((Component)spacer2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, new Dimension(14, 25), null));
        JPanel jPanel9 = this.myClangFlagsEditor;
        jPanel8.add((Component)jPanel9, new GridConstraints(1, 0, 1, 2, 0, 3, 3, 0, null, null, null));
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 0, -1, false, false));
        jPanel8.add((Component)jPanel10, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myShowErrorsFromClangdJBCheckBox = jBCheckBox6 = new JBCheckBox();
        jBCheckBox6.setHorizontalTextPosition(11);
        jBCheckBox6.setMargin(new Insets(0, 10, 0, 0));
        jBCheckBox6.setSelected(false);
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox6, DynamicBundle.getBundle((String)"messages/ClangdBundle", ClangdConfigurable.class).getString("language.cpp.clangd.show.errors.warnings"));
        jPanel10.add((Component)jBCheckBox6, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, new Dimension(230, 25), null));
        this.mySeeTheListOfTextPane = jTextPane = new JTextPane();
        jTextPane.setContentType("text/plain");
        jTextPane.setEditable(false);
        ((Component)jTextPane).setEnabled(true);
        jTextPane.setMargin(new Insets(0, 0, 0, 0));
        jTextPane.setText("text");
        jPanel10.add((Component)jTextPane, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null, 1));
        this.myClangTidyPanel = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseClangTidyViaJBCheckBox = jBCheckBox5 = new JBCheckBox();
        jBCheckBox5.setMargin(new Insets(4, 10, 4, 4));
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox5, DynamicBundle.getBundle((String)"messages/ClangdBundle", ClangdConfigurable.class).getString("language.cpp.clangd.use.clang.tidy"));
        jPanel4.add((Component)jBCheckBox5, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        Spacer spacer3 = new Spacer();
        jPanel4.add((Component)spacer3, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer4 = new Spacer();
        jPanel4.add((Component)spacer4, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel2 = this.myEnabledCLionInspectionsHint;
        jBLabel2.setText("");
        jPanel4.add((Component)jBLabel2, new GridConstraints(0, 1, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myClangNavigationPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel3, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseNavigationViaClangdCheckBox = jBCheckBox4 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox4, DynamicBundle.getBundle((String)"messages/ClangdBundle", ClangdConfigurable.class).getString("language.cpp.clangd.use.navigation"));
        jPanel3.add((Component)jBCheckBox4, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        Spacer spacer5 = new Spacer();
        jPanel3.add((Component)spacer5, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer6 = new Spacer();
        jPanel3.add((Component)spacer6, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer7 = new Spacer();
        jPanel6.add((Component)spacer7, new GridConstraints(7, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        Spacer spacer8 = new Spacer();
        jPanel6.add((Component)spacer8, new GridConstraints(4, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myClangdCompletionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel2, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myClangdCompletionType = jBCheckBox3 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox3, DynamicBundle.getBundle((String)"messages/ClangdBundle", ClangdConfigurable.class).getString("language.cpp.clangd.use.code.completion.via.clangd"));
        jPanel2.add((Component)jBCheckBox3, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        this.myClangdLookupNamespacesByDefault = jBCheckBox2 = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox2, DynamicBundle.getBundle((String)"messages/ClangdBundle", ClangdConfigurable.class).getString("language.cpp.clangd.lookup.completion.in.namespaces"));
        jBCheckBox2.setToolTipText(DynamicBundle.getBundle((String)"messages/ClangdBundle", ClangdConfigurable.class).getString("language.cpp.clangd.lookup.completion.in.namespaces.tooltip"));
        jPanel2.add((Component)jBCheckBox2, new GridConstraints(1, 0, 1, 1, 9, 0, 0, 0, null, null, null, 3));
        this.myClangParameterInfoPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel, new GridConstraints(5, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myUseParameterInfoViaClangdCheckBox = jBCheckBox = new JBCheckBox();
        this.$$$loadButtonText$$$((AbstractButton)jBCheckBox, DynamicBundle.getBundle((String)"messages/ClangdBundle", ClangdConfigurable.class).getString("language.cpp.clangd.use.parameter.info"));
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 1, 9, 0, 0, 0, null, null, null));
        Spacer spacer9 = new Spacer();
        jPanel.add((Component)spacer9, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer10 = new Spacer();
        jPanel.add((Component)spacer10, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myClangdVersionLabel = jBLabel = new JBLabel();
        jPanel6.add((Component)jBLabel, new GridConstraints(6, 0, 1, 1, 9, 0, 2, 2, null, null, null));
        JPanel jPanel11 = new JPanel();
        jPanel11.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel11, new GridConstraints(0, 0, 1, 1, 0, 3, 1, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/cidr/lang/daemon/clang/clangd/settings/ClangdConfigurable", "<init>"));
    }
}

