/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyDiagnostic;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class ClangTidyAnnotationHolder {
    private final State myState;
    private final String myFailReason;
    private final List<ClangTidyDiagnostic> myDiagnostics;

    private ClangTidyAnnotationHolder(@NotNull State state, @NotNull String failReason) {
        if (state == null) {
            ClangTidyAnnotationHolder.$$$reportNull$$$0(0);
        }
        if (failReason == null) {
            ClangTidyAnnotationHolder.$$$reportNull$$$0(1);
        }
        this.myState = state;
        this.myFailReason = failReason;
        this.myDiagnostics = null;
    }

    private ClangTidyAnnotationHolder(@NotNull List<? extends ClangTidyDiagnostic> diagnostics) {
        if (diagnostics == null) {
            ClangTidyAnnotationHolder.$$$reportNull$$$0(2);
        }
        this.myState = State.SUCCESS;
        this.myFailReason = null;
        this.myDiagnostics = new ArrayList<ClangTidyDiagnostic>(diagnostics);
    }

    public String getFailReason() {
        return this.myFailReason;
    }

    public List<ClangTidyDiagnostic> getDiagnostics() {
        return this.myDiagnostics;
    }

    public static ClangTidyAnnotationHolder error(@NotNull String reason) {
        if (reason == null) {
            ClangTidyAnnotationHolder.$$$reportNull$$$0(3);
        }
        return new ClangTidyAnnotationHolder(State.ERROR, reason);
    }

    public static ClangTidyAnnotationHolder warning(@NotNull String reason) {
        if (reason == null) {
            ClangTidyAnnotationHolder.$$$reportNull$$$0(4);
        }
        return new ClangTidyAnnotationHolder(State.WARNING, reason);
    }

    public static ClangTidyAnnotationHolder success(@NotNull List<? extends ClangTidyDiagnostic> diagnostics) {
        if (diagnostics == null) {
            ClangTidyAnnotationHolder.$$$reportNull$$$0(5);
        }
        return new ClangTidyAnnotationHolder(diagnostics);
    }

    public boolean isError() {
        return this.myState == State.ERROR;
    }

    public boolean isWarning() {
        return this.myState == State.WARNING;
    }

    public boolean isSuccess() {
        return this.myState == State.SUCCESS;
    }

    public boolean isFail() {
        return this.myState != State.SUCCESS;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "failReason";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/tidy/ClangTidyAnnotationHolder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "warning";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "success";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static enum State {
        SUCCESS,
        WARNING,
        ERROR;

    }
}

