/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.LogService;
import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.idea.protobuf.InvalidProtocolBufferException;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryProfiler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class MemoryLiveAllocationTable
extends DataStoreTable<MemoryStatements> {
    @NotNull
    private final LogService myLogService;

    @NotNull
    private LogService.Logger getLogger() {
        return this.myLogService.getLogger(MemoryLiveAllocationTable.class);
    }

    public MemoryLiveAllocationTable(@NotNull LogService logService) {
        this.myLogService = logService;
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        super.initialize(connection);
        try {
            this.createTable("Memory_AllocationContexts", "Session INTEGER NOT NULL", "Timestamp INTEGER", "Data BLOB", "PRIMARY KEY(Session, Timestamp)");
            this.createTable("Memory_AllocationEvents", "Session INTEGER NOT NULL", "Timestamp INTEGER", "Data BLOB", "PRIMARY KEY(Session, Timestamp)");
            this.createTable("Memory_JniGlobalReferences", "Session INTEGER NOT NULL", "Timestamp INTEGER", "Data BLOB", "PRIMARY KEY(Session, Timestamp)");
            this.createTable("Memory_AllocationSamplingRateEvent", "Session INTEGER NOT NULL", "Timestamp INTEGER", "Data BLOB", "PRIMARY KEY(Session, Timestamp)");
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            for (MemoryStatements statement : MemoryStatements.values()) {
                this.createStatement(statement, statement.getStatement());
            }
        }
        catch (SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
    }

    public List<Memory.BatchAllocationEvents> getAllocationEvents(Common.Session session, long startTime, long endTime) {
        ArrayList<Memory.BatchAllocationEvents> results = new ArrayList<Memory.BatchAllocationEvents>();
        try {
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_ALLOC_EVENTS, session.getSessionId(), startTime, endTime);
            while (resultSet.next()) {
                results.add(((Memory.BatchAllocationEvents.Builder)Memory.BatchAllocationEvents.newBuilder().mergeFrom(resultSet.getBytes(1))).build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        return results;
    }

    @NotNull
    public List<Memory.BatchAllocationContexts> getAllocationContexts(Common.Session session, long startTime, long endTime) {
        ArrayList<Memory.BatchAllocationContexts> results = new ArrayList<Memory.BatchAllocationContexts>();
        try {
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_ALLOC_CONTEXTS, session.getSessionId(), startTime, endTime);
            while (resultSet.next()) {
                results.add(((Memory.BatchAllocationContexts.Builder)Memory.BatchAllocationContexts.newBuilder().mergeFrom(resultSet.getBytes(1))).build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        return results;
    }

    private static Memory.JNIGlobalReferenceEvent readJniEventFromResultSet(ResultSet resultset, Memory.JNIGlobalReferenceEvent.Type type) throws SQLException {
        int objectTag = resultset.getInt("Tag");
        long refValue = resultset.getLong("RefValue");
        long timestamp = resultset.getLong("Timestamp");
        int threadId = resultset.getInt("ThreadId");
        byte[] backtrace = resultset.getBytes("Backtrace");
        Memory.JNIGlobalReferenceEvent.Builder event = Memory.JNIGlobalReferenceEvent.newBuilder();
        event.setEventType(type);
        event.setObjectTag(objectTag);
        event.setRefValue(refValue);
        event.setTimestamp(timestamp);
        event.setThreadId(threadId);
        if (backtrace != null && backtrace.length != 0) {
            try {
                event.setBacktrace(Memory.NativeBacktrace.parseFrom((byte[])backtrace));
            }
            catch (InvalidProtocolBufferException ex) {
                MemoryLiveAllocationTable.onError(ex);
            }
        }
        return event.build();
    }

    public List<Memory.BatchJNIGlobalRefEvent> getJniReferenceEvents(Common.Session session, long startTime, long endTime) {
        ArrayList<Memory.BatchJNIGlobalRefEvent> results = new ArrayList<Memory.BatchJNIGlobalRefEvent>();
        try {
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_JNI_EVENTS, session.getSessionId(), startTime, endTime);
            while (resultSet.next()) {
                results.add(((Memory.BatchJNIGlobalRefEvent.Builder)Memory.BatchJNIGlobalRefEvent.newBuilder().mergeFrom(resultSet.getBytes(1))).build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        return results;
    }

    public void insertJniReferenceData(@NotNull Common.Session session, @NotNull Memory.BatchJNIGlobalRefEvent sample) {
        this.execute(MemoryStatements.INSERT_JNI_REF, session.getSessionId(), sample.getTimestamp(), sample.toByteArray());
    }

    public void insertAllocationContexts(Common.Session session, Memory.BatchAllocationContexts sample) {
        Memory.BatchAllocationContexts.Builder convertedSampleBuilder = sample.toBuilder();
        List classes = convertedSampleBuilder.getClassesList();
        convertedSampleBuilder.clearClasses();
        List convertedClasses = classes.stream().map(klass -> klass.toBuilder().setClassName(MemoryLiveAllocationTable.jniToJavaName(klass.getClassName())).build()).collect(Collectors.toList());
        convertedSampleBuilder.addAllClasses(convertedClasses);
        this.execute(MemoryStatements.INSERT_ALLOC_CONTEXTS, session.getSessionId(), sample.getTimestamp(), convertedSampleBuilder.build().toByteArray());
    }

    public void insertAllocationEvents(Common.Session session, Memory.BatchAllocationEvents sample) {
        this.execute(MemoryStatements.INSERT_ALLOC_EVENTS, session.getSessionId(), sample.getTimestamp(), sample.toByteArray());
    }

    public void insertOrReplaceAllocationSamplingRateEvent(@NotNull Common.Session session, @NotNull MemoryProfiler.AllocationSamplingRateEvent event) {
        this.execute(MemoryStatements.INSERT_OR_REPLACE_ALLOCATION_SAMPLING_RATE_EVENT, session.getSessionId(), event.getTimestamp(), event.toByteArray());
    }

    @NotNull
    public List<MemoryProfiler.AllocationSamplingRateEvent> getAllocationSamplingRateEvents(long sessionId, long startTime, long endTime) {
        ArrayList<MemoryProfiler.AllocationSamplingRateEvent> results = new ArrayList<MemoryProfiler.AllocationSamplingRateEvent>();
        try {
            ResultSet resultSet = this.executeQuery(MemoryStatements.QUERY_ALLOCATION_SAMPLING_RATE_EVENTS_BY_TIME, sessionId, startTime, endTime);
            while (resultSet.next()) {
                results.add(((MemoryProfiler.AllocationSamplingRateEvent.Builder)MemoryProfiler.AllocationSamplingRateEvent.newBuilder().mergeFrom(resultSet.getBytes(1))).build());
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryLiveAllocationTable.onError(ex);
        }
        return results;
    }

    private static String jniToJavaName(String jniName) {
        Object javaName;
        if (jniName.isEmpty()) {
            return jniName;
        }
        int arrayDimension = 0;
        int classNameIndex = 0;
        while (jniName.charAt(classNameIndex) == '[') {
            ++arrayDimension;
            ++classNameIndex;
        }
        if (jniName.charAt(classNameIndex) == 'L') {
            javaName = jniName.substring(classNameIndex + 1, jniName.length() - 1).replace('/', '.');
        } else {
            javaName = jniName.substring(classNameIndex);
            switch (javaName) {
                case "Z": {
                    javaName = "boolean";
                    break;
                }
                case "B": {
                    javaName = "byte";
                    break;
                }
                case "C": {
                    javaName = "char";
                    break;
                }
                case "S": {
                    javaName = "short";
                    break;
                }
                case "I": {
                    javaName = "int";
                    break;
                }
                case "J": {
                    javaName = "long";
                    break;
                }
                case "F": {
                    javaName = "float";
                    break;
                }
                case "D": {
                    javaName = "double";
                    break;
                }
            }
        }
        while (arrayDimension > 0) {
            javaName = (String)javaName + "[]";
            --arrayDimension;
        }
        return javaName;
    }

    public static enum MemoryStatements {
        INSERT_ALLOC_CONTEXTS("INSERT OR IGNORE INTO Memory_AllocationContexts (Session, Timestamp, Data) VALUES (?, ?, ?)"),
        INSERT_ALLOC_EVENTS("INSERT OR IGNORE INTO Memory_AllocationEvents (Session, Timestamp, Data) VALUES (?, ?, ?)"),
        QUERY_ALLOC_CONTEXTS("SELECT Data FROM Memory_AllocationContexts WHERE Session = ? AND Timestamp > ? AND Timestamp <= ? ORDER BY Timestamp ASC"),
        QUERY_ALLOC_EVENTS("SELECT Data FROM Memory_AllocationEvents WHERE Session = ? AND Timestamp > ? AND Timestamp <= ? ORDER BY Timestamp ASC"),
        INSERT_JNI_REF("INSERT OR IGNORE INTO Memory_JniGlobalReferences (Session, Timestamp, Data) VALUES (?, ?, ?)"),
        QUERY_JNI_EVENTS("SELECT Data FROM Memory_JniGlobalReferences WHERE Session = ? AND Timestamp > ? AND Timestamp <= ? ORDER BY Timestamp ASC"),
        INSERT_OR_REPLACE_ALLOCATION_SAMPLING_RATE_EVENT("INSERT OR REPLACE INTO Memory_AllocationSamplingRateEvent (Session, Timestamp, Data) VALUES (?, ?, ?)"),
        QUERY_ALLOCATION_SAMPLING_RATE_EVENTS_BY_TIME("SELECT Data FROM Memory_AllocationSamplingRateEvent WHERE Session = ? AND Timestamp > ? AND Timestamp <= ? ORDER BY Timestamp ASC");

        @NotNull
        private final String mySqlStatement;

        private MemoryStatements(String sqlStatement) {
            this.mySqlStatement = sqlStatement;
        }

        @NotNull
        public String getStatement() {
            return this.mySqlStatement;
        }
    }
}

