/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.idea.protobuf.GeneratedMessageV3;
import com.android.tools.idea.protobuf.InvalidProtocolBufferException;
import com.android.tools.idea.protobuf.Message;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profiler.proto.MemoryProfiler;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemoryStatsTable
extends DataStoreTable<MemoryStatements> {
    @Override
    public void initialize(@NotNull Connection connection) {
        super.initialize(connection);
        try {
            this.createTable("Memory_Samples", "Session INTEGER NOT NULL", "Timestamp INTEGER", "Type INTEGER", "Data BLOB", "PRIMARY KEY(Session, Timestamp, Type)");
            this.createTable("Memory_AllocationInfo", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "InfoData BLOB", "LegacyEventsData BLOB", "PRIMARY KEY(Session, StartTime)");
            this.createTable("Memory_HeapDump", "Session INTEGER NOT NULL", "StartTime INTEGER", "EndTime INTEGER", "InfoData BLOB", "PRIMARY KEY(Session, StartTime)");
        }
        catch (SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
    }

    @Override
    public void prepareStatements() {
        try {
            for (MemoryStatements statement : MemoryStatements.values()) {
                this.createStatement(statement, statement.getStatement());
            }
        }
        catch (SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
    }

    @NotNull
    public MemoryProfiler.MemoryData getData(@NotNull MemoryProfiler.MemoryRequest request) {
        long sessionId = request.getSession().getSessionId();
        long startTime = request.getStartTime();
        long endTime = request.getEndTime();
        List<MemoryProfiler.MemoryData.MemorySample> memorySamples = this.getResultsInfo(MemoryStatements.QUERY_MEMORY, sessionId, startTime, endTime, MemoryProfiler.MemoryData.MemorySample.getDefaultInstance());
        List<MemoryProfiler.MemoryData.AllocStatsSample> allocStatsSamples = this.getResultsInfo(MemoryStatements.QUERY_ALLOC_STATS, sessionId, startTime, endTime, MemoryProfiler.MemoryData.AllocStatsSample.getDefaultInstance());
        List<MemoryProfiler.MemoryData.GcStatsSample> gcStatsSamples = this.getResultsInfo(MemoryStatements.QUERY_GC_STATS, sessionId, startTime, endTime, MemoryProfiler.MemoryData.GcStatsSample.getDefaultInstance());
        List<Memory.HeapDumpInfo> heapDumpSamples = this.getResultsInfo(MemoryStatements.QUERY_HEAP_INFO_BY_TIME, sessionId, startTime, endTime, Memory.HeapDumpInfo.getDefaultInstance());
        List<Memory.AllocationsInfo> allocationSamples = this.getResultsInfo(MemoryStatements.QUERY_ALLOCATION_INFO_BY_TIME, sessionId, startTime, endTime, Memory.AllocationsInfo.getDefaultInstance());
        return MemoryProfiler.MemoryData.newBuilder().addAllMemSamples(memorySamples).addAllAllocStatsSamples(allocStatsSamples).addAllGcStatsSamples(gcStatsSamples).addAllHeapDumpInfos(heapDumpSamples).addAllAllocationsInfo(allocationSamples).build();
    }

    public void insertMemory(@NotNull Common.Session session, @NotNull List<MemoryProfiler.MemoryData.MemorySample> samples) {
        for (MemoryProfiler.MemoryData.MemorySample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, session.getSessionId(), sample.getTimestamp(), MemorySamplesType.MEMORY.ordinal(), sample.toByteArray());
        }
    }

    public void insertAllocStats(@NotNull Common.Session session, @NotNull List<MemoryProfiler.MemoryData.AllocStatsSample> samples) {
        for (MemoryProfiler.MemoryData.AllocStatsSample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, session.getSessionId(), sample.getTimestamp(), MemorySamplesType.ALLOC_STATS.ordinal(), sample.toByteArray());
        }
    }

    public void insertGcStats(@NotNull Common.Session session, @NotNull List<MemoryProfiler.MemoryData.GcStatsSample> samples) {
        for (MemoryProfiler.MemoryData.GcStatsSample sample : samples) {
            this.execute(MemoryStatements.INSERT_SAMPLE, session.getSessionId(), sample.getStartTime(), MemorySamplesType.GC_STATS.ordinal(), sample.toByteArray());
        }
    }

    public void insertOrReplaceHeapInfo(@NotNull Common.Session session, @NotNull Memory.HeapDumpInfo info) {
        this.execute(MemoryStatements.INSERT_OR_REPLACE_HEAP_INFO, session.getSessionId(), info.getStartTime(), info.getEndTime(), info.toByteArray());
    }

    public List<Memory.HeapDumpInfo> getHeapDumpInfoByRequest(@NotNull Common.Session session, @NotNull MemoryProfiler.ListDumpInfosRequest request) {
        return this.getResultsInfo(MemoryStatements.QUERY_HEAP_INFO_BY_TIME, session.getSessionId(), request.getStartTime(), request.getEndTime(), Memory.HeapDumpInfo.getDefaultInstance());
    }

    public void insertOrReplaceAllocationsInfo(@NotNull Common.Session session, @NotNull Memory.AllocationsInfo info) {
        this.execute(MemoryStatements.INSERT_OR_REPLACE_ALLOCATIONS_INFO, session.getSessionId(), info.getStartTime(), info.getEndTime(), info.toByteArray());
    }

    @Nullable
    public Memory.AllocationsInfo getAllocationsInfo(@NotNull Common.Session session, long trackingStartTime) {
        try {
            byte[] bytes;
            ResultSet results = this.executeQuery(MemoryStatements.QUERY_ALLOCATION_INFO_BY_ID, session.getSessionId(), trackingStartTime);
            if (results.next() && (bytes = results.getBytes(1)) != null) {
                return Memory.AllocationsInfo.parseFrom((byte[])bytes);
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return null;
    }

    private <T extends GeneratedMessageV3> List<T> getResultsInfo(@NotNull MemoryStatements query, long sessionId, long startTime, long endTime, @NotNull T defaultInstance) {
        ArrayList<GeneratedMessageV3> datas = new ArrayList<GeneratedMessageV3>();
        try {
            ResultSet resultSet = this.executeQuery(query, sessionId, startTime, endTime);
            while (resultSet.next()) {
                Message data = defaultInstance.toBuilder().mergeFrom(resultSet.getBytes(1)).build();
                datas.add((GeneratedMessageV3)data);
            }
        }
        catch (InvalidProtocolBufferException | ClassCastException | SQLException ex) {
            MemoryStatsTable.onError(ex);
        }
        return datas;
    }

    public static enum MemoryStatements {
        INSERT_SAMPLE("INSERT OR IGNORE INTO Memory_Samples (Session, Timestamp, Type, Data) VALUES (?, ?, ?, ?)"),
        QUERY_MEMORY(String.format(Locale.US, "SELECT Data FROM Memory_Samples WHERE Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.MEMORY.ordinal())),
        QUERY_ALLOC_STATS(String.format(Locale.US, "SELECT Data FROM Memory_Samples WHERE Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.ALLOC_STATS.ordinal())),
        QUERY_GC_STATS(String.format(Locale.US, "SELECT Data FROM Memory_Samples WHERE Session = ? AND Type = %d AND TimeStamp > ? AND TimeStamp <= ?", MemorySamplesType.GC_STATS.ordinal())),
        INSERT_OR_REPLACE_HEAP_INFO("INSERT OR REPLACE INTO Memory_HeapDump (Session, StartTime, EndTime, InfoData) VALUES (?, ?, ?, ?)"),
        QUERY_HEAP_INFO_BY_TIME("SELECT InfoData FROM Memory_HeapDump where Session = ? AND EndTime > ? AND StartTime <= ?"),
        INSERT_OR_REPLACE_ALLOCATIONS_INFO("INSERT OR REPLACE INTO Memory_AllocationInfo (Session, StartTime, EndTime, InfoData) VALUES (?, ?, ?, ?)"),
        UPDATE_LEGACY_ALLOCATIONS_INFO_EVENTS("UPDATE Memory_AllocationInfo SET LegacyEventsData = ? WHERE Session = ? AND StartTime = ?"),
        QUERY_ALLOCATION_INFO_BY_TIME("SELECT InfoData FROM Memory_AllocationInfo WHERE Session = ? AND EndTime > ? AND StartTime <= ?"),
        QUERY_ALLOCATION_INFO_BY_ID("SELECT InfoData from Memory_AllocationInfo WHERE Session = ? AND StartTime = ?");

        @NotNull
        private final String mySqlStatement;

        private MemoryStatements(String sqlStatement) {
            this.mySqlStatement = sqlStatement;
        }

        @NotNull
        public String getStatement() {
            return this.mySqlStatement;
        }
    }

    private static enum MemorySamplesType {
        MEMORY,
        ALLOC_STATS,
        GC_STATS;

    }
}

