/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.datastore.database;

import com.android.tools.datastore.database.DataStoreTable;
import com.android.tools.idea.protobuf.InvalidProtocolBufferException;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Predicates;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UnifiedEventsTable
extends DataStoreTable<Statements> {
    @Override
    public void prepareStatements() {
        try {
            for (Statements statement : Statements.values()) {
                this.createStatement(statement, statement.getStatement());
            }
        }
        catch (SQLException ex) {
            UnifiedEventsTable.onError(ex);
        }
    }

    @Override
    public void initialize(@NotNull Connection connection) {
        super.initialize(connection);
        try {
            this.createTableIfNotExists("UnifiedEventsTable", "StreamId INTEGER NOT NULL", "ProcessId INTEGER NOT NULL", "GroupId INTEGER NOT NULL", "Kind INTEGER NOT NULL", "CommandId INTEGER NOT NULL", "Timestamp INTEGER NOT NULL", "IsEnded INTEGER NOT NULL", "Data BLOB");
            this.createTableIfNotExists("BytesTable", "StreamId INTEGER NOT NULL", "Id STRING NOT NULL", "Path STRING NOT NULL");
            this.createUniqueIndex("UnifiedEventsTable", "Kind", "StreamId", "ProcessId", "GroupId", "Timestamp", "IsEnded");
            this.createUniqueIndex("BytesTable", "StreamId", "Id");
        }
        catch (SQLException ex) {
            UnifiedEventsTable.onError(ex);
        }
    }

    public void insertUnifiedEvent(long streamId, @NotNull Common.Event event) {
        this.execute(Statements.INSERT_EVENT, streamId, event.getPid(), event.getGroupId(), event.getKind().getNumber(), event.getCommandId(), event.getTimestamp(), event.getIsEnded() ? 1 : 0, event.toByteArray());
    }

    public void deleteEvents(long streamId, int pid, long groupId, Common.Event.Kind kind, long fromTimestamp, long toTimestamp) {
        this.execute(Statements.DELETE_EVENTS, streamId, pid, groupId, kind.getNumber(), fromTimestamp, toTimestamp);
    }

    @VisibleForTesting
    public List<Common.Event> queryUnifiedEvents() {
        return this.queryUnifiedEvents(Statements.QUERY_EVENTS, new Object[0]);
    }

    public List<Transport.EventGroup> queryUnifiedEventGroups(@NotNull Transport.GetEventGroupsRequest request) {
        ArrayList<Number> baseParams = new ArrayList<Number>();
        ArrayList<Object> beforeRangeParams = null;
        ArrayList<Object> afterRangeParams = null;
        HashMap<Long, Transport.EventGroup.Builder> builderGroups = new HashMap<Long, Transport.EventGroup.Builder>();
        String sql = "SELECT Data, GroupId%s From [UnifiedEventsTable] WHERE Kind = ? %s";
        StringBuilder filter = new StringBuilder();
        baseParams.add(request.getKind().getNumber());
        if (request.getStreamId() != 0L) {
            filter.append(" AND StreamId = ?");
            baseParams.add(request.getStreamId());
        }
        if (request.getPid() != 0) {
            filter.append(" AND ProcessId = ?");
            baseParams.add(request.getPid());
        }
        if (request.getGroupId() != 0L) {
            filter.append(" AND GroupId = ?");
            baseParams.add(request.getGroupId());
        }
        if (request.getCommandId() != 0) {
            filter.append(" AND CommandId = ?");
            baseParams.add(request.getCommandId());
        }
        String sqlBefore = String.format(sql, ", IsEnded, MAX(Timestamp), MAX(ROWID)", filter.toString() + " AND Timestamp < ? GROUP BY GroupId");
        String sqlAfter = String.format(sql, ", MIN(Timestamp), MIN(ROWID)", filter.toString() + " AND Timestamp > ? GROUP BY GroupId");
        ArrayList<Object> inRangeQueryParams = new ArrayList<Object>(baseParams);
        if (request.getFromTimestamp() > 0L) {
            beforeRangeParams = new ArrayList<Object>(baseParams);
            beforeRangeParams.add(request.getFromTimestamp());
            filter.append(" AND Timestamp >= ?");
            inRangeQueryParams.add(request.getFromTimestamp());
        }
        if (request.getToTimestamp() > 0L && request.getToTimestamp() != Long.MAX_VALUE) {
            afterRangeParams = new ArrayList<Object>(baseParams);
            afterRangeParams.add(request.getToTimestamp());
            filter.append(" AND Timestamp <= ?");
            inRangeQueryParams.add(request.getToTimestamp());
        }
        if (beforeRangeParams != null) {
            this.gatherEvents(sqlBefore, beforeRangeParams, builderGroups, resultSet -> {
                try {
                    return !resultSet.getBoolean("IsEnded");
                }
                catch (SQLException e) {
                    UnifiedEventsTable.onError(e);
                    return false;
                }
            });
        }
        String query = String.format(sql, "", filter.toString());
        this.gatherEvents(query, inRangeQueryParams, builderGroups, (Predicate<ResultSet>)Predicates.alwaysTrue());
        if (afterRangeParams != null) {
            this.gatherEvents(sqlAfter, afterRangeParams, builderGroups, resultSet -> {
                try {
                    return builderGroups.containsKey(resultSet.getLong("GroupId"));
                }
                catch (SQLException e) {
                    UnifiedEventsTable.onError(e);
                    return false;
                }
            });
        }
        return builderGroups.values().stream().map(Transport.EventGroup.Builder::build).collect(Collectors.toList());
    }

    public void insertFile(long streamId, @NotNull String id, @NotNull Transport.FileResponse response) {
        this.execute(Statements.INSERT_FILE, streamId, id, response.getFilePath());
    }

    @Nullable
    public Transport.FileResponse getFile(@NotNull Transport.BytesRequest request) {
        try {
            ResultSet results = this.executeQuery(Statements.GET_FILE, request.getStreamId(), request.getId());
            if (results.next()) {
                return Transport.FileResponse.newBuilder().setFilePath(results.getString(1)).build();
            }
        }
        catch (SQLException ex) {
            UnifiedEventsTable.onError(ex);
        }
        return null;
    }

    private void gatherEvents(String sql, List<Object> params, HashMap<Long, Transport.EventGroup.Builder> builderGroups, Predicate<ResultSet> filter) {
        try {
            ResultSet results = this.executeOneTimeQuery(sql, params.toArray());
            while (results.next()) {
                Long groupId = results.getLong("GroupId");
                if (!filter.test(results)) continue;
                Transport.EventGroup.Builder group = builderGroups.computeIfAbsent(groupId, arg_0 -> ((Transport.EventGroup.Builder)Transport.EventGroup.newBuilder()).setGroupId(arg_0));
                group.addEvents((Common.Event)Common.Event.parser().parseFrom(results.getBytes("Data")));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            UnifiedEventsTable.onError(ex);
        }
    }

    private List<Common.Event> queryUnifiedEvents(Statements stmt, Object ... args) {
        ArrayList<Common.Event> records = new ArrayList<Common.Event>();
        try {
            ResultSet results = this.executeQuery(stmt, args);
            while (results.next()) {
                records.add((Common.Event)Common.Event.parser().parseFrom(results.getBytes(1)));
            }
        }
        catch (InvalidProtocolBufferException | SQLException ex) {
            UnifiedEventsTable.onError(ex);
        }
        return records;
    }

    public static enum Statements {
        INSERT_EVENT("INSERT OR IGNORE INTO [UnifiedEventsTable] (StreamId, ProcessId, GroupId, Kind, CommandId, Timestamp, IsEnded, Data) VALUES (?, ?, ?, ?, ?, ?, ?, ?)"),
        DELETE_EVENTS("DELETE FROM [UnifiedEventsTable] WHERE StreamId = ? AND ProcessId = ? And GroupId = ? And Kind = ? AND Timestamp >= ? AND Timestamp <= ?"),
        QUERY_EVENTS("SELECT Data FROM [UnifiedEventsTable]"),
        INSERT_FILE("INSERT OR IGNORE INTO [BytesTable] (StreamId, Id, Path) VALUES (?, ?, ?)"),
        GET_FILE("SELECT Path FROM [BytesTable] WHERE StreamId = ? AND Id = ?");

        @NotNull
        private final String mySqlStatement;

        private Statements(String sqlStatement) {
            this.mySqlStatement = sqlStatement;
        }

        @NotNull
        public String getStatement() {
            return this.mySqlStatement;
        }
    }
}

