/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.AxisComponent;
import com.android.tools.adtui.ComboCheckBox;
import com.android.tools.adtui.RangeTooltipComponent;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.common.AdtUiCursorType;
import com.android.tools.adtui.common.AdtUiCursorsProvider;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.adtui.common.StudioColorsKt;
import com.android.tools.adtui.flat.FlatSeparator;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.MultiSelectionModel;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ResizingAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.TimeAxisFormatter;
import com.android.tools.adtui.trackgroup.TrackGroupListPanel;
import com.android.tools.adtui.trackgroup.TrackRendererFactory;
import com.android.tools.profilers.DropDownButton;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.ProfilerFonts;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.ProfilerTooltipMouseAdapter;
import com.android.tools.profilers.ProfilerTrackRendererFactory;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StageView;
import com.android.tools.profilers.StringUtils;
import com.android.tools.profilers.StudioProfilersView;
import com.android.tools.profilers.cpu.AndroidFrameEventTooltipView;
import com.android.tools.profilers.cpu.AndroidFrameTimelineTooltipView;
import com.android.tools.profilers.cpu.BatteryDrainTooltip;
import com.android.tools.profilers.cpu.BatteryDrainTooltipView;
import com.android.tools.profilers.cpu.BufferQueueTooltipView;
import com.android.tools.profilers.cpu.CaptureNode;
import com.android.tools.profilers.cpu.CpuCaptureMinimapModel;
import com.android.tools.profilers.cpu.CpuCaptureMinimapView;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuCaptureStageCpuUsageTooltip;
import com.android.tools.profilers.cpu.CpuCaptureStageCpuUsageTooltipView;
import com.android.tools.profilers.cpu.CpuFrameTooltipView;
import com.android.tools.profilers.cpu.CpuFrequencyTooltipView;
import com.android.tools.profilers.cpu.CpuKernelTooltipView;
import com.android.tools.profilers.cpu.CpuThreadsTooltip;
import com.android.tools.profilers.cpu.CpuThreadsTooltipView;
import com.android.tools.profilers.cpu.PowerRailTooltipView;
import com.android.tools.profilers.cpu.RssMemoryTooltipView;
import com.android.tools.profilers.cpu.StatusPanel;
import com.android.tools.profilers.cpu.SurfaceflingerTooltipView;
import com.android.tools.profilers.cpu.VsyncTooltipView;
import com.android.tools.profilers.cpu.analysis.CpuAnalysisPanel;
import com.android.tools.profilers.cpu.capturedetails.CpuCaptureNodeTooltip;
import com.android.tools.profilers.cpu.capturedetails.CpuCaptureNodeTooltipView;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameEventTooltip;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineEvent;
import com.android.tools.profilers.cpu.systemtrace.AndroidFrameTimelineTooltip;
import com.android.tools.profilers.cpu.systemtrace.BufferQueueTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuFrameTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuFrequencyTooltip;
import com.android.tools.profilers.cpu.systemtrace.CpuKernelTooltip;
import com.android.tools.profilers.cpu.systemtrace.PowerRailTooltip;
import com.android.tools.profilers.cpu.systemtrace.RssMemoryTooltip;
import com.android.tools.profilers.cpu.systemtrace.SurfaceflingerTooltip;
import com.android.tools.profilers.cpu.systemtrace.VsyncTooltip;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.LifecycleTooltipView;
import com.android.tools.profilers.event.UserEventTooltip;
import com.android.tools.profilers.event.UserEventTooltipView;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.NotNull;

public class CpuCaptureStageView
extends StageView<CpuCaptureStage> {
    private static final double TIMELINE_PAN_FACTOR = 0.1;
    private static final double TIMELINE_DRAG_FACTOR = 0.001;
    private static final String ZOOM_IN_KEY = "zoom_in";
    private static final String ZOOM_OUT_KEY = "zoom_out";
    private static final String PAN_LEFT_KEY = "pan_left";
    private static final String PAN_RIGHT_KEY = "pan_right";
    private static final String PANNING_MODE_ON_KEY = "panning_mode_on";
    private static final String PANNING_MODE_OFF_KEY = "panning_mode_off";
    private final ProfilerTrackRendererFactory myTrackRendererFactory;
    private final TrackGroupListPanel myTrackGroupList;
    private final CpuAnalysisPanel myAnalysisPanel;
    private final JScrollPane myScrollPane;
    private final LinkLabel<?> myDeselectAllLabel;
    private final JPanel myDeselectAllToolbar;
    private final JButton myCollapseFrameButton = DropDownButton.of("Collapse frames", (Function0<? extends JComponent>)((Function0)() -> ComboCheckBox.of(new ArrayList<String>(((CpuCaptureStage)((Object)((Object)this.getStage()))).getCapture().getTags()), ((CpuCaptureStage)((Object)((Object)this.getStage()))).getCapture().getCollapsedTags(), selected -> {
        ((CpuCaptureStage)((Object)((Object)((Object)this.getStage())))).getCapture().collapseNodesWithTags(new HashSet<String>((Collection<String>)selected));
        this.onTrackGroupSelectionChange();
        this.updateComponents();
        this.getComponent().requestFocus();
        return Unit.INSTANCE;
    }, (String)"Apply", StringUtils::abbreviatePath)));
    private final JBCheckBox myVsyncBackgroundCheckBox = new JBCheckBox("VSync guide", true);
    private boolean myIsPanningMode = false;

    public CpuCaptureStageView(@NotNull StudioProfilersView view, @NotNull CpuCaptureStage stage) {
        super(view, stage);
        this.myTrackRendererFactory = new ProfilerTrackRendererFactory(this.getProfilersView(), () -> this.myVsyncBackgroundCheckBox.isSelected());
        this.myTrackGroupList = this.createTrackGroupListPanel();
        this.myScrollPane = new JBScrollPane((Component)this.myTrackGroupList.getComponent(), 20, 31);
        this.myScrollPane.setBorder((Border)JBUI.Borders.empty());
        this.myAnalysisPanel = new CpuAnalysisPanel(view, stage);
        this.myDeselectAllToolbar = new JPanel(ProfilerLayout.createToolbarLayout());
        this.myDeselectAllLabel = this.createDeselectAllLabel();
        this.myVsyncBackgroundCheckBox.addItemListener(e -> {
            this.getComponent().invalidate();
            this.getComponent().repaint();
        });
        this.getTooltipBinder().bind(CpuCaptureStageCpuUsageTooltip.class, CpuCaptureStageCpuUsageTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(CpuFrameTooltip.class, CpuFrameTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(CpuThreadsTooltip.class, CpuThreadsTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(CpuCaptureNodeTooltip.class, CpuCaptureNodeTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(CpuKernelTooltip.class, CpuKernelTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(UserEventTooltip.class, UserEventTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(LifecycleTooltip.class, LifecycleTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(SurfaceflingerTooltip.class, SurfaceflingerTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(VsyncTooltip.class, VsyncTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(BufferQueueTooltip.class, BufferQueueTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(RssMemoryTooltip.class, RssMemoryTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(PowerRailTooltip.class, PowerRailTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(BatteryDrainTooltip.class, BatteryDrainTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(CpuFrequencyTooltip.class, CpuFrequencyTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(AndroidFrameEventTooltip.class, AndroidFrameEventTooltipView::new);
        this.myTrackGroupList.getTooltipBinder().bind(AndroidFrameTimelineTooltip.class, AndroidFrameTimelineTooltipView::new);
        stage.getAspect().addDependency((AspectObserver)this).onChange((Enum)CpuCaptureStage.Aspect.STATE, this::updateComponents);
        stage.getMultiSelectionModel().addDependency((AspectObserver)this).onChange((Enum)MultiSelectionModel.Aspect.SELECTIONS_CHANGED, this::onTrackGroupSelectionChange).onChange((Enum)MultiSelectionModel.Aspect.ACTIVE_SELECTION_CHANGED, this::updateTrackGroupList);
        this.updateComponents();
    }

    @Override
    public JComponent getToolbar() {
        JPanel panel = new JPanel(new BorderLayout());
        this.myDeselectAllToolbar.add((Component)this.myDeselectAllLabel);
        this.myDeselectAllToolbar.add((Component)new FlatSeparator());
        this.myDeselectAllToolbar.setVisible(false);
        JPanel leftPanel = new JPanel();
        leftPanel.setBorder(BorderFactory.createEmptyBorder(0, 6, 0, 0));
        leftPanel.setLayout(new BoxLayout(leftPanel, 2));
        leftPanel.add(this.myCollapseFrameButton);
        leftPanel.add((Component)this.myVsyncBackgroundCheckBox);
        panel.add((Component)this.myDeselectAllToolbar, "East");
        panel.add((Component)leftPanel, "West");
        return panel;
    }

    private void updateComponents() {
        this.getComponent().removeAll();
        if (((CpuCaptureStage)((Object)this.getStage())).getState() == CpuCaptureStage.State.PARSING) {
            this.getComponent().add(new StatusPanel(((CpuCaptureStage)((Object)this.getStage())).getCaptureHandler(), "Parsing", "Abort"));
            this.myCollapseFrameButton.setVisible(false);
            this.myVsyncBackgroundCheckBox.setVisible(false);
        } else {
            this.unregisterAnalyzingEvents();
            this.registerAnalyzingEvents();
            this.getComponent().add(this.createAnalyzingComponents());
            this.getComponent().revalidate();
            this.myTrackGroupList.getComponent().requestFocusInWindow();
            this.myCollapseFrameButton.setVisible(!((CpuCaptureStage)((Object)this.getStage())).getCapture().getTags().isEmpty());
            this.myVsyncBackgroundCheckBox.setVisible(((CpuCaptureStage)((Object)this.getStage())).getCapture().getSystemTraceData() != null);
        }
    }

    private void registerAnalyzingEvents() {
        ((CpuCaptureStage)((Object)this.getStage())).getMinimapModel().getRangeSelectionModel().addDependency((AspectObserver)this).onChange((Enum)RangeSelectionModel.Aspect.SELECTION, this::updateTrackGroupList);
        ((CpuCaptureStage)((Object)this.getStage())).getCapture().getCaptureNodes().forEach(node -> node.getAspectModel().addDependency((AspectObserver)this).onChange((Enum)CaptureNode.Aspect.FILTER_APPLIED, this::updateTrackGroupList));
    }

    private void unregisterAnalyzingEvents() {
        ((CpuCaptureStage)((Object)this.getStage())).getMinimapModel().getRangeSelectionModel().removeDependencies((AspectObserver)this);
        ((CpuCaptureStage)((Object)this.getStage())).getCapture().getCaptureNodes().forEach(node -> node.getAspectModel().removeDependencies((AspectObserver)this));
    }

    private JComponent createAnalyzingComponents() {
        if (((CpuCaptureStage)((Object)this.getStage())).getCapture().getRange().isEmpty()) {
            JPanel container = new JPanel(new BorderLayout());
            JLabel label = new JLabel("<html><div style='text-align: center;'>This trace was recorded successfully but it doesn't contain any CPU usage data.<br>Please interact with the app to generate data while recording a trace.</div></html>");
            label.setFont(ProfilerFonts.H3_FONT);
            label.setHorizontalAlignment(0);
            label.setVerticalAlignment(0);
            container.add(label);
            return container;
        }
        CpuCaptureMinimapModel minimapModel = ((CpuCaptureStage)((Object)this.getStage())).getMinimapModel();
        CpuCaptureMinimapView minimap = new CpuCaptureMinimapView(minimapModel);
        RangeTooltipComponent minimapTooltipComponent = new RangeTooltipComponent(((CpuCaptureStage)((Object)this.getStage())).getCaptureTimeline(), (JComponent)this.getTooltipPanel(), this.getProfilersView().getComponent(), () -> false);
        minimap.registerRangeTooltipComponent(minimapTooltipComponent);
        minimap.addMouseListener(new ProfilerTooltipMouseAdapter((Stage)((Object)this.getStage()), () -> new CpuCaptureStageCpuUsageTooltip(minimapModel.getCpuUsage(), ((CpuCaptureStage)((Object)((Object)this.getStage()))).getCaptureTimeline().getTooltipRange())));
        this.loadTrackGroupModels();
        JPanel container = new JPanel((LayoutManager)new TabularLayout("*", "Fit-,*"));
        container.add((Component)minimapTooltipComponent, new TabularLayout.Constraint(0, 0));
        container.add((Component)minimap.getComponent(), new TabularLayout.Constraint(0, 0));
        container.add((Component)this.myScrollPane, new TabularLayout.Constraint(1, 0));
        container.add((Component)CpuCaptureStageView.createBottomAxisPanel(minimapModel.getRangeSelectionModel().getSelectionRange()), new TabularLayout.Constraint(2, 0));
        JBSplitter splitter = new JBSplitter(false, 0.5f);
        splitter.setFirstComponent((JComponent)container);
        splitter.setSecondComponent(this.myAnalysisPanel.getComponent());
        splitter.getDivider().setBorder(JBUI.Borders.customLine((Color)StudioColorsKt.getBorder(), (int)0, (int)1, (int)0, (int)1));
        this.initKeyBindings((JComponent)splitter);
        return splitter;
    }

    private void initKeyBindings(@NotNull JComponent container) {
        InputMap inputMap = container.getInputMap(1);
        ActionMap actionMap = container.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(87, 0), ZOOM_IN_KEY);
        inputMap.put(KeyStroke.getKeyStroke(83, 0), ZOOM_OUT_KEY);
        inputMap.put(KeyStroke.getKeyStroke(65, 0), PAN_LEFT_KEY);
        inputMap.put(KeyStroke.getKeyStroke(68, 0), PAN_RIGHT_KEY);
        inputMap.put(KeyStroke.getKeyStroke(32, 0), PANNING_MODE_ON_KEY);
        inputMap.put(KeyStroke.getKeyStroke(32, 0, true), PANNING_MODE_OFF_KEY);
        actionMap.put(ZOOM_IN_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().zoomIn();
                CpuCaptureStageView.this.getProfilersView().getStudioProfilers().getIdeServices().getFeatureTracker().trackZoomIn();
            }
        });
        actionMap.put(ZOOM_OUT_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().zoomOut();
                CpuCaptureStageView.this.getProfilersView().getStudioProfilers().getIdeServices().getFeatureTracker().trackZoomOut();
            }
        });
        actionMap.put(PAN_LEFT_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().panView(-((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().getViewRange().getLength() * 0.1);
            }
        });
        actionMap.put(PAN_RIGHT_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().panView(((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().getViewRange().getLength() * 0.1);
            }
        });
        actionMap.put(PANNING_MODE_ON_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CpuCaptureStageView.this.setPanningMode(true, CpuCaptureStageView.this.myTrackGroupList);
            }
        });
        actionMap.put(PANNING_MODE_OFF_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CpuCaptureStageView.this.setPanningMode(false, CpuCaptureStageView.this.myTrackGroupList);
            }
        });
    }

    @NotNull
    private TrackGroupListPanel createTrackGroupListPanel() {
        TrackGroupListPanel trackGroupListPanel = new TrackGroupListPanel((TrackRendererFactory)this.myTrackRendererFactory);
        MouseAdapter mouseListener = new MouseAdapter(){
            private int myLastX = 0;

            @Override
            public void mousePressed(MouseEvent e) {
                if (CpuCaptureStageView.this.myIsPanningMode) {
                    this.myLastX = e.getX();
                }
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                if (CpuCaptureStageView.this.myIsPanningMode) {
                    int deltaX = this.myLastX - e.getX();
                    this.myLastX = e.getX();
                    ((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().panView(((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().getViewRange().getLength() * (double)deltaX * 0.001);
                }
            }
        };
        trackGroupListPanel.getComponent().addMouseListener(mouseListener);
        trackGroupListPanel.getComponent().addMouseMotionListener(mouseListener);
        trackGroupListPanel.getComponent().addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (AdtUiUtils.isActionKeyDown((InputEvent)e)) {
                    if (e.isShiftDown()) {
                        return;
                    }
                    int wheelRotation = e.getWheelRotation();
                    if (wheelRotation != 0) {
                        if (wheelRotation > 0) {
                            ((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().zoomOut();
                            CpuCaptureStageView.this.getProfilersView().getStudioProfilers().getIdeServices().getFeatureTracker().trackZoomOut();
                        } else {
                            ((CpuCaptureStage)((Object)CpuCaptureStageView.this.getStage())).getTimeline().zoomIn();
                            CpuCaptureStageView.this.getProfilersView().getStudioProfilers().getIdeServices().getFeatureTracker().trackZoomIn();
                        }
                    }
                } else {
                    e.setSource(CpuCaptureStageView.this.myScrollPane);
                    CpuCaptureStageView.this.myScrollPane.dispatchEvent(e);
                }
            }
        });
        return trackGroupListPanel;
    }

    private void setPanningMode(boolean isPanningMode, @NotNull TrackGroupListPanel trackGroupListPanel) {
        this.myIsPanningMode = isPanningMode;
        trackGroupListPanel.setEnabled(!isPanningMode);
        this.getProfilersView().getComponent().setCursor(isPanningMode ? AdtUiCursorsProvider.getInstance().getCursor(AdtUiCursorType.GRABBING) : null);
    }

    private static JComponent createBottomAxisPanel(@NotNull Range range) {
        JPanel axisPanel = new JPanel((LayoutManager)new TabularLayout("150px,*"));
        axisPanel.setBackground(ProfilerColors.DEFAULT_BACKGROUND);
        AxisComponent timeAxis = new AxisComponent((AxisComponentModel)new ResizingAxisComponentModel.Builder(range, (BaseAxisFormatter)TimeAxisFormatter.DEFAULT).build(), AxisComponent.AxisOrientation.BOTTOM, true);
        timeAxis.setMinimumSize(new Dimension(0, ProfilerLayout.TIME_AXIS_HEIGHT));
        timeAxis.setPreferredSize(new Dimension(Integer.MAX_VALUE, ProfilerLayout.TIME_AXIS_HEIGHT));
        axisPanel.add((Component)timeAxis, new TabularLayout.Constraint(0, 1));
        return axisPanel;
    }

    private LinkLabel<?> createDeselectAllLabel() {
        LinkLabel label = LinkLabel.create((String)"Clear thread/event selection", () -> ((CpuCaptureStage)((Object)((Object)this.getStage()))).getMultiSelectionModel().clearSelection());
        label.setBorder((Border)new JBEmptyBorder(0, 0, 0, 4));
        label.setToolTipText("Click to deselect all threads/events");
        return label;
    }

    private void updateTrackGroupList() {
        this.myTrackGroupList.getComponent().updateUI();
        this.onActiveSelectionChange();
    }

    private void loadTrackGroupModels() {
        this.myTrackGroupList.setRangeTooltipComponent(new RangeTooltipComponent(((CpuCaptureStage)((Object)this.getStage())).getTimeline(), (JComponent)this.myTrackGroupList.getTooltipPanel(), this.getProfilersView().getComponent(), () -> false));
        this.myTrackGroupList.loadTrackGroups(((CpuCaptureStage)((Object)this.getStage())).getTrackGroupModels(), true);
        this.myTrackGroupList.registerMultiSelectionModel(((CpuCaptureStage)((Object)this.getStage())).getMultiSelectionModel());
    }

    private void onTrackGroupSelectionChange() {
        this.updateTrackGroupList();
        this.myDeselectAllToolbar.setVisible(!((CpuCaptureStage)((Object)this.getStage())).getMultiSelectionModel().getSelections().isEmpty());
    }

    private void onActiveSelectionChange() {
        Object selection = ((CpuCaptureStage)((Object)this.getStage())).getMultiSelectionModel().getActiveSelectionKey();
        Range selectionRange = ((CpuCaptureStage)((Object)this.getStage())).getTimeline().getSelectionRange();
        if (selection == null) {
            selectionRange.clear();
        } else if (selection instanceof CaptureNode) {
            selectionRange.set((double)((CaptureNode)selection).getStart(), (double)((CaptureNode)selection).getEnd());
        } else if (selection instanceof AndroidFrameTimelineEvent) {
            selectionRange.set((double)((AndroidFrameTimelineEvent)selection).getExpectedStartUs(), (double)((AndroidFrameTimelineEvent)selection).getActualEndUs());
        }
    }

    @VisibleForTesting
    @NotNull
    protected final TrackGroupListPanel getTrackGroupList() {
        return this.myTrackGroupList;
    }

    @VisibleForTesting
    @NotNull
    protected final CpuAnalysisPanel getAnalysisPanel() {
        return this.myAnalysisPanel;
    }

    @VisibleForTesting
    LinkLabel<?> getDeselectAllLabel() {
        return this.myDeselectAllLabel;
    }

    @VisibleForTesting
    JPanel getDeselectAllToolbar() {
        return this.myDeselectAllToolbar;
    }
}

