/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.NumberFormatter;
import com.android.tools.profilers.cpu.systemtrace.RssMemoryTooltip;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0016\u001a\u00020\u0003H\u0014J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002J\u0010\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R!\u0010\u0013\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0014\u0010\u0010\u001a\u0004\b\u0015\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/profilers/cpu/RssMemoryTooltipView;", "Lcom/android/tools/adtui/TooltipView;", "parent", "Ljavax/swing/JComponent;", "tooltip", "Lcom/android/tools/profilers/cpu/systemtrace/RssMemoryTooltip;", "<init>", "(Ljavax/swing/JComponent;Lcom/android/tools/profilers/cpu/systemtrace/RssMemoryTooltip;)V", "getTooltip", "()Lcom/android/tools/profilers/cpu/systemtrace/RssMemoryTooltip;", "content", "Ljavax/swing/JPanel;", "descriptionLabel", "Ljavax/swing/JLabel;", "Lorg/jetbrains/annotations/NotNull;", "getDescriptionLabel$annotations", "()V", "getDescriptionLabel", "()Ljavax/swing/JLabel;", "valueLabel", "getValueLabel$annotations", "getValueLabel", "createTooltip", "updateView", "", "getTitle", "", "counterName", "getDescriptionText", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
public final class RssMemoryTooltipView
extends TooltipView {
    @NotNull
    private final RssMemoryTooltip tooltip;
    @NotNull
    private final JPanel content;
    @NotNull
    private final JLabel descriptionLabel;
    @NotNull
    private final JLabel valueLabel;
    public static final int $stable = 8;

    public RssMemoryTooltipView(@NotNull JComponent parent, @NotNull RssMemoryTooltip tooltip) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)((Object)tooltip), (String)"tooltip");
        super(tooltip.getTimeline());
        this.tooltip = tooltip;
        this.content = new JPanel((LayoutManager)new TabularLayout("*").setVGap(12));
        JLabel jLabel = TooltipView.createTooltipLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"createTooltipLabel(...)");
        this.descriptionLabel = jLabel;
        JLabel jLabel2 = TooltipView.createTooltipLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel2, (String)"createTooltipLabel(...)");
        this.valueLabel = jLabel2;
        this.content.add((Component)this.valueLabel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        this.content.add((Component)this.descriptionLabel, new TabularLayout.Constraint(1, 0, 0, 4, null));
        this.tooltip.addDependency((AspectObserver)this).onChange((Enum)RssMemoryTooltip.Aspect.VALUE_CHANGED, () -> RssMemoryTooltipView._init_$lambda$0(this));
        this.updateView();
    }

    @NotNull
    public final RssMemoryTooltip getTooltip() {
        return this.tooltip;
    }

    @NotNull
    public final JLabel getDescriptionLabel() {
        return this.descriptionLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDescriptionLabel$annotations() {
    }

    @NotNull
    public final JLabel getValueLabel() {
        return this.valueLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getValueLabel$annotations() {
    }

    @NotNull
    protected JComponent createTooltip() {
        return this.content;
    }

    private final void updateView() {
        this.descriptionLabel.setText("<html>" + this.getDescriptionText(this.tooltip.getCounterName()) + "</html>");
        String string = NumberFormatter.formatFileSize((long)this.tooltip.getActiveValueBytes());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatFileSize(...)");
        String rssValueText = string;
        this.valueLabel.setText(this.getTitle(this.tooltip.getCounterName()) + ": " + rssValueText);
    }

    private final String getTitle(String counterName) {
        return switch (counterName) {
            case "mem.rss" -> "Total Resident Memory Utilization";
            case "mem.rss.anon" -> "Resident Memory Allocations";
            case "mem.rss.file" -> "Resident File Mapping Memory";
            case "mem.rss.shmem" -> "Resident Shared Memory";
            default -> "Value";
        };
    }

    private final String getDescriptionText(String counterName) {
        return switch (counterName) {
            case "mem.rss" -> "The total of all physical memory in use by the process,<br>including allocations, file mappings and shared memory.<br><br>/proc/&lt;pid&gt;/status reports this value as \"VmRSS\".";
            case "mem.rss.anon" -> "The amount of physical memory the process is using for normal<br>memory allocations (those backed by the swap file, and that<br>are not shared).<br><br>/proc/&lt;pid&gt;/status reports this value as \"RssAnon\".";
            case "mem.rss.file" -> "The amount of physical memory the process is using for file mappings -<br>that is, memory which is used for files that have been mapped into<br>a region of memory by the memory manager.<br><br>/proc/&lt;pid&gt;/status reports this value as \"RssFile\"";
            case "mem.rss.shmem" -> "The amount of physical memory the process is using for interprocess sharing.<br><br>/proc/&lt;pid&gt;/status reports this value as \"RssShmem\".";
            default -> "";
        };
    }

    private static final void _init_$lambda$0(RssMemoryTooltipView this$0) {
        this$0.updateView();
    }
}

