/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.StateChartModel;
import com.android.tools.profilers.ProfilerColors;
import com.android.tools.profilers.cpu.Interval;
import com.android.tools.profilers.cpu.LazyDataSeries;
import com.android.tools.profilers.cpu.VsyncPanel;
import com.android.tools.profilers.cpu.VsyncPanelKt;
import com.intellij.ide.ui.UISettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J4\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\n2\u0006\u0010\r\u001a\u00020\u000eH\u0007J&\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0007\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/profilers/cpu/VsyncPanel;", "", "<init>", "()V", "of", "Ljavax/swing/JComponent;", "content", "viewRange", "Lcom/android/tools/adtui/model/Range;", "vsyncValues", "", "Lcom/android/tools/adtui/model/SeriesData;", "", "vsyncEnabler", "Ljava/util/function/BooleanSupplier;", "series", "Lcom/android/tools/adtui/model/RangedSeries;", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=1)
public final class VsyncPanel {
    @NotNull
    public static final VsyncPanel INSTANCE = new VsyncPanel();
    public static final int $stable;

    private VsyncPanel() {
    }

    @JvmStatic
    @NotNull
    public static final JComponent of(@NotNull JComponent content, @NotNull Range viewRange, @NotNull List<SeriesData<Long>> vsyncValues, @NotNull BooleanSupplier vsyncEnabler) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)viewRange, (String)"viewRange");
        Intrinsics.checkNotNullParameter(vsyncValues, (String)"vsyncValues");
        Intrinsics.checkNotNullParameter((Object)vsyncEnabler, (String)"vsyncEnabler");
        return VsyncPanel.of(content, (RangedSeries<Long>)new RangedSeries(viewRange, (DataSeries)new LazyDataSeries(() -> VsyncPanel.of$lambda$0(vsyncValues)), null, 4, null), vsyncEnabler);
    }

    @JvmStatic
    @NotNull
    public static final JComponent of(@NotNull JComponent content, @NotNull RangedSeries<Long> series, @NotNull BooleanSupplier vsyncEnabler) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter(series, (String)"series");
        Intrinsics.checkNotNullParameter((Object)vsyncEnabler, (String)"vsyncEnabler");
        Serializable serializable = new BorderLayout();
        Serializable $this$of_u24lambda_u241 = serializable = new JPanel(series, vsyncEnabler, (BorderLayout)serializable){
            private final StateChartModel<Long> model;
            private final AspectObserver observer;
            private boolean intervalsInViewUpdated;
            private final List<Interval> intervalsInView;
            final /* synthetic */ BooleanSupplier $vsyncEnabler;
            {
                void $this$model_u24lambda_u240;
                StateChartModel stateChartModel;
                this.$vsyncEnabler = $vsyncEnabler;
                super($super_call_param$1);
                StateChartModel stateChartModel2 = stateChartModel = new StateChartModel();
                of.2 var7_6 = this;
                boolean bl = false;
                $this$model_u24lambda_u240.addSeries($series);
                var7_6.model = stateChartModel;
                this.observer = new AspectObserver();
                this.intervalsInView = new ArrayList<E>();
            }

            public final StateChartModel<Long> getModel() {
                return this.model;
            }

            public final AspectObserver getObserver() {
                return this.observer;
            }

            public final boolean getIntervalsInViewUpdated() {
                return this.intervalsInViewUpdated;
            }

            public final void setIntervalsInViewUpdated(boolean bl) {
                this.intervalsInViewUpdated = bl;
            }

            public final List<Interval> getIntervalsInView() {
                return this.intervalsInView;
            }

            protected void paintComponent(Graphics g) {
                Intrinsics.checkNotNullParameter((Object)g, (String)"g");
                super.paintComponent(g);
                if (this.$vsyncEnabler.getAsBoolean()) {
                    Graphics graphics = g.create();
                    Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                    Graphics2D g2d = (Graphics2D)graphics;
                    boolean bl = false;
                    UISettings.Companion.setupAntialiasing((Graphics)g2d);
                    this.draw(g2d);
                    g2d.dispose();
                }
            }

            private final void updateIntervalsInView() {
                if (!this.intervalsInViewUpdated) {
                    this.intervalsInViewUpdated = true;
                    this.intervalsInView.clear();
                    RangedSeries data = (RangedSeries)this.model.getSeries().get(0);
                    double min = data.getXRange().getMin();
                    double max = data.getXRange().getMax();
                    double invRange = 1.0 / (max - min);
                    List dataList = data.getSeries();
                    if (!((Collection)dataList).isEmpty()) {
                        double previousX = ((SeriesData)dataList.get((int)0)).x;
                        boolean previousVal = ((Number)((SeriesData)dataList.get((int)0)).value).longValue() > 0L;
                        for (SeriesData event : dataList.subList(1, dataList.size())) {
                            double x = event.x;
                            if (x >= min) {
                                of.2.updateIntervalsInView$addInterval(this, min, invRange, Math.max(min, previousX), Math.min(max, x), previousVal);
                            }
                            previousX = x;
                            boolean bl = previousVal = ((Number)event.value).longValue() > 0L;
                            if (!(previousX >= max)) continue;
                        }
                        if (previousX < max) {
                            of.2.updateIntervalsInView$addInterval(this, min, invRange, Math.max(min, previousX), max, previousVal);
                        }
                    }
                }
            }

            private final void draw(Graphics2D g2d) {
                int endIndexExclusive;
                int n;
                g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                float scaleX = this.getWidth();
                float scaleY = this.getHeight();
                Rectangle clipRect = g2d.getClipBounds();
                this.updateIntervalsInView();
                if (clipRect != null && clipRect.x != 0) {
                    int it = of.2.draw$overlapIndex(this, (float)clipRect.x / scaleX, 0.0f);
                    boolean bl = false;
                    n = it < 0 ? -(it + 1) : it;
                } else {
                    n = 0;
                }
                int startIndexInclusive = n;
                if (clipRect != null && clipRect.width != this.getWidth()) {
                    int it = of.2.draw$overlapIndex(this, (float)(clipRect.x + clipRect.width) / scaleX, 0.0f);
                    boolean bl = false;
                    v1 = it < 0 ? -(it + 1) : it + 1;
                } else {
                    v1 = endIndexExclusive = this.intervalsInView.size();
                }
                if ((float)(endIndexExclusive - startIndexInclusive) < scaleX) {
                    Iterable $this$forEach$iv = this.intervalsInView.subList(startIndexInclusive, endIndexExclusive);
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Interval interval = (Interval)element$iv;
                        boolean bl = false;
                        float x = interval.component1();
                        float w = interval.component2();
                        boolean on = interval.component3();
                        g2d.setColor(on ? ProfilerColors.VSYNC_BACKGROUND : ProfilerColors.DEFAULT_BACKGROUND);
                        g2d.fill(new Rectangle2D.Float(x * scaleX, 0.0f, w * scaleX, scaleY));
                    }
                }
            }

            private static final boolean updateIntervalsInView$addInterval(of.2 this$0, double min, double invRange, double previousX, double x, boolean on) {
                return this$0.intervalsInView.add(new Interval((float)((previousX - min) * invRange), (float)((x - previousX) * invRange), on));
            }

            private static final int draw$overlapIndex$lambda$2(float $x, float $w, Interval value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value.getX() + value.getW() < $x ? -1 : (value.getX() > $x + $w ? 1 : 0);
            }

            private static final int draw$overlapIndex(of.2 this$0, float x, float w) {
                return CollectionsKt.binarySearch$default(this$0.intervalsInView, (int)0, (int)0, arg_0 -> of.2.draw$overlapIndex$lambda$2(x, w, arg_0), (int)3, null);
            }
        };
        boolean bl = false;
        ((Container)$this$of_u24lambda_u241).add(content);
        $this$of_u24lambda_u241.getModel().addDependency($this$of_u24lambda_u241.getObserver()).onChange((Enum)StateChartModel.Aspect.MODEL_CHANGED, () -> VsyncPanel.of$lambda$1$modelChanged($this$of_u24lambda_u241));
        VsyncPanel.of$lambda$1$modelChanged($this$of_u24lambda_u241);
        MouseListener handler2 = new MouseListener(content){
            final /* synthetic */ JComponent $content;
            {
                this.$content = $content;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mousePressed(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseReleased(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseEntered(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseExited(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseDragged(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }

            public void mouseMoved(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.$content.dispatchEvent(e);
            }
        };
        ((Component)$this$of_u24lambda_u241).addMouseListener(handler2);
        ((Component)$this$of_u24lambda_u241).addMouseMotionListener((MouseMotionListener)((Object)handler2));
        return (JComponent)serializable;
    }

    private static final List of$lambda$0(List $vsyncValues) {
        return $vsyncValues;
    }

    private static final void of$lambda$1$modelChanged(of.2 $this_apply) {
        $this_apply.setIntervalsInViewUpdated(false);
        VsyncPanelKt.access$getOpaqueContainer($this_apply).repaint();
    }
}

