/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu.art;

import com.android.tools.adtui.model.Range;
import com.android.tools.perflib.vmtrace.VmClockType;
import com.android.tools.perflib.vmtrace.VmTraceHandler;
import com.android.tools.perflib.vmtrace.VmTraceParser;
import com.android.tools.profilers.cpu.BaseCpuCapture;
import com.android.tools.profilers.cpu.CpuCapture;
import com.android.tools.profilers.cpu.TraceParser;
import com.android.tools.profilers.cpu.art.ArtTraceHandler;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ArtTraceParser
implements TraceParser {
    private static final String DUAL_CLOCK_DISABLED_MESSAGE = "This trace only supports Wall Clock Time.<p>To view Thread Time, take a new recording after enabling dual clock in Android Studio.";
    private final ArtTraceHandler myTraceHandler = new ArtTraceHandler();

    @Override
    public CpuCapture parse(@NotNull File trace, long traceId) throws IOException {
        VmTraceParser parser = new VmTraceParser(trace, (VmTraceHandler)this.myTraceHandler);
        parser.parse();
        Range range = new Range((double)this.myTraceHandler.getStartTimeUs(), (double)(this.myTraceHandler.getStartTimeUs() + this.myTraceHandler.getElapsedTimeUs()));
        boolean isDualClock = parser.getVmClockType() == VmClockType.DUAL;
        return new BaseCpuCapture(traceId, ProfilingConfiguration.TraceType.ART, isDualClock, isDualClock ? null : DUAL_CLOCK_DISABLED_MESSAGE, range, this.myTraceHandler.getThreadsGraph());
    }

    public static boolean verifyFileHasArtHeader(@NotNull File trace) {
        return VmTraceParser.verifyFileHasArtHeader((File)trace, (VmTraceHandler)new ArtTraceHandler());
    }
}

