/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.RangedSeries;
import com.android.tools.adtui.model.TooltipModel;
import com.android.tools.adtui.model.event.EventModel;
import com.android.tools.adtui.model.event.LifecycleEventModel;
import com.android.tools.adtui.model.event.UserEvent;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.event.LifecycleEventDataSeries;
import com.android.tools.profilers.event.LifecycleTooltip;
import com.android.tools.profilers.event.UserEventDataSeries;
import com.android.tools.profilers.sessions.SessionsManager;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class EventMonitor
extends ProfilerMonitor {
    @NotNull
    private final EventModel<UserEvent> myUserEvents;
    @NotNull
    private final LifecycleEventModel myLifecycleEvents;
    private boolean myEnabled;
    private Common.AgentData.Status myAgentStatus = Common.AgentData.Status.UNSPECIFIED;
    private Supplier<TooltipModel> myTooltipBuilder;

    public EventMonitor(@NotNull StudioProfilers profilers) {
        super(profilers);
        UserEventDataSeries events = new UserEventDataSeries(this.myProfilers);
        this.myUserEvents = new EventModel(new RangedSeries(this.getTimeline().getViewRange(), (DataSeries)events, this.getTimeline().getDataRange()));
        LifecycleEventDataSeries activities = new LifecycleEventDataSeries(this.myProfilers, false);
        LifecycleEventDataSeries fragments = new LifecycleEventDataSeries(this.myProfilers, true);
        this.myLifecycleEvents = new LifecycleEventModel(new RangedSeries(this.getTimeline().getViewRange(), (DataSeries)activities, this.getTimeline().getDataRange()), new RangedSeries(this.getTimeline().getViewRange(), (DataSeries)fragments, this.getTimeline().getDataRange()));
        this.myProfilers.addDependency((AspectObserver)this).onChange((Enum)ProfilerAspect.AGENT, this::updateEnabledState);
        this.updateEnabledState();
    }

    @Override
    public void enter() {
    }

    @Override
    public void exit() {
    }

    @NotNull
    public EventModel<UserEvent> getUserEvents() {
        return this.myUserEvents;
    }

    @NotNull
    public LifecycleEventModel getLifecycleEvents() {
        return this.myLifecycleEvents;
    }

    @Override
    public String getName() {
        return "EVENTS";
    }

    @Override
    public TooltipModel buildTooltip() {
        if (this.myTooltipBuilder != null) {
            return this.myTooltipBuilder.get();
        }
        return new LifecycleTooltip(this.getTimeline(), this.getLifecycleEvents());
    }

    public void setTooltipBuilder(Supplier<TooltipModel> tooltipBuilder) {
        this.myTooltipBuilder = tooltipBuilder;
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public boolean isEnabled() {
        return this.myEnabled;
    }

    private void updateEnabledState() {
        boolean newEnabledState = this.isNewEnabledState();
        Common.AgentData.Status newAgentStatus = this.myProfilers.getAgentData().getStatus();
        if (this.myAgentStatus != newAgentStatus || this.myEnabled != newEnabledState) {
            this.myEnabled = newEnabledState;
            this.myAgentStatus = newAgentStatus;
            this.changed(ProfilerMonitor.Aspect.ENABLE);
        }
    }

    private boolean isNewEnabledState() {
        boolean agentAttached = this.myProfilers.isAgentAttached();
        SessionsManager sessionsManager = this.myProfilers.getSessionsManager();
        boolean isAlive = sessionsManager.isSessionAlive();
        boolean recordingHasEvents = !isAlive && sessionsManager.getSelectedSessionMetaData().getJvmtiEnabled();
        return agentAttached || recordingHasEvents;
    }
}

