/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.event;

import com.android.tools.adtui.model.DataSeries;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.event.EventAction;
import com.android.tools.adtui.model.event.KeyboardAction;
import com.android.tools.adtui.model.event.KeyboardData;
import com.android.tools.adtui.model.event.UserEvent;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.StudioProfilers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class UserEventDataSeries
implements DataSeries<EventAction<UserEvent>> {
    @NotNull
    private final StudioProfilers myProfilers;
    @NotNull
    private final Common.Session mySession;

    public UserEventDataSeries(@NotNull StudioProfilers profilers) {
        this.myProfilers = profilers;
        this.mySession = profilers.getSession();
    }

    public List<SeriesData<EventAction<UserEvent>>> getDataForRange(@NotNull Range timeCurrentRangeUs) {
        return this.getTransportData(timeCurrentRangeUs);
    }

    @NotNull
    private List<SeriesData<EventAction<UserEvent>>> getTransportData(@NotNull Range rangeUs) {
        ArrayList<SeriesData<EventAction<UserEvent>>> series = new ArrayList<SeriesData<EventAction<UserEvent>>>();
        Transport.GetEventGroupsRequest request = Transport.GetEventGroupsRequest.newBuilder().setKind(Common.Event.Kind.INTERACTION).setStreamId(this.mySession.getStreamId()).setPid(this.mySession.getPid()).setFromTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin())).setToTimestamp(TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax())).build();
        Transport.GetEventGroupsResponse response = this.myProfilers.getClient().getTransportClient().getEventGroups(request);
        for (Transport.EventGroup group : response.getGroupsList()) {
            Common.Event startEvent = group.getEvents(0);
            long actionStart = TimeUnit.NANOSECONDS.toMicros(startEvent.getTimestamp());
            switch (startEvent.getInteraction().getType()) {
                case ROTATION: {
                    series.add((SeriesData<EventAction<UserEvent>>)new SeriesData(actionStart, (Object)new EventAction(actionStart, actionStart, (Object)UserEvent.ROTATION)));
                    break;
                }
                case KEY: {
                    series.add((SeriesData<EventAction<UserEvent>>)new SeriesData(actionStart, (Object)new KeyboardAction(actionStart, actionStart, new KeyboardData(startEvent.getInteraction().getEventData()))));
                    break;
                }
                case TOUCH: {
                    long actionEnd = group.getEventsCount() == 1 ? (long)rangeUs.getMax() : TimeUnit.NANOSECONDS.toMicros(group.getEvents(group.getEventsCount() - 1).getTimestamp());
                    series.add((SeriesData<EventAction<UserEvent>>)new SeriesData(actionStart, (Object)new EventAction(actionStart, actionEnd, (Object)UserEvent.TOUCH)));
                    break;
                }
            }
        }
        Collections.sort(series, Comparator.comparingLong(data -> data.x));
        return series;
    }
}

