/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.chart.linechart.DurationDataRenderer;
import com.android.tools.adtui.model.DurationData;
import com.android.tools.adtui.stdui.CommonButton;
import com.android.tools.adtui.stdui.DefaultContextMenuItem;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.SupportLevel;
import com.android.tools.profilers.memory.DetailedMemoryUsage;
import com.android.tools.profilers.memory.GcDurationData;
import com.android.tools.profilers.memory.MemoryStageLegends;
import com.android.tools.profilers.memory.adapters.MemoryDataProvider;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.Color;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import kotlin.Metadata;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001e\u001fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ)\u0010\n\u001a\u0015\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\u0002\b\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\tJ\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006 "}, d2={"Lcom/android/tools/profilers/memory/GarbageCollectionComponent;", "", "<init>", "()V", "makeGarbageCollectionButton", "Lcom/android/tools/adtui/stdui/CommonButton;", "memoryDataProvider", "Lcom/android/tools/profilers/memory/adapters/MemoryDataProvider;", "studioProfilers", "Lcom/android/tools/profilers/StudioProfilers;", "makeGcDurationDataRenderer", "Lcom/android/tools/adtui/chart/linechart/DurationDataRenderer;", "Lcom/android/tools/profilers/memory/GcDurationData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "detailedMemoryUsage", "Lcom/android/tools/profilers/memory/DetailedMemoryUsage;", "tooltipLegends", "Lcom/android/tools/profilers/memory/MemoryStageLegends;", "makeGarbageCollectionAction", "Lcom/android/tools/adtui/stdui/DefaultContextMenuItem;", "profilers", "myForceGarbageCollectionButton", "Ljavax/swing/JButton;", "containerComponent", "Ljavax/swing/JComponent;", "getGcSupportStatus", "Lcom/android/tools/profilers/memory/GarbageCollectionComponent$GcSupportStatus;", "updateGcButton", "", "GcSupportStatus", "Companion", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=1)
public final class GarbageCollectionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    @NotNull
    private static final String FORCE_GARBAGE_COLLECTION = "Force garbage collection";

    @NotNull
    public final CommonButton makeGarbageCollectionButton(@NotNull MemoryDataProvider memoryDataProvider, @NotNull StudioProfilers studioProfilers) {
        Intrinsics.checkNotNullParameter((Object)memoryDataProvider, (String)"memoryDataProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)studioProfilers), (String)"studioProfilers");
        CommonButton myForceGarbageCollectionButton = new CommonButton(StudioIcons.Profiler.Toolbar.FORCE_GARBAGE_COLLECTION);
        Icon icon = StudioIcons.Profiler.Toolbar.FORCE_GARBAGE_COLLECTION;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"FORCE_GARBAGE_COLLECTION");
        myForceGarbageCollectionButton.setDisabledIcon(IconLoader.getDisabledIcon((Icon)icon));
        myForceGarbageCollectionButton.addActionListener(arg_0 -> GarbageCollectionComponent.makeGarbageCollectionButton$lambda$0(memoryDataProvider, studioProfilers, arg_0));
        return myForceGarbageCollectionButton;
    }

    @NotNull
    public final DurationDataRenderer<GcDurationData> makeGcDurationDataRenderer(@NotNull DetailedMemoryUsage detailedMemoryUsage, @NotNull MemoryStageLegends tooltipLegends2) {
        Intrinsics.checkNotNullParameter((Object)((Object)detailedMemoryUsage), (String)"detailedMemoryUsage");
        Intrinsics.checkNotNullParameter((Object)((Object)tooltipLegends2), (String)"tooltipLegends");
        DurationDataRenderer durationDataRenderer = new DurationDataRenderer.Builder(detailedMemoryUsage.getGcDurations(), (Color)JBColor.BLACK).setIcon(StudioIcons.Profiler.Events.GARBAGE_EVENT).setLabelOffsets((float)(-StudioIcons.Profiler.Events.GARBAGE_EVENT.getIconWidth()) / 2.0f, (float)StudioIcons.Profiler.Events.GARBAGE_EVENT.getIconHeight() / 2.0f).setHostInsets((Insets)JBUI.insets((int)ProfilerLayout.Y_AXIS_TOP_MARGIN, (int)0, (int)0, (int)0)).setHoverHandler(arg_0 -> GarbageCollectionComponent.makeGcDurationDataRenderer$lambda$1(tooltipLegends2, arg_0)).setClickRegionPadding(0, 0).build();
        Intrinsics.checkNotNullExpressionValue((Object)durationDataRenderer, (String)"build(...)");
        return durationDataRenderer;
    }

    @NotNull
    public final DefaultContextMenuItem makeGarbageCollectionAction(@NotNull StudioProfilers profilers, @NotNull JButton myForceGarbageCollectionButton, @NotNull JComponent containerComponent) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)myForceGarbageCollectionButton, (String)"myForceGarbageCollectionButton");
        Intrinsics.checkNotNullParameter((Object)containerComponent, (String)"containerComponent");
        KeyStroke[] keyStrokeArray = new KeyStroke[]{KeyStroke.getKeyStroke(71, GarbageCollectionComponent.Companion.getActionMask())};
        DefaultContextMenuItem defaultContextMenuItem = new DefaultContextMenuItem.Builder(FORCE_GARBAGE_COLLECTION).setContainerComponent(containerComponent).setIcon(myForceGarbageCollectionButton.getIcon()).setActionRunnable(() -> GarbageCollectionComponent.makeGarbageCollectionAction$lambda$2(myForceGarbageCollectionButton)).setEnableBooleanSupplier(() -> GarbageCollectionComponent.makeGarbageCollectionAction$lambda$3(this, profilers)).setKeyStrokes(keyStrokeArray).build();
        Intrinsics.checkNotNullExpressionValue((Object)defaultContextMenuItem, (String)"build(...)");
        return defaultContextMenuItem;
    }

    @NotNull
    public final GcSupportStatus getGcSupportStatus(@NotNull StudioProfilers profilers) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        return !profilers.getSessionsManager().isSessionAlive() ? GcSupportStatus.SESSION_DEAD : (profilers.getSelectedSessionSupportLevel().isFeatureSupported(SupportLevel.Feature.MEMORY_GC) ? GcSupportStatus.ENABLED : GcSupportStatus.PROFILEABLE_PROCESS);
    }

    public final void updateGcButton(@NotNull StudioProfilers profilers, @NotNull JButton myForceGarbageCollectionButton) {
        Intrinsics.checkNotNullParameter((Object)((Object)profilers), (String)"profilers");
        Intrinsics.checkNotNullParameter((Object)myForceGarbageCollectionButton, (String)"myForceGarbageCollectionButton");
        GcSupportStatus gcSupportStatus = this.getGcSupportStatus(profilers);
        myForceGarbageCollectionButton.setEnabled(gcSupportStatus.isSupported());
        myForceGarbageCollectionButton.setToolTipText(gcSupportStatus.getMessage());
    }

    private static final void makeGarbageCollectionButton$lambda$0(MemoryDataProvider $memoryDataProvider, StudioProfilers $studioProfilers, ActionEvent it) {
        $memoryDataProvider.forceGarbageCollection();
        $studioProfilers.getIdeServices().getFeatureTracker().trackForceGc();
    }

    private static final void makeGcDurationDataRenderer$lambda$1(MemoryStageLegends $tooltipLegends, GcDurationData it) {
        $tooltipLegends.getGcDurationLegend().setPickData((DurationData)it);
    }

    private static final void makeGarbageCollectionAction$lambda$2(JButton $myForceGarbageCollectionButton) {
        $myForceGarbageCollectionButton.doClick(0);
    }

    private static final boolean makeGarbageCollectionAction$lambda$3(GarbageCollectionComponent this$0, StudioProfilers $profilers) {
        return this$0.getGcSupportStatus($profilers).isSupported();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/profilers/memory/GarbageCollectionComponent$Companion;", "", "<init>", "()V", "FORCE_GARBAGE_COLLECTION", "", "getActionMask", "", "intellij.android.profilers.ui"})
    public static final class Companion {
        private Companion() {
        }

        private final int getActionMask() {
            return 0;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0019\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/profilers/memory/GarbageCollectionComponent$GcSupportStatus;", "", "isSupported", "", "message", "", "<init>", "(Ljava/lang/String;IZLjava/lang/String;)V", "()Z", "getMessage", "()Ljava/lang/String;", "ENABLED", "SESSION_DEAD", "PROFILEABLE_PROCESS", "intellij.android.profilers.ui"})
    public static final class GcSupportStatus
    extends Enum<GcSupportStatus> {
        private final boolean isSupported;
        @NotNull
        private final String message;
        public static final /* enum */ GcSupportStatus ENABLED = new GcSupportStatus(true, "Force garbage collection");
        public static final /* enum */ GcSupportStatus SESSION_DEAD = new GcSupportStatus(false, "Forcing garbage collection is unavailable for ended sessions");
        public static final /* enum */ GcSupportStatus PROFILEABLE_PROCESS = new GcSupportStatus(false, "Forcing garbage collection is not supported for profileable processes");
        private static final /* synthetic */ GcSupportStatus[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private GcSupportStatus(boolean isSupported, String message) {
            this.isSupported = isSupported;
            this.message = message;
        }

        public final boolean isSupported() {
            return this.isSupported;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        public static GcSupportStatus[] values() {
            return (GcSupportStatus[])$VALUES.clone();
        }

        public static GcSupportStatus valueOf(String value) {
            return Enum.valueOf(GcSupportStatus.class, value);
        }

        @NotNull
        public static EnumEntries<GcSupportStatus> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = gcSupportStatusArray = new GcSupportStatus[]{GcSupportStatus.ENABLED, GcSupportStatus.SESSION_DEAD, GcSupportStatus.PROFILEABLE_PROCESS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

